/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.convert;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TimeZone;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.AddFile$;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFile;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetTable;
import org.apache.spark.sql.delta.commands.convert.ParquetTable;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaMergingUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DateFormatter;
import org.apache.spark.sql.delta.util.DateFormatter$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.PartitionUtils;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-gaB\b\u0011!\u0003\r\ta\b\u0005\u0006Y\u0001!\t!\f\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0011\u001dY\u0004\u00011A\u0005\u0002IBq\u0001\u0010\u0001A\u0002\u0013\u0005Q\bC\u0004A\u0001\u0001\u0007I\u0011\u0001\u001a\t\u000f\u0005\u0003\u0001\u0019!C\u0001\u0005\")A\t\u0001C\u0001\u000b\")\u0011\u000f\u0001C\u0001e\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\n\u0003?\u0002\u0011\u0013!C\u0001\u0003CBq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\n\u00012i\u001c8wKJ$X\u000b^5mg\n\u000b7/\u001a\u0006\u0003#I\tqaY8om\u0016\u0014HO\u0003\u0002\u0014)\u0005A1m\\7nC:$7O\u0003\u0002\u0016-\u0005)A-\u001a7uC*\u0011q\u0003G\u0001\u0004gFd'BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9#&D\u0001)\u0015\tIC#\u0001\u0005nKR,'/\u001b8h\u0013\tY\u0003F\u0001\u0007EK2$\u0018\rT8hO&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002]A\u0011\u0011eL\u0005\u0003a\t\u0012A!\u00168ji\u0006IB/[7fgR\fW\u000e\u001d)beRLG/[8o!\u0006$H/\u001a:o+\u0005\u0019\u0004C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0011a\u0017M\\4\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u0007'R\u0014\u0018N\\4\u00025%\u001cWMY3sON\u0003\u0018M]6UC\ndWm\u00117bgN\u0004\u0016\r\u001e5\u0002=%\u001cWMY3sON\u0003\u0018M]6UC\ndWm\u00117bgN\u0004\u0016\r\u001e5`I\u0015\fHC\u0001\u0018?\u0011\u001dyD!!AA\u0002M\n1\u0001\u001f\u00132\u0003aI7-\u001a2fe\u001ed\u0015N\u0019+bE2,7\t\\1tgB\u000bG\u000f[\u0001\u001dS\u000e,'-\u001a:h\u0019&\u0014G+\u00192mK\u000ec\u0017m]:QCRDw\fJ3r)\tq3\tC\u0004@\r\u0005\u0005\t\u0019A\u001a\u0002\u001f\u001d,G\u000fU1scV,G\u000fV1cY\u0016$RA\u0012&P7\"\u0004\"a\u0012%\u000e\u0003AI!!\u0013\t\u0003%\r{gN^3siR\u000b'oZ3u)\u0006\u0014G.\u001a\u0005\u00063\u001d\u0001\ra\u0013\t\u0003\u00196k\u0011AF\u0005\u0003\u001dZ\u0011Ab\u00159be.\u001cVm]:j_:DQ\u0001U\u0004A\u0002E\u000b\u0011\u0002^1sO\u0016$H)\u001b:\u0011\u0005IKfBA*X!\t!&%D\u0001V\u0015\t1f$\u0001\u0004=e>|GOP\u0005\u00031\n\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e[\u0015\tA&\u0005C\u0003]\u000f\u0001\u0007Q,\u0001\u0007dCR\fGn\\4UC\ndW\rE\u0002\"=\u0002L!a\u0018\u0012\u0003\r=\u0003H/[8o!\t\tg-D\u0001c\u0015\t\u0019G-A\u0004dCR\fGn\\4\u000b\u0005\u00154\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\u001d\u0014'\u0001D\"bi\u0006dwn\u001a+bE2,\u0007\"B5\b\u0001\u0004Q\u0017a\u00049beRLG/[8o'\u000eDW-\\1\u0011\u0007\u0005r6\u000e\u0005\u0002m_6\tQN\u0003\u0002o-\u0005)A/\u001f9fg&\u0011\u0001/\u001c\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aD4fi&\u001bWMY3sOR\u000b'\r\\3\u0015\u000b\u0019\u001bH/^@\t\u000beA\u0001\u0019A&\t\u000bAC\u0001\u0019A)\t\u000bYD\u0001\u0019A<\u0002\u0015M\u0004\u0018M]6UC\ndW\rE\u0002\"=b\u0004\"!_?\u000e\u0003iT!aY>\u000b\u0005q4\u0012!C2p]:,7\r^8s\u0013\tq(PA\u0003UC\ndW\r\u0003\u0004\u0002\u0002!\u0001\rA[\u0001\fi\u0006\u0014G.Z*dQ\u0016l\u0017-\u0001\thKR\fV/\u00197jM&,G\rU1uQR1\u0011qAA\f\u00033\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0002gg*\u0019\u0011\u0011\u0003\u000e\u0002\r!\fGm\\8q\u0013\u0011\t)\"a\u0003\u0003\tA\u000bG\u000f\u001b\u0005\u00063%\u0001\ra\u0013\u0005\b\u00037I\u0001\u0019AA\u0004\u0003\u0011\u0001\u0018\r\u001e5\u0002\u001b\r\u0014X-\u0019;f\u0003\u0012$g)\u001b7f)9\t\t#!\f\u00028\u0005m\u00121IA*\u0003+\u0002B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O!\u0012aB1di&|gn]\u0005\u0005\u0003W\t)CA\u0004BI\u00124\u0015\u000e\\3\t\u000f\u0005=\"\u00021\u0001\u00022\u0005QA/\u0019:hKR4\u0015\u000e\\3\u0011\u0007\u001d\u000b\u0019$C\u0002\u00026A\u0011\u0011cQ8om\u0016\u0014H\u000fV1sO\u0016$h)\u001b7f\u0011\u001d\tID\u0003a\u0001\u0003\u000f\t\u0001BY1tKB\u000bG\u000f\u001b\u0005\b\u0003\u001bQ\u0001\u0019AA\u001f!\u0011\tI!a\u0010\n\t\u0005\u0005\u00131\u0002\u0002\u000b\r&dWmU=ti\u0016l\u0007bBA#\u0015\u0001\u0007\u0011qI\u0001\u0005G>tg\r\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\tiEF\u0001\tS:$XM\u001d8bY&!\u0011\u0011KA&\u0005\u001d\u0019\u0016\u000bT\"p]\u001aDQ!\u001b\u0006A\u0002)D\u0011\"a\u0016\u000b!\u0003\u0005\r!!\u0017\u0002\u001fU\u001cX-\u00112t_2,H/\u001a)bi\"\u00042!IA.\u0013\r\tiF\t\u0002\b\u0005>|G.Z1o\u0003]\u0019'/Z1uK\u0006#GMR5mK\u0012\"WMZ1vYR$c'\u0006\u0002\u0002d)\"\u0011\u0011LA3W\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA9E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00043je:\u000bW.\u001a$jYR,'\u000f\u0006\u0003\u0002Z\u0005m\u0004BBA?\u0019\u0001\u0007\u0011+A\u0004eSJt\u0015-\\3\u0002%1L7\u000f\u001e#jeNLe\u000eU1sC2dW\r\u001c\u000b\u000b\u0003\u0007\u000b\t*a%\u0002\u0018\u00065\u0006#\u0002'\u0002\u0006\u0006%\u0015bAAD-\t9A)\u0019;bg\u0016$\b\u0003BAF\u0003\u001bk\u0011\u0001F\u0005\u0004\u0003\u001f#\"AF*fe&\fG.\u001b>bE2,g)\u001b7f'R\fG/^:\t\u000bei\u0001\u0019A&\t\r\u0005UU\u00021\u0001R\u0003\u001d\u0011xn\u001c;ESJDq!!'\u000e\u0001\u0004\tY*\u0001\u0003eSJ\u001c\b#BAO\u0003O\u000bf\u0002BAP\u0003Gs1\u0001VAQ\u0013\u0005\u0019\u0013bAASE\u00059\u0001/Y2lC\u001e,\u0017\u0002BAU\u0003W\u00131aU3r\u0015\r\t)K\t\u0005\b\u0003_k\u0001\u0019AAY\u0003A\u0019XM]5bY&T\u0018M\u00197f\u0007>tg\r\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9\fG\u0001\u0005kRLG.\u0003\u0003\u0002<\u0006U&!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\fa#\\3sO\u0016\u001c6\r[3nCNLe\u000eU1sC2dW\r\u001c\u000b\bW\u0006\u0005\u00171YAc\u0011\u0015Ib\u00021\u0001L\u0011\u0015Ig\u00021\u0001l\u0011\u001d\t9M\u0004a\u0001\u0003\u0013\f!cY8om\u0016\u0014H\u000fV1sO\u0016$h)\u001b7fgB)A*!\"\u00022\u0001")
public interface ConvertUtilsBase
extends DeltaLogging {
    public void org$apache$spark$sql$delta$commands$convert$ConvertUtilsBase$_setter_$timestampPartitionPattern_$eq(String var1);

    public String timestampPartitionPattern();

    public String icebergSparkTableClassPath();

    public void icebergSparkTableClassPath_$eq(String var1);

    public String icebergLibTableClassPath();

    public void icebergLibTableClassPath_$eq(String var1);

    public static /* synthetic */ ConvertTargetTable getParquetTable$(ConvertUtilsBase $this, SparkSession spark, String targetDir, Option catalogTable, Option partitionSchema) {
        return $this.getParquetTable(spark, targetDir, (Option<CatalogTable>)catalogTable, (Option<StructType>)partitionSchema);
    }

    default public ConvertTargetTable getParquetTable(SparkSession spark, String targetDir, Option<CatalogTable> catalogTable, Option<StructType> partitionSchema) {
        String qualifiedDir = this.getQualifiedPath(spark, new Path(targetDir)).toString();
        return new ParquetTable(spark, qualifiedDir, catalogTable, partitionSchema);
    }

    public static /* synthetic */ ConvertTargetTable getIcebergTable$(ConvertUtilsBase $this, SparkSession spark, String targetDir, Option sparkTable, Option tableSchema) {
        return $this.getIcebergTable(spark, targetDir, (Option<Table>)sparkTable, (Option<StructType>)tableSchema);
    }

    default public ConvertTargetTable getIcebergTable(SparkSession spark, String targetDir, Option<Table> sparkTable, Option<StructType> tableSchema) {
        ConvertTargetTable convertTargetTable;
        try {
            Class clazz = Utils$.MODULE$.classForName(this.icebergSparkTableClassPath(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            if (sparkTable.isDefined()) {
                Constructor constFromTable = clazz.getConstructor(SparkSession.class, Utils$.MODULE$.classForName(this.icebergLibTableClassPath(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()), Option.class);
                Method method = sparkTable.get().getClass().getMethod("table", new Class[0]);
                convertTargetTable = (ConvertTargetTable)constFromTable.newInstance(spark, method.invoke(sparkTable.get(), new Object[0]), tableSchema);
            } else {
                String baseDir = this.getQualifiedPath(spark, new Path(targetDir)).toString();
                Constructor constFromPath = clazz.getConstructor(SparkSession.class, String.class, Option.class);
                convertTargetTable = (ConvertTargetTable)constFromPath.newInstance(spark, baseDir, tableSchema);
            }
        }
        catch (ClassNotFoundException e) {
            this.logError(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find Iceberg class"}))).log((Seq<MDC>)Nil$.MODULE$)), e);
            throw DeltaErrors$.MODULE$.icebergClassMissing(spark.sparkContext().getConf(), e);
        }
        catch (InvocationTargetException e) {
            this.logError(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got error when creating an Iceberg Converter"}))).log((Seq<MDC>)Nil$.MODULE$)), e);
            throw ExceptionUtils.getRootCause((Throwable)e);
        }
        return convertTargetTable;
    }

    public static /* synthetic */ Path getQualifiedPath$(ConvertUtilsBase $this, SparkSession spark, Path path) {
        return $this.getQualifiedPath(spark, path);
    }

    default public Path getQualifiedPath(SparkSession spark, Path path) {
        Path qualifiedPath;
        Configuration sessionHadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = path.getFileSystem(sessionHadoopConf);
        if (!fs.exists(qualifiedPath = fs.makeQualified(path))) {
            throw DeltaErrors$.MODULE$.directoryNotFoundException(qualifiedPath.toString());
        }
        return qualifiedPath;
    }

    public static /* synthetic */ AddFile createAddFile$(ConvertUtilsBase $this, ConvertTargetFile targetFile, Path basePath, FileSystem fs, SQLConf conf, Option partitionSchema, boolean useAbsolutePath) {
        return $this.createAddFile(targetFile, basePath, fs, conf, (Option<StructType>)partitionSchema, useAbsolutePath);
    }

    default public AddFile createAddFile(ConvertTargetFile targetFile, Path basePath, FileSystem fs, SQLConf conf, Option<StructType> partitionSchema, boolean useAbsolutePath) {
        String string;
        Seq partitionFields = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.fields())).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq partitionColNames = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.fieldNames())).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq physicalPartitionColNames = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)x$3.map((Function1 & Serializable & scala.Serializable)f -> DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)f), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        SerializableFileStatus file = targetFile.fileStatus();
        Path path = file.getHadoopPath();
        Map partition = (Map)targetFile.partitionValues().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String pathStr = file.getHadoopPath().toUri().toString();
            DateFormatter dateFormatter = DateFormatter$.MODULE$.apply();
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(this.timestampPartitionPattern(), TimeZone.getDefault());
            Function2 resolver = conf.resolver();
            Path dir = file.isDir() ? file.getHadoopPath() : file.getHadoopPath().getParent();
            Tuple2<Option<PartitionUtils.PartitionValues>, Option<Path>> tuple2 = PartitionUtils$.MODULE$.parsePartition(dir, false, (Set<Path>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{basePath}))), (Map<String, DataType>)Predef$.MODULE$.Map().empty(), false, TimeZone.getDefault(), dateFormatter, timestampFormatter, PartitionUtils$.MODULE$.parsePartition$default$9());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option partitionOpt = (Option)tuple2._1();
            Option partitionOpt2 = partitionOpt;
            return (Map)partitionOpt2.map((Function1 & Serializable & scala.Serializable)partValues -> {
                if (partitionColNames.size() != partValues.columnNames().size()) {
                    throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, partValues.columnNames(), (Seq<String>)partitionColNames);
                }
                Option tz = Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone());
                if (!BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_CONVERT_PARTITION_VALUES_IGNORE_CAST_FAILURE()))) {
                    ((IterableLike)partValues.literals().zip((GenIterable)partitionFields, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        ConvertUtilsBase.$anonfun$createAddFile$10(tz, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                Seq values = (Seq)((TraversableLike)partValues.literals().map((Function1 & Serializable & scala.Serializable)l -> {
                    Cast qual$3 = Cast$.MODULE$.apply((Expression)l, (DataType)StringType$.MODULE$, tz, false);
                    InternalRow x$3 = qual$3.eval$default$1();
                    return qual$3.eval(x$3);
                }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)Option$.MODULE$.apply(x$5).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString()).orNull(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom());
                ((IterableLike)partitionColNames.zip(partValues.columnNames(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    ConvertUtilsBase.$anonfun$createAddFile$15(resolver, pathStr, x0$2);
                    return BoxedUnit.UNIT;
                });
                return ((TraversableOnce)physicalPartitionColNames.zip((GenIterable)values, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                if (partitionColNames.nonEmpty()) {
                    throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<String>)partitionColNames);
                }
                return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            });
        });
        if (!useAbsolutePath) {
            Path relativePath = DeltaFileOperations$.MODULE$.tryRelativizePath(fs, basePath, path, DeltaFileOperations$.MODULE$.tryRelativizePath$default$4());
            Predef$.MODULE$.assert(!relativePath.isAbsolute(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Fail to relativize path ").append(path).append(" against base path ").append(basePath).append(".").toString());
            string = relativePath.toUri().toString();
        } else {
            string = path.toUri().toString();
        }
        String pathStrForAddFile = string;
        return new AddFile(pathStrForAddFile, (Map<String, String>)partition, file.length(), file.modificationTime(), true, AddFile$.MODULE$.apply$default$6(), AddFile$.MODULE$.apply$default$7(), AddFile$.MODULE$.apply$default$8(), AddFile$.MODULE$.apply$default$9(), AddFile$.MODULE$.apply$default$10(), AddFile$.MODULE$.apply$default$11());
    }

    public static /* synthetic */ boolean createAddFile$default$6$(ConvertUtilsBase $this) {
        return $this.createAddFile$default$6();
    }

    default public boolean createAddFile$default$6() {
        return false;
    }

    public static /* synthetic */ boolean dirNameFilter$(ConvertUtilsBase $this, String dirName) {
        return $this.dirNameFilter(dirName);
    }

    default public boolean dirNameFilter(String dirName) {
        return DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(dirName) && !dirName.contains("=");
    }

    public static /* synthetic */ Dataset listDirsInParallel$(ConvertUtilsBase $this, SparkSession spark, String rootDir, Seq dirs, SerializableConfiguration serializableConf) {
        return $this.listDirsInParallel(spark, rootDir, (Seq<String>)dirs, serializableConf);
    }

    default public Dataset<SerializableFileStatus> listDirsInParallel(SparkSession spark, String rootDir, Seq<String> dirs, SerializableConfiguration serializableConf) {
        Broadcast conf = spark.sparkContext().broadcast((Object)serializableConf, ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        int parallelism = spark.sessionState().conf().parallelPartitionDiscoveryParallelism();
        RDD qual$1 = spark.sparkContext().parallelize(dirs, scala.math.package$.MODULE$.min(parallelism, dirs.length()), ClassTag$.MODULE$.apply(String.class));
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)batch -> batch.flatMap((Function1 & Serializable & scala.Serializable)dir -> DeltaFileOperations$.MODULE$.localListDirs(((SerializableConfiguration)conf.value()).value(), (Seq<String>)((Seq)new .colon.colon(dir, (List)Nil$.MODULE$)), false, DeltaFileOperations$.MODULE$.localListDirs$default$4(), DeltaFileOperations$.MODULE$.localListDirs$default$5()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ConvertUtilsBase.$anonfun$listDirsInParallel$3(x$7))));
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD rdd = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(SerializableFileStatus.class));
        return spark.createDataset(rdd, org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
    }

    public static /* synthetic */ StructType mergeSchemasInParallel$(ConvertUtilsBase $this, SparkSession spark, StructType partitionSchema, Dataset convertTargetFiles) {
        return $this.mergeSchemasInParallel(spark, partitionSchema, (Dataset<ConvertTargetFile>)convertTargetFiles);
    }

    default public StructType mergeSchemasInParallel(SparkSession spark, StructType partitionSchema, Dataset<ConvertTargetFile> convertTargetFiles) {
        String[] partiallyMergedSchemas = (String[])this.recordFrameProfile("Delta", "ConvertUtils.mergeSchemasInParallel", (Function0 & Serializable & scala.Serializable)() -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])convertTargetFiles.mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> {
            ObjectRef dataSchema = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
            iterator.foreach((Function1 & Serializable & scala.Serializable)file -> {
                ConvertUtilsBase.$anonfun$mergeSchemasInParallel$3(dataSchema, file);
                return BoxedUnit.UNIT;
            });
            return package$.MODULE$.Iterator().single((Object)((StructType)dataSchema.elem).toDDL());
        }, org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).collect())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ConvertUtilsBase.$anonfun$mergeSchemasInParallel$4(x$8))));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).isEmpty()) {
            throw DeltaErrors$.MODULE$.failedInferSchema();
        }
        ObjectRef mergedSchema = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            mergedSchema.elem = SchemaMergingUtils$.MODULE$.mergeSchemas((StructType)mergedSchema.elem, StructType$.MODULE$.fromDDL(schema), SchemaMergingUtils$.MODULE$.mergeSchemas$default$3(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$4(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$5(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$6());
            return BoxedUnit.UNIT;
        });
        return (StructType)PartitioningUtils$.MODULE$.mergeDataAndPartitionSchema((StructType)mergedSchema.elem, StructType$.MODULE$.apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).toSeq()), spark.sessionState().conf().caseSensitiveAnalysis())._1();
    }

    public static /* synthetic */ void $anonfun$createAddFile$10(Option tz$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            InternalRow x$1;
            Cast qual$1;
            Literal literal = (Literal)tuple2._1();
            StructField field = (StructField)tuple2._2();
            if (literal.eval(literal.eval$default$1()) != null && (qual$1 = Cast$.MODULE$.apply((Expression)literal, field.dataType(), tz$1, false)).eval(x$1 = qual$1.eval$default$1()) == null) {
                Cast qual$2 = Cast$.MODULE$.apply((Expression)literal, (DataType)StringType$.MODULE$, tz$1, false);
                InternalRow x$2 = qual$2.eval$default$1();
                Object partitionValue = qual$2.eval(x$2);
                String partitionValueStr = (String)Option$.MODULE$.apply(partitionValue).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString()).orNull(Predef$.MODULE$.$conforms());
                throw DeltaErrors$.MODULE$.castPartitionValueException(partitionValueStr, field.dataType());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$createAddFile$15(Function2 resolver$1, String pathStr$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String parsed;
            String expected = (String)tuple2._1();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)expected, (Object)(parsed = (String)tuple2._2())))) {
                throw DeltaErrors$.MODULE$.unexpectedPartitionColumnFromFileNameException(pathStr$1, parsed, expected);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$listDirsInParallel$3(SerializableFileStatus x$7) {
        return !x$7.isDir();
    }

    public static /* synthetic */ void $anonfun$mergeSchemasInParallel$3(ObjectRef dataSchema$1, ConvertTargetFile file) {
        try {
            dataSchema$1.elem = SchemaMergingUtils$.MODULE$.mergeSchemas((StructType)dataSchema$1.elem, StructType$.MODULE$.fromDDL((String)file.parquetSchemaDDL().get()).asNullable(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$3(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$4(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$5(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$6());
        }
        catch (AnalysisException cause) {
            throw DeltaErrors$.MODULE$.failedMergeSchemaFile(file.fileStatus().path(), StructType$.MODULE$.fromDDL((String)file.parquetSchemaDDL().get()).treeString(), cause);
        }
    }

    public static /* synthetic */ boolean $anonfun$mergeSchemasInParallel$4(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static void $init$(ConvertUtilsBase $this) {
        $this.org$apache$spark$sql$delta$commands$convert$ConvertUtilsBase$_setter_$timestampPartitionPattern_$eq("yyyy-MM-dd HH:mm:ss[.S]");
        $this.icebergSparkTableClassPath_$eq("org.apache.spark.sql.delta.commands.convert.IcebergTable");
        $this.icebergLibTableClassPath_$eq("org.apache.iceberg.Table");
    }
}

