/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.coordinatedcommits;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import io.delta.storage.commit.CommitCoordinatorClient;
import io.delta.storage.commit.GetCommitsResponse;
import io.delta.storage.commit.TableIdentifier;
import java.io.Serializable;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.CoordinatedCommitsTableFeature$;
import org.apache.spark.sql.delta.DeltaConfig;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaIllegalArgumentException;
import org.apache.spark.sql.delta.DeltaIllegalArgumentException$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.commands.CloneTableCommand;
import org.apache.spark.sql.delta.coordinatedcommits.CommitCoordinatorProvider$;
import org.apache.spark.sql.delta.coordinatedcommits.CoordinatedCommitsUsageLogs$;
import org.apache.spark.sql.delta.coordinatedcommits.TableCommitCoordinatorClient;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.ClosableIterator;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.FileNames$BackfilledDeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$CompactedDeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$DeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$UnbackfilledDeltaFile$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class CoordinatedCommitsUtils$
implements DeltaLogging {
    public static CoordinatedCommitsUtils$ MODULE$;
    private final Seq<DeltaConfig<? extends Object>> TABLE_PROPERTY_CONFS;
    private final Seq<DeltaConfig<? super Option<Object>>> ICT_TABLE_PROPERTY_CONFS;
    private final Seq<String> TABLE_PROPERTY_KEYS;
    private final Seq<String> ICT_TABLE_PROPERTY_KEYS;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CoordinatedCommitsUtils$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public GetCommitsResponse getCommitsFromCommitCoordinatorWithUsageLogs(DeltaLog deltaLog, TableCommitCoordinatorClient tableCommitCoordinatorClient, Option<CatalogTable> catalogTableOpt, long startVersion, Option<Object> versionToLoad, boolean isAsyncRequest) {
        return (GetCommitsResponse)this.recordFrameProfile("DeltaLog", new StringBuilder(41).append("CommitCoordinatorClient.getCommits.async=").append(isAsyncRequest).toString(), (Function0 & Serializable & scala.Serializable)() -> {
            GetCommitsResponse getCommitsResponse;
            long startTimeMs = System.currentTimeMillis();
            try {
                GetCommitsResponse response = tableCommitCoordinatorClient.getCommits((Option<org.apache.spark.sql.catalyst.TableIdentifier>)catalogTableOpt.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)startVersion)), versionToLoad);
                Map additionalEventData = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"responseCommitsSize"), (Object)BoxesRunTime.boxToInteger((int)response.getCommits().size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"responseLatestTableVersion"), (Object)BoxesRunTime.boxToLong((long)response.getLatestTableVersion()))}));
                CoordinatedCommitsUtils$.recordEvent$1(additionalEventData, deltaLog, startVersion, versionToLoad, isAsyncRequest, startTimeMs);
                getCommitsResponse = response;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    CoordinatedCommitsUtils$.recordEvent$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exceptionClass"), (Object)e.getClass().getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exceptionString"), (Object)Utils$.MODULE$.exceptionString(e))})), deltaLog, startVersion, versionToLoad, isAsyncRequest, startTimeMs);
                    throw e;
                }
                throw throwable;
            }
            return getCommitsResponse;
        });
    }

    public Iterator<Tuple2<FileStatus, Object>> commitFilesIterator(DeltaLog deltaLog, long startVersion) {
        LongRef maxVersionSeen = LongRef.create((long)(startVersion - 1L));
        Iterator listedDeltas = CoordinatedCommitsUtils$.listDeltas$1(startVersion, (Option)None$.MODULE$, deltaLog).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoordinatedCommitsUtils$.$anonfun$commitFilesIterator$3(maxVersionSeen, x0$1)));
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> CoordinatedCommitsUtils$.$anonfun$commitFilesIterator$5(listedDeltas, deltaLog, maxVersionSeen, BoxesRunTime.unboxToInt((Object)x0$2)));
    }

    public Option<CommitCoordinatorClient> getCommitCoordinatorClient(SparkSession spark, DeltaLog deltaLog, Metadata metadata, Protocol protocol, boolean failIfImplUnavailable) {
        return metadata.coordinatedCommitsCoordinatorName().flatMap((Function1 & Serializable & scala.Serializable)commitCoordinatorStr -> {
            Predef$.MODULE$.assert(protocol.isFeatureSupported(CoordinatedCommitsTableFeature$.MODULE$));
            Map<String, String> coordinatorConf = metadata.coordinatedCommitsCoordinatorConf();
            Option<CommitCoordinatorClient> coordinatorOpt = CommitCoordinatorProvider$.MODULE$.getCommitCoordinatorClientOpt((String)commitCoordinatorStr, coordinatorConf, spark);
            if (coordinatorOpt.isEmpty()) {
                DeltaLog x$1 = deltaLog;
                String x$2 = CoordinatedCommitsUsageLogs$.MODULE$.COMMIT_COORDINATOR_MISSING_IMPLEMENTATION();
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"commitCoordinatorName"), commitCoordinatorStr), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registeredCommitCoordinators"), (Object)CommitCoordinatorProvider$.MODULE$.getRegisteredCoordinatorNames().mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"commitCoordinatorConf"), coordinatorConf), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failIfImplUnavailable"), (Object)Boolean.toString(failIfImplUnavailable))}));
                Map<TagDefinition, String> x$4 = MODULE$.recordDeltaEvent$default$3();
                Option<Path> x$5 = MODULE$.recordDeltaEvent$default$5();
                MODULE$.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
                if (failIfImplUnavailable) {
                    throw new IllegalArgumentException(new StringBuilder(28).append("Unknown commit-coordinator: ").append((String)commitCoordinatorStr).toString());
                }
            }
            return coordinatorOpt;
        });
    }

    public Option<TableCommitCoordinatorClient> getTableCommitCoordinator(SparkSession spark, DeltaLog deltaLog, SnapshotDescriptor snapshotDescriptor, boolean failIfImplUnavailable) {
        return this.getCommitCoordinatorClient(spark, deltaLog, snapshotDescriptor.metadata(), snapshotDescriptor.protocol(), failIfImplUnavailable).map((Function1 & Serializable & scala.Serializable)commitCoordinator -> new TableCommitCoordinatorClient((CommitCoordinatorClient)commitCoordinator, snapshotDescriptor.deltaLog().logPath(), snapshotDescriptor.metadata().coordinatedCommitsTableConf(), snapshotDescriptor.deltaLog().newDeltaHadoopConf(), snapshotDescriptor.deltaLog().store()));
    }

    public Tuple2<Option<String>, Map<String, String>> getCoordinatedCommitsConfs(Metadata metadata) {
        Option<String> option = metadata.coordinatedCommitsCoordinatorName();
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            return new Tuple2((Object)new Some((Object)name), metadata.coordinatedCommitsCoordinatorConf());
        }
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)None$.MODULE$, (Object)Predef$.MODULE$.Map().empty());
        }
        throw new MatchError(option);
    }

    public Seq<DeltaConfig<? extends Object>> TABLE_PROPERTY_CONFS() {
        return this.TABLE_PROPERTY_CONFS;
    }

    public Seq<DeltaConfig<? super Option<Object>>> ICT_TABLE_PROPERTY_CONFS() {
        return this.ICT_TABLE_PROPERTY_CONFS;
    }

    public Seq<String> TABLE_PROPERTY_KEYS() {
        return this.TABLE_PROPERTY_KEYS;
    }

    public Seq<String> ICT_TABLE_PROPERTY_KEYS() {
        return this.ICT_TABLE_PROPERTY_KEYS;
    }

    public boolean tablePropertiesPresent(Metadata metadata) {
        return this.TABLE_PROPERTY_KEYS().exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)CoordinatedCommitsUtils$.$anonfun$tablePropertiesPresent$1(metadata, key)));
    }

    public boolean unbackfilledCommitsPresent(Snapshot snapshot) {
        return snapshot.logSegment().deltas().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoordinatedCommitsUtils$.$anonfun$unbackfilledCommitsPresent$1(x0$1))) && !snapshot.allCommitsBackfilled();
    }

    public void backfillWhenCoordinatedCommitsDisabled(Snapshot snapshot) {
        if (snapshot.getTableCommitCoordinatorForWrites().nonEmpty()) {
            return;
        }
        Seq unbackfilledFilesAndVersions = (Seq)snapshot.logSegment().deltas().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option<Tuple3<FileStatus, Object, String>> option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    FileStatus unbackfilledDeltaFile = (FileStatus)((Tuple3)option.get())._1();
                    long version = BoxesRunTime.unboxToLong((Object)((Tuple3)option.get())._2());
                    return (B1)new Tuple2((Object)unbackfilledDeltaFile, (Object)BoxesRunTime.boxToLong((long)version));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                FileStatus fileStatus = x1;
                Option<Tuple3<FileStatus, Object, String>> option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(fileStatus);
                return !option.isEmpty();
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (unbackfilledFilesAndVersions.isEmpty()) {
            return;
        }
        DeltaLog deltaLog = snapshot.deltaLog();
        Configuration hadoopConf = deltaLog.newDeltaHadoopConf();
        FileSystem fs = deltaLog.logPath().getFileSystem(hadoopConf);
        boolean overwrite = !deltaLog.store().isPartialWriteVisible(deltaLog.logPath(), hadoopConf);
        LongRef numAlreadyBackfilledFiles = LongRef.create((long)0L);
        unbackfilledFilesAndVersions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CoordinatedCommitsUtils$.$anonfun$backfillWhenCoordinatedCommitsDisabled$1(deltaLog, fs, hadoopConf, overwrite, numAlreadyBackfilledFiles, x0$1);
            return BoxedUnit.UNIT;
        });
        DeltaLog x$1 = deltaLog;
        String x$2 = "delta.coordinatedCommits.backfillWhenCoordinatedCommitsSupportedAndDisabled";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numUnbackfilledFiles"), (Object)BoxesRunTime.boxToInteger((int)unbackfilledFilesAndVersions.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unbackfilledFiles"), unbackfilledFilesAndVersions.map((Function1 & Serializable & scala.Serializable)x$5 -> ((FileStatus)x$5._1()).getPath().toString(), Seq$.MODULE$.canBuildFrom())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAlreadyBackfilledFiles"), (Object)BoxesRunTime.boxToLong((long)numAlreadyBackfilledFiles.elem))}));
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$52 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$52);
    }

    public Option<FileStatus> getLastBackfilledFile(Seq<FileStatus> deltas) {
        ObjectRef maxFile = ObjectRef.create((Object)None$.MODULE$);
        deltas.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CoordinatedCommitsUtils$.$anonfun$getLastBackfilledFile$1(maxFile, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Option)maxFile.elem;
    }

    public Map<String, String> getExplicitCCConfigurations(Map<String, String> properties) {
        return (Map)properties.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoordinatedCommitsUtils$.$anonfun$getExplicitCCConfigurations$1(x0$1)));
    }

    public Map<String, String> getExplicitICTConfigurations(Map<String, String> properties) {
        return (Map)properties.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoordinatedCommitsUtils$.$anonfun$getExplicitICTConfigurations$1(x0$1)));
    }

    public Map<String, String> getDefaultCCConfigurations(SparkSession spark, boolean withDefaultKey) {
        return ((TraversableOnce)this.TABLE_PROPERTY_CONFS().flatMap((Function1 & Serializable & scala.Serializable)conf -> Option$.MODULE$.option2Iterable(spark.conf().getOption(conf.defaultTablePropertyKey()).map((Function1 & Serializable & scala.Serializable)value -> {
            String finalKey = withDefaultKey ? conf.defaultTablePropertyKey() : conf.key();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)finalKey), value);
        })), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public boolean getDefaultCCConfigurations$default$2() {
        return false;
    }

    private void verifyContainsOnlyCoordinatorNameAndConf(Map<String, String> properties, String command, boolean fromDefault) {
        ((IterableLike)new .colon.colon(DeltaConfigs$.MODULE$.COORDINATED_COMMITS_TABLE_CONF(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)conf -> {
            CoordinatedCommitsUtils$.$anonfun$verifyContainsOnlyCoordinatorNameAndConf$1(fromDefault, properties, command, conf);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)new .colon.colon(DeltaConfigs$.MODULE$.COORDINATED_COMMITS_COORDINATOR_NAME(), (List)new .colon.colon(DeltaConfigs$.MODULE$.COORDINATED_COMMITS_COORDINATOR_CONF(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)conf -> {
            CoordinatedCommitsUtils$.$anonfun$verifyContainsOnlyCoordinatorNameAndConf$2(fromDefault, properties, command, conf);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyNotContainsICTConfigurations(Seq<String> propKeys, String command, String errorClass) {
        this.ICT_TABLE_PROPERTY_KEYS().foreach((Function1 & Serializable & scala.Serializable)key -> {
            CoordinatedCommitsUtils$.$anonfun$verifyNotContainsICTConfigurations$1(propKeys, errorClass, command, key);
            return BoxedUnit.UNIT;
        });
    }

    public void validateConfigurationsForAlterTableSetPropertiesDeltaCommand(Map<String, String> existingConfs, Map<String, String> propertyOverrides) {
        Map<String, String> existingCoordinatedCommitsConfs = this.getExplicitCCConfigurations(existingConfs);
        Map<String, String> coordinatedCommitsOverrides = this.getExplicitCCConfigurations(propertyOverrides);
        if (coordinatedCommitsOverrides.nonEmpty()) {
            if (existingCoordinatedCommitsConfs.nonEmpty()) {
                throw new DeltaIllegalArgumentException("DELTA_CANNOT_OVERRIDE_COORDINATED_COMMITS_CONFS", (String[])((Object[])new String[]{"ALTER"}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
            }
            this.verifyNotContainsICTConfigurations((Seq<String>)propertyOverrides.keys().toSeq(), "ALTER", "DELTA_CANNOT_SET_COORDINATED_COMMITS_DEPENDENCIES");
            this.verifyContainsOnlyCoordinatorNameAndConf(coordinatedCommitsOverrides, "ALTER", false);
        }
        if (existingCoordinatedCommitsConfs.nonEmpty()) {
            this.verifyNotContainsICTConfigurations((Seq<String>)propertyOverrides.keys().toSeq(), "ALTER", "DELTA_CANNOT_MODIFY_COORDINATED_COMMITS_DEPENDENCIES");
            return;
        }
    }

    public void validateConfigurationsForAlterTableUnsetPropertiesDeltaCommand(Map<String, String> existingConfs, Seq<String> propKeysToUnset) {
        if (this.getExplicitCCConfigurations(existingConfs).nonEmpty()) {
            if (propKeysToUnset.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)CoordinatedCommitsUtils$.$anonfun$validateConfigurationsForAlterTableUnsetPropertiesDeltaCommand$1(elem)))) {
                throw new DeltaIllegalArgumentException("DELTA_CANNOT_UNSET_COORDINATED_COMMITS_CONFS", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
            }
            this.verifyNotContainsICTConfigurations(propKeysToUnset, "ALTER", "DELTA_CANNOT_MODIFY_COORDINATED_COMMITS_DEPENDENCIES");
            return;
        }
    }

    public void validateConfigurationsForCreateDeltaTableCommand(SparkSession spark, boolean tableExists, Option<LogicalPlan> query, Map<String, String> catalogTableProperties) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Some some;
        LogicalPlan cmd;
        Option<LogicalPlan> option = query;
        if (option instanceof Some && (cmd = (LogicalPlan)(some = (Some)option).value()) instanceof CloneTableCommand) {
            CloneTableCommand cloneTableCommand = (CloneTableCommand)cmd;
            tuple22 = new Tuple2((Object)(tableExists ? "REPLACE with CLONE" : "CREATE with CLONE"), cloneTableCommand.tablePropertyOverrides());
        } else {
            tuple22 = tuple2 = new Tuple2((Object)(tableExists ? "REPLACE" : "CREATE"), catalogTableProperties);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String command = (String)tuple2._1();
        Map propertyOverrides = (Map)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)command, (Object)propertyOverrides);
        String command2 = (String)tuple23._1();
        Map propertyOverrides2 = (Map)tuple23._2();
        this.validateConfigurationsForCreateDeltaTableCommandImpl(spark, (Map<String, String>)propertyOverrides2, tableExists, command2);
    }

    public void validateConfigurationsForCreateDeltaTableCommandImpl(SparkSession spark, Map<String, String> propertyOverrides, boolean tableExists, String command) {
        Map<String, String> coordinatedCommitsConfs = this.getExplicitCCConfigurations(propertyOverrides);
        if (tableExists) {
            if (coordinatedCommitsConfs.nonEmpty()) {
                throw new DeltaIllegalArgumentException("DELTA_CANNOT_OVERRIDE_COORDINATED_COMMITS_CONFS", (String[])((Object[])new String[]{command}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
            }
            return;
        }
        if (coordinatedCommitsConfs.nonEmpty()) {
            this.verifyContainsOnlyCoordinatorNameAndConf(coordinatedCommitsConfs, command, false);
            return;
        }
        Map<String, String> defaultCoordinatedCommitsConfs = this.getDefaultCCConfigurations(spark, true);
        if (defaultCoordinatedCommitsConfs.nonEmpty()) {
            this.verifyContainsOnlyCoordinatorNameAndConf(defaultCoordinatedCommitsConfs, command, true);
            return;
        }
    }

    public Optional<TableIdentifier> toCCTableIdentifier(Option<org.apache.spark.sql.catalyst.TableIdentifier> catalystTableIdentifierOpt) {
        return (Optional)catalystTableIdentifierOpt.map((Function1 & Serializable & scala.Serializable)catalystTableIdentifier -> {
            Seq namespace = (Seq)Option$.MODULE$.option2Iterable(catalystTableIdentifier.catalog()).toSeq().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(catalystTableIdentifier.database()).toSeq(), Seq$.MODULE$.canBuildFrom());
            return new TableIdentifier((String[])namespace.toArray(ClassTag$.MODULE$.apply(String.class)), catalystTableIdentifier.table());
        }).map((Function1 & Serializable & scala.Serializable)x$1 -> Optional.of(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Optional.empty());
    }

    private static final void recordEvent$1(Map additionalData, DeltaLog deltaLog$1, long startVersion$1, Option versionToLoad$1, boolean isAsyncRequest$1, long startTimeMs$1) {
        DeltaLog x$1 = deltaLog$1;
        String x$2 = CoordinatedCommitsUsageLogs$.MODULE$.COMMIT_COORDINATOR_CLIENT_GET_COMMITS();
        Map x$3 = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startVersion"), (Object)BoxesRunTime.boxToLong((long)startVersion$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versionToLoad"), versionToLoad$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"async"), (Object)Boolean.toString(isAsyncRequest$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"durationMs"), (Object)Long.toString(System.currentTimeMillis() - startTimeMs$1))}))).$plus$plus((GenTraversableOnce)additionalData);
        Map<TagDefinition, String> x$4 = MODULE$.recordDeltaEvent$default$3();
        Option<Path> x$5 = MODULE$.recordDeltaEvent$default$5();
        MODULE$.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$commitFilesIterator$1(Option endVersion$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long version = tuple2._2$mcJ$sp();
            return endVersion$1.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> version <= x$2);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Iterator listDeltas$1(long startVersion, Option endVersion, DeltaLog deltaLog$2) {
        return deltaLog$2.listFrom(startVersion).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option<Tuple2<FileStatus, Object>> option = FileNames$DeltaFile$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    FileStatus fileStatus = (FileStatus)((Tuple2)option.get())._1();
                    long version = ((Tuple2)option.get())._2$mcJ$sp();
                    return (B1)new Tuple2((Object)fileStatus, (Object)BoxesRunTime.boxToLong((long)version));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                FileStatus fileStatus = x1;
                Option<Tuple2<FileStatus, Object>> option = FileNames$DeltaFile$.MODULE$.unapply(fileStatus);
                return !option.isEmpty();
            }
        }).takeWhile((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoordinatedCommitsUtils$.$anonfun$commitFilesIterator$1(endVersion, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$commitFilesIterator$3(LongRef maxVersionSeen$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long version = tuple2._2$mcJ$sp();
            maxVersionSeen$1.elem = scala.math.package$.MODULE$.max(maxVersionSeen$1.elem, version);
            return true;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Iterator tailFromSnapshot$1(DeltaLog deltaLog$2, LongRef maxVersionSeen$1) {
        long version;
        Some some;
        Tuple2 tuple2;
        Snapshot currentSnapshotInDeltaLog = deltaLog$2.unsafeVolatileSnapshot();
        if (currentSnapshotInDeltaLog.version() == maxVersionSeen$1.elem && currentSnapshotInDeltaLog.tableCommitCoordinatorClientOpt().isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        Snapshot endSnapshot = deltaLog$2.update(deltaLog$2.update$default$1(), deltaLog$2.update$default$2(), deltaLog$2.update$default$3());
        if (maxVersionSeen$1.elem >= endSnapshot.version()) {
            return package$.MODULE$.Iterator().empty();
        }
        Seq unbackfilledDeltas = (Seq)endSnapshot.logSegment().deltas().collect((PartialFunction)new scala.Serializable(maxVersionSeen$1){
            public static final long serialVersionUID = 0L;
            private final LongRef maxVersionSeen$1;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option<Tuple3<FileStatus, Object, String>> option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    FileStatus fileStatus = (FileStatus)((Tuple3)option.get())._1();
                    long version = BoxesRunTime.unboxToLong((Object)((Tuple3)option.get())._2());
                    if (version > this.maxVersionSeen$1.elem) {
                        return (B1)new Tuple2((Object)fileStatus, (Object)BoxesRunTime.boxToLong((long)version));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                long version;
                FileStatus fileStatus = x1;
                Option<Tuple3<FileStatus, Object, String>> option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(fileStatus);
                return !option.isEmpty() && (version = BoxesRunTime.unboxToLong((Object)((Tuple3)option.get())._2())) > this.maxVersionSeen$1.elem;
            }
            {
                this.maxVersionSeen$1 = maxVersionSeen$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Option option = unbackfilledDeltas.headOption();
        Iterator gapListing = option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null && maxVersionSeen$1.elem + 1L < (version = tuple2._2$mcJ$sp()) ? CoordinatedCommitsUtils$.listDeltas$1(maxVersionSeen$1.elem + 1L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)version)), deltaLog$2) : package$.MODULE$.Iterator().empty();
        return gapListing.$plus$plus((Function0 & Serializable & scala.Serializable)() -> unbackfilledDeltas);
    }

    public static final /* synthetic */ GenTraversableOnce $anonfun$commitFilesIterator$5(Iterator listedDeltas$1, DeltaLog deltaLog$2, LongRef maxVersionSeen$1, int x0$2) {
        int n = x0$2;
        switch (n) {
            case 1: {
                return listedDeltas$1;
            }
            case 2: {
                return CoordinatedCommitsUtils$.tailFromSnapshot$1(deltaLog$2, maxVersionSeen$1);
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static final /* synthetic */ boolean $anonfun$tablePropertiesPresent$1(Metadata metadata$2, String key) {
        return metadata$2.configuration().contains((Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$unbackfilledCommitsPresent$1(FileStatus x0$1) {
        FileStatus fileStatus = x0$1;
        Option<Tuple3<FileStatus, Object, String>> option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(fileStatus);
        return !option.isEmpty();
    }

    public static final /* synthetic */ void $anonfun$backfillWhenCoordinatedCommitsDisabled$1(DeltaLog deltaLog$4, FileSystem fs$1, Configuration hadoopConf$1, boolean overwrite$1, LongRef numAlreadyBackfilledFiles$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FileStatus unbackfilledDeltaFile = (FileStatus)tuple2._1();
            long version = tuple2._2$mcJ$sp();
            Path backfilledFilePath = FileNames$.MODULE$.unsafeDeltaFile(deltaLog$4.logPath(), version);
            if (!fs$1.exists(backfilledFilePath)) {
                ClosableIterator<String> actionsIter = deltaLog$4.store().readAsIterator(unbackfilledDeltaFile.getPath(), hadoopConf$1);
                deltaLog$4.store().write(backfilledFilePath, actionsIter, overwrite$1, hadoopConf$1);
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delta file ", " "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), unbackfilledDeltaFile.getPath().toString())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"backfilled to path ", "."}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH2(), backfilledFilePath.toString())})))));
                return;
            }
            ++numAlreadyBackfilledFiles$1.elem;
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delta file ", " "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), unbackfilledDeltaFile.getPath().toString())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"already backfilled."}))).log((Seq<MDC>)Nil$.MODULE$))));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getLastBackfilledFile$1(ObjectRef maxFile$1, FileStatus x0$1) {
        FileStatus fileStatus = x0$1;
        Option<Tuple2<FileStatus, Object>> option = FileNames$BackfilledDeltaFile$.MODULE$.unapply(fileStatus);
        if (!option.isEmpty()) {
            FileStatus f = (FileStatus)((Tuple2)option.get())._1();
            maxFile$1.elem = new Some((Object)f);
            return;
        }
        Option<Tuple3<FileStatus, Object, Object>> option2 = FileNames$CompactedDeltaFile$.MODULE$.unapply(fileStatus);
        if (!option2.isEmpty()) {
            FileStatus f = (FileStatus)((Tuple3)option2.get())._1();
            maxFile$1.elem = new Some((Object)f);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getExplicitCCConfigurations$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return MODULE$.TABLE_PROPERTY_KEYS().contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getExplicitICTConfigurations$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return MODULE$.ICT_TABLE_PROPERTY_KEYS().contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$verifyContainsOnlyCoordinatorNameAndConf$1(boolean fromDefault$1, Map properties$1, String command$1, DeltaConfig conf) {
        if (fromDefault$1) {
            if (properties$1.contains((Object)conf.defaultTablePropertyKey())) {
                throw new DeltaIllegalArgumentException("DELTA_CONF_OVERRIDE_NOT_SUPPORTED_IN_SESSION", (String[])((Object[])new String[]{command$1, conf.defaultTablePropertyKey(), conf.defaultTablePropertyKey()}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
            }
            return;
        }
        if (properties$1.contains((Object)conf.key())) {
            throw new DeltaIllegalArgumentException("DELTA_CONF_OVERRIDE_NOT_SUPPORTED_IN_COMMAND", (String[])((Object[])new String[]{command$1, conf.key()}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$verifyContainsOnlyCoordinatorNameAndConf$2(boolean fromDefault$1, Map properties$1, String command$1, DeltaConfig conf) {
        if (fromDefault$1) {
            if (!properties$1.contains((Object)conf.defaultTablePropertyKey())) {
                throw new DeltaIllegalArgumentException("DELTA_MUST_SET_ALL_COORDINATED_COMMITS_CONFS_IN_SESSION", (String[])((Object[])new String[]{command$1, conf.defaultTablePropertyKey()}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
            }
            return;
        }
        if (!properties$1.contains((Object)conf.key())) {
            throw new DeltaIllegalArgumentException("DELTA_MUST_SET_ALL_COORDINATED_COMMITS_CONFS_IN_COMMAND", (String[])((Object[])new String[]{command$1, conf.key()}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$verifyNotContainsICTConfigurations$1(Seq propKeys$1, String errorClass$1, String command$2, String key) {
        if (propKeys$1.contains((Object)key)) {
            throw new DeltaIllegalArgumentException(errorClass$1, (String[])((Object[])new String[]{command$2}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateConfigurationsForAlterTableUnsetPropertiesDeltaCommand$1(Object elem) {
        return MODULE$.TABLE_PROPERTY_KEYS().contains(elem);
    }

    private CoordinatedCommitsUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LoggingShims.$init$(this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.TABLE_PROPERTY_CONFS = (Seq)new .colon.colon(DeltaConfigs$.MODULE$.COORDINATED_COMMITS_COORDINATOR_NAME(), (List)new .colon.colon(DeltaConfigs$.MODULE$.COORDINATED_COMMITS_COORDINATOR_CONF(), (List)new .colon.colon(DeltaConfigs$.MODULE$.COORDINATED_COMMITS_TABLE_CONF(), (List)Nil$.MODULE$)));
        this.ICT_TABLE_PROPERTY_CONFS = (Seq)new .colon.colon(DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMPS_ENABLED(), (List)new .colon.colon(DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMP_ENABLEMENT_VERSION(), (List)new .colon.colon(DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMP_ENABLEMENT_TIMESTAMP(), (List)Nil$.MODULE$)));
        this.TABLE_PROPERTY_KEYS = (Seq)this.TABLE_PROPERTY_CONFS().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.key(), Seq$.MODULE$.canBuildFrom());
        this.ICT_TABLE_PROPERTY_KEYS = (Seq)this.ICT_TABLE_PROPERTY_CONFS().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.key(), Seq$.MODULE$.canBuildFrom());
    }
}

