/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.schema;

import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.TypeWidening$;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.constraints.Constraints$;
import org.apache.spark.sql.delta.schema.SchemaMergingUtils$;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;

public final class ImplicitMetadataOperation$ {
    public static ImplicitMetadataOperation$ MODULE$;

    static {
        new ImplicitMetadataOperation$();
    }

    public StructType mergeSchema(SparkSession spark, OptimisticTransaction txn, StructType dataSchema, boolean isOverwriteMode, boolean canOverwriteSchema) {
        if (isOverwriteMode && canOverwriteSchema) {
            return dataSchema;
        }
        this.checkDependentExpressions(spark, txn.protocol(), txn.metadata(), dataSchema);
        StructType x$1 = txn.metadata().schema();
        StructType x$2 = dataSchema;
        boolean x$3 = TypeWidening$.MODULE$.isEnabled(txn.protocol(), txn.metadata());
        boolean x$4 = SchemaMergingUtils$.MODULE$.mergeSchemas$default$3();
        boolean x$5 = SchemaMergingUtils$.MODULE$.mergeSchemas$default$4();
        boolean x$6 = SchemaMergingUtils$.MODULE$.mergeSchemas$default$6();
        return SchemaMergingUtils$.MODULE$.mergeSchemas(x$1, x$2, x$4, x$5, x$3, x$6);
    }

    private void checkDependentConstraints(SparkSession spark, Seq<String> path, Metadata metadata, DataType currentDt, DataType updateDt) {
        Map<String, String> dependentConstraints = Constraints$.MODULE$.findDependentConstraints(spark, path, metadata);
        if (dependentConstraints.nonEmpty()) {
            throw DeltaErrors$.MODULE$.constraintDataTypeMismatch(path, currentDt, updateDt, dependentConstraints);
        }
    }

    private void checkDependentGeneratedColumns(SparkSession spark, Seq<String> path, Protocol protocol, Metadata metadata, DataType currentDt, DataType updateDt) {
        Map<String, String> dependentGeneratedColumns = SchemaUtils$.MODULE$.findDependentGeneratedColumns(spark, path, protocol, metadata.schema());
        if (dependentGeneratedColumns.nonEmpty()) {
            throw DeltaErrors$.MODULE$.generatedColumnsDataTypeMismatch(path, currentDt, updateDt, dependentGeneratedColumns);
        }
    }

    private void checkConstraintsOrGeneratedColumnsOnStructField(SparkSession spark, Seq<String> path, Protocol protocol, Metadata metadata, DataType currentDt, DataType updateDt) {
        block8: {
            Tuple2 tuple2;
            while (true) {
                if ((tuple2 = new Tuple2((Object)currentDt, (Object)updateDt)) != null && tuple2._1() instanceof StructType && tuple2._2() instanceof StructType) {
                    break block8;
                }
                if (tuple2 != null) {
                    DataType current = (DataType)tuple2._1();
                    DataType update = (DataType)tuple2._2();
                    if (current instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)current;
                        if (update instanceof ArrayType) {
                            ArrayType arrayType2 = (ArrayType)update;
                            updateDt = arrayType2.elementType();
                            currentDt = arrayType.elementType();
                            path = (Seq)path.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom());
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break;
                DataType current = (DataType)tuple2._1();
                DataType update = (DataType)tuple2._2();
                if (!(current instanceof MapType)) break;
                MapType mapType = (MapType)current;
                if (!(update instanceof MapType)) break;
                MapType mapType2 = (MapType)update;
                this.checkConstraintsOrGeneratedColumnsOnStructField(spark, (Seq<String>)((Seq)path.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom())), protocol, metadata, mapType.keyType(), mapType2.keyType());
                updateDt = mapType2.valueType();
                currentDt = mapType.valueType();
                path = (Seq)path.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom());
            }
            if (tuple2 != null) {
                DataType dataType = currentDt;
                DataType dataType2 = updateDt;
                if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                    this.checkDependentConstraints(spark, path, metadata, currentDt, updateDt);
                    this.checkDependentGeneratedColumns(spark, path, protocol, metadata, currentDt, updateDt);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        }
    }

    private void checkDependentExpressions(SparkSession sparkSession, Protocol protocol, Metadata metadata, StructType dataSchema) {
        SchemaMergingUtils$.MODULE$.transformColumns(metadata.schema(), dataSchema, (Function4<Seq<String>, StructField, Option<StructField>, Function2<String, String, Object>, StructField>)(Function4 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1, x3$1) -> {
            Tuple4 tuple4 = new Tuple4(x0$1, x1$1, x2$1, x3$1);
            if (tuple4 != null) {
                Seq fieldPath = (Seq)tuple4._1();
                StructField currentField = (StructField)tuple4._2();
                Option option = (Option)tuple4._3();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    StructField updateField = (StructField)some.value();
                    if (!SchemaMergingUtils$.MODULE$.equalsIgnoreCaseAndCompatibleNullability(currentField.dataType(), updateField.dataType())) {
                        MODULE$.checkConstraintsOrGeneratedColumnsOnStructField(sparkSession, (Seq<String>)((Seq)fieldPath.$colon$plus((Object)currentField.name(), Seq$.MODULE$.canBuildFrom())), protocol, metadata, currentField.dataType(), updateField.dataType());
                        return updateField;
                    }
                }
            }
            if (tuple4 != null) {
                StructField field = (StructField)tuple4._2();
                return field;
            }
            throw new MatchError((Object)tuple4);
        });
    }

    private ImplicitMetadataOperation$() {
        MODULE$ = this;
    }
}

