/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.skipping;

import org.apache.spark.SparkException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.expressions.HilbertByteArrayIndex;
import org.apache.spark.sql.delta.expressions.HilbertLongIndex;
import org.apache.spark.sql.delta.expressions.InterleaveBits;
import org.apache.spark.sql.delta.expressions.RangePartitionId;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class MultiDimClusteringFunctions$ {
    public static MultiDimClusteringFunctions$ MODULE$;

    static {
        new MultiDimClusteringFunctions$();
    }

    private Column withExpr(Expression expr) {
        return Column$.MODULE$.apply(expr);
    }

    public Column range_partition_id(Column col, int numPartitions) {
        return this.withExpr((Expression)new RangePartitionId(col.expr(), numPartitions));
    }

    public Column interleave_bits(Seq<Column> cols) {
        return this.withExpr(new InterleaveBits((Seq<Expression>)((Seq)cols.map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.expr(), Seq$.MODULE$.canBuildFrom()))));
    }

    public Column hilbert_index(int numBits, Seq<Column> cols) {
        if (cols.size() > 9) {
            throw new SparkException("Hilbert indexing can only be used on 9 or fewer columns.");
        }
        int hilbertBits = cols.length() * numBits;
        return this.withExpr(hilbertBits < 64 ? new HilbertLongIndex(numBits, (Seq<Expression>)((Seq)cols.map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.expr(), Seq$.MODULE$.canBuildFrom()))) : new Cast((Expression)new HilbertByteArrayIndex(numBits, (Seq<Expression>)((Seq)cols.map((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.expr(), Seq$.MODULE$.canBuildFrom()))), (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
    }

    private MultiDimClusteringFunctions$() {
        MODULE$ = this;
    }
}

