/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import org.apache.spark.sql.delta.util.DateTimeFormatterHelper;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0003\u0006\u0001/!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\"\u0002!\u0001\t\u0003\t\u0005\u0002\u0003$\u0001\u0011\u000b\u0007I\u0011C$\t\u000bI\u0003A\u0011B*\t\u000be\u0003A\u0011\t.\t\u000b-\u0003A\u0011I0\u00033%\u001bx\u000e\u000f\u001c1cQKW.Z:uC6\u0004hi\u001c:nCR$XM\u001d\u0006\u0003\u00171\tA!\u001e;jY*\u0011QBD\u0001\u0006I\u0016dG/\u0019\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0005\u0001aq\"\u0005\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0001j\u0011AC\u0005\u0003C)\u0011!\u0003V5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;feB\u0011qdI\u0005\u0003I)\u0011q\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0011\u0016d\u0007/\u001a:\u0002\u000fA\fG\u000f^3s]B\u0011qE\f\b\u0003Q1\u0002\"!\u000b\u000e\u000e\u0003)R!a\u000b\f\u0002\rq\u0012xn\u001c;?\u0013\ti#$\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017\u001b\u0003!!\u0018.\\3[_:,\u0007CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011!\u0018.\\3\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u00075>tW-\u00133\u0002\r1|7-\u00197f!\tad(D\u0001>\u0015\tYa'\u0003\u0002@{\t1Aj\\2bY\u0016\fa\u0001P5oSRtD\u0003\u0002\"D\t\u0016\u0003\"a\b\u0001\t\u000b\u0015\"\u0001\u0019\u0001\u0014\t\u000bE\"\u0001\u0019\u0001\u001a\t\u000bi\"\u0001\u0019A\u001e\u0002\u0013\u0019|'/\\1ui\u0016\u0014X#\u0001%\u0011\u0005%cU\"\u0001&\u000b\u0005-#\u0014A\u00024pe6\fG/\u0003\u0002N\u0015\n\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:)\u0005\u0015y\u0005CA\rQ\u0013\t\t&DA\u0005ue\u0006t7/[3oi\u0006IAo\\%ogR\fg\u000e\u001e\u000b\u0003)^\u0003\"aM+\n\u0005Y#$aB%ogR\fg\u000e\u001e\u0005\u00061\u001a\u0001\rAJ\u0001\u0002g\u0006)\u0001/\u0019:tKR\u00111L\u0018\t\u00033qK!!\u0018\u000e\u0003\t1{gn\u001a\u0005\u00061\u001e\u0001\rA\n\u000b\u0003M\u0001DQ!\u0019\u0005A\u0002m\u000b!!^:")
public class Iso8601TimestampFormatter
implements TimestampFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private final String pattern;
    private final ZoneId timeZone;
    private final Locale locale;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Instant toInstantWithZoneId(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toInstantWithZoneId$(this, temporalAccessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale) {
        return DateTimeFormatterHelper.getOrCreateFormatter$(this, pattern, locale);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if (!this.bitmap$trans$0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale);
                this.bitmap$trans$0 = true;
            }
        }
        return this.formatter;
    }

    public DateTimeFormatter formatter() {
        if (!this.bitmap$trans$0) {
            return this.formatter$lzycompute();
        }
        return this.formatter;
    }

    private Instant toInstant(String s) {
        TemporalAccessor temporalAccessor = this.formatter().parse(s);
        if (temporalAccessor.query(TemporalQueries.offset()) == null) {
            return this.toInstantWithZoneId(temporalAccessor, this.timeZone);
        }
        return Instant.from(temporalAccessor);
    }

    @Override
    public long parse(String s) {
        return DateTimeUtils$.MODULE$.instantToMicros(this.toInstant(s));
    }

    @Override
    public String format(long us) {
        Instant instant = DateTimeUtils$.MODULE$.microsToInstant(us);
        return this.formatter().withZone(this.timeZone).format(instant);
    }

    public Iso8601TimestampFormatter(String pattern, ZoneId timeZone, Locale locale) {
        this.pattern = pattern;
        this.timeZone = timeZone;
        this.locale = locale;
        DateTimeFormatterHelper.$init$(this);
    }
}

