/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.delta.util.FractionTimestampFormatter;
import org.apache.spark.sql.delta.util.Iso8601TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import scala.Serializable;

public final class TimestampFormatter$
implements Serializable {
    public static TimestampFormatter$ MODULE$;
    private final String defaultPattern;
    private final Locale defaultLocale;

    static {
        new TimestampFormatter$();
    }

    public String defaultPattern() {
        return this.defaultPattern;
    }

    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    public TimestampFormatter apply(String format, ZoneId zoneId) {
        return new Iso8601TimestampFormatter(format, zoneId, this.defaultLocale());
    }

    public TimestampFormatter apply(String format, TimeZone timeZone, Locale locale) {
        return new Iso8601TimestampFormatter(format, timeZone.toZoneId(), locale);
    }

    public TimestampFormatter apply(String format, TimeZone timeZone) {
        return this.apply(format, timeZone, this.defaultLocale());
    }

    public TimestampFormatter apply(TimeZone timeZone) {
        return this.apply(this.defaultPattern(), timeZone, this.defaultLocale());
    }

    public TimestampFormatter getFractionFormatter(TimeZone timeZone) {
        return new FractionTimestampFormatter(timeZone);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TimestampFormatter$() {
        MODULE$ = this;
        this.defaultPattern = "yyyy-MM-dd HH:mm:ss";
        this.defaultLocale = Locale.US;
    }
}

