/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.paths.SparkPath;
import org.apache.spark.paths.SparkPath$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ElementAt;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.delta.CheckpointProvider$;
import org.apache.spark.sql.delta.Checkpoints$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.LastCheckpointInfo;
import org.apache.spark.sql.delta.LastCheckpointInfo$;
import org.apache.spark.sql.delta.LastCheckpointV2;
import org.apache.spark.sql.delta.LastCheckpointV2$;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.SerializableFileStatus$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.V2Checkpoint;
import org.apache.spark.sql.delta.V2Checkpoint$Format$JSON$;
import org.apache.spark.sql.delta.V2Checkpoint$Format$PARQUET$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.CheckpointMetadata;
import org.apache.spark.sql.delta.actions.CheckpointMetadata$;
import org.apache.spark.sql.delta.actions.SidecarFile;
import org.apache.spark.sql.delta.actions.SidecarFile$;
import org.apache.spark.sql.delta.actions.SingleAction;
import org.apache.spark.sql.delta.actions.SingleAction$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class Checkpoints$
implements DeltaLogging {
    public static final Checkpoints$ MODULE$ = new Checkpoints$();
    private static final String LAST_CHECKPOINT_FILE_NAME;
    private static final String STRUCT_PARTITIONS_COL_NAME;
    private static final String STRUCT_STATS_COL_NAME;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        LAST_CHECKPOINT_FILE_NAME = "_last_checkpoint";
        STRUCT_PARTITIONS_COL_NAME = "partitionValues_parsed";
        STRUCT_STATS_COL_NAME = "stats_parsed";
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String LAST_CHECKPOINT_FILE_NAME() {
        return LAST_CHECKPOINT_FILE_NAME;
    }

    public Option<StructType> checkpointSchemaToWriteInLastCheckpointFile(SparkSession spark, StructType schema) {
        int checkpointSchemaSizeThreshold = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.CHECKPOINT_SCHEMA_WRITE_THRESHOLD_LENGTH()));
        return new Some((Object)schema).filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Checkpoints$.$anonfun$checkpointSchemaToWriteInLastCheckpointFile$1(checkpointSchemaSizeThreshold, s)));
    }

    public LastCheckpointInfo writeCheckpoint(SparkSession spark, DeltaLog deltaLog, Snapshot snapshot) {
        return (LastCheckpointInfo)this.recordFrameProfile("Delta", "Checkpoints.writeCheckpoint", () -> Checkpoints$.$anonfun$writeCheckpoint$1(deltaLog, snapshot, spark));
    }

    public Tuple2<Path, Path> getCheckpointWritePath(Configuration conf, Path logPath, long version, int numParts, int part, boolean useRename, boolean v2CheckpointEnabled) {
        Path path;
        if (v2CheckpointEnabled) {
            path = FileNames$.MODULE$.newV2CheckpointSidecarFile(logPath, version, numParts, part + 1);
        } else if (numParts > 1) {
            Predef$.MODULE$.assert(part < numParts, (Function0 & Serializable)() -> new StringBuilder(45).append("Asked to create part: ").append(part).append(" of max ").append(numParts).append(" in checkpoint.").toString());
            path = (Path)FileNames$.MODULE$.checkpointFileWithParts(logPath, version, numParts).apply(part);
        } else {
            path = FileNames$.MODULE$.checkpointFileSingular(logPath, version);
        }
        Path destinationName = path;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Checkpoints$.getCheckpointWritePath$1(destinationName, useRename, conf)), (Object)destinationName);
    }

    public Tuple4<FileStatus, Seq<Action>, LastCheckpointV2, Option<StructType>> writeTopLevelV2Checkpoint(V2Checkpoint.Format v2CheckpointFormat, SerializableFileStatus[] sidecarCheckpointFiles, SparkSession spark, StructType sidecarSchema, Snapshot snapshot, DeltaLog deltaLog, long rowsWrittenInCheckpointJob, long parquetFilesSizeInBytes, Configuration hadoopConf, boolean useRename) {
        Tuple2 tuple2;
        CheckpointMetadata checkpointMetadata;
        Seq sidecarFilesWritten = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sidecarCheckpointFiles), (Function1 & Serializable)x$12 -> SidecarFile$.MODULE$.apply((SerializableFileStatus)x$12), ClassTag$.MODULE$.apply(SidecarFile.class))));
        Option<StructType> sidecarFileSchemaOpt = this.checkpointSchemaToWriteInLastCheckpointFile(spark, sidecarSchema);
        CheckpointMetadata checkpointMetadata2 = checkpointMetadata = new CheckpointMetadata(snapshot.version(), CheckpointMetadata$.MODULE$.apply$default$2());
        Seq nonFileActionsToWrite = (Seq)((IterableOps)sidecarFilesWritten.$plus$colon((Object)checkpointMetadata2)).$plus$plus(snapshot.nonFileActions());
        V2Checkpoint.Format format = v2CheckpointFormat;
        V2Checkpoint$Format$JSON$ v2Checkpoint$Format$JSON$ = V2Checkpoint$Format$JSON$.MODULE$;
        if (!(format != null ? !format.equals(v2Checkpoint$Format$JSON$) : v2Checkpoint$Format$JSON$ != null)) {
            Path v2CheckpointPath = FileNames$.MODULE$.newV2CheckpointJsonFile(deltaLog.logPath(), snapshot.version());
            boolean isPartialWriteVisible = deltaLog.store().isPartialWriteVisible(v2CheckpointPath, hadoopConf);
            deltaLog.store().write(v2CheckpointPath, (Iterator<String>)((IterableOnceOps)nonFileActionsToWrite.map((Function1 & Serializable)x$13 -> x$13.json())).toIterator(), !isPartialWriteVisible, hadoopConf);
            tuple2 = new Tuple2((Object)v2CheckpointPath, (Object)None$.MODULE$);
        } else {
            V2Checkpoint.Format format2 = v2CheckpointFormat;
            V2Checkpoint$Format$PARQUET$ v2Checkpoint$Format$PARQUET$ = V2Checkpoint$Format$PARQUET$.MODULE$;
            if (!(format2 != null ? !format2.equals(v2Checkpoint$Format$PARQUET$) : v2Checkpoint$Format$PARQUET$ != null)) {
                SparkSession sparkSession = spark;
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Org_apache_spark_sql_delta_Checkpoints$$typecreator10$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.delta.actions.SingleAction").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_sql_delta_Checkpoints$$typecreator10$1() {
                    }
                }
                Dataset dfToWrite = sparkSession.implicits().localSeqToDatasetHolder((Seq)nonFileActionsToWrite.map((Function1 & Serializable)x$14 -> x$14.wrap()), sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_Checkpoints$$typecreator10$1()))).toDF();
                Path v2CheckpointPath = FileNames$.MODULE$.newV2CheckpointParquetFile(deltaLog.logPath(), snapshot.version());
                StructType schemaOfDfWritten = this.createCheckpointV2ParquetFile(spark, (Dataset<Row>)dfToWrite, v2CheckpointPath, hadoopConf, useRename);
                tuple2 = new Tuple2((Object)v2CheckpointPath, (Object)new Some((Object)schemaOfDfWritten));
            } else {
                throw DeltaErrors$.MODULE$.assertionFailedError(new StringBuilder(35).append("Unrecognized checkpoint V2 format: ").append(v2CheckpointFormat).toString());
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Path v2CheckpointPath = (Path)tuple22._1();
        Option checkpointSchemaToWriteInLastCheckpoint = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)v2CheckpointPath, (Object)checkpointSchemaToWriteInLastCheckpoint);
        Path v2CheckpointPath2 = (Path)tuple23._1();
        Option checkpointSchemaToWriteInLastCheckpoint2 = (Option)tuple23._2();
        FileStatus v2CheckpointFileStatus = v2CheckpointPath2.getFileSystem(hadoopConf).getFileStatus(v2CheckpointPath2);
        LastCheckpointV2 unfilteredV2Checkpoint = LastCheckpointV2$.MODULE$.apply(v2CheckpointFileStatus, (Option<Seq<SingleAction>>)new Some(((IterableOps)snapshot.nonFileActions().$colon$plus((Object)checkpointMetadata)).map((Function1 & Serializable)x$16 -> x$16.wrap())), (Option<Seq<SidecarFile>>)new Some((Object)sidecarFilesWritten));
        return new Tuple4((Object)v2CheckpointFileStatus, (Object)nonFileActionsToWrite, (Object)this.trimLastCheckpointV2(unfilteredV2Checkpoint, spark), (Object)checkpointSchemaToWriteInLastCheckpoint2);
    }

    public StructType createCheckpointV2ParquetFile(SparkSession spark, Dataset<Row> ds, Path finalPath, Configuration hadoopConf, boolean useRename) {
        return (StructType)this.recordFrameProfile("Checkpoints", "createCheckpointV2ParquetFile", (Function0 & Serializable)() -> {
            Dataset df = ds.select("txn", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"add", "remove", "metaData", "protocol", "domainMetadata", "checkpointMetadata", "sidecar"}));
            StructType schema = df.schema().asNullable();
            ParquetFileFormat format = new ParquetFileFormat();
            Job job = Job.getInstance((Configuration)hadoopConf);
            OutputWriterFactory factory = format.prepareWrite(spark, job, Predef$.MODULE$.Map().empty(), schema);
            SerializableConfiguration serConf = new SerializableConfiguration(job.getConfiguration());
            SparkPath finalSparkPath = SparkPath$.MODULE$.fromPath(finalPath);
            RDD qual$1 = df.repartition(1).queryExecution().executedPlan().execute();
            Function1 & Serializable x$1 = (Function1 & Serializable)iter -> {
                FileStatus fileStatus;
                Path path;
                int actualNumParts = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.numPartitions())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
                Predef$.MODULE$.require(actualNumParts == 1, (Function0 & Serializable)() -> "The parquet V2 checkpoint must be written in 1 file");
                int partition = TaskContext$.MODULE$.getPartitionId();
                Path finalPath = finalSparkPath.toPath();
                if (useRename) {
                    Path tempPath = new Path(finalPath.getParent(), new StringBuilder(6).append(".").append(finalPath.getName()).append(".").append(UUID.randomUUID()).append(".tmp").toString());
                    DeltaFileOperations$.MODULE$.registerTempFileDeletionTaskFailureListener(serConf.value(), tempPath);
                    path = tempPath;
                } else {
                    path = finalPath;
                }
                Path writePath = path;
                FileSystem fs = writePath.getFileSystem(serConf.value());
                int attemptId = 0;
                TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(new JobConf(serConf.value()), new TaskAttemptID("", 0, TaskType.REDUCE, partition, attemptId));
                None$ writerOpt = None$.MODULE$;
                try {
                    writerOpt = new Some((Object)factory.newInstance(writePath.toString(), schema, (TaskAttemptContext)taskAttemptContext));
                    OutputWriter writer = (OutputWriter)writerOpt.get();
                    iter.foreach((Function1 & Serializable)row -> {
                        writer.write(row);
                        return BoxedUnit.UNIT;
                    });
                    writer.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileAlreadyExistsException && !useRename && fs.exists(writePath)) {
                    }
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        throw throwable3;
                    }
                    throw throwable;
                }
                if (useRename) {
                    MODULE$.renameAndCleanupTempPartFile(writePath, finalPath, fs);
                }
                try {
                    fileStatus = fs.getFileStatus(finalPath);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (throwable4 instanceof FileNotFoundException && useRename) {
                        throw DeltaErrors$.MODULE$.failOnCheckpointRename(writePath, finalPath);
                    }
                    throw throwable;
                }
                FileStatus finalPathFileStatus = fileStatus;
                return scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SerializableFileStatus[]{SerializableFileStatus$.MODULE$.fromStatus(finalPathFileStatus)}));
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(SerializableFileStatus.class)).collect();
            return schema;
        });
    }

    public LastCheckpointV2 trimLastCheckpointV2(LastCheckpointV2 lastCheckpointV2, SparkSession spark) {
        int nonFileActionThreshold = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LAST_CHECKPOINT_NON_FILE_ACTIONS_THRESHOLD()));
        int sidecarThreshold = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LAST_CHECKPOINT_SIDECARS_THRESHOLD()));
        Option x$1 = lastCheckpointV2.sidecarFiles().filter((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Checkpoints$.$anonfun$trimLastCheckpointV2$1(sidecarThreshold, x$18)));
        Option x$2 = lastCheckpointV2.nonFileActions().filter((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)Checkpoints$.$anonfun$trimLastCheckpointV2$2(nonFileActionThreshold, x$19)));
        String x$3 = lastCheckpointV2.copy$default$1();
        long x$4 = lastCheckpointV2.copy$default$2();
        long x$5 = lastCheckpointV2.copy$default$3();
        return lastCheckpointV2.copy(x$3, x$4, x$5, (Option<Seq<SingleAction>>)x$2, (Option<Seq<SidecarFile>>)x$1);
    }

    public void renameAndCleanupTempPartFile(Path tempPath, Path finalPath, FileSystem fs) {
        boolean renameSuccessful;
        boolean bl;
        try {
            bl = Utils$.MODULE$.isTesting() && fs.exists(finalPath) ? false : fs.rename(tempPath, finalPath);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            bl = renameSuccessful = false;
        }
        if (!renameSuccessful) {
            try {
                fs.delete(tempPath, false);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Error while deleting the temporary checkpoint part file ").append(tempPath).toString(), throwable2);
                }
                throw throwable;
            }
            return;
        }
    }

    public boolean isGCSPath(Configuration hadoopConf, Path path) {
        String scheme = path.toUri().getScheme();
        if (scheme != null) {
            return scheme.equalsIgnoreCase("gs");
        }
        return path.getFileSystem(hadoopConf).getScheme().equalsIgnoreCase("gs");
    }

    public Dataset<Row> buildCheckpoint(Dataset<Row> state, Snapshot snapshot) {
        BoxedUnit boxedUnit;
        ArrayBuffer additionalCols = new ArrayBuffer();
        SQLConf sessionConf = state.sparkSession().sessionState().conf();
        Object object = this.shouldWriteStatsAsJson(snapshot) ? additionalCols.$plus$eq((Object)functions$.MODULE$.col("add.stats").as("stats")) : BoxedUnit.UNIT;
        boolean includeStructColumns = this.shouldWriteStatsAsStruct(sessionConf, snapshot);
        if (includeStructColumns) {
            Option<Column> partitionValues = this.extractPartitionValues(snapshot.metadata().partitionSchema(), "add.partitionValues");
            boxedUnit = additionalCols.$plus$plus$eq(partitionValues);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return state.withColumn("add", functions$.MODULE$.when(functions$.MODULE$.col("add").isNotNull(), (Object)functions$.MODULE$.struct((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("add.path"), functions$.MODULE$.col("add.partitionValues"), functions$.MODULE$.col("add.size"), functions$.MODULE$.col("add.modificationTime"), functions$.MODULE$.col("add.dataChange"), functions$.MODULE$.col("add.tags"), functions$.MODULE$.col("add.deletionVector"), functions$.MODULE$.col("add.baseRowId"), functions$.MODULE$.col("add.defaultRowCommitVersion"), functions$.MODULE$.col("add.clusteringProvider")})).$plus$plus((IterableOnce)additionalCols))));
    }

    public boolean shouldWriteStatsAsStruct(SQLConf conf, Snapshot snapshot) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHECKPOINT_WRITE_STATS_AS_STRUCT().fromMetaData(snapshot.metadata()));
    }

    public boolean shouldWriteStatsAsJson(Snapshot snapshot) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHECKPOINT_WRITE_STATS_AS_JSON().fromMetaData(snapshot.metadata()));
    }

    public String STRUCT_PARTITIONS_COL_NAME() {
        return STRUCT_PARTITIONS_COL_NAME;
    }

    public String STRUCT_STATS_COL_NAME() {
        return STRUCT_STATS_COL_NAME;
    }

    public Option<Column> extractPartitionValues(StructType partitionSchema, String partitionValuesColName) {
        Seq partitionValues = (Seq)partitionSchema.map((Function1 & Serializable)field -> {
            UnresolvedAttribute attribute;
            String physicalName = DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)field);
            UnresolvedAttribute x$1 = attribute = UnresolvedAttribute$.MODULE$.quotedString(partitionValuesColName);
            Literal x$2 = Literal$.MODULE$.apply((Object)physicalName);
            boolean x$3 = false;
            Option x$4 = ElementAt$.MODULE$.apply$default$3();
            return new Column((Expression)Cast$.MODULE$.apply((Expression)new ElementAt((Expression)x$1, (Expression)x$2, x$4, false), field.dataType(), false)).as(physicalName);
        });
        if (partitionValues.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)functions$.MODULE$.struct(partitionValues).as(this.STRUCT_PARTITIONS_COL_NAME()));
    }

    public static final /* synthetic */ boolean $anonfun$checkpointSchemaToWriteInLastCheckpointFile$1(int checkpointSchemaSizeThreshold$1, StructType s) {
        return JsonUtils$.MODULE$.toJson(s, ManifestFactory$.MODULE$.classType(StructType.class)).length() <= checkpointSchemaSizeThreshold$1;
    }

    public static final /* synthetic */ long $anonfun$writeCheckpoint$2(Snapshot snapshot$2, long partSize) {
        return (long)scala.math.package$.MODULE$.ceil((double)(snapshot$2.numOfFiles() + snapshot$2.numOfRemoves()) / (double)partSize);
    }

    public static final /* synthetic */ long $anonfun$writeCheckpoint$3() {
        return 1L;
    }

    public static final /* synthetic */ SingleAction $anonfun$writeCheckpoint$4(LongAccumulator numOfFiles$1, SingleAction action) {
        block0: {
            if (action.add() == null) break block0;
            numOfFiles$1.add(1L);
        }
        return action;
    }

    public static final /* synthetic */ void $anonfun$writeCheckpoint$9(LongAccumulator checkpointRowCount$1, OutputWriter writer$1, InternalRow row) {
        checkpointRowCount$1.add(1L);
        writer$1.write(row);
    }

    private static final SerializableFileStatus[] executeFinalCheckpointFiles$1(QueryExecution qe$1, int numParts$1, SerializableConfiguration serConf$1, SparkPath logSparkPath$1, long version$2, boolean useRename$1, boolean v2CheckpointEnabled$1, OutputWriterFactory factory$1, StructType schema$1, LongAccumulator checkpointRowCount$1) {
        RDD qual$1 = qe$1.executedPlan().execute();
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            FileStatus fileStatus;
            Object object;
            Iterator iterator = x0$1;
            int actualNumParts = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.numPartitions())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> numParts$1));
            int partition = TaskContext$.MODULE$.getPartitionId();
            Tuple2<Path, Path> tuple2 = MODULE$.getCheckpointWritePath(serConf$1.value(), logSparkPath$1.toPath(), version$2, actualNumParts, partition, useRename$1, v2CheckpointEnabled$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Path writtenPath = (Path)tuple2._1();
            Path finalPath = (Path)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)writtenPath, (Object)finalPath);
            Path writtenPath2 = (Path)tuple22._1();
            Path finalPath2 = (Path)tuple22._2();
            FileSystem fs = writtenPath2.getFileSystem(serConf$1.value());
            JFunction0.mcV.sp & Serializable writeAction = (JFunction0.mcV.sp & Serializable)() -> {
                try {
                    OutputWriter writer = factory$1.newInstance(writtenPath2.toString(), schema$1, (TaskAttemptContext)new TaskAttemptContextImpl(new JobConf(serConf$1.value()), new TaskAttemptID("", 0, TaskType.REDUCE, 0, 0)));
                    iterator.foreach((Function1 & Serializable)row -> {
                        Checkpoints$.$anonfun$writeCheckpoint$9(checkpointRowCount$1, writer, row);
                        return BoxedUnit.UNIT;
                    });
                    writer.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileAlreadyExistsException) {
                        FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                        if (!useRename$1) {
                            if (fs.exists(writtenPath2)) {
                            }
                            throw fileAlreadyExistsException;
                        }
                    }
                    throw throwable;
                }
            };
            if (MODULE$.isGCSPath(serConf$1.value(), writtenPath2)) {
                object = DeltaFileOperations$.MODULE$.runInNewThread("delta-gcs-checkpoint-write", DeltaFileOperations$.MODULE$.runInNewThread$default$2(), writeAction);
            } else {
                writeAction.apply$mcV$sp();
                object = BoxedUnit.UNIT;
            }
            if (useRename$1) {
                MODULE$.renameAndCleanupTempPartFile(writtenPath2, finalPath2, fs);
            }
            try {
                fileStatus = fs.getFileStatus(finalPath2);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof FileNotFoundException && useRename$1) {
                    throw DeltaErrors$.MODULE$.failOnCheckpointRename(writtenPath2, finalPath2);
                }
                throw throwable;
            }
            FileStatus finalPathFileStatus = fileStatus;
            return scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SerializableFileStatus[]{SerializableFileStatus$.MODULE$.fromStatus(finalPathFileStatus)}));
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        return (SerializableFileStatus[])qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(SerializableFileStatus.class)).collect();
    }

    public static final /* synthetic */ SerializableFileStatus[] $anonfun$writeCheckpoint$10(QueryExecution qe$1, int numParts$1, SerializableConfiguration serConf$1, SparkPath logSparkPath$1, long version$2, boolean useRename$1, boolean v2CheckpointEnabled$1, OutputWriterFactory factory$1, StructType schema$1, LongAccumulator checkpointRowCount$1) {
        return Checkpoints$.executeFinalCheckpointFiles$1(qe$1, numParts$1, serConf$1, logSparkPath$1, version$2, useRename$1, v2CheckpointEnabled$1, factory$1, schema$1, checkpointRowCount$1);
    }

    public static final /* synthetic */ String $anonfun$writeCheckpoint$12() {
        return DeltaErrors$.MODULE$.EmptyCheckpointErrorMessage();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ LastCheckpointInfo $anonfun$writeCheckpoint$1(DeltaLog deltaLog$1, Snapshot snapshot$2, SparkSession spark$1) {
        block11: {
            block10: {
                hadoopConf = deltaLog$1.newDeltaHadoopConf();
                useRename = deltaLog$1.store().isPartialWriteVisible(deltaLog$1.logPath(), hadoopConf);
                policy = DeltaConfigs$.MODULE$.CHECKPOINT_POLICY().fromMetaData(snapshot$2.metadata());
                if (!policy.needsV2CheckpointSupport()) ** GOTO lbl29
                Predef$.MODULE$.assert(CheckpointProvider$.MODULE$.isV2CheckpointEnabled(snapshot$2));
                var12_7 = v2Format = spark$1.conf().get(DeltaSQLConf$.MODULE$.CHECKPOINT_V2_TOP_LEVEL_FILE_FORMAT());
                if (!(var12_7 instanceof Some)) ** GOTO lbl-1000
                var13_8 = (Some)var12_7;
                var14_9 = (String)var13_8.value();
                v0 = V2Checkpoint$Format$JSON$.MODULE$.name();
                var15_10 = var14_9;
                if (!(v0 != null ? v0.equals(var15_10) == false : var15_10 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = None$.MODULE$.equals(var12_7) != false;
                }
                if (!v1) break block10;
                v2 = new Some((Object)V2Checkpoint$Format$JSON$.MODULE$);
                break block11;
            }
            if (!(var12_7 instanceof Some)) ** GOTO lbl-1000
            var16_11 = (Some)var12_7;
            var17_12 = (String)var16_11.value();
            v3 = V2Checkpoint$Format$PARQUET$.MODULE$.name();
            var18_13 = var17_12;
            if (!(v3 != null ? v3.equals(var18_13) == false : var18_13 != null)) {
                v2 = new Some((Object)V2Checkpoint$Format$PARQUET$.MODULE$);
            } else lbl-1000:
            // 2 sources

            {
                throw new IllegalStateException("unknown checkpoint format");
lbl29:
                // 1 sources

                v2 = None$.MODULE$;
            }
        }
        v2CheckpointFormatOpt = v2;
        v2CheckpointEnabled = v2CheckpointFormatOpt.nonEmpty();
        checkpointRowCount = spark$1.sparkContext().longAccumulator("checkpointRowCount");
        numOfFiles = spark$1.sparkContext().longAccumulator("numOfFiles");
        sessionConf = spark$1.sessionState().conf();
        checkpointPartSize = sessionConf.getConf(DeltaSQLConf$.MODULE$.DELTA_CHECKPOINT_PART_SIZE());
        numParts = (int)BoxesRunTime.unboxToLong((Object)checkpointPartSize.map((Function1)(JFunction1.mcJJ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)J, $anonfun$writeCheckpoint$2(org.apache.spark.sql.delta.Snapshot long ), (J)J)((Snapshot)snapshot$2)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()J, $anonfun$writeCheckpoint$3(), ()J)()));
        legacyMultiPartCheckpoint = v2CheckpointEnabled == false && numParts > 1;
        repartitioned = snapshot$2.stateDS().repartition(numParts, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("add.path"), functions$.MODULE$.col("remove.path")}))})).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$writeCheckpoint$4(org.apache.spark.util.LongAccumulator org.apache.spark.sql.delta.actions.SingleAction ), (Lorg/apache/spark/sql/delta/actions/SingleAction;)Lorg/apache/spark/sql/delta/actions/SingleAction;)((LongAccumulator)numOfFiles), SingleAction$.MODULE$.encoder());
        base = v2CheckpointEnabled != false ? repartitioned.select("add", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"remove"})).withColumn("remove", functions$.MODULE$.col("remove").dropFields((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tags", "stats"}))).where("add is not null or remove is not null") : repartitioned.drop((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"commitInfo", "cdc", "checkpointMetadata", "sidecar"})).withColumn("remove", functions$.MODULE$.col("remove").dropFields((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tags", "stats"})));
        chk = Checkpoints$.MODULE$.buildCheckpoint((Dataset<Row>)base, snapshot$2);
        schema = chk.schema().asNullable();
        format = new ParquetFileFormat();
        job = Job.getInstance((Configuration)hadoopConf);
        var31_28 = new Tuple2((Object)format.prepareWrite(spark$1, job, Predef$.MODULE$.Map().empty(), schema), (Object)new SerializableConfiguration(job.getConfiguration()));
        if (var31_28 == null) {
            throw new MatchError((Object)var31_28);
        }
        factory = (OutputWriterFactory)var31_28._1();
        serConf = (SerializableConfiguration)var31_28._2();
        var30_31 = new Tuple2((Object)factory, (Object)serConf);
        factory = (OutputWriterFactory)var30_31._1();
        serConf = (SerializableConfiguration)var30_31._2();
        logSparkPath = SparkPath$.MODULE$.fromPath(snapshot$2.path());
        version = snapshot$2.version();
        qe = chk.queryExecution();
        finalCheckpointFiles = (SerializableFileStatus[])SQLExecution$.MODULE$.withNewExecutionId(qe, (Option)new Some((Object)"Delta checkpoint"), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$writeCheckpoint$10(org.apache.spark.sql.execution.QueryExecution int org.apache.spark.util.SerializableConfiguration org.apache.spark.paths.SparkPath long boolean boolean org.apache.spark.sql.execution.datasources.OutputWriterFactory org.apache.spark.sql.types.StructType org.apache.spark.util.LongAccumulator ), ()[Lorg/apache/spark/sql/delta/SerializableFileStatus;)((QueryExecution)qe, (int)numParts, (SerializableConfiguration)serConf, (SparkPath)logSparkPath, (long)version, (boolean)useRename, (boolean)v2CheckpointEnabled, (OutputWriterFactory)factory, (StructType)schema, (LongAccumulator)checkpointRowCount));
        if (!BoxesRunTime.equalsNumObject((Number)numOfFiles.value(), (Object)BoxesRunTime.boxToLong((long)snapshot$2.numOfFiles()))) {
            throw DeltaErrors$.MODULE$.checkpointMismatchWithSnapshot();
        }
        overallCheckpointSizeInBytes = parquetFilesSizeInBytes = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])finalCheckpointFiles), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$writeCheckpoint$11$adapted(org.apache.spark.sql.delta.SerializableFileStatus ), (Lorg/apache/spark/sql/delta/SerializableFileStatus;)Ljava/lang/Object;)(), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        overallNumCheckpointActions = Predef$.MODULE$.Long2long(checkpointRowCount.value());
        checkpointSchemaToWriteInLastCheckpoint = Checkpoints$.MODULE$.checkpointSchemaToWriteInLastCheckpointFile(spark$1, schema);
        if (v2CheckpointEnabled) {
            var52_42 = Checkpoints$.MODULE$.writeTopLevelV2Checkpoint((V2Checkpoint.Format)v2CheckpointFormatOpt.get(), finalCheckpointFiles, spark$1, schema, snapshot$2, deltaLog$1, overallNumCheckpointActions, parquetFilesSizeInBytes, hadoopConf, useRename);
            if (var52_42 == null) {
                throw new MatchError(var52_42);
            }
            v2CheckpointFileStatus = (FileStatus)var52_42._1();
            nonFileActionsWriten = (Seq)var52_42._2();
            v2Checkpoint = (LastCheckpointV2)var52_42._3();
            checkpointSchema = (Option)var52_42._4();
            var51_47 = new Tuple4((Object)v2CheckpointFileStatus, (Object)nonFileActionsWriten, (Object)v2Checkpoint, (Object)checkpointSchema);
            v2CheckpointFileStatus = (FileStatus)var51_47._1();
            nonFileActionsWriten = (Seq)var51_47._2();
            v2Checkpoint = (LastCheckpointV2)var51_47._3();
            checkpointSchema = (Option)var51_47._4();
            overallCheckpointSizeInBytes += v2CheckpointFileStatus.getLen();
            overallNumCheckpointActions += (long)nonFileActionsWriten.size();
            checkpointSchemaToWriteInLastCheckpoint = checkpointSchema;
            v4 = new Some((Object)v2Checkpoint);
        } else {
            v4 = v2Checkpoint = None$.MODULE$;
        }
        if (!v2CheckpointEnabled && BoxesRunTime.equalsNumObject((Number)checkpointRowCount.value(), (Object)BoxesRunTime.boxToInteger((int)0))) {
            Checkpoints$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$writeCheckpoint$12(), ()Ljava/lang/String;)());
        }
        checkpointParts = legacyMultiPartCheckpoint != false ? new Some((Object)BoxesRunTime.boxToInteger((int)numParts)) : None$.MODULE$;
        x$1 = snapshot$2.version();
        x$2 = overallNumCheckpointActions;
        x$3 = checkpointParts;
        x$4 = new Some((Object)BoxesRunTime.boxToLong((long)overallCheckpointSizeInBytes));
        x$5 = new Some((Object)BoxesRunTime.boxToLong((long)snapshot$2.numOfFiles()));
        x$6 = v2Checkpoint;
        x$7 = checkpointSchemaToWriteInLastCheckpoint;
        x$8 = LastCheckpointInfo$.MODULE$.apply$default$8();
        return new LastCheckpointInfo(x$1, x$2, (Option<Object>)x$3, (Option<Object>)x$4, (Option<Object>)x$5, x$7, (Option<LastCheckpointV2>)x$6, x$8);
    }

    private static final Path getCheckpointWritePath$1(Path path, boolean useRename$2, Configuration conf$1) {
        if (useRename$2) {
            Path tempPath = new Path(path.getParent(), new StringBuilder(6).append(".").append(path.getName()).append(".").append(UUID.randomUUID()).append(".tmp").toString());
            DeltaFileOperations$.MODULE$.registerTempFileDeletionTaskFailureListener(conf$1, tempPath);
            return tempPath;
        }
        return path;
    }

    public static final /* synthetic */ boolean $anonfun$trimLastCheckpointV2$1(int sidecarThreshold$1, Seq x$18) {
        return x$18.size() <= sidecarThreshold$1;
    }

    public static final /* synthetic */ boolean $anonfun$trimLastCheckpointV2$2(int nonFileActionThreshold$1, Seq x$19) {
        return x$19.size() <= nonFileActionThreshold$1;
    }

    private Checkpoints$() {
    }

    public static final /* synthetic */ Object $anonfun$writeCheckpoint$11$adapted(SerializableFileStatus x$10) {
        return BoxesRunTime.boxToLong((long)x$10.length());
    }
}

