/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.CheckpointInstance;
import org.apache.spark.sql.delta.CheckpointInstance$;
import org.apache.spark.sql.delta.CheckpointInstance$Format$SENTINEL$;
import org.apache.spark.sql.delta.CheckpointInstance$Format$SINGLE$;
import org.apache.spark.sql.delta.CheckpointInstance$Format$V2$;
import org.apache.spark.sql.delta.CheckpointInstance$Format$WITH_PARTS$;
import org.apache.spark.sql.delta.Checkpoints$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.LastCheckpointInfo;
import org.apache.spark.sql.delta.LastCheckpointInfo$;
import org.apache.spark.sql.delta.LastCheckpointV2;
import org.apache.spark.sql.delta.MetadataCleanup;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotManagement;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015c\u0001\u0003\u0017.!\u0003\r\t\u0001O?\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b)\u0003a\u0011A&\t\u000bQ\u0003a\u0011A&\t\u000bU\u0003a\u0011\u0003,\t\u000bu\u0003a\u0011\u00030\t\u000b\u0015\u0004A\u0011\u00014\t\u000fI\u0004!\u0019!C\u0001\u0017\")1\u000f\u0001C\ti\"1\u00111\u0004\u0001\u0005\u0002\u0019Cq!a\u0007\u0001\t\u0003\t\t\u0004C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!A\u00111\n\u0001\u0005\u00125\ni\u0005C\u0004\u0002f\u0001!\t\"a\u001a\t\u0011\u0005-\u0004\u0001\"\u0001.\u0003[Bq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002~\u0001!\t\"a \t\u000f\u0005-\u0005\u0001\"\u0005\u0002\u000e\"9\u00111\u0012\u0001\u0005\u0012\u0005M\u0005\"CAM\u0001E\u0005I\u0011CAN\u0011!\t\t\f\u0001C\t[\u0005M\u0006BCAc\u0001E\u0005I\u0011C\u0017\u0002H\u001e9\u00111Z\u0017\t\u0002\u00055gA\u0002\u0017.\u0011\u0003\ty\rC\u0004\u0002Rb!\t!a5\t\u0013\u0005U\u0007D1A\u0005\u0002\u0005]\u0007\u0002CAt1\u0001\u0006I!!7\t\u0011\u0005%\b\u0004\"\u0001.\u0003WD\u0001B!\u0003\u0019\t\u0003i#1\u0002\u0005\b\u0005+AB\u0011\u0001B\f\u0011!\u0011\t\u0005\u0007C\t[\t\r\u0003b\u0002BS1\u0011\u0005!q\u0015\u0005\b\u0005\u0007DB\u0011\u0001Bc\u0011!\u0011i\r\u0007C\u0001[\t=\u0007\u0002\u0003Bp1\u0011\u0005QF!9\t\u0011\t%\b\u0004\"\u0001.\u0005WDqaa\u0004\u0019\t\u0003\u0019\t\u0002C\u0004\u0004$a!\ta!\n\t\u0013\r%\u0002D1A\u0005\u0002\u0005]\u0007\u0002CB\u00161\u0001\u0006I!!7\t\u0013\r5\u0002D1A\u0005\u0002\u0005]\u0007\u0002CB\u00181\u0001\u0006I!!7\t\u000f\rE\u0002\u0004\"\u0001\u00044\tY1\t[3dWB|\u0017N\u001c;t\u0015\tqs&A\u0003eK2$\u0018M\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001s}\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0007C\u0001!D\u001b\u0005\t%B\u0001\".\u0003!iW\r^3sS:<\u0017B\u0001#B\u00051!U\r\u001c;b\u0019><w-\u001b8h\u0003\u0019!\u0013N\\5uIQ\tq\t\u0005\u0002;\u0011&\u0011\u0011j\u000f\u0002\u0005+:LG/A\u0004m_\u001e\u0004\u0016\r\u001e5\u0016\u00031\u0003\"!\u0014*\u000e\u00039S!a\u0014)\u0002\u0005\u0019\u001c(BA)4\u0003\u0019A\u0017\rZ8pa&\u00111K\u0014\u0002\u0005!\u0006$\b.\u0001\u0005eCR\f\u0007+\u0019;i\u0003\u0015\u0019Ho\u001c:f+\u00059\u0006C\u0001-\\\u001b\u0005I&B\u0001..\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001X-\u0003\u00111{wm\u0015;pe\u0016\fA\u0002Z8M_\u001e\u001cE.Z1okB$\"aR0\t\u000b\u0001,\u0001\u0019A1\u0002#Mt\u0017\r]:i_R$vn\u00117fC:,\b\u000f\u0005\u0002cG6\tQ&\u0003\u0002e[\tA1K\\1qg\"|G/\u0001\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dGCA4k!\tQ\u0004.\u0003\u0002jw\t\u0019\u0011J\u001c;\t\u000b-4\u0001\u0019\u00017\u0002\u00115,G/\u00193bi\u0006\u0004\"!\u001c9\u000e\u00039T!a\\\u0017\u0002\u000f\u0005\u001cG/[8og&\u0011\u0011O\u001c\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006yA*Q*U?\u000eCUiQ&Q\u001f&sE+A\u0010xSRD7\t[3dWB|\u0017N\u001c;Fq\u000e,\u0007\u000f^5p]\"\u000bg\u000e\u001a7j]\u001e$B!^>\u0002\u0002Q\u0011qI\u001e\u0005\u0007o\"!\t\u0019\u0001=\u0002\u000bQDWO\\6\u0011\u0007iJx)\u0003\u0002{w\tAAHY=oC6,g\bC\u0003}\u0011\u0001\u0007Q0\u0001\u0005eK2$\u0018\rT8h!\t\u0011g0\u0003\u0002\u0000[\tAA)\u001a7uC2{w\rC\u0004\u0002\u0004!\u0001\r!!\u0002\u0002\r=\u0004H+\u001f9f!\u0011\t9!!\u0006\u000f\t\u0005%\u0011\u0011\u0003\t\u0004\u0003\u0017YTBAA\u0007\u0015\r\tyaN\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M1(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'Y\u0014AC2iK\u000e\\\u0007o\\5oi\"Z\u0011\"a\b\u0002&\u0005\u001d\u00121FA\u0017!\rQ\u0014\u0011E\u0005\u0004\u0003GY$A\u00033faJ,7-\u0019;fI\u00069Q.Z:tC\u001e,\u0017EAA\u0015\u0003\u0005#\u0006.[:![\u0016$\bn\u001c3!SN\u0004C-\u001a9sK\u000e\fG/\u001a3!C:$\u0007e^5mY\u0002\u0012W\r\t:f[>4X\r\u001a\u0011j]\u00022W\u000f^;sK\u00022XM]:j_:\u001ch&A\u0003tS:\u001cW-\t\u0002\u00020\u0005!\u0011G\r\u00181)\r9\u00151\u0007\u0005\u0007\u0003kQ\u0001\u0019A1\u0002)Mt\u0017\r]:i_R$vn\u00115fG.\u0004x.\u001b8u\u0003e\u0019'/Z1uK\u000eCWmY6q_&tG/\u0011;WKJ\u001c\u0018n\u001c8\u0015\u0007\u001d\u000bY\u0004C\u0004\u0002>-\u0001\r!a\u0010\u0002\u000fY,'o]5p]B\u0019!(!\u0011\n\u0007\u0005\r3H\u0001\u0003M_:<\u0017\u0001H2iK\u000e\\\u0007o\\5oi\u0006sGm\u00117fC:,\u0006\u000fR3mi\u0006dun\u001a\u000b\u0004\u000f\u0006%\u0003BBA\u001b\u0019\u0001\u0007\u0011-A\fxe&$X\rT1ti\u000eCWmY6q_&tGOR5mKR9q)a\u0014\u0002R\u0005m\u0003\"\u0002?\u000e\u0001\u0004i\bbBA*\u001b\u0001\u0007\u0011QK\u0001\u0013Y\u0006\u001cHo\u00115fG.\u0004x.\u001b8u\u0013:4w\u000eE\u0002c\u0003/J1!!\u0017.\u0005Ia\u0015m\u001d;DQ\u0016\u001c7\u000e]8j]RLeNZ8\t\u000f\u0005uS\u00021\u0001\u0002`\u0005Y\u0011\r\u001a3DQ\u0016\u001c7n];n!\rQ\u0014\u0011M\u0005\u0004\u0003GZ$a\u0002\"p_2,\u0017M\\\u0001\u0015oJLG/Z\"iK\u000e\\\u0007o\\5oi\u001aKG.Z:\u0015\t\u0005U\u0013\u0011\u000e\u0005\u0007\u0003kq\u0001\u0019A1\u0002-I,\u0017\r\u001a'bgR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016$\"!a\u001c\u0011\u000bi\n\t(!\u0016\n\u0007\u0005M4H\u0001\u0004PaRLwN\\\u0001\u0015Y>\fG-T3uC\u0012\fG/\u0019$s_64\u0015\u000e\\3\u0015\t\u0005=\u0014\u0011\u0010\u0005\u0007\u0003w\u0002\u0002\u0019A4\u0002\u000bQ\u0014\u0018.Z:\u0002-5\fg.^1mYfdu.\u00193DQ\u0016\u001c7\u000e]8j]R$B!!\u0016\u0002\u0002\"9\u00111Q\tA\u0002\u0005\u0015\u0015AA2w!\r\u0011\u0017qQ\u0005\u0004\u0003\u0013k#AE\"iK\u000e\\\u0007o\\5oi&s7\u000f^1oG\u0016\f\u0001EZ5oI2\u000b7\u000f^\"p[BdW\r^3DQ\u0016\u001c7\u000e]8j]R\u0014UMZ8sKR!\u0011qRAI!\u0015Q\u0014\u0011OAC\u0011\u001d\tiD\u0005a\u0001\u0003\u007f!B!a$\u0002\u0016\"I\u0011qS\n\u0011\u0002\u0003\u0007\u0011qR\u0001\u0013G\",7m\u001b9pS:$\u0018J\\:uC:\u001cW-\u0001\u0016gS:$G*Y:u\u0007>l\u0007\u000f\\3uK\u000eCWmY6q_&tGOQ3g_J,G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u%\u0006BAH\u0003?[#!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003W[\u0014AC1o]>$\u0018\r^5p]&!\u0011qVAS\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001$O\u0016$H*\u0019;fgR\u001cu.\u001c9mKR,7\t[3dWB|\u0017N\u001c;Ge>lG*[:u)\u0019\ty)!.\u0002@\"9\u0011qW\u000bA\u0002\u0005e\u0016!C5ogR\fgnY3t!\u0015Q\u00141XAC\u0013\r\til\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\n\u0003\u0003,\u0002\u0013!a\u0001\u0003\u0007\f1C\\8u\u0019\u0006$XM\u001d+iC:4VM]:j_:\u0004RAOA9\u0003\u007f\tQfZ3u\u0019\u0006$Xm\u001d;D_6\u0004H.\u001a;f\u0007\",7m\u001b9pS:$hI]8n\u0019&\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIM\u000b\u0003\u0002D\u0006}\u0015aC\"iK\u000e\\\u0007o\\5oiN\u0004\"A\u0019\r\u0014\u0007aIt(\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u001b\f\u0011\u0004T!T)~\u001b\u0005*R\"L!>Ke\nV0G\u00132+uLT!N\u000bV\u0011\u0011\u0011\u001c\t\u0005\u00037\f)/\u0004\u0002\u0002^*!\u0011q\\Aq\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0018\u0001\u00026bm\u0006LA!a\u0006\u0002^\u0006QB*Q*U?\u000eCUiQ&Q\u001f&sEk\u0018$J\u0019\u0016{f*Q'FA\u0005Y3\r[3dWB|\u0017N\u001c;TG\",W.\u0019+p/JLG/Z%o\u0019\u0006\u001cHo\u00115fG.\u0004x.\u001b8u\r&dW\r\u0006\u0004\u0002n\u0006m(Q\u0001\t\u0006u\u0005E\u0014q\u001e\t\u0005\u0003c\f90\u0004\u0002\u0002t*\u0019\u0011Q_\u0018\u0002\u000bQL\b/Z:\n\t\u0005e\u00181\u001f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007B\u0002\u001a\u001d\u0001\u0004\ti\u0010\u0005\u0003\u0002\u0000\n\u0005Q\"A\u0018\n\u0007\t\rqF\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004\u0003\bq\u0001\r!a<\u0002\rM\u001c\u0007.Z7b\u0003=9(/\u001b;f\u0007\",7m\u001b9pS:$H\u0003CA+\u0005\u001b\u0011yA!\u0005\t\rIj\u0002\u0019AA\u007f\u0011\u0015aX\u00041\u0001~\u0011\u0019\u0011\u0019\"\ba\u0001C\u0006A1O\\1qg\"|G/\u0001\fhKR\u001c\u0005.Z2la>Lg\u000e^,sSR,\u0007+\u0019;i)A\u0011IBa\b\u0003.\t=\"\u0011\u0007B\u001b\u0005s\u0011i\u0004E\u0003;\u00057aE*C\u0002\u0003\u001em\u0012a\u0001V;qY\u0016\u0014\u0004b\u0002B\u0011=\u0001\u0007!1E\u0001\u0005G>tg\r\u0005\u0003\u0003&\t%RB\u0001B\u0014\u0015\r\u0011\t\u0003U\u0005\u0005\u0005W\u00119CA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006\u0015z\u0001\r\u0001\u0014\u0005\b\u0003{q\u0002\u0019AA \u0011\u0019\u0011\u0019D\ba\u0001O\u0006Aa.^7QCJ$8\u000f\u0003\u0004\u00038y\u0001\raZ\u0001\u0005a\u0006\u0014H\u000fC\u0004\u0003<y\u0001\r!a\u0018\u0002\u0013U\u001cXMU3oC6,\u0007b\u0002B =\u0001\u0007\u0011qL\u0001\u0014mJ\u001a\u0005.Z2la>Lg\u000e^#oC\ndW\rZ\u0001\u001aoJLG/\u001a+pa2+g/\u001a7We\rCWmY6q_&tG\u000f\u0006\f\u0003F\t=$\u0011\u0011BG\u0005\u001f\u0013\u0019J!&\u0003\u0018\nm%q\u0014BR!-Q$q\tB&\u0005#\u0012I'!<\n\u0007\t%3H\u0001\u0004UkBdW\r\u000e\t\u0004\u001b\n5\u0013b\u0001B(\u001d\nQa)\u001b7f'R\fG/^:\u0011\r\tM#Q\fB2\u001d\u0011\u0011)F!\u0017\u000f\t\u0005-!qK\u0005\u0002y%\u0019!1L\u001e\u0002\u000fA\f7m[1hK&!!q\fB1\u0005\r\u0019V-\u001d\u0006\u0004\u00057Z\u0004cA7\u0003f%\u0019!q\r8\u0003\r\u0005\u001bG/[8o!\r\u0011'1N\u0005\u0004\u0005[j#\u0001\u0005'bgR\u001c\u0005.Z2la>Lg\u000e\u001e,3\u0011\u001d\u0011\th\ba\u0001\u0005g\n!C\u001e\u001aDQ\u0016\u001c7\u000e]8j]R4uN]7biB!!Q\u000fB>\u001d\r\u0011'qO\u0005\u0004\u0005sj\u0013\u0001\u0004,3\u0007\",7m\u001b9pS:$\u0018\u0002\u0002B?\u0005\u007f\u0012aAR8s[\u0006$(b\u0001B=[!9!1Q\u0010A\u0002\t\u0015\u0015AF:jI\u0016\u001c\u0017M]\"iK\u000e\\\u0007o\\5oi\u001aKG.Z:\u0011\u000bi\nYLa\"\u0011\u0007\t\u0014I)C\u0002\u0003\f6\u0012acU3sS\u0006d\u0017N_1cY\u00164\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0007e}\u0001\r!!@\t\u000f\tEu\u00041\u0001\u0002p\u0006i1/\u001b3fG\u0006\u00148k\u00195f[\u0006DaAa\u0005 \u0001\u0004\t\u0007\"\u0002? \u0001\u0004i\bb\u0002BM?\u0001\u0007\u0011qH\u0001\u001be><8o\u0016:jiR,g.\u00138DQ\u0016\u001c7\u000e]8j]RTuN\u0019\u0005\b\u0005;{\u0002\u0019AA \u0003]\u0001\u0018M]9vKR4\u0015\u000e\\3t'&TX-\u00138CsR,7\u000fC\u0004\u0003\"~\u0001\rAa\t\u0002\u0015!\fGm\\8q\u0007>tg\rC\u0004\u0003<}\u0001\r!a\u0018\u0002;\r\u0014X-\u0019;f\u0007\",7m\u001b9pS:$hK\r)beF,X\r\u001e$jY\u0016$B\"a<\u0003*\n-&1\u0018B`\u0005\u0003DaA\r\u0011A\u0002\u0005u\bb\u0002BWA\u0001\u0007!qV\u0001\u0003IN\u0004b!a@\u00032\nU\u0016b\u0001BZ_\t9A)\u0019;bg\u0016$\b\u0003BA\u0000\u0005oK1A!/0\u0005\r\u0011vn\u001e\u0005\u0007\u0005{\u0003\u0003\u0019\u0001'\u0002\u0013\u0019Lg.\u00197QCRD\u0007b\u0002BQA\u0001\u0007!1\u0005\u0005\b\u0005w\u0001\u0003\u0019AA0\u0003Q!(/[7MCN$8\t[3dWB|\u0017N\u001c;WeQ1!\u0011\u000eBd\u0005\u0017DqA!3\"\u0001\u0004\u0011I'\u0001\tmCN$8\t[3dWB|\u0017N\u001c;We!1!'\ta\u0001\u0003{\fAD]3oC6,\u0017I\u001c3DY\u0016\fg.\u001e9UK6\u0004\b+\u0019:u\r&dW\rF\u0004H\u0005#\u0014)Na6\t\r\tM'\u00051\u0001M\u0003!!X-\u001c9QCRD\u0007B\u0002B_E\u0001\u0007A\n\u0003\u0004PE\u0001\u0007!\u0011\u001c\t\u0004\u001b\nm\u0017b\u0001Bo\u001d\nQa)\u001b7f'f\u001cH/Z7\u0002\u0013%\u001cxiQ*QCRDGCBA0\u0005G\u0014)\u000fC\u0004\u0003\"\u000e\u0002\rAa\t\t\r\t\u001d8\u00051\u0001M\u0003\u0011\u0001\u0018\r\u001e5\u0002\u001f\t,\u0018\u000e\u001c3DQ\u0016\u001c7\u000e]8j]R$bA!<\u0004\n\r5\u0001\u0003\u0002Bx\u0007\u0007qAA!=\u0004\u00029!!1\u001fB\u0000\u001d\u0011\u0011)P!@\u000f\t\t](1 \b\u0005\u0003\u0017\u0011I0C\u00017\u0013\t!T'\u0003\u00023g%\u0011\u0001'M\u0005\u0004\u00057z\u0013\u0002BB\u0003\u0007\u000f\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\tms\u0006C\u0004\u0004\f\u0011\u0002\rA!<\u0002\u000bM$\u0018\r^3\t\r\tMA\u00051\u0001b\u0003a\u0019\bn\\;mI^\u0013\u0018\u000e^3Ti\u0006$8/Q:TiJ,8\r\u001e\u000b\u0007\u0003?\u001a\u0019b!\t\t\u000f\t\u0005R\u00051\u0001\u0004\u0016A!1qCB\u000f\u001b\t\u0019IBC\u0002\u0004\u001c=\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0007?\u0019IBA\u0004T#2\u001buN\u001c4\t\r\tMQ\u00051\u0001b\u0003Y\u0019\bn\\;mI^\u0013\u0018\u000e^3Ti\u0006$8/Q:Kg>tG\u0003BA0\u0007OAaAa\u0005'\u0001\u0004\t\u0017AG*U%V\u001bEk\u0018)B%RKE+S(O'~\u001bu\nT0O\u00036+\u0015aG*U%V\u001bEk\u0018)B%RKE+S(O'~\u001bu\nT0O\u00036+\u0005%A\u000bT)J+6\tV0T)\u0006#6kX\"P\u0019~s\u0015)T#\u0002-M#&+V\"U?N#\u0016\tV*`\u0007>cuLT!N\u000b\u0002\na#\u001a=ue\u0006\u001cG\u000fU1si&$\u0018n\u001c8WC2,Xm\u001d\u000b\u0007\u0007k\u0019id!\u0011\u0011\u000bi\n\tha\u000e\u0011\t\u0005}8\u0011H\u0005\u0004\u0007wy#AB\"pYVlg\u000eC\u0004\u0004@-\u0002\r!a<\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006Dqaa\u0011,\u0001\u0004\t)!\u0001\fqCJ$\u0018\u000e^5p]Z\u000bG.^3t\u0007>dg*Y7f\u0001")
public interface Checkpoints
extends DeltaLogging {
    public static Option<Column> extractPartitionValues(StructType partitionSchema, String partitionValuesColName) {
        return Checkpoints$.MODULE$.extractPartitionValues(partitionSchema, partitionValuesColName);
    }

    public static String STRUCT_STATS_COL_NAME() {
        return Checkpoints$.MODULE$.STRUCT_STATS_COL_NAME();
    }

    public static String STRUCT_PARTITIONS_COL_NAME() {
        return Checkpoints$.MODULE$.STRUCT_PARTITIONS_COL_NAME();
    }

    public static boolean shouldWriteStatsAsJson(Snapshot snapshot) {
        return Checkpoints$.MODULE$.shouldWriteStatsAsJson(snapshot);
    }

    public static boolean shouldWriteStatsAsStruct(SQLConf conf, Snapshot snapshot) {
        return Checkpoints$.MODULE$.shouldWriteStatsAsStruct(conf, snapshot);
    }

    public static LastCheckpointV2 trimLastCheckpointV2(LastCheckpointV2 lastCheckpointV2, SparkSession spark) {
        return Checkpoints$.MODULE$.trimLastCheckpointV2(lastCheckpointV2, spark);
    }

    public static StructType createCheckpointV2ParquetFile(SparkSession spark, Dataset<Row> ds, Path finalPath, Configuration hadoopConf, boolean useRename) {
        return Checkpoints$.MODULE$.createCheckpointV2ParquetFile(spark, ds, finalPath, hadoopConf, useRename);
    }

    public static Tuple2<Path, Path> getCheckpointWritePath(Configuration conf, Path logPath, long version, int numParts, int part, boolean useRename, boolean v2CheckpointEnabled) {
        return Checkpoints$.MODULE$.getCheckpointWritePath(conf, logPath, version, numParts, part, useRename, v2CheckpointEnabled);
    }

    public static String LAST_CHECKPOINT_FILE_NAME() {
        return Checkpoints$.MODULE$.LAST_CHECKPOINT_FILE_NAME();
    }

    public void org$apache$spark$sql$delta$Checkpoints$_setter_$LAST_CHECKPOINT_$eq(Path var1);

    public Path logPath();

    public Path dataPath();

    public LogStore store();

    public void doLogCleanup(Snapshot var1);

    public static /* synthetic */ int checkpointInterval$(Checkpoints $this, Metadata metadata) {
        return $this.checkpointInterval(metadata);
    }

    default public int checkpointInterval(Metadata metadata) {
        return BoxesRunTime.unboxToInt((Object)DeltaConfigs$.MODULE$.CHECKPOINT_INTERVAL().fromMetaData(metadata));
    }

    public Path LAST_CHECKPOINT();

    public static /* synthetic */ void withCheckpointExceptionHandling$(Checkpoints $this, DeltaLog deltaLog, String opType, Function0 thunk) {
        $this.withCheckpointExceptionHandling(deltaLog, opType, (Function0<BoxedUnit>)thunk);
    }

    default public void withCheckpointExceptionHandling(DeltaLog deltaLog, String opType, Function0<BoxedUnit> thunk) {
        try {
            thunk.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                boolean throwError;
                DeltaLog x$1 = deltaLog;
                String x$2 = opType;
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)throwable2.getMessage()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stackTrace"), (Object)throwable2.getStackTrace())}));
                Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                Option<Path> x$5 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
                this.logWarning((Function0 & Serializable)() -> "Error when writing checkpoint-related files", throwable2);
                boolean bl = throwError = Utils$.MODULE$.isTesting() || BoxesRunTime.unboxToBoolean((Object)((DeltaLog)this).spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CHECKPOINT_THROW_EXCEPTION_WHEN_FAILED()));
                if (throwError) {
                    throw throwable2;
                }
            }
            throw throwable;
        }
    }

    public static /* synthetic */ void checkpoint$(Checkpoints $this) {
        $this.checkpoint();
    }

    default public void checkpoint() {
        this.checkpoint(((SnapshotManagement)((Object)this)).unsafeVolatileSnapshot());
    }

    public static /* synthetic */ void checkpoint$(Checkpoints $this, Snapshot snapshotToCheckpoint) {
        $this.checkpoint(snapshotToCheckpoint);
    }

    default public void checkpoint(Snapshot snapshotToCheckpoint) {
        this.recordDeltaOperation((DeltaLog)this, "delta.checkpoint", this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable)() -> this.withCheckpointExceptionHandling(snapshotToCheckpoint.deltaLog(), "delta.checkpoint.sync.error", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (snapshotToCheckpoint.version() < 0L) {
                throw DeltaErrors$.MODULE$.checkpointNonExistTable(((DeltaLog)this).dataPath());
            }
            this.checkpointAndCleanUpDeltaLog(snapshotToCheckpoint);
        }));
    }

    public static /* synthetic */ void createCheckpointAtVersion$(Checkpoints $this, long version) {
        $this.createCheckpointAtVersion(version);
    }

    default public void createCheckpointAtVersion(long version) {
        this.recordDeltaOperation((DeltaLog)this, "delta.createCheckpointAtVersion", this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable)() -> {
            Snapshot snapshot = ((SnapshotManagement)((Object)this)).getSnapshotAt(version, ((SnapshotManagement)((Object)this)).getSnapshotAt$default$2());
            this.withCheckpointExceptionHandling((DeltaLog)this, "delta.checkpoint.sync.error", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                if (snapshot.version() < 0L) {
                    throw DeltaErrors$.MODULE$.checkpointNonExistTable(((DeltaLog)this).dataPath());
                }
                this.writeCheckpointFiles(snapshot);
            });
        });
    }

    public static /* synthetic */ void checkpointAndCleanUpDeltaLog$(Checkpoints $this, Snapshot snapshotToCheckpoint) {
        $this.checkpointAndCleanUpDeltaLog(snapshotToCheckpoint);
    }

    default public void checkpointAndCleanUpDeltaLog(Snapshot snapshotToCheckpoint) {
        LastCheckpointInfo lastCheckpointInfo = this.writeCheckpointFiles(snapshotToCheckpoint);
        this.writeLastCheckpointFile(snapshotToCheckpoint.deltaLog(), lastCheckpointInfo, LastCheckpointInfo$.MODULE$.checksumEnabled(((DeltaLog)this).spark()));
        ((MetadataCleanup)((Object)this)).doLogCleanup(snapshotToCheckpoint);
    }

    public static /* synthetic */ void writeLastCheckpointFile$(Checkpoints $this, DeltaLog deltaLog, LastCheckpointInfo lastCheckpointInfo, boolean addChecksum) {
        $this.writeLastCheckpointFile(deltaLog, lastCheckpointInfo, addChecksum);
    }

    default public void writeLastCheckpointFile(DeltaLog deltaLog, LastCheckpointInfo lastCheckpointInfo, boolean addChecksum) {
        this.withCheckpointExceptionHandling(deltaLog, "delta.lastCheckpoint.write.error", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            boolean suppressOptionalFields = BoxesRunTime.unboxToBoolean((Object)((DeltaLog)this).spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.SUPPRESS_OPTIONAL_LAST_CHECKPOINT_FIELDS()));
            LastCheckpointInfo lastCheckpointInfoToWrite = lastCheckpointInfo;
            String json = LastCheckpointInfo$.MODULE$.serializeToJson(lastCheckpointInfoToWrite, addChecksum, suppressOptionalFields);
            ((DeltaLog)this).store().write(this.LAST_CHECKPOINT(), (Iterator<String>)package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{json})), true, ((DeltaLog)this).newDeltaHadoopConf());
        });
    }

    public static /* synthetic */ LastCheckpointInfo writeCheckpointFiles$(Checkpoints $this, Snapshot snapshotToCheckpoint) {
        return $this.writeCheckpointFiles(snapshotToCheckpoint);
    }

    default public LastCheckpointInfo writeCheckpointFiles(Snapshot snapshotToCheckpoint) {
        snapshotToCheckpoint.ensureCommitFilesBackfilled();
        return Checkpoints$.MODULE$.writeCheckpoint(((DeltaLog)this).spark(), (DeltaLog)this, snapshotToCheckpoint);
    }

    public static /* synthetic */ Option readLastCheckpointFile$(Checkpoints $this) {
        return $this.readLastCheckpointFile();
    }

    default public Option<LastCheckpointInfo> readLastCheckpointFile() {
        return this.loadMetadataFromFile(0);
    }

    private Option<LastCheckpointInfo> loadMetadataFromFile(int tries) {
        return (Option)this.recordDeltaOperation((DeltaLog)this, "delta.deltaLog.loadMetadataFromFile", this.recordDeltaOperation$default$3(), (Function0 & Serializable)() -> {
            Option option;
            try {
                Seq<String> lastCheckpointInfoJson = ((DeltaLog)this).store().read(this.LAST_CHECKPOINT(), ((DeltaLog)this).newDeltaHadoopConf());
                boolean validate = LastCheckpointInfo$.MODULE$.checksumEnabled(((DeltaLog)this).spark());
                option = new Some((Object)LastCheckpointInfo$.MODULE$.deserializeFromJson((String)lastCheckpointInfoJson.head(), validate));
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof FileNotFoundException) {
                    option = None$.MODULE$;
                }
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option2.get();
                    if (tries < 3) {
                        this.logWarning((Function0 & Serializable)() -> new StringBuilder(138).append("Failed to parse ").append(this.LAST_CHECKPOINT()).append(". This may happen if there was an error ").append("during read operation, or a file appears to be partial. Sleeping and trying again.").toString(), e);
                        Thread.sleep(1000L);
                        option = this.loadMetadataFromFile(tries + 1);
                    }
                }
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    DeltaLog x$1 = (DeltaLog)this;
                    String x$2 = "delta.lastCheckpoint.read.corruptedJson";
                    Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)Utils$.MODULE$.exceptionString(throwable2))}));
                    Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                    Option<Path> x$5 = this.recordDeltaEvent$default$5();
                    this.recordDeltaEvent(x$1, "delta.lastCheckpoint.read.corruptedJson", x$4, x$3, x$5);
                    this.logWarning((Function0 & Serializable)() -> new StringBuilder(56).append(this.LAST_CHECKPOINT()).append(" is corrupted. Will search the checkpoint files directly").toString(), throwable2);
                    Option<CheckpointInstance> verifiedCheckpoint = this.findLastCompleteCheckpointBefore((Option<CheckpointInstance>)None$.MODULE$);
                    option = verifiedCheckpoint.map((Function1 & Serializable)cv -> this.manuallyLoadCheckpoint((CheckpointInstance)cv));
                }
                throw throwable;
            }
            return option;
        });
    }

    public static /* synthetic */ LastCheckpointInfo manuallyLoadCheckpoint$(Checkpoints $this, CheckpointInstance cv) {
        return $this.manuallyLoadCheckpoint(cv);
    }

    default public LastCheckpointInfo manuallyLoadCheckpoint(CheckpointInstance cv) {
        return new LastCheckpointInfo(cv.version(), -1L, cv.numParts(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<StructType>)None$.MODULE$, LastCheckpointInfo$.MODULE$.apply$default$7(), LastCheckpointInfo$.MODULE$.apply$default$8());
    }

    public static /* synthetic */ Option findLastCompleteCheckpointBefore$(Checkpoints $this, long version) {
        return $this.findLastCompleteCheckpointBefore(version);
    }

    default public Option<CheckpointInstance> findLastCompleteCheckpointBefore(long version) {
        long x$1 = version;
        CheckpointInstance$Format$SINGLE$ x$2 = CheckpointInstance$Format$SINGLE$.MODULE$;
        None$ x$3 = None$.MODULE$;
        Option<String> x$4 = CheckpointInstance$.MODULE$.apply$default$3();
        CheckpointInstance upperBound = new CheckpointInstance(x$1, x$2, x$4, (Option<Object>)x$3);
        return this.findLastCompleteCheckpointBefore((Option<CheckpointInstance>)new Some((Object)upperBound));
    }

    public static /* synthetic */ Option findLastCompleteCheckpointBefore$(Checkpoints $this, Option checkpointInstance) {
        return $this.findLastCompleteCheckpointBefore((Option<CheckpointInstance>)checkpointInstance);
    }

    default public Option<CheckpointInstance> findLastCompleteCheckpointBefore(Option<CheckpointInstance> checkpointInstance) {
        Tuple2 tuple2 = (Tuple2)checkpointInstance.collect((PartialFunction)new Serializable((DeltaLog)this){
            private static final long serialVersionUID = 0L;

            public final <A1 extends CheckpointInstance, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.version() >= 0L) {
                    return (B1)new Tuple2(A1, (Object)BoxesRunTime.boxToLong((long)A1.version()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(CheckpointInstance x1) {
                CheckpointInstance checkpointInstance = x1;
                return checkpointInstance.version() >= 0L;
            }
        }).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)CheckpointInstance$.MODULE$.sentinelValue((Option<Object>)None$.MODULE$), (Object)BoxesRunTime.boxToLong((long)0L)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CheckpointInstance upperBoundCv = (CheckpointInstance)tuple2._1();
        long startVersion = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)upperBoundCv, (Object)BoxesRunTime.boxToLong((long)startVersion));
        CheckpointInstance upperBoundCv2 = (CheckpointInstance)tuple22._1();
        long startVersion2 = tuple22._2$mcJ$sp();
        LongRef cur = LongRef.create((long)startVersion2);
        Configuration hadoopConf = ((DeltaLog)this).newDeltaHadoopConf();
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(58).append("Try to find Delta last complete checkpoint before version ").append(startVersion2).toString());
        while (cur.elem >= 0L) {
            CheckpointInstance[] checkpoints = (CheckpointInstance[])((DeltaLog)this).store().listFrom(FileNames$.MODULE$.listingPrefix(((DeltaLog)this).logPath(), scala.math.package$.MODULE$.max(0L, cur.elem - 1000L)), hadoopConf).filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Checkpoints.$anonfun$findLastCompleteCheckpointBefore$3(file))).map((Function1 & Serializable)file -> CheckpointInstance$.MODULE$.apply(file.getPath())).takeWhile((Function1 & Serializable)tv -> BoxesRunTime.boxToBoolean((boolean)Checkpoints.$anonfun$findLastCompleteCheckpointBefore$5(cur, upperBoundCv2, tv))).toArray(ClassTag$.MODULE$.apply(CheckpointInstance.class));
            Option<CheckpointInstance> lastCheckpoint = this.getLatestCompleteCheckpointFromList(checkpoints, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)upperBoundCv2.version())));
            if (lastCheckpoint.isDefined()) {
                this.logInfo((Function0 & Serializable)() -> new StringBuilder(37).append("Delta checkpoint is found at version ").append(((CheckpointInstance)lastCheckpoint.get()).version()).toString());
                return lastCheckpoint;
            }
            cur.elem -= 1000L;
        }
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(51).append("No checkpoint found for Delta table before version ").append(startVersion2).toString());
        return None$.MODULE$;
    }

    public static /* synthetic */ Option findLastCompleteCheckpointBefore$default$1$(Checkpoints $this) {
        return $this.findLastCompleteCheckpointBefore$default$1();
    }

    default public Option<CheckpointInstance> findLastCompleteCheckpointBefore$default$1() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option getLatestCompleteCheckpointFromList$(Checkpoints $this, CheckpointInstance[] instances, Option notLaterThanVersion) {
        return $this.getLatestCompleteCheckpointFromList(instances, (Option<Object>)notLaterThanVersion);
    }

    default public Option<CheckpointInstance> getLatestCompleteCheckpointFromList(CheckpointInstance[] instances, Option<Object> notLaterThanVersion) {
        CheckpointInstance sentinelCv = CheckpointInstance$.MODULE$.sentinelValue(notLaterThanVersion);
        Map complete = (Map)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])instances), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.$less$eq(sentinelCv)))), (Function1 & Serializable)x -> (CheckpointInstance)Predef$.MODULE$.identity(x)).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Checkpoints.$anonfun$getLatestCompleteCheckpointFromList$3(x0$1)));
        if (complete.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(complete.keys().max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
    }

    public static /* synthetic */ Option getLatestCompleteCheckpointFromList$default$2$(Checkpoints $this) {
        return $this.getLatestCompleteCheckpointFromList$default$2();
    }

    default public Option<Object> getLatestCompleteCheckpointFromList$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ boolean $anonfun$findLastCompleteCheckpointBefore$3(FileStatus file) {
        return FileNames$.MODULE$.isCheckpointFile(file) && file.getLen() != 0L;
    }

    public static /* synthetic */ boolean $anonfun$findLastCompleteCheckpointBefore$5(LongRef cur$1, CheckpointInstance upperBoundCv$1, CheckpointInstance tv) {
        return (cur$1.elem == 0L || tv.version() <= cur$1.elem) && tv.$less(upperBoundCv$1);
    }

    public static /* synthetic */ boolean $anonfun$getLatestCompleteCheckpointFromList$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            CheckpointInstance ci = (CheckpointInstance)tuple2._1();
            CheckpointInstance[] matchingCheckpointInstances = (CheckpointInstance[])tuple2._2();
            CheckpointInstance.Format format = ci.format();
            if (CheckpointInstance$Format$SINGLE$.MODULE$.equals(format)) {
                return matchingCheckpointInstances.length == 1;
            }
            if (CheckpointInstance$Format$WITH_PARTS$.MODULE$.equals(format)) {
                Predef$.MODULE$.assert(ci.numParts().nonEmpty(), (Function0 & Serializable)() -> "Multi-Part Checkpoint must have non empty numParts");
                return matchingCheckpointInstances.length == BoxesRunTime.unboxToInt((Object)ci.numParts().get());
            }
            if (CheckpointInstance$Format$V2$.MODULE$.equals(format)) {
                return matchingCheckpointInstances.length == 1;
            }
            if (CheckpointInstance$Format$SENTINEL$.MODULE$.equals(format)) {
                return false;
            }
            throw new MatchError((Object)format);
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(Checkpoints $this) {
        $this.org$apache$spark$sql$delta$Checkpoints$_setter_$LAST_CHECKPOINT_$eq(new Path(((DeltaLog)$this).logPath(), Checkpoints$.MODULE$.LAST_CHECKPOINT_FILE_NAME()));
    }
}

