/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.SnapshotManagement$;
import org.apache.spark.sql.delta.storage.ClosableIterator;
import org.apache.spark.sql.delta.util.FileNames$DeltaFile$;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class DeltaFileProviderUtils$ {
    public static final DeltaFileProviderUtils$ MODULE$ = new DeltaFileProviderUtils$();
    private static final Map<String, String> jsonStatsParseOption = Predef$.MODULE$.Map().empty();

    public DeltaThreadPool readThreadPool() {
        return SnapshotManagement$.MODULE$.deltaLogAsyncUpdateThreadPool();
    }

    public Map<String, String> jsonStatsParseOption() {
        return jsonStatsParseOption;
    }

    public Function1<String, InternalRow> createJsonStatsParser(StructType schemaToUse) {
        JsonToStructs parser = new JsonToStructs((DataType)schemaToUse, this.jsonStatsParseOption(), null, (Option)new Some((Object)SQLConf$.MODULE$.get().sessionLocalTimeZone()));
        return (Function1 & Serializable)json -> {
            UTF8String utf8json = UTF8String.fromString((String)json);
            return (InternalRow)parser.nullSafeEval((Object)utf8json);
        };
    }

    public Seq<FileStatus> getDeltaFilesInVersionRange(SparkSession spark, DeltaLog deltaLog, long startVersion, long endVersion) {
        Seq result = deltaLog.listFrom(startVersion).collect((PartialFunction)new Serializable(endVersion){
            private static final long serialVersionUID = 0L;
            private final long endVersion$1;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple2<FileStatus, Object>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(A1)).isEmpty()) {
                    FileStatus fs = (FileStatus)((Tuple2)option.get())._1();
                    long v = ((Tuple2)option.get())._2$mcJ$sp();
                    if (v <= this.endVersion$1) {
                        return (B1)new Tuple2((Object)fs, (Object)BoxesRunTime.boxToLong((long)v));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                long v;
                Option<Tuple2<FileStatus, Object>> option;
                FileStatus fileStatus = x1;
                return fileStatus != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(fileStatus)).isEmpty() && (v = ((Tuple2)option.get())._2$mcJ$sp()) <= this.endVersion$1;
            }
            {
                this.endVersion$1 = endVersion$1;
            }
        }).toSeq();
        if ((long)result.size() != endVersion - startVersion + 1L) {
            throw DeltaErrors$.MODULE$.deltaVersionsNotContiguousException(spark, (Seq<Object>)((Seq)result.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._2$mcJ$sp()))));
        }
        return (Seq)result.map((Function1 & Serializable)x$2 -> (FileStatus)x$2._1());
    }

    public Seq<ClosableIterator<String>> parallelReadAndParseDeltaFilesAsIterator(DeltaLog deltaLog, SparkSession spark, Seq<FileStatus> files) {
        Configuration hadoopConf = deltaLog.newDeltaHadoopConf();
        return this.parallelReadDeltaFilesBase(spark, files, hadoopConf, (Function1 & Serializable)file -> deltaLog.store().readAsIterator((FileStatus)file, hadoopConf));
    }

    public <A> Seq<A> parallelReadDeltaFilesBase(SparkSession spark, Seq<FileStatus> files, Configuration hadoopConf, Function1<FileStatus, A> f) {
        return this.readThreadPool().parallelMap(spark, files, (Function1 & Serializable)file -> f.apply(file)).toSeq();
    }

    private DeltaFileProviderUtils$() {
    }
}

