/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import com.databricks.spark.util.TagDefinitions$TAG_TAHOE_PATH$;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FileSourceOptions$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AnalysisHelper$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$$anonfun$;
import org.apache.spark.sql.delta.DeltaLogFileIndex;
import org.apache.spark.sql.delta.DeltaLogFileIndex$;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public final class DeltaLog$
implements DeltaLogging {
    public static final DeltaLog$ MODULE$ = new DeltaLog$();
    private static final String LOG_DIR_NAME;
    private static Option<Cache<Tuple2<Path, Map<String, String>>, DeltaLog>> deltaLogCache;
    private static final Map<String, String> jsonCommitParseOption;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        LOG_DIR_NAME = "_delta_log";
        deltaLogCache = None$.MODULE$;
        jsonCommitParseOption = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)FailFastMode$.MODULE$.name())}));
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String LOG_DIR_NAME() {
        return LOG_DIR_NAME;
    }

    public Path logPathFor(String dataPath) {
        return this.logPathFor(new Path(dataPath));
    }

    public Path logPathFor(Path dataPath) {
        return DeltaTableUtils$.MODULE$.safeConcatPaths(dataPath, this.LOG_DIR_NAME());
    }

    public synchronized Cache<Tuple2<Path, Map<String, String>>, DeltaLog> getOrCreateCache(SQLConf conf) {
        Option<Cache<Tuple2<Path, Map<String, String>>, DeltaLog>> option = this.deltaLogCache();
        if (option instanceof Some) {
            Some some = (Some)option;
            Cache c = (Cache)some.value();
            return c;
        }
        if (None$.MODULE$.equals(option)) {
            CacheBuilder builder = this.createCacheBuilder(conf).removalListener(removalNotification -> {
                DeltaLog log = (DeltaLog)removalNotification.getValue();
                try {
                    log.unsafeVolatileSnapshot().uncache();
                }
                catch (NullPointerException nullPointerException) {}
            });
            this.deltaLogCache_$eq((Option<Cache<Tuple2<Path, Map<String, String>>, DeltaLog>>)new Some((Object)builder.build()));
            return (Cache)this.deltaLogCache().get();
        }
        throw new MatchError(option);
    }

    private Option<Cache<Tuple2<Path, Map<String, String>>, DeltaLog>> deltaLogCache() {
        return deltaLogCache;
    }

    private void deltaLogCache_$eq(Option<Cache<Tuple2<Path, Map<String, String>>, DeltaLog>> x$1) {
        deltaLogCache = x$1;
    }

    private CacheBuilder<Object, Object> createCacheBuilder(SQLConf conf) {
        long cacheRetention = BoxesRunTime.unboxToLong((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_LOG_CACHE_RETENTION_MINUTES()));
        long cacheSize = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_LOG_CACHE_SIZE()))), BoxesRunTime.unboxToLong((Object)package$.MODULE$.props().get("delta.log.cacheSize").map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$7)))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        return CacheBuilder.newBuilder().expireAfterAccess(cacheRetention, TimeUnit.MINUTES).maximumSize(cacheSize);
    }

    public LogicalRelation indexToRelation(SparkSession spark, DeltaLogFileIndex index, Map<String, String> additionalOptions, StructType schema) {
        FileFormat fileFormat = index.format();
        JsonFileFormat jsonFileFormat = DeltaLogFileIndex$.MODULE$.COMMIT_FILE_FORMAT();
        FileFormat fileFormat2 = fileFormat;
        Map formatSpecificOptions = !(jsonFileFormat != null ? !jsonFileFormat.equals(fileFormat2) : fileFormat2 != null) ? this.jsonCommitParseOption() : Predef$.MODULE$.Map().empty();
        Map allOptions = (Map)((MapOps)additionalOptions.$plus$plus((IterableOnce)formatSpecificOptions)).$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FileSourceOptions$.MODULE$.IGNORE_CORRUPT_FILES()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FileSourceOptions$.MODULE$.IGNORE_MISSING_FILES()), (Object)"false")})));
        HadoopFsRelation fsRelation = new HadoopFsRelation((FileIndex)index, index.partitionSchema(), schema, (Option)None$.MODULE$, index.format(), allOptions, spark);
        return LogicalRelation$.MODULE$.apply((BaseRelation)fsRelation, LogicalRelation$.MODULE$.apply$default$2());
    }

    public StructType indexToRelation$default$4() {
        return Action$.MODULE$.logSchema();
    }

    public Map<String, String> jsonCommitParseOption() {
        return jsonCommitParseOption;
    }

    public DeltaLog forTable(SparkSession spark, String dataPath) {
        return this.apply(spark, this.logPathFor(dataPath), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath) {
        return this.apply(spark, this.logPathFor(dataPath), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath, Map<String, String> options) {
        return this.apply(spark, this.logPathFor(dataPath), options, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath, Clock clock) {
        return this.apply(spark, this.logPathFor(dataPath), clock);
    }

    public DeltaLog forTable(SparkSession spark, TableIdentifier tableName) {
        return this.forTable(spark, tableName, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, CatalogTable table) {
        return this.forTable(spark, table, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, TableIdentifier tableName, Clock clock) {
        if (DeltaTableIdentifier$.MODULE$.isDeltaPath(spark, tableName)) {
            return this.forTable(spark, new Path(tableName.table()));
        }
        return this.forTable(spark, spark.sessionState().catalog().getTableMetadata(tableName), clock);
    }

    public DeltaLog forTable(SparkSession spark, CatalogTable table, Clock clock) {
        return this.apply(spark, this.logPathFor(new Path(table.location())), clock);
    }

    private DeltaLog apply(SparkSession spark, Path rawPath, Clock clock) {
        return this.apply(spark, rawPath, (Map<String, String>)Predef$.MODULE$.Map().empty(), clock);
    }

    public Tuple2<DeltaLog, Snapshot> forTableWithSnapshot(SparkSession spark, String dataPath) {
        return this.withFreshSnapshot((Function1<Clock, DeltaLog>)(Function1 & Serializable)x$8 -> MODULE$.forTable(spark, new Path(dataPath), (Clock)x$8));
    }

    public Tuple2<DeltaLog, Snapshot> forTableWithSnapshot(SparkSession spark, Path dataPath) {
        return this.withFreshSnapshot((Function1<Clock, DeltaLog>)(Function1 & Serializable)x$9 -> MODULE$.forTable(spark, dataPath, (Clock)x$9));
    }

    public Tuple2<DeltaLog, Snapshot> forTableWithSnapshot(SparkSession spark, TableIdentifier tableName) {
        return this.withFreshSnapshot((Function1<Clock, DeltaLog>)(Function1 & Serializable)x$10 -> MODULE$.forTable(spark, tableName, (Clock)x$10));
    }

    public Tuple2<DeltaLog, Snapshot> forTableWithSnapshot(SparkSession spark, Path dataPath, Map<String, String> options) {
        return this.withFreshSnapshot((Function1<Clock, DeltaLog>)(Function1 & Serializable)x$11 -> MODULE$.apply(spark, MODULE$.logPathFor(dataPath), options, (Clock)x$11));
    }

    public Tuple2<DeltaLog, Snapshot> withFreshSnapshot(Function1<Clock, DeltaLog> thunk) {
        SystemClock clock = new SystemClock();
        long ts = clock.getTimeMillis();
        DeltaLog deltaLog = (DeltaLog)thunk.apply((Object)clock);
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)ts));
        boolean x$2 = deltaLog.update$default$1();
        Snapshot snapshot = deltaLog.update(x$2, (Option<Object>)x$1);
        return new Tuple2((Object)deltaLog, (Object)snapshot);
    }

    private DeltaLog apply(SparkSession spark, Path rawPath, Map<String, String> options, Clock clock) {
        Map fileSystemOptions = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LOAD_FILE_SYSTEM_CONFIGS_FROM_DATAFRAME_OPTIONS())) ? options.filterKeys((Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)DeltaLog$.$anonfun$apply$1(k))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : Predef$.MODULE$.Map().empty();
        Configuration hadoopConf = spark.sessionState().newHadoopConfWithOptions(fileSystemOptions);
        FileSystem fs = rawPath.getFileSystem(hadoopConf);
        Path path = fs.makeQualified(rawPath);
        DeltaLog deltaLog = this.getDeltaLogFromCache$1(spark, path, fileSystemOptions, options, clock);
        if (BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(deltaLog.org$apache$spark$sql$delta$DeltaLog$$sparkContext().get()).map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isStopped())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true))) {
            this.getOrCreateCache(spark.sessionState().conf()).invalidate((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)fileSystemOptions));
            return this.getDeltaLogFromCache$1(spark, path, fileSystemOptions, options, clock);
        }
        return deltaLog;
    }

    private Clock apply$default$3() {
        return new SystemClock();
    }

    public void invalidateCache(SparkSession spark, Path dataPath) {
        try {
            Path rawPath = this.logPathFor(dataPath);
            FileSystem fs = rawPath.getFileSystem(spark.sessionState().newHadoopConf());
            Path path = fs.makeQualified(rawPath);
            Cache<Tuple2<Path, Map<String, String>>, DeltaLog> deltaLogCache = this.getOrCreateCache(spark.sessionState().conf());
            if (BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LOAD_FILE_SYSTEM_CONFIGS_FROM_DATAFRAME_OPTIONS()))) {
                ArrayBuffer keysToBeRemoved = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                for (Tuple2 key : deltaLogCache.asMap().keySet()) {
                    Object object = key._1();
                    Path path2 = path;
                    Object object2 = !(object != null ? !object.equals(path2) : path2 != null) ? keysToBeRemoved.$plus$eq((Object)key) : BoxedUnit.UNIT;
                }
                deltaLogCache.invalidateAll((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)keysToBeRemoved).asJava());
            } else {
                deltaLogCache.invalidate((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)Predef$.MODULE$.Map().empty()));
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
    }

    public void clearCache() {
        this.deltaLogCache().foreach((Function1 & Serializable)x$13 -> {
            x$13.invalidateAll();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void unsetCache() {
        this.deltaLogCache_$eq((Option<Cache<Tuple2<Path, Map<String, String>>, DeltaLog>>)None$.MODULE$);
    }

    public long cacheSize() {
        return BoxesRunTime.unboxToLong((Object)this.deltaLogCache().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.size())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public Dataset<Row> filterFileList(StructType partitionSchema, Dataset<Row> files, Seq<Expression> partitionFilters, Seq<String> partitionColumnPrefixes, boolean shouldRewritePartitionFilters) {
        Seq<Expression> rewrittenFilters = shouldRewritePartitionFilters ? this.rewritePartitionFilters(partitionSchema, (Function2<String, String, Object>)files.sparkSession().sessionState().conf().resolver(), partitionFilters, partitionColumnPrefixes) : partitionFilters;
        Expression expr = (Expression)rewrittenFilters.reduceLeftOption((Function2)And$.MODULE$).getOrElse((Function0 & Serializable)() -> Literal$.MODULE$.TrueLiteral());
        Column columnFilter = new Column(expr);
        return files.filter(columnFilter);
    }

    public Seq<String> filterFileList$default$4() {
        return Nil$.MODULE$;
    }

    public boolean filterFileList$default$5() {
        return true;
    }

    public Seq<Expression> rewritePartitionFilters(StructType partitionSchema, Function2<String, String, Object> resolver, Seq<Expression> partitionFilters, Seq<String> partitionColumnPrefixes) {
        return (Seq)partitionFilters.map((Function1 & Serializable)x$15 -> (Expression)x$15.transformUp((PartialFunction)new Serializable(partitionSchema, resolver, partitionColumnPrefixes){
            private static final long serialVersionUID = 0L;
            private final StructType partitionSchema$1;
            private final Function2 resolver$1;
            private final Seq partitionColumnPrefixes$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Attribute) {
                    Some some;
                    StructField f;
                    Attribute attribute = (Attribute)A1;
                    String unquoted = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(attribute.name()), "`")), "`");
                    Option partitionCol = this.partitionSchema$1.find((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$rewritePartitionFilters$1$1.$anonfun$applyOrElse$1(this, unquoted, field)));
                    Option option = partitionCol;
                    if (option instanceof Some && (f = (StructField)(some = (Some)option).value()) != null) {
                        StructField structField = f;
                        String name = DeltaColumnMapping$.MODULE$.getPhysicalName(structField);
                        return (B1)new Cast((Expression)new UnresolvedAttribute((Seq)this.partitionColumnPrefixes$1.$plus$plus((IterableOnce)new .colon.colon((Object)"partitionValues", (List)new .colon.colon((Object)name, (List)Nil$.MODULE$)))), structField.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                    }
                    if (None$.MODULE$.equals(option)) {
                        DeltaLog$.MODULE$.log().error(new StringBuilder(63).append("Partition filter referenced column ").append(attribute.name()).append(" not in the partition schema").toString());
                        return (B1)new UnresolvedAttribute((Seq)this.partitionColumnPrefixes$1.$plus$plus((IterableOnce)new .colon.colon((Object)"partitionValues", (List)new .colon.colon((Object)attribute.name(), (List)Nil$.MODULE$))));
                    }
                    throw new MatchError((Object)option);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof Attribute;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(anonfun$$nestedInanonfun$rewritePartitionFilters$1$1 $this, String unquoted$1, StructField field) {
                return BoxesRunTime.unboxToBoolean((Object)$this.resolver$1.apply((Object)field.name(), (Object)unquoted$1));
            }
            {
                this.partitionSchema$1 = partitionSchema$1;
                this.resolver$1 = resolver$1;
                this.partitionColumnPrefixes$1 = partitionColumnPrefixes$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.delta.DeltaLog$$anonfun$$nestedInanonfun$rewritePartitionFilters$1$1 java.lang.String org.apache.spark.sql.types.StructField )}, serializedLambda);
            }
        }));
    }

    public Seq<String> rewritePartitionFilters$default$4() {
        return Nil$.MODULE$;
    }

    public void assertRemovable(Snapshot snapshot) {
        Metadata metadata = snapshot.metadata();
        if (BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.IS_APPEND_ONLY().fromMetaData(metadata))) {
            throw DeltaErrors$.MODULE$.modifyAppendOnlyTableException(metadata.name());
        }
    }

    public Option<Object> minSetTransactionRetentionInterval(Metadata metadata) {
        return DeltaConfigs$.MODULE$.TRANSACTION_ID_RETENTION_DURATION().fromMetaData(metadata).map((Function1 & Serializable)i -> BoxesRunTime.boxToLong((long)DeltaConfigs$.MODULE$.getMilliSeconds(i)));
    }

    public long tombstoneRetentionMillis(Metadata metadata) {
        return DeltaConfigs$.MODULE$.getMilliSeconds(DeltaConfigs$.MODULE$.TOMBSTONE_RETENTION().fromMetaData(metadata));
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(String k) {
        return DeltaTableUtils$.MODULE$.validDeltaTableHadoopPrefixes().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)k.startsWith(x$1)));
    }

    private final DeltaLog createDeltaLog$1(Path path$2, Map fileSystemOptions$1, Map options$2, Clock clock$1) {
        return (DeltaLog)this.recordDeltaOperation(null, "delta.log.create", (Map<TagDefinition, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TagDefinitions$TAG_TAHOE_PATH$.MODULE$), (Object)path$2.getParent().toString())}))), (Function0 & Serializable)() -> (DeltaLog)AnalysisHelper$.MODULE$.allowInvokingTransformsInAnalyzer((Function0 & Serializable)() -> new DeltaLog(path$2, path$2.getParent(), (Map<String, String>)fileSystemOptions$1, (Map<String, String>)options$2, clock$1)));
    }

    private final DeltaLog getDeltaLogFromCache$1(SparkSession spark$5, Path path$2, Map fileSystemOptions$1, Map options$2, Clock clock$1) {
        DeltaLog deltaLog;
        try {
            deltaLog = (DeltaLog)this.getOrCreateCache(spark$5.sessionState().conf()).get((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path$2), (Object)fileSystemOptions$1), () -> this.createDeltaLog$1(path$2, fileSystemOptions$1, options$2, clock$1));
        }
        catch (UncheckedExecutionException e) {
            throw e.getCause();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        return deltaLog;
    }

    private DeltaLog$() {
    }
}

