/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.delta.DefaultRowCommitVersion$;
import org.apache.spark.sql.delta.DeltaCommitTag$PreservedRowTrackingTag$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.RowCommitVersion$;
import org.apache.spark.sql.delta.RowId$;
import org.apache.spark.sql.delta.RowTrackingFeature$;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import org.apache.spark.sql.types.StructField;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class RowTracking$ {
    public static final RowTracking$ MODULE$ = new RowTracking$();

    public boolean isSupported(Protocol protocol) {
        return protocol.isFeatureSupported(RowTrackingFeature$.MODULE$);
    }

    public boolean isEnabled(Protocol protocol, Metadata metadata) {
        boolean isEnabled = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().fromMetaData(metadata));
        if (isEnabled && !this.isSupported(protocol)) {
            throw new IllegalStateException(new StringBuilder(94).append("Table property '").append(DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().key()).append("' is ").append("set on the table but this table version doesn't support table feature ").append("'").append(TableFeatureProtocolUtils$.MODULE$.propertyKey(RowTrackingFeature$.MODULE$)).append("'.").toString());
        }
        return isEnabled;
    }

    public void checkStatsCollectedIfRowTrackingSupported(Protocol protocol, boolean convertToDeltaShouldCollectStats, boolean statsCollectionEnabled) {
        if (!this.isSupported(protocol)) {
            return;
        }
        if (!convertToDeltaShouldCollectStats || !statsCollectionEnabled) {
            throw DeltaErrors$.MODULE$.convertToDeltaRowTrackingEnabledWithoutStatsCollection();
        }
    }

    public Iterable<StructField> createMetadataStructFields(Protocol protocol, Metadata metadata, boolean nullable) {
        return (Iterable)((IterableOps)((IterableOps)Option$.MODULE$.option2Iterable(RowId$.MODULE$.createRowIdField(protocol, metadata, nullable)).$plus$plus(RowId$.MODULE$.createBaseRowIdField(protocol, metadata))).$plus$plus(DefaultRowCommitVersion$.MODULE$.createDefaultRowCommitVersionField(protocol, metadata))).$plus$plus(RowCommitVersion$.MODULE$.createMetadataStructField(protocol, metadata, nullable));
    }

    private Map<String, String> addPreservedRowTrackingTag(Map<String, String> tagsMap, boolean preserved) {
        return (Map)tagsMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaCommitTag$PreservedRowTrackingTag$.MODULE$.key()), (Object)Boolean.toString(preserved)));
    }

    public Map<String, String> addPreservedRowTrackingTagIfNotSet(SnapshotDescriptor snapshot, Map<String, String> tagsMap) {
        if (!this.isEnabled(snapshot.protocol(), snapshot.metadata()) || tagsMap.contains((Object)DeltaCommitTag$PreservedRowTrackingTag$.MODULE$.key())) {
            return tagsMap;
        }
        return this.addPreservedRowTrackingTag(tagsMap, true);
    }

    public Map<String, String> addPreservedRowTrackingTagIfNotSet$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Dataset<Row> preserveRowTrackingColumns(Dataset<Row> dfWithoutRowTrackingColumns, SnapshotDescriptor snapshot) {
        Dataset<Row> dfWithRowIds = RowId$.MODULE$.preserveRowIds(dfWithoutRowTrackingColumns, snapshot);
        return RowCommitVersion$.MODULE$.preserveRowCommitVersions(dfWithRowIds, snapshot);
    }

    private RowTracking$() {
    }
}

