/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.TypeChange;
import org.apache.spark.sql.delta.TypeWideningMetadata$;
import org.apache.spark.sql.delta.TypeWideningTableFeature$;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TypeWidening$ {
    public static final TypeWidening$ MODULE$ = new TypeWidening$();

    public boolean isSupported(Protocol protocol) {
        return protocol.isFeatureSupported(TypeWideningTableFeature$.MODULE$);
    }

    public boolean isEnabled(Protocol protocol, Metadata metadata) {
        boolean isEnabled = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_TYPE_WIDENING().fromMetaData(metadata));
        if (isEnabled && !this.isSupported(protocol)) {
            throw new IllegalStateException(new StringBuilder(94).append("Table property '").append(DeltaConfigs$.MODULE$.ENABLE_TYPE_WIDENING().key()).append("' is ").append("set on the table but this table version doesn't support table feature ").append("'").append(TableFeatureProtocolUtils$.MODULE$.propertyKey(TypeWideningTableFeature$.MODULE$)).append("'.").toString());
        }
        return isEnabled;
    }

    public void ensureFeatureConsistentlyEnabled(Protocol protocol, Metadata metadata, Protocol otherProtocol, Metadata otherMetadata) {
        if (this.isEnabled(protocol, metadata) != this.isEnabled(otherProtocol, otherMetadata)) {
            throw DeltaErrors$.MODULE$.metadataChangedException((Option<CommitInfo>)None$.MODULE$);
        }
    }

    public boolean isTypeChangeSupported(AtomicType fromType, AtomicType toType) {
        AtomicType to;
        AtomicType from;
        Tuple2 tuple2 = new Tuple2((Object)fromType, (Object)toType);
        if (tuple2 != null) {
            AtomicType from2 = (AtomicType)tuple2._1();
            AtomicType to2 = (AtomicType)tuple2._2();
            AtomicType atomicType = from2;
            AtomicType atomicType2 = to2;
            if (!(atomicType != null ? !atomicType.equals(atomicType2) : atomicType2 != null)) {
                return true;
            }
        }
        if (tuple2 != null && !Cast$.MODULE$.canUpCast((DataType)(from = (AtomicType)tuple2._1()), (DataType)(to = (AtomicType)tuple2._2()))) {
            return false;
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType3 = (AtomicType)tuple2._2();
            if (ByteType$.MODULE$.equals(atomicType) && ShortType$.MODULE$.equals(atomicType3)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType4 = (AtomicType)tuple2._2();
            if ((ByteType$.MODULE$.equals(atomicType) ? true : ShortType$.MODULE$.equals(atomicType)) && IntegerType$.MODULE$.equals(atomicType4)) {
                return true;
            }
        }
        return false;
    }

    public boolean isTypeChangeSupportedForSchemaEvolution(AtomicType fromType, AtomicType toType) {
        AtomicType to;
        AtomicType from;
        Tuple2 tuple2 = new Tuple2((Object)fromType, (Object)toType);
        if (tuple2 != null) {
            AtomicType from2 = (AtomicType)tuple2._1();
            AtomicType to2 = (AtomicType)tuple2._2();
            AtomicType atomicType = from2;
            AtomicType atomicType2 = to2;
            if (!(atomicType != null ? !atomicType.equals(atomicType2) : atomicType2 != null)) {
                return true;
            }
        }
        if (tuple2 != null && !this.isTypeChangeSupported(from = (AtomicType)tuple2._1(), to = (AtomicType)tuple2._2())) {
            return false;
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType3 = (AtomicType)tuple2._2();
            if (ByteType$.MODULE$.equals(atomicType) && ShortType$.MODULE$.equals(atomicType3)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType4 = (AtomicType)tuple2._2();
            if ((ByteType$.MODULE$.equals(atomicType) ? true : ShortType$.MODULE$.equals(atomicType)) && IntegerType$.MODULE$.equals(atomicType4)) {
                return true;
            }
        }
        return false;
    }

    public void assertTableReadable(Protocol protocol, Metadata metadata) {
        if (!this.isSupported(protocol) || !TypeWideningMetadata$.MODULE$.containsTypeWideningMetadata(metadata.schema())) {
            return;
        }
        TypeWideningMetadata$.MODULE$.getAllTypeChanges(metadata.schema()).foreach((Function1 & Serializable)x0$1 -> {
            TypeWidening$.$anonfun$assertTableReadable$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<AddFile> filterFilesRequiringRewrite(Snapshot snapshot, Seq<AddFile> files) {
        Option<Object> option = TypeWideningMetadata$.MODULE$.getLatestTypeChangeVersion(snapshot.metadata().schema());
        if (option instanceof Some) {
            Some some = (Some)option;
            long latestVersion = BoxesRunTime.unboxToLong((Object)some.value());
            return (Seq)files.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TypeWidening$.$anonfun$filterFilesRequiringRewrite$1(latestVersion, x$1)));
        }
        if (None$.MODULE$.equals(option)) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        throw new MatchError(option);
    }

    public long numFilesRequiringRewrite(Snapshot snapshot) {
        return this.filterFilesRequiringRewrite(snapshot, (Seq<AddFile>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(snapshot.allFiles().collect())).size();
    }

    public static final /* synthetic */ void $anonfun$assertTableReadable$1(Tuple2 x0$1) {
        TypeChange typeChange;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (typeChange = (TypeChange)tuple2._2()) != null) {
            DataType from = typeChange.fromType();
            DataType to = typeChange.toType();
            if (from instanceof AtomicType) {
                AtomicType atomicType;
                AtomicType atomicType2 = (AtomicType)from;
                if (to instanceof AtomicType && MODULE$.isTypeChangeSupported(atomicType2, atomicType = (AtomicType)to)) {
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Seq fieldPath = (Seq)tuple2._1();
            TypeChange invalidChange = (TypeChange)tuple2._2();
            throw DeltaErrors$.MODULE$.unsupportedTypeChangeInSchema((Seq<String>)((Seq)fieldPath.$plus$plus(invalidChange.fieldPath())), invalidChange.fromType(), invalidChange.toType());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$filterFilesRequiringRewrite$1(long latestVersion$1, AddFile x$1) {
        Option<Object> option = x$1.defaultRowCommitVersion();
        if (option instanceof Some) {
            Some some = (Some)option;
            long version = BoxesRunTime.unboxToLong((Object)some.value());
            return version < latestVersion$1;
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    private TypeWidening$() {
    }
}

