/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.TypeChange;
import org.apache.spark.sql.delta.TypeChange$;
import org.apache.spark.sql.delta.TypeWidening$;
import org.apache.spark.sql.delta.TypeWideningMetadata;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaMergingUtils$;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class TypeWideningMetadata$
implements DeltaLogging,
Serializable {
    public static final TypeWideningMetadata$ MODULE$ = new TypeWideningMetadata$();
    private static final String TYPE_CHANGES_METADATA_KEY;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        TYPE_CHANGES_METADATA_KEY = "delta.typeChanges";
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String TYPE_CHANGES_METADATA_KEY() {
        return TYPE_CHANGES_METADATA_KEY;
    }

    public Option<TypeWideningMetadata> fromField(StructField field) {
        return Option$.MODULE$.when(field.metadata().contains(this.TYPE_CHANGES_METADATA_KEY()), (Function0 & Serializable)() -> {
            Seq typeChanges = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])field.metadata().getMetadataArray(MODULE$.TYPE_CHANGES_METADATA_KEY())), (Function1 & Serializable)changeMetadata -> TypeChange$.MODULE$.fromMetadata((Metadata)changeMetadata), ClassTag$.MODULE$.apply(TypeChange.class))));
            return new TypeWideningMetadata((Seq<TypeChange>)typeChanges);
        });
    }

    public StructType addTypeWideningMetadata(OptimisticTransaction txn, StructType schema, StructType oldSchema) {
        StructType schemaWithMetadata;
        block2: {
            if (!TypeWidening$.MODULE$.isEnabled(txn.protocol(), txn.metadata())) {
                return schema;
            }
            if (DataType$.MODULE$.equalsIgnoreNullability((DataType)schema, (DataType)oldSchema)) {
                return schema;
            }
            Buffer changesToRecord = (Buffer)Buffer$.MODULE$.empty();
            schemaWithMetadata = SchemaMergingUtils$.MODULE$.transformColumns(schema, oldSchema, (Function4<Seq<String>, StructField, Option<StructField>, Function2<String, String, Object>, StructField>)(Function4 & Serializable)(x0$1, x1$1, x2$1, x3$1) -> {
                Tuple4 tuple4 = new Tuple4(x0$1, x1$1, x2$1, x3$1);
                if (tuple4 != null) {
                    StructField newField = (StructField)tuple4._2();
                    Option option = (Option)tuple4._3();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        StructField oldField = (StructField)some.value();
                        Seq<TypeChange> typeChanges = MODULE$.collectTypeChanges(oldField.dataType(), newField.dataType(), txn.getFirstAttemptVersion());
                        changesToRecord.$plus$plus$eq(typeChanges);
                        return new TypeWideningMetadata(typeChanges).appendToField(newField);
                    }
                }
                if (tuple4 != null) {
                    StructField newField = (StructField)tuple4._2();
                    Option option = (Option)tuple4._3();
                    if (None$.MODULE$.equals(option)) {
                        return newField;
                    }
                }
                throw new MatchError((Object)tuple4);
            });
            if (!changesToRecord.nonEmpty()) break block2;
            DeltaLog x$1 = txn.snapshot().deltaLog();
            String x$2 = "delta.typeWidening.typeChanges";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changes"), changesToRecord.map((Function1 & Serializable)change -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fromType"), (Object)change.fromType().sql()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"toType"), (Object)change.toType().sql())}))))}));
            Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
            Option<Path> x$5 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$1, "delta.typeWidening.typeChanges", x$4, x$3, x$5);
        }
        return schemaWithMetadata;
    }

    private Seq<TypeChange> collectTypeChanges(DataType fromType, DataType toType, long version) {
        Tuple2 tuple2 = new Tuple2((Object)fromType, (Object)toType);
        if (tuple2 != null) {
            DataType from = (DataType)tuple2._1();
            DataType to = (DataType)tuple2._2();
            if (from instanceof MapType) {
                MapType mapType = (MapType)from;
                if (to instanceof MapType) {
                    MapType mapType2 = (MapType)to;
                    return (Seq)((IterableOps)this.collectTypeChanges(mapType.keyType(), mapType2.keyType(), version).map((Function1 & Serializable)typeChange -> {
                        Seq x$1 = (Seq)typeChange.fieldPath().$plus$colon((Object)"key");
                        long x$2 = typeChange.copy$default$1();
                        DataType x$3 = typeChange.copy$default$2();
                        DataType x$4 = typeChange.copy$default$3();
                        return typeChange.copy(x$2, x$3, x$4, (Seq<String>)x$1);
                    })).$plus$plus((IterableOnce)this.collectTypeChanges(mapType.valueType(), mapType2.valueType(), version).map((Function1 & Serializable)typeChange -> {
                        Seq x$5 = (Seq)typeChange.fieldPath().$plus$colon((Object)"value");
                        long x$6 = typeChange.copy$default$1();
                        DataType x$7 = typeChange.copy$default$2();
                        DataType x$8 = typeChange.copy$default$3();
                        return typeChange.copy(x$6, x$7, x$8, (Seq<String>)x$5);
                    }));
                }
            }
        }
        if (tuple2 != null) {
            DataType from = (DataType)tuple2._1();
            DataType to = (DataType)tuple2._2();
            if (from instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)from;
                if (to instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)to;
                    return (Seq)this.collectTypeChanges(arrayType.elementType(), arrayType2.elementType(), version).map((Function1 & Serializable)typeChange -> {
                        Seq x$9 = (Seq)typeChange.fieldPath().$plus$colon((Object)"element");
                        long x$10 = typeChange.copy$default$1();
                        DataType x$11 = typeChange.copy$default$2();
                        DataType x$12 = typeChange.copy$default$3();
                        return typeChange.copy(x$10, x$11, x$12, (Seq<String>)x$9);
                    });
                }
            }
        }
        if (tuple2 != null) {
            DataType fromType2 = (DataType)tuple2._1();
            DataType toType2 = (DataType)tuple2._2();
            if (fromType2 instanceof AtomicType) {
                AtomicType atomicType = (AtomicType)fromType2;
                if (toType2 instanceof AtomicType) {
                    AtomicType atomicType2 = (AtomicType)toType2;
                    AtomicType atomicType3 = atomicType;
                    AtomicType atomicType4 = atomicType2;
                    if (atomicType3 == null ? atomicType4 != null : !atomicType3.equals(atomicType4)) {
                        return new .colon.colon((Object)new TypeChange(version, (DataType)atomicType, (DataType)atomicType2, (Seq<String>)((Seq)package$.MODULE$.Seq().empty())), (List)Nil$.MODULE$);
                    }
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof AtomicType && tuple2._2() instanceof AtomicType) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (tuple2 != null && tuple2._1() instanceof StructType && tuple2._2() instanceof StructType) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        throw new MatchError((Object)tuple2);
    }

    public StructType updateTypeChangeVersion(StructType schema, long fromVersion, long toVersion) {
        return SchemaMergingUtils$.MODULE$.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable)(x0$1, x1$1, x2$1) -> {
            Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
            if (tuple3 != null) {
                StructField field = (StructField)tuple3._2();
                Option<TypeWideningMetadata> option = MODULE$.fromField(field);
                if (option instanceof Some) {
                    Metadata newMetadata;
                    Some some = (Some)option;
                    TypeWideningMetadata typeWideningMetadata = (TypeWideningMetadata)some.value();
                    Seq updatedTypeChanges = (Seq)typeWideningMetadata.typeChanges().map((Function1 & Serializable)x0$2 -> {
                        TypeChange typeChange = x0$2;
                        if (typeChange.version() == fromVersion) {
                            return typeChange.copy(toVersion, typeChange.copy$default$2(), typeChange.copy$default$3(), typeChange.copy$default$4());
                        }
                        return typeChange;
                    });
                    Metadata x$1 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).putMetadataArray(MODULE$.TYPE_CHANGES_METADATA_KEY(), (Metadata[])((IterableOnceOps)updatedTypeChanges.map((Function1 & Serializable)x$3 -> x$3.toMetadata())).toArray(ClassTag$.MODULE$.apply(Metadata.class))).build();
                    String x$2 = field.copy$default$1();
                    DataType x$32 = field.copy$default$2();
                    boolean x$4 = field.copy$default$3();
                    return field.copy(x$2, x$32, x$4, x$1);
                }
                if (None$.MODULE$.equals(option)) {
                    return field;
                }
                throw new MatchError(option);
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public Tuple2<StructType, Seq<Tuple2<Seq<String>, StructField>>> removeTypeWideningMetadata(StructType schema) {
        if (!this.containsTypeWideningMetadata(schema)) {
            return new Tuple2((Object)schema, (Object)package$.MODULE$.Seq().empty());
        }
        Buffer changes = (Buffer)Buffer$.MODULE$.empty();
        StructType newSchema = SchemaMergingUtils$.MODULE$.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable)(x0$1, x1$1, x2$1) -> {
            StructField field;
            Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
            if (tuple3 != null) {
                Seq fieldPath = (Seq)tuple3._1();
                StructField field2 = (StructField)tuple3._2();
                if (fieldPath != null) {
                    StructField structField;
                    Seq seq = fieldPath;
                    if (field2 != null && (structField = field2).metadata().contains(MODULE$.TYPE_CHANGES_METADATA_KEY())) {
                        Metadata cleanMetadata;
                        changes.append((Object)new Tuple2((Object)seq, (Object)structField));
                        Metadata x$1 = cleanMetadata = new MetadataBuilder().withMetadata(structField.metadata()).remove(MODULE$.TYPE_CHANGES_METADATA_KEY()).build();
                        String x$2 = structField.copy$default$1();
                        DataType x$3 = structField.copy$default$2();
                        boolean x$4 = structField.copy$default$3();
                        return structField.copy(x$2, x$3, x$4, x$1);
                    }
                }
            }
            if (tuple3 != null && (field = (StructField)tuple3._2()) != null) {
                StructField structField = field;
                return structField;
            }
            throw new MatchError((Object)tuple3);
        });
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newSchema), (Object)changes.toSeq());
    }

    public boolean containsTypeWideningMetadata(StructType schema) {
        return schema.existsRecursively((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TypeWideningMetadata$.$anonfun$containsTypeWideningMetadata$1(x0$1)));
    }

    public Seq<Tuple2<Seq<String>, TypeChange>> getAllTypeChanges(StructType schema) {
        if (!this.containsTypeWideningMetadata(schema)) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        Seq<Tuple2<Seq<String>, StructField>> allStructFields = SchemaUtils$.MODULE$.filterRecursively(schema, true, (Function1<StructField, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TypeWideningMetadata$.$anonfun$getAllTypeChanges$1(x$5)));
        return (Seq)allStructFields.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq fieldPath = (Seq)tuple2._1();
                StructField field = (StructField)tuple2._2();
                return (IterableOnce)this.getTypeChanges$1(field).map((Function1 & Serializable)x$7 -> new Tuple2(fieldPath.$colon$plus((Object)field.name()), x$7));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<Object> getLatestTypeChangeVersion(StructType schema) {
        Seq allStructFields = (Seq)SchemaUtils$.MODULE$.filterRecursively(schema, true, (Function1<StructField, Object>)(Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TypeWideningMetadata$.$anonfun$getLatestTypeChangeVersion$1(x$8))).map((Function1 & Serializable)x$9 -> (StructField)x$9._2());
        Seq versions = (Seq)((IterableOps)((IterableOps)allStructFields.flatMap((Function1 & Serializable)field -> MODULE$.fromField((StructField)field))).flatMap((Function1 & Serializable)x$10 -> x$10.typeChanges())).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.version()));
        if (versions.nonEmpty()) {
            return new Some(versions.max((Ordering)Ordering.Long$.MODULE$));
        }
        return None$.MODULE$;
    }

    public TypeWideningMetadata apply(Seq<TypeChange> typeChanges) {
        return new TypeWideningMetadata(typeChanges);
    }

    public Option<Seq<TypeChange>> unapply(TypeWideningMetadata x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some(x$0.typeChanges());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TypeWideningMetadata$.class);
    }

    public static final /* synthetic */ boolean $anonfun$containsTypeWideningMetadata$2(StructField x$4) {
        return x$4.metadata().contains(MODULE$.TYPE_CHANGES_METADATA_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$containsTypeWideningMetadata$1(DataType x0$1) {
        DataType dataType = x0$1;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return structType.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TypeWideningMetadata$.$anonfun$containsTypeWideningMetadata$2(x$4)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getAllTypeChanges$1(StructField x$5) {
        return true;
    }

    private final Seq getTypeChanges$1(StructField field) {
        return (Seq)this.fromField(field).map((Function1 & Serializable)x$6 -> x$6.typeChanges()).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public static final /* synthetic */ boolean $anonfun$getLatestTypeChangeVersion$1(StructField x$8) {
        return true;
    }

    private TypeWideningMetadata$() {
    }
}

