/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005uga\u0002\t\u0012!\u0003\r\tA\b\u0005\u0006S\u0001!\tA\u000b\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0011\u0015\u0001\u0005\u0001\"\u0003B\u0011\u0015\u0011\u0007\u0001\"\u0005d\u0011\u001d\t)\u0001\u0001C\t\u0003\u000fA\u0011\"a\u0006\u0001#\u0003%\t\"!\u0007\t\u0013\u0005=\u0002!%A\u0005\u0012\u0005e\u0001bBA\u0019\u0001\u0011E\u00111\u0007\u0005\b\u0003\u000f\u0002A\u0011CA%\u0011\u001d\t9\u0007\u0001C\t\u0003SBq!a'\u0001\t#\ti\nC\u0004\u0002\"\u0002!\t\"a)\t\u000f\u0005\u001d\u0006\u0001\"\u0005\u0002*\"9\u0011Q\u0019\u0001\u0005\u0012\u0005\u001d\u0007bBAk\u0001\u0011E\u0011q\u001b\u0002\u0012-\u0006\u001cW/^7D_6l\u0017M\u001c3J[Bd'B\u0001\n\u0014\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\u000b\u0016\u0003\u0015!W\r\u001c;b\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019:S\"A\t\n\u0005!\n\"\u0001\u0004#fYR\f7i\\7nC:$\u0017A\u0002\u0013j]&$H\u0005F\u0001,!\t\u0001C&\u0003\u0002.C\t!QK\\5u\u0003U\u0019X\u000f\u001d9peR,GMR:G_JdunZ4j]\u001e,\u0012\u0001\r\t\u0004cYBT\"\u0001\u001a\u000b\u0005M\"\u0014!C5n[V$\u0018M\u00197f\u0015\t)\u0014%\u0001\u0006d_2dWm\u0019;j_:L!a\u000e\u001a\u0003\u0007M+\u0017\u000f\u0005\u0002:}5\t!H\u0003\u0002<y\u0005!A.\u00198h\u0015\u0005i\u0014\u0001\u00026bm\u0006L!a\u0010\u001e\u0003\rM#(/\u001b8h\u0003=\u0019\bn\\;mI2{wMV1dkVlG#\u0002\"F\u0015BS\u0006C\u0001\u0011D\u0013\t!\u0015EA\u0004C_>dW-\u00198\t\u000ba\u0019\u0001\u0019\u0001$\u0011\u0005\u001dCU\"A\u000b\n\u0005%+\"\u0001D*qCJ\\7+Z:tS>t\u0007\"B&\u0004\u0001\u0004a\u0015\u0001\u00033fYR\fGj\\4\u0011\u00055sU\"A\n\n\u0005=\u001b\"\u0001\u0003#fYR\fGj\\4\t\u000bE\u001b\u0001\u0019\u0001*\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0002T16\tAK\u0003\u0002V-\u0006!1m\u001c8g\u0015\t9\u0016$\u0001\u0004iC\u0012|w\u000e]\u0005\u00033R\u0013QbQ8oM&<WO]1uS>t\u0007\"B.\u0004\u0001\u0004a\u0016\u0001\u00029bi\"\u0004\"!\u00181\u000e\u0003yS!a\u0018,\u0002\u0005\u0019\u001c\u0018BA1_\u0005\u0011\u0001\u0016\r\u001e5\u0002\u001d1|wMV1dkVl7\u000b^1siRI1\u0006Z3gOZ\\\u0018\u0011\u0001\u0005\u00061\u0011\u0001\rA\u0012\u0005\u0006\u0017\u0012\u0001\r\u0001\u0014\u0005\u00067\u0012\u0001\r\u0001\u0018\u0005\u0006Q\u0012\u0001\r![\u0001\u0005I&4g\rE\u0002HU2L!a[\u000b\u0003\u000f\u0011\u000bG/Y:fiB\u0011Q\u000e\u001e\b\u0003]J\u0004\"a\\\u0011\u000e\u0003AT!!]\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0018%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007fUT!a]\u0011\t\u000b]$\u0001\u0019\u0001=\u0002%ML'0Z(g\t\u0006$\u0018\rV8EK2,G/\u001a\t\u0003AeL!A_\u0011\u0003\t1{gn\u001a\u0005\u0006y\u0012\u0001\r!`\u0001\u0019gB,7-\u001b4jK\u0012\u0014V\r^3oi&|g.T5mY&\u001c\bc\u0001\u0011\u007fq&\u0011q0\t\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005\rA\u00011\u0001y\u0003Y!WMZ1vYR\u0014V\r^3oi&|g.T5mY&\u001c\u0018\u0001\u00047pOZ\u000b7-^;n\u000b:$GcC\u0016\u0002\n\u0005-\u0011QBA\b\u0003'AQaS\u0003A\u00021CQ\u0001G\u0003A\u0002\u0019CQaW\u0003A\u0002qC\u0001\"!\u0005\u0006!\u0003\u0005\r!`\u0001\rM&dWm\u001d#fY\u0016$X\r\u001a\u0005\t\u0003+)\u0001\u0013!a\u0001{\u0006IA-\u001b:D_VtGo]\u0001\u0017Y><g+Y2vk6,e\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0004\u0016\u0004{\u0006u1FAA\u0010!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\u0012%\u0001\u0006b]:|G/\u0019;j_:LA!!\f\u0002$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-1|wMV1dkVlWI\u001c3%I\u00164\u0017-\u001e7uIU\n!B]3mCRLg/\u001b>f)%a\u0017QGA\u001c\u0003\u007f\t\u0019\u0005C\u0003\\\u0011\u0001\u0007A\f\u0003\u0004`\u0011\u0001\u0007\u0011\u0011\b\t\u0004;\u0006m\u0012bAA\u001f=\nQa)\u001b7f'f\u001cH/Z7\t\r\u0005\u0005\u0003\u00021\u0001]\u00035\u0011Xm]3sm>L'OQ1tK\"1\u0011Q\t\u0005A\u0002\t\u000bQ![:ESJ\fQbZ3u\u00032d7+\u001e2eSJ\u001cH\u0003CA&\u0003;\n\t'!\u001a\u0011\u000b\u00055\u0013q\u000b7\u000f\t\u0005=\u00131\u000b\b\u0004_\u0006E\u0013\"\u0001\u0012\n\u0007\u0005U\u0013%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00131\f\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011QK\u0011\t\r\u0005}\u0013\u00021\u0001m\u0003\u0011\u0011\u0017m]3\t\r\u0005\r\u0014\u00021\u0001m\u0003\u00111\u0017\u000e\\3\t\r}K\u0001\u0019AA\u001d\u0003\u0019!W\r\\3uKRi\u00010a\u001b\u0002n\u0005=\u00141OAG\u0003#CQ\u0001\u001b\u0006A\u0002%DQ\u0001\u0007\u0006A\u0002\u0019Ca!!\u001d\u000b\u0001\u0004a\u0017\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\t\rES\u0001\u0019AA;!\u0019\t9(! \u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0004\u0003w:\u0012!\u00032s_\u0006$7-Y:u\u0013\u0011\ty(!\u001f\u0003\u0013\t\u0013x.\u00193dCN$\b\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001du#\u0001\u0003vi&d\u0017\u0002BAF\u0003\u000b\u0013\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"1\u0011q\u0012\u0006A\u0002\t\u000b\u0001\u0002]1sC2dW\r\u001c\u0005\b\u0003'S\u0001\u0019AAK\u0003I\u0001\u0018M]1mY\u0016d\u0007+\u0019:uSRLwN\\:\u0011\u0007\u0001\n9*C\u0002\u0002\u001a\u0006\u00121!\u00138u\u00031\u0019HO]5oOR{\u0007+\u0019;i)\ra\u0016q\u0014\u0005\u00067.\u0001\r\u0001\\\u0001\ra\u0006$\b\u000eV8TiJLgn\u001a\u000b\u0004Y\u0006\u0015\u0006\"B.\r\u0001\u0004a\u0016!F4fi\u0006\u001bG/[8o%\u0016d\u0017\r^5wKB\u000bG\u000f\u001b\u000b\u000b\u0003W\u000bi+!0\u0002@\u0006\u0005\u0007c\u0001\u0011\u007fY\"9\u0011qV\u0007A\u0002\u0005E\u0016AB1di&|g\u000e\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9lE\u0001\bC\u000e$\u0018n\u001c8t\u0013\u0011\tY,!.\u0003\u0015\u0019KG.Z!di&|g\u000e\u0003\u0004`\u001b\u0001\u0007\u0011\u0011\b\u0005\u0007\u0003cj\u0001\u0019\u0001/\t\r\u0005\rW\u00021\u0001C\u0003U\u0011X\r\\1uSZL'0Z%h]>\u0014X-\u0012:s_J\fqdZ3u-\u0006d\u0017\u000e\u001a*fY\u0006$\u0018N^3QCRD7/\u00118e'V\u0014G-\u001b:t))\tI-!4\u0002P\u0006E\u00171\u001b\t\u0006\u0003\u001b\nY\r\\\u0005\u0004o\u0005m\u0003bBAX\u001d\u0001\u0007\u0011\u0011\u0017\u0005\u0007?:\u0001\r!!\u000f\t\r\u0005Ed\u00021\u0001]\u0011\u0019\t\u0019M\u0004a\u0001\u0005\u0006ir-\u001a;EK2,G/[8o-\u0016\u001cGo\u001c:SK2\fG/\u001b<f!\u0006$\b\u000e\u0006\u0003\u0002Z\u0006m\u0007c\u0001\u0011\u007f9\"9\u0011qV\bA\u0002\u0005E\u0006")
public interface VacuumCommandImpl
extends DeltaCommand {
    public void org$apache$spark$sql$delta$commands$VacuumCommandImpl$_setter_$org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging_$eq(Seq<String> var1);

    public Seq<String> org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging();

    private boolean shouldLogVacuum(SparkSession spark, DeltaLog deltaLog, Configuration hadoopConf, Path path) {
        boolean bl;
        Option logVacuumConf = spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_LOGGING_ENABLED());
        if (logVacuumConf.nonEmpty()) {
            return BoxesRunTime.unboxToBoolean((Object)logVacuumConf.get());
        }
        LogStore logStore = deltaLog.store();
        try {
            URI rawResolvedUri = logStore.resolvePathOnPhysicalStorage(path, hadoopConf).toUri();
            String scheme = rawResolvedUri.getScheme();
            bl = this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging().contains((Object)scheme);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.logWarning((Function0 & Serializable)() -> "Vacuum event logging not enabled on this file system because we cannot detect your cloud storage type.");
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void logVacuumStart$(VacuumCommandImpl $this, SparkSession spark, DeltaLog deltaLog, Path path, Dataset diff, long sizeOfDataToDelete, Option specifiedRetentionMillis, long defaultRetentionMillis) {
        $this.logVacuumStart(spark, deltaLog, path, (Dataset<String>)diff, sizeOfDataToDelete, (Option<Object>)specifiedRetentionMillis, defaultRetentionMillis);
    }

    default public void logVacuumStart(SparkSession spark, DeltaLog deltaLog, Path path, Dataset<String> diff, long sizeOfDataToDelete, Option<Object> specifiedRetentionMillis, long defaultRetentionMillis) {
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(99).append("Deleting untracked files and empty directories in ").append(path).append(". The amount of data to be ").append("deleted is ").append(sizeOfDataToDelete).append(" (in bytes)").toString());
        if (this.shouldLogVacuum(spark, deltaLog, deltaLog.newDeltaHadoopConf(), path)) {
            boolean checkEnabled = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_RETENTION_CHECK_ENABLED()));
            OptimisticTransaction txn = deltaLog.startTransaction();
            Map metrics = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFilesToDelete"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "number of files to deleted")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sizeOfDataToDelete"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "The total amount of data to be deleted in bytes"))}));
            ((SQLMetric)metrics.apply((Object)"numFilesToDelete")).set(diff.count());
            ((SQLMetric)metrics.apply((Object)"sizeOfDataToDelete")).set(sizeOfDataToDelete);
            txn.registerSQLMetrics(spark, (Map<String, SQLMetric>)metrics);
            txn.commit((Seq<Action>)((Seq)Nil$.MODULE$), new DeltaOperations.VacuumStart(checkEnabled, specifiedRetentionMillis, defaultRetentionMillis));
            return;
        }
    }

    public static /* synthetic */ void logVacuumEnd$(VacuumCommandImpl $this, DeltaLog deltaLog, SparkSession spark, Path path, Option filesDeleted, Option dirCounts) {
        $this.logVacuumEnd(deltaLog, spark, path, (Option<Object>)filesDeleted, (Option<Object>)dirCounts);
    }

    default public void logVacuumEnd(DeltaLog deltaLog, SparkSession spark, Path path, Option<Object> filesDeleted, Option<Object> dirCounts) {
        Object object;
        if (this.shouldLogVacuum(spark, deltaLog, deltaLog.newDeltaHadoopConf(), path)) {
            String status;
            OptimisticTransaction txn = deltaLog.startTransaction();
            String string = status = filesDeleted.isEmpty() && dirCounts.isEmpty() ? "FAILED" : "COMPLETED";
            if (filesDeleted.nonEmpty() && dirCounts.nonEmpty()) {
                Map metrics = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "number of files deleted.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numVacuumedDirectories"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "num of directories vacuumed.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "status of vacuum"))}));
                ((SQLMetric)metrics.apply((Object)"numDeletedFiles")).set(BoxesRunTime.unboxToLong((Object)filesDeleted.get()));
                ((SQLMetric)metrics.apply((Object)"numVacuumedDirectories")).set(BoxesRunTime.unboxToLong((Object)dirCounts.get()));
                txn.registerSQLMetrics(spark, (Map<String, SQLMetric>)metrics);
            }
            object = BoxesRunTime.boxToLong((long)txn.commit((Seq<Action>)((Seq)Nil$.MODULE$), new DeltaOperations.VacuumEnd(status)));
        } else {
            object = BoxedUnit.UNIT;
        }
        if (filesDeleted.nonEmpty()) {
            this.logConsole(new StringBuilder(58).append("Deleted ").append(filesDeleted.get()).append(" files and directories in a total ").append("of ").append(dirCounts.get()).append(" directories.").toString());
            return;
        }
    }

    public static /* synthetic */ Option logVacuumEnd$default$4$(VacuumCommandImpl $this) {
        return $this.logVacuumEnd$default$4();
    }

    default public Option<Object> logVacuumEnd$default$4() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option logVacuumEnd$default$5$(VacuumCommandImpl $this) {
        return $this.logVacuumEnd$default$5();
    }

    default public Option<Object> logVacuumEnd$default$5() {
        return None$.MODULE$;
    }

    public static /* synthetic */ String relativize$(VacuumCommandImpl $this, Path path, FileSystem fs, Path reservoirBase, boolean isDir) {
        return $this.relativize(path, fs, reservoirBase, isDir);
    }

    default public String relativize(Path path, FileSystem fs, Path reservoirBase, boolean isDir) {
        return this.pathToString(DeltaFileOperations$.MODULE$.tryRelativizePath(fs, reservoirBase, path, DeltaFileOperations$.MODULE$.tryRelativizePath$default$4()));
    }

    public static /* synthetic */ Iterator getAllSubdirs$(VacuumCommandImpl $this, String base, String file, FileSystem fs) {
        return $this.getAllSubdirs(base, file, fs);
    }

    default public Iterator<String> getAllSubdirs(String base, String file, FileSystem fs) {
        return (Iterator)DeltaFileOperations$.MODULE$.getAllSubDirectories(base, file)._1();
    }

    public static /* synthetic */ long delete$(VacuumCommandImpl $this, Dataset diff, SparkSession spark, String basePath, Broadcast hadoopConf, boolean parallel, int parallelPartitions) {
        return $this.delete((Dataset<String>)diff, spark, basePath, (Broadcast<SerializableConfiguration>)hadoopConf, parallel, parallelPartitions);
    }

    default public long delete(Dataset<String> diff, SparkSession spark, String basePath, Broadcast<SerializableConfiguration> hadoopConf, boolean parallel, int parallelPartitions) {
        if (parallel) {
            return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])diff.repartition(parallelPartitions).mapPartitions((Function1 & Serializable)files -> {
                FileSystem fs = new Path(basePath).getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
                int filesDeletedPerPartition = files.map((Function1 & Serializable)p -> this.stringToPath((String)p)).count((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.tryDeleteNonRecursive(fs, f, DeltaFileOperations$.MODULE$.tryDeleteNonRecursive$default$3())));
                return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{filesDeletedPerPartition}));
            }, org.apache.spark.sql.delta.implicits.package$.MODULE$.intEncoder()).collect()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        FileSystem fs = new Path(basePath).getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
        Iterator fileResultSet = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(diff.toLocalIterator()).asScala();
        return fileResultSet.map((Function1 & Serializable)p -> this.stringToPath((String)p)).count((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.tryDeleteNonRecursive(fs, f, DeltaFileOperations$.MODULE$.tryDeleteNonRecursive$default$3())));
    }

    public static /* synthetic */ Path stringToPath$(VacuumCommandImpl $this, String path) {
        return $this.stringToPath(path);
    }

    default public Path stringToPath(String path) {
        return new Path(new URI(path));
    }

    public static /* synthetic */ String pathToString$(VacuumCommandImpl $this, Path path) {
        return $this.pathToString(path);
    }

    default public String pathToString(Path path) {
        return path.toUri().toString();
    }

    public static /* synthetic */ Option getActionRelativePath$(VacuumCommandImpl $this, FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        return $this.getActionRelativePath(action, fs, basePath, relativizeIgnoreError);
    }

    default public Option<String> getActionRelativePath(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        Path filePath = this.stringToPath(action.path());
        if (filePath.isAbsolute()) {
            Path maybeRelative = DeltaFileOperations$.MODULE$.tryRelativizePath(fs, basePath, filePath, relativizeIgnoreError);
            if (maybeRelative.isAbsolute()) {
                return None$.MODULE$;
            }
            return new Some((Object)this.pathToString(maybeRelative));
        }
        return new Some((Object)this.pathToString(filePath));
    }

    public static /* synthetic */ Seq getValidRelativePathsAndSubdirs$(VacuumCommandImpl $this, FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        return $this.getValidRelativePathsAndSubdirs(action, fs, basePath, relativizeIgnoreError);
    }

    default public Seq<String> getValidRelativePathsAndSubdirs(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        Seq paths = (Seq)this.getActionRelativePath(action, fs, basePath, relativizeIgnoreError).map((Function1 & Serializable)relativePath -> (Seq)new .colon.colon(relativePath, (List)Nil$.MODULE$).$plus$plus(this.getAllSubdirs("/", (String)relativePath, fs))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        Option deletionVectorPath = this.getDeletionVectorRelativePath(action).map((Function1 & Serializable)path -> this.pathToString((Path)path));
        return (Seq)paths.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(deletionVectorPath).toSeq());
    }

    public static /* synthetic */ Option getDeletionVectorRelativePath$(VacuumCommandImpl $this, FileAction action) {
        return $this.getDeletionVectorRelativePath(action);
    }

    default public Option<Path> getDeletionVectorRelativePath(FileAction action) {
        Some some;
        DeletionVectorDescriptor dv;
        RemoveFile removeFile;
        AddFile addFile;
        FileAction fileAction = action;
        Object dv2 = fileAction instanceof AddFile && (addFile = (AddFile)fileAction).deletionVector() != null ? new Some((Object)addFile.deletionVector()) : (fileAction instanceof RemoveFile && (removeFile = (RemoveFile)fileAction).deletionVector() != null ? new Some((Object)removeFile.deletionVector()) : None$.MODULE$);
        None$ none$ = dv2;
        if (none$ instanceof Some && (dv = (DeletionVectorDescriptor)(some = (Some)none$).value()).isOnDisk()) {
            if (dv.isRelative()) {
                return new Some((Object)dv.absolutePath(new Path(".")));
            }
            Predef$.MODULE$.assert(dv.isAbsolute());
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(none$)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)none$);
    }

    public static void $init$(VacuumCommandImpl $this) {
        $this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$_setter_$org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging_$eq((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"wasbs", "wasbss", "abfs", "abfss", "adl", "gs", "file", "hdfs"}))));
    }
}

