/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.hooks;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.hooks.UpdateCatalog;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ThreadUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class UpdateCatalog$
implements Serializable {
    public static final UpdateCatalog$ MODULE$ = new UpdateCatalog$();
    private static ExecutionContext tp;
    private static final Charset latin1;
    private static final String ERROR_KEY;
    private static final String LONG_SCHEMA_ERROR;
    private static final String NON_LATIN_CHARS_ERROR;
    private static final String HIVE_METASTORE_NAME;
    private static final AtomicInteger org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests;

    static {
        latin1 = Charset.forName("ISO-8859-1");
        ERROR_KEY = "delta.catalogUpdateError";
        LONG_SCHEMA_ERROR = "The schema contains a very long nested field and cannot be stored in the catalog.";
        NON_LATIN_CHARS_ERROR = "The schema contains non-latin encoding characters and cannot be stored in the catalog.";
        HIVE_METASTORE_NAME = "hive_metastore";
        org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests = new AtomicInteger(0);
    }

    private ExecutionContext tp() {
        return tp;
    }

    private void tp_$eq(ExecutionContext x$1) {
        tp = x$1;
    }

    private Charset latin1() {
        return latin1;
    }

    public String ERROR_KEY() {
        return ERROR_KEY;
    }

    public String LONG_SCHEMA_ERROR() {
        return LONG_SCHEMA_ERROR;
    }

    public String NON_LATIN_CHARS_ERROR() {
        return NON_LATIN_CHARS_ERROR;
    }

    public String HIVE_METASTORE_NAME() {
        return HIVE_METASTORE_NAME;
    }

    public synchronized ExecutionContext org$apache$spark$sql$delta$hooks$UpdateCatalog$$getOrCreateExecutionContext(SQLConf conf) {
        block0: {
            if (this.tp() != null) break block0;
            this.tp_$eq((ExecutionContext)ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)DeltaThreadPool$.MODULE$.newDaemonCachedThreadPool("delta-catalog-update", BoxesRunTime.unboxToInt((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_UPDATE_CATALOG_THREAD_POOL_SIZE())))));
        }
        return this.tp();
    }

    public AtomicInteger org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests() {
        return org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests;
    }

    public boolean awaitCompletion(long timeoutMillis) {
        boolean bl;
        try {
            ThreadUtils$.MODULE$.runInNewThread("UpdateCatalog-awaitCompletion", ThreadUtils$.MODULE$.runInNewThread$default$2(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                long startTime = System.currentTimeMillis();
                while (MODULE$.org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests().get() > 0) {
                    Thread.sleep(100L);
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - startTime <= timeoutMillis) continue;
                    throw new TimeoutException(new StringBuilder(59).append("Timed out waiting for catalog updates to complete after ").append(currentTime).append(" ms").toString());
                }
            });
            bl = true;
        }
        catch (TimeoutException timeoutException) {
            bl = false;
        }
        return bl;
    }

    public void org$apache$spark$sql$delta$hooks$UpdateCatalog$$replaceTable(SparkSession spark, Snapshot snapshot, CatalogTable table) {
        Map additionalProperties;
        SessionCatalog catalog;
        block6: {
            StructType schema;
            String tblName;
            String db;
            block5: {
                String catalogName;
                catalog = spark.sessionState().catalog();
                TableIdentifier qualifiedIdentifier = catalog.qualifyIdentifier(TableIdentifier$.MODULE$.apply(table.identifier().table(), (Option)new Some((Object)table.database())));
                db = (String)qualifiedIdentifier.database().get();
                tblName = qualifiedIdentifier.table();
                long truncationThreshold = BoxesRunTime.unboxToLong((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_UPDATE_CATALOG_LONG_FIELD_TRUNCATION_THRESHOLD()));
                Tuple2<StructType, Map<String, String>> tuple2 = this.truncateSchemaIfNecessary(snapshot.schema(), truncationThreshold);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                StructType schema2 = (StructType)tuple2._1();
                Map additionalProperties2 = (Map)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)schema2, (Object)additionalProperties2);
                schema = (StructType)tuple22._1();
                additionalProperties = (Map)tuple22._2();
                String string = catalogName = (String)table.identifier().catalog().getOrElse((Function0 & Serializable)() -> spark.sessionState().catalogManager().currentCatalog().name());
                String string2 = this.HIVE_METASTORE_NAME();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block5;
                String string3 = catalogName;
                String string4 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
            }
            if (catalog.externalCatalog().tableExists(db, tblName)) {
                catalog.externalCatalog().alterTableDataSchema(db, tblName, schema);
            }
        }
        Map x$1 = (Map)this.updatedProperties(snapshot).$plus$plus((IterableOnce)additionalProperties);
        TableIdentifier x$2 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        StructType x$5 = table.copy$default$4();
        Option x$6 = table.copy$default$5();
        Seq x$7 = table.copy$default$6();
        Option x$8 = table.copy$default$7();
        String x$9 = table.copy$default$8();
        long x$10 = table.copy$default$9();
        long x$11 = table.copy$default$10();
        String x$12 = table.copy$default$11();
        Option x$13 = table.copy$default$13();
        Option x$14 = table.copy$default$14();
        Option x$15 = table.copy$default$15();
        Seq x$16 = table.copy$default$16();
        boolean x$17 = table.copy$default$17();
        boolean x$18 = table.copy$default$18();
        Map x$19 = table.copy$default$19();
        Option x$20 = table.copy$default$20();
        catalog.alterTable(table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    public Map<String, String> updatedProperties(Snapshot snapshot) {
        Map newProperties = (Map)snapshot.getProperties().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.METASTORE_LAST_UPDATE_VERSION()), (Object)Long.toString(snapshot.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.METASTORE_LAST_COMMIT_TIMESTAMP()), (Object)Long.toString(snapshot.timestamp()))})));
        return newProperties;
    }

    public Tuple2<StructType, Map<String, String>> truncateSchemaIfNecessary(StructType schema, long truncationThreshold) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            CharsetEncoder encoder = this.latin1().newEncoder();
            schema.foreach((Function1 & Serializable)f -> {
                UpdateCatalog$.$anonfun$truncateSchemaIfNecessary$1(truncationThreshold, object, encoder, f);
                return BoxedUnit.UNIT;
            });
            tuple2 = new Tuple2((Object)schema, (Object)Predef$.MODULE$.Map().empty());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public UpdateCatalog apply(CatalogTable table) {
        return new UpdateCatalog(table);
    }

    public Option<CatalogTable> unapply(UpdateCatalog x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.table());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UpdateCatalog$.class);
    }

    public static final /* synthetic */ void $anonfun$truncateSchemaIfNecessary$1(long truncationThreshold$1, Object nonLocalReturnKey1$1, CharsetEncoder encoder$1, StructField f) {
        if ((long)f.dataType().catalogString().length() > truncationThreshold$1) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Tuple2((Object)new StructType(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.ERROR_KEY()), (Object)MODULE$.LONG_SCHEMA_ERROR())}))));
        }
        if (!encoder$1.canEncode(f.name()) || !encoder$1.canEncode(f.dataType().catalogString())) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Tuple2((Object)new StructType(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.ERROR_KEY()), (Object)MODULE$.NON_LATIN_CHARS_ERROR())}))));
        }
    }

    private UpdateCatalog$() {
    }
}

