/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.managedcommit;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.util.FileNames$DeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$UnbackfilledDeltaFile$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ManagedCommitUtils$ {
    public static final ManagedCommitUtils$ MODULE$ = new ManagedCommitUtils$();

    public Iterator<Tuple2<FileStatus, Object>> commitFilesIterator(DeltaLog deltaLog, long startVersion) {
        LongRef maxVersionSeen = LongRef.create((long)(startVersion - 1L));
        Iterator listedDeltas = ManagedCommitUtils$.listDeltas$1(startVersion, (Option)None$.MODULE$, deltaLog).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ManagedCommitUtils$.$anonfun$commitFilesIterator$3(maxVersionSeen, x0$1)));
        return scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})).flatMap((Function1 & Serializable)x0$2 -> ManagedCommitUtils$.$anonfun$commitFilesIterator$5(listedDeltas, deltaLog, maxVersionSeen, BoxesRunTime.unboxToInt((Object)x0$2)));
    }

    public static final /* synthetic */ boolean $anonfun$commitFilesIterator$1(Option endVersion$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long version = tuple2._2$mcJ$sp();
            return endVersion$1.forall((Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> version <= x$1);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Iterator listDeltas$1(long startVersion, Option endVersion, DeltaLog deltaLog$1) {
        return deltaLog$1.listFrom(startVersion).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple2<FileStatus, Object>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(A1)).isEmpty()) {
                    FileStatus fileStatus = (FileStatus)((Tuple2)option.get())._1();
                    long version = ((Tuple2)option.get())._2$mcJ$sp();
                    return (B1)new Tuple2((Object)fileStatus, (Object)BoxesRunTime.boxToLong((long)version));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                Option<Tuple2<FileStatus, Object>> option;
                FileStatus fileStatus = x1;
                return fileStatus != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(fileStatus)).isEmpty();
            }
        }).takeWhile((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ManagedCommitUtils$.$anonfun$commitFilesIterator$1(endVersion, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$commitFilesIterator$3(LongRef maxVersionSeen$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long version = tuple2._2$mcJ$sp();
            maxVersionSeen$1.elem = package$.MODULE$.max(maxVersionSeen$1.elem, version);
            return true;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Iterator tailFromSnapshot$1(DeltaLog deltaLog$1, LongRef maxVersionSeen$1) {
        long version;
        Some some;
        Tuple2 tuple2;
        Snapshot currentSnapshotInDeltaLog = deltaLog$1.unsafeVolatileSnapshot();
        if (currentSnapshotInDeltaLog.version() == maxVersionSeen$1.elem && currentSnapshotInDeltaLog.tableCommitOwnerClientOpt().isEmpty()) {
            return scala.package$.MODULE$.Iterator().empty();
        }
        Snapshot endSnapshot = deltaLog$1.update(deltaLog$1.update$default$1(), deltaLog$1.update$default$2());
        if (maxVersionSeen$1.elem >= endSnapshot.version()) {
            return scala.package$.MODULE$.Iterator().empty();
        }
        Seq unbackfilledDeltas = (Seq)endSnapshot.logSegment().deltas().collect((PartialFunction)new Serializable(maxVersionSeen$1){
            private static final long serialVersionUID = 0L;
            private final LongRef maxVersionSeen$1;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple3<FileStatus, Object, String>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(A1)).isEmpty()) {
                    FileStatus fileStatus = (FileStatus)((Tuple3)option.get())._1();
                    long version = BoxesRunTime.unboxToLong((Object)((Tuple3)option.get())._2());
                    if (version > this.maxVersionSeen$1.elem) {
                        return (B1)new Tuple2((Object)fileStatus, (Object)BoxesRunTime.boxToLong((long)version));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                long version;
                Option<Tuple3<FileStatus, Object, String>> option;
                FileStatus fileStatus = x1;
                return fileStatus != null && !(option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(fileStatus)).isEmpty() && (version = BoxesRunTime.unboxToLong((Object)((Tuple3)option.get())._2())) > this.maxVersionSeen$1.elem;
            }
            {
                this.maxVersionSeen$1 = maxVersionSeen$1;
            }
        });
        Option option = unbackfilledDeltas.headOption();
        Iterator gapListing = option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null && maxVersionSeen$1.elem + 1L < (version = tuple2._2$mcJ$sp()) ? ManagedCommitUtils$.listDeltas$1(maxVersionSeen$1.elem + 1L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)version)), deltaLog$1) : scala.package$.MODULE$.Iterator().empty();
        return gapListing.$plus$plus((Function0 & Serializable)() -> unbackfilledDeltas);
    }

    public static final /* synthetic */ IterableOnce $anonfun$commitFilesIterator$5(Iterator listedDeltas$1, DeltaLog deltaLog$1, LongRef maxVersionSeen$1, int x0$2) {
        int n = x0$2;
        switch (n) {
            case 1: {
                return listedDeltas$1;
            }
            case 2: {
                return ManagedCommitUtils$.tailFromSnapshot$1(deltaLog$1, maxVersionSeen$1);
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private ManagedCommitUtils$() {
    }
}

