/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.SerializableFileStatus$;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class DeltaFileOperations$
implements DeltaLogging {
    public static final DeltaFileOperations$ MODULE$ = new DeltaFileOperations$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Path absolutePath(String basePath, String child) {
        Path p = new Path(new URI(child));
        if (p.isAbsolute()) {
            return p;
        }
        Path merged = new Path(basePath, p);
        String mergedUri = merged.toUri().toString();
        if (child.endsWith("/") && !mergedUri.endsWith("/")) {
            return new Path(new URI(new StringBuilder(1).append(mergedUri).append("/").toString()));
        }
        return merged;
    }

    public Path tryRelativizePath(FileSystem fs, Path basePath, Path child, boolean ignoreError) {
        if (child.isAbsolute()) {
            Path path;
            try {
                path = new Path(fs.makeQualified(basePath).toUri().relativize(fs.makeQualified(child).toUri()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (ignoreError) {
                    path = child;
                }
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Failed to relativize the path (").append(child).append(") ").append("with the base path (").append(basePath).append(") and the file system URI (").append(fs.getUri()).append(")").toString(), illegalArgumentException);
                throw DeltaErrors$.MODULE$.failRelativizePath(child.toString());
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            return path;
        }
        return child;
    }

    public boolean tryRelativizePath$default$4() {
        return false;
    }

    private boolean isThrottlingError(Throwable t) {
        return Option$.MODULE$.apply((Object)t.getMessage()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.$anonfun$isThrottlingError$1(x$1)));
    }

    private void randomBackoff(String opName, Throwable t, int base, int jitter) {
        int sleepTime = Random$.MODULE$.nextInt(jitter) + base;
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Sleeping for ").append(sleepTime).append(" ms to rate limit ").append(opName).toString(), t);
        Thread.sleep(sleepTime);
    }

    private int randomBackoff$default$3() {
        return 100;
    }

    private int randomBackoff$default$4() {
        return 1000;
    }

    private Iterator<SerializableFileStatus> listUsingLogStore(LogStore logStore, Configuration hadoopConf, Iterator<String> subDirs, boolean recurse, Function1<String, Object> hiddenDirNameFilter, Function1<String, Object> hiddenFileNameFilter, boolean listAsDirectories) {
        Iterator filesAndDirs = subDirs.flatMap((Function1 & Serializable)dir -> this.list$1((String)dir, 10, listAsDirectories, logStore, hadoopConf, (Function1)hiddenDirNameFilter, (Function1)hiddenFileNameFilter));
        if (recurse) {
            return this.recurseDirectories(logStore, hadoopConf, (Iterator<SerializableFileStatus>)filesAndDirs, hiddenDirNameFilter, hiddenFileNameFilter);
        }
        return filesAndDirs;
    }

    private boolean listUsingLogStore$default$7() {
        return true;
    }

    private Iterator<SerializableFileStatus> recurseDirectories(LogStore logStore, Configuration hadoopConf, Iterator<SerializableFileStatus> filesAndDirs, Function1<String, Object> hiddenDirNameFilter, Function1<String, Object> hiddenFileNameFilter) {
        return filesAndDirs.flatMap((Function1 & Serializable)x0$1 -> {
            SerializableFileStatus serializableFileStatus;
            SerializableFileStatus serializableFileStatus2 = x0$1;
            if (serializableFileStatus2 != null && (serializableFileStatus = serializableFileStatus2).isDir()) {
                return package$.MODULE$.Iterator().single((Object)serializableFileStatus).$plus$plus((Function0 & Serializable)() -> MODULE$.listUsingLogStore(logStore, hadoopConf, (Iterator<String>)package$.MODULE$.Iterator().single((Object)serializableFileStatus.path()), true, hiddenDirNameFilter, hiddenFileNameFilter, MODULE$.listUsingLogStore$default$7()));
            }
            return package$.MODULE$.Iterator().single((Object)serializableFileStatus2);
        });
    }

    public boolean defaultHiddenFileFilter(String fileName) {
        return fileName.startsWith("_") || fileName.startsWith(".");
    }

    public Dataset<SerializableFileStatus> recursiveListDirs(SparkSession spark, Seq<String> subDirs, Broadcast<SerializableConfiguration> hadoopConf, Function1<String, Object> hiddenDirNameFilter, Function1<String, Object> hiddenFileNameFilter, Option<Object> fileListingParallelism, boolean listAsDirectories) {
        if (subDirs.isEmpty()) {
            return spark.emptyDataset(org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
        }
        int listParallelism = BoxesRunTime.unboxToInt((Object)fileListingParallelism.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> spark.sparkContext().defaultParallelism()));
        RDD qual$1 = spark.sparkContext().parallelize(subDirs, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        Function1 & Serializable x$1 = (Function1 & Serializable)dirs -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), ((SerializableConfiguration)hadoopConf.value()).value());
            return MODULE$.listUsingLogStore(logStore, ((SerializableConfiguration)hadoopConf.value()).value(), (Iterator<String>)dirs, false, hiddenDirNameFilter, hiddenFileNameFilter, listAsDirectories);
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD qual$2 = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(SerializableFileStatus.class));
        int x$3 = listParallelism;
        Ordering x$4 = qual$2.repartition$default$2(x$3);
        RDD dirsAndFiles = qual$2.repartition(x$3, x$4);
        RDD allDirsAndFiles = dirsAndFiles.mapPartitions((Function1 & Serializable)firstLevelDirsAndFiles -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), ((SerializableConfiguration)hadoopConf.value()).value());
            return MODULE$.recurseDirectories(logStore, ((SerializableConfiguration)hadoopConf.value()).value(), (Iterator<SerializableFileStatus>)firstLevelDirsAndFiles, hiddenDirNameFilter, hiddenFileNameFilter);
        }, dirsAndFiles.mapPartitions$default$2(), ClassTag$.MODULE$.apply(SerializableFileStatus.class));
        return spark.createDataset(allDirsAndFiles, org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
    }

    public Function1<String, Object> recursiveListDirs$default$4() {
        return (Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName));
    }

    public Function1<String, Object> recursiveListDirs$default$5() {
        return (Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName));
    }

    public Option<Object> recursiveListDirs$default$6() {
        return None$.MODULE$;
    }

    public boolean recursiveListDirs$default$7() {
        return true;
    }

    public Dataset<SerializableFileStatus> recursiveListFrom(SparkSession spark, String listFilename, String topDir, Broadcast<SerializableConfiguration> hadoopConf, Function1<String, Object> hiddenDirNameFilter, Function1<String, Object> hiddenFileNameFilter, Option<Object> fileListingParallelism) {
        List<String> subDirs = this.getAllTopComponents(new Path(listFilename), new Path(topDir));
        return this.recursiveListDirs(spark, (Seq<String>)subDirs, hadoopConf, hiddenDirNameFilter, hiddenFileNameFilter, fileListingParallelism, false);
    }

    public Function1<String, Object> recursiveListFrom$default$5() {
        return (Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName));
    }

    public Function1<String, Object> recursiveListFrom$default$6() {
        return (Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName));
    }

    public Option<Object> recursiveListFrom$default$7() {
        return None$.MODULE$;
    }

    public Iterator<SerializableFileStatus> localListDirs(Configuration hadoopConf, Seq<String> dirs, boolean recursive, Function1<String, Object> dirFilter, Function1<String, Object> fileFilter) {
        LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), hadoopConf);
        return this.listUsingLogStore(logStore, hadoopConf, (Iterator<String>)dirs.toIterator(), recursive, dirFilter, fileFilter, this.listUsingLogStore$default$7());
    }

    public boolean localListDirs$default$3() {
        return true;
    }

    public Function1<String, Object> localListDirs$default$4() {
        return (Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName));
    }

    public Function1<String, Object> localListDirs$default$5() {
        return (Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName));
    }

    public Iterator<SerializableFileStatus> localListFrom(Configuration hadoopConf, String listFilename, String topDir, boolean recursive, Function1<String, Object> dirFilter, Function1<String, Object> fileFilter) {
        LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), hadoopConf);
        List<String> listDirs = this.getAllTopComponents(new Path(listFilename), new Path(topDir));
        return this.listUsingLogStore(logStore, hadoopConf, (Iterator<String>)listDirs.toIterator(), recursive, dirFilter, fileFilter, false);
    }

    public boolean localListFrom$default$4() {
        return true;
    }

    public Function1<String, Object> localListFrom$default$5() {
        return (Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName));
    }

    public Function1<String, Object> localListFrom$default$6() {
        return (Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName));
    }

    public boolean tryDeleteNonRecursive(FileSystem fs, Path path, int tries) {
        boolean bl;
        try {
            bl = fs.delete(path, false);
        }
        catch (Throwable throwable) {
            Throwable e;
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException) {
                bl = true;
            }
            if (throwable2 instanceof IOException) {
                bl = false;
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && this.isThrottlingError(e = (Throwable)option.get()) && tries > 0) {
                this.randomBackoff("deletes", e, this.randomBackoff$default$3(), this.randomBackoff$default$4());
                bl = this.tryDeleteNonRecursive(fs, path, tries - 1);
            }
            throw throwable;
        }
        return bl;
    }

    public int tryDeleteNonRecursive$default$3() {
        return 3;
    }

    public Tuple2<Iterator<String>, String> getAllSubDirectories(String base, String path) {
        String[] baseSplits = base.split("/");
        String[] pathSplits = (String[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])path.split("/")), baseSplits.length);
        Iterator it = package$.MODULE$.Iterator().tabulate(pathSplits.length - 1, (Function1 & Serializable)i -> DeltaFileOperations$.$anonfun$getAllSubDirectories$1(baseSplits, pathSplits, BoxesRunTime.unboxToInt((Object)i)));
        return new Tuple2((Object)it, (Object)path);
    }

    public void registerTempFileDeletionTaskFailureListener(Configuration conf, Path tempPath) {
        TaskContext tc = TaskContext$.MODULE$.get();
        if (tc == null) {
            throw DeltaErrors$.MODULE$.sparkTaskThreadNotFound();
        }
        tc.addTaskFailureListener((Function2 & Serializable)(x$2, x$3) -> {
            DeltaFileOperations$.$anonfun$registerTempFileDeletionTaskFailureListener$1(tempPath, conf, x$2, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Footer> readParquetFootersInParallel(Configuration conf, Seq<FileStatus> partFiles, boolean ignoreCorruptFiles) {
        return (Seq)ThreadUtils$.MODULE$.parmap(partFiles, "readingParquetFooters", 8, (Function1 & Serializable)currentFile -> {
            Some some;
            try {
                some = new Some((Object)new Footer(currentFile.getPath(), ParquetFileReader.readFooter((Configuration)conf, (FileStatus)currentFile, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS)));
            }
            catch (RuntimeException e) {
                if (ignoreCorruptFiles) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Skipped the footer in the corrupted file: ").append(currentFile).toString(), e);
                    some = None$.MODULE$;
                }
                throw DeltaErrors$.MODULE$.failedReadFileFooter(currentFile.toString(), e);
            }
            return some;
        }).flatten(Predef$.MODULE$.$conforms());
    }

    public List<String> getAllTopComponents(Path listDir, Path topDir) {
        Nil$ ret = Nil$.MODULE$;
        Path currDir = listDir;
        while (currDir.depth() > topDir.depth()) {
            Path parent;
            ret = (List)ret.$colon$plus((Object)currDir.toString());
            currDir = parent = currDir.getParent();
        }
        return ret;
    }

    public <T> T runInNewThread(String threadName, boolean isDaemon, Function0<T> body) {
        return (T)ThreadUtils$.MODULE$.runInNewThread(threadName, isDaemon, body);
    }

    public <T> boolean runInNewThread$default$2() {
        return true;
    }

    public Dataset<AddFile> makePathsAbsolute(String qualifiedTablePath, Dataset<AddFile> files) {
        return files.mapPartitions((Function1 & Serializable)fileList -> fileList.map((Function1 & Serializable)addFile -> {
            Path fileSource = MODULE$.absolutePath(qualifiedTablePath, addFile.path());
            if (addFile.deletionVector() != null) {
                DeletionVectorDescriptor absoluteDV = addFile.deletionVector().copyWithAbsolutePath(new Path(qualifiedTablePath));
                String x$1 = fileSource.toUri().toString();
                DeletionVectorDescriptor x$2 = absoluteDV;
                Map<String, String> x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                boolean x$6 = addFile.copy$default$5();
                String x$7 = addFile.copy$default$6();
                Map<String, String> x$8 = addFile.copy$default$7();
                Option<Object> x$9 = addFile.copy$default$9();
                Option<Object> x$10 = addFile.copy$default$10();
                Option<String> x$11 = addFile.copy$default$11();
                return addFile.copy(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10, x$11);
            }
            return addFile.copy(fileSource.toUri().toString(), addFile.copy$default$2(), addFile.copy$default$3(), addFile.copy$default$4(), addFile.copy$default$5(), addFile.copy$default$6(), addFile.copy$default$7(), addFile.copy$default$8(), addFile.copy$default$9(), addFile.copy$default$10(), addFile.copy$default$11());
        }), org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder());
    }

    public static final /* synthetic */ boolean $anonfun$isThrottlingError$1(String x$1) {
        return x$1.toLowerCase(Locale.ROOT).contains("slow down");
    }

    public static final /* synthetic */ boolean $anonfun$listUsingLogStore$2(Function1 hiddenDirNameFilter$1, Function1 hiddenFileNameFilter$1, FileStatus f) {
        String name = f.getPath().getName();
        if (f.isDirectory()) {
            return BoxesRunTime.unboxToBoolean((Object)hiddenDirNameFilter$1.apply((Object)name));
        }
        return BoxesRunTime.unboxToBoolean((Object)hiddenFileNameFilter$1.apply((Object)name));
    }

    private final Iterator list$1(String dir, int tries, boolean listAsDirectories$1, LogStore logStore$1, Configuration hadoopConf$1, Function1 hiddenDirNameFilter$1, Function1 hiddenFileNameFilter$1) {
        Iterator iterator;
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(8).append("Listing ").append(dir).toString());
        try {
            Path path = listAsDirectories$1 ? new Path(dir, "\u0000") : new Path(new StringBuilder(1).append(dir).append("\u0000").toString());
            iterator = logStore$1.listFrom(path, hadoopConf$1).filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.$anonfun$listUsingLogStore$2(hiddenDirNameFilter$1, hiddenFileNameFilter$1, f))).map((Function1 & Serializable)status -> SerializableFileStatus$.MODULE$.fromStatus((FileStatus)status));
        }
        catch (Throwable throwable) {
            Throwable e;
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && this.isThrottlingError(e = (Throwable)option.get()) && tries > 0) {
                this.randomBackoff("listing", e, this.randomBackoff$default$3(), this.randomBackoff$default$4());
                iterator = this.list$1(dir, tries - 1, listAsDirectories$1, logStore$1, hadoopConf$1, hiddenDirNameFilter$1, hiddenFileNameFilter$1);
            }
            if (throwable2 instanceof FileNotFoundException) {
                iterator = package$.MODULE$.Iterator().empty();
            }
            throw throwable;
        }
        return iterator;
    }

    public static final /* synthetic */ String $anonfun$getAllSubDirectories$1(String[] baseSplits$1, String[] pathSplits$1, int i) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])baseSplits$1), ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])pathSplits$1), i + 1), ClassTag$.MODULE$.apply(String.class))).mkString("/");
    }

    public static final /* synthetic */ void $anonfun$registerTempFileDeletionTaskFailureListener$1(Path tempPath$1, Configuration conf$1, TaskContext x$2, Throwable x$3) {
        Boolean bl;
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)tempPath$1.getFileSystem(conf$1).delete(tempPath$1, false));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                MODULE$.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Failed to delete ").append(tempPath$1).toString(), throwable2);
                bl = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private DeltaFileOperations$() {
    }
}

