/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.GeneratedColumn$;
import org.apache.spark.sql.delta.IdentityColumn$;
import org.apache.spark.sql.delta.IdentityColumnsTableFeature$;
import org.apache.spark.sql.delta.RowCommitVersion$MetadataAttribute$;
import org.apache.spark.sql.delta.RowId$RowIdMetadataAttribute$;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.constraints.Constraint;
import org.apache.spark.sql.delta.constraints.Constraints;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.sources.DeltaStreamUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class ColumnWithDefaultExprUtils$
implements DeltaLogging {
    public static final ColumnWithDefaultExprUtils$ MODULE$ = new ColumnWithDefaultExprUtils$();
    private static final String USE_NULL_AS_DEFAULT_DELTA_OPTION;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        LoggingShims.$init$(MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        USE_NULL_AS_DEFAULT_DELTA_OPTION = "__use_null_as_default";
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String USE_NULL_AS_DEFAULT_DELTA_OPTION() {
        return USE_NULL_AS_DEFAULT_DELTA_OPTION;
    }

    public boolean isIdentityColumn(StructField field) {
        org.apache.spark.sql.types.Metadata md = field.metadata();
        boolean hasStart = md.contains(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_START());
        boolean hasStep = md.contains(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_STEP());
        boolean hasInsert = md.contains(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_ALLOW_EXPLICIT_INSERT());
        if (hasStart != hasStep || hasStart != hasInsert) {
            throw DeltaErrors$.MODULE$.identityColumnInconsistentMetadata(field.name(), hasStart, hasStep, hasInsert);
        }
        return hasStart && hasStep && hasInsert;
    }

    public boolean hasIdentityColumn(StructType schema) {
        return schema.exists((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ColumnWithDefaultExprUtils$.MODULE$.isIdentityColumn(field)));
    }

    public boolean satisfiesIdentityColumnProtocol(Protocol protocol) {
        return protocol.isFeatureSupported(IdentityColumnsTableFeature$.MODULE$) || protocol.minWriterVersion() == 6 || protocol.writerFeatureNames().contains((Object)"identityColumns");
    }

    public boolean columnHasDefaultExpr(Protocol protocol, StructField col, boolean nullAsDefault) {
        return this.isIdentityColumn(col) || col.metadata().contains(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY()) || col.nullable() && nullAsDefault || GeneratedColumn$.MODULE$.isGeneratedColumn(protocol, col);
    }

    public boolean tableHasDefaultExpr(Protocol protocol, Metadata metadata, boolean nullAsDefault) {
        return this.hasIdentityColumn(metadata.schema()) || metadata.schema().exists((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ColumnWithDefaultExprUtils$.$anonfun$tableHasDefaultExpr$1(nullAsDefault, f))) || GeneratedColumn$.MODULE$.enforcesGeneratedColumns(protocol, metadata);
    }

    public Tuple3<Dataset<Row>, Seq<Constraint>, scala.collection.immutable.Set<String>> addDefaultExprsOrReturnConstraints(DeltaLog deltaLog, Protocol protocol, QueryExecution queryExecution, StructType schema, Dataset<Row> data, boolean nullAsDefault) {
        Dataset<Row> dataset;
        LazyRef metadataOutputNames$lzy = new LazyRef();
        CaseInsensitiveMap topLevelOutputNames = CaseInsensitiveMap$.MODULE$.apply(((IterableOnceOps)data.schema().map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        ArrayBuffer constraints = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set track = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq selectExprs = (Seq)schema.flatMap((Function1 & Serializable)f -> {
            Option<Expression> option = GeneratedColumn$.MODULE$.getGenerationExpression((StructField)f);
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression expr = (Expression)some.value();
                if (GeneratedColumn$.MODULE$.satisfyGeneratedColumnProtocol(protocol)) {
                    if (topLevelOutputNames.contains(f.name())) {
                        Column column = SchemaUtils$.MODULE$.fieldToColumn((StructField)f);
                        constraints.$plus$eq((Object)new Constraints.Check("Generated Column", (Expression)new EqualNullSafe(column.expr(), expr)));
                        return new Some((Object)column);
                    }
                    return new Some((Object)Column$.MODULE$.apply(expr).alias(f.name()));
                }
            }
            if (MODULE$.isIdentityColumn((StructField)f)) {
                if (topLevelOutputNames.contains(f.name())) {
                    return new Some((Object)SchemaUtils$.MODULE$.fieldToColumn((StructField)f));
                }
                track.$plus$eq((Object)f.name());
                return new Some((Object)IdentityColumn$.MODULE$.createIdentityColumnGenerationExprAsColumn((StructField)f));
            }
            if (topLevelOutputNames.contains(f.name()) || !BoxesRunTime.unboxToBoolean((Object)data.sparkSession().conf().get(DeltaSQLConf$.MODULE$.GENERATED_COLUMN_ALLOW_NULLABLE()))) {
                return new Some((Object)SchemaUtils$.MODULE$.fieldToColumn((StructField)f));
            }
            return ResolveDefaultColumns$.MODULE$.getDefaultValueExprOrNullLit(f, nullAsDefault).map((Function1 & Serializable)x$1 -> Column$.MODULE$.apply((Expression)x$1));
        });
        Seq cdcSelectExprs = (Seq)CDCReader$.MODULE$.CDC_COLUMNS_IN_DATA().flatMap((Function1 & Serializable)cdcColumnName -> topLevelOutputNames.get(cdcColumnName).flatMap((Function1 & Serializable)cdcField -> {
            if (ColumnWithDefaultExprUtils$.metadataOutputNames$1(metadataOutputNames$lzy, schema).contains(cdcColumnName)) {
                return None$.MODULE$;
            }
            return new Some((Object)SchemaUtils$.MODULE$.fieldToColumn((StructField)cdcField).alias(cdcField.name()));
        }));
        selectExprs = (Seq)selectExprs.$plus$plus((IterableOnce)cdcSelectExprs);
        Seq rowIdExprs = (Seq)((IterableOps)data.queryExecution().analyzed().output().filter((Function1 & Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)RowId$RowIdMetadataAttribute$.MODULE$.isRowIdColumn(attr)))).map((Function1 & Serializable)x$2 -> Column$.MODULE$.apply((Expression)x$2));
        selectExprs = (Seq)selectExprs.$plus$plus((IterableOnce)rowIdExprs);
        Seq rowCommitVersionExprs = (Seq)((IterableOps)data.queryExecution().analyzed().output().filter((Function1 & Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)RowCommitVersion$MetadataAttribute$.MODULE$.isRowCommitVersionColumn(attr)))).map((Function1 & Serializable)x$3 -> Column$.MODULE$.apply((Expression)x$3));
        selectExprs = (Seq)selectExprs.$plus$plus((IterableOnce)rowCommitVersionExprs);
        QueryExecution queryExecution2 = queryExecution;
        if (queryExecution2 instanceof IncrementalExecution) {
            IncrementalExecution incrementalExecution = (IncrementalExecution)queryExecution2;
            dataset = DeltaStreamUtils$.MODULE$.selectFromStreamingDataFrame(incrementalExecution, data, (Seq<Column>)selectExprs);
        } else {
            dataset = data.select(selectExprs);
        }
        Dataset<Row> newData = dataset;
        this.recordDeltaEvent(deltaLog, "delta.generatedColumns.write", this.recordDeltaEvent$default$3(), this.recordDeltaEvent$default$4(), this.recordDeltaEvent$default$5());
        return new Tuple3(newData, (Object)constraints.toSeq(), (Object)track.toSet());
    }

    public StructType removeDefaultExpressions(StructType schema, boolean keepGeneratedColumns, boolean keepIdentityColumns) {
        BooleanRef updated = BooleanRef.create((boolean)false);
        Seq updatedSchema = (Seq)schema.map((Function1 & Serializable)field -> {
            if (!keepGeneratedColumns && GeneratedColumn$.MODULE$.isGeneratedColumn((StructField)field)) {
                org.apache.spark.sql.types.Metadata newMetadata;
                updated$1.elem = true;
                org.apache.spark.sql.types.Metadata x$1 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).remove(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY()).build();
                String x$2 = field.copy$default$1();
                DataType x$3 = field.copy$default$2();
                boolean x$4 = field.copy$default$3();
                return field.copy(x$2, x$3, x$4, x$1);
            }
            if (!keepIdentityColumns && MODULE$.isIdentityColumn((StructField)field)) {
                org.apache.spark.sql.types.Metadata newMetadata;
                updated$1.elem = true;
                org.apache.spark.sql.types.Metadata x$5 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).remove(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_ALLOW_EXPLICIT_INSERT()).remove(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_HIGHWATERMARK()).remove(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_START()).remove(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_STEP()).build();
                String x$6 = field.copy$default$1();
                DataType x$7 = field.copy$default$2();
                boolean x$8 = field.copy$default$3();
                return field.copy(x$6, x$7, x$8, x$5);
            }
            return field;
        });
        if (updated.elem) {
            return StructType$.MODULE$.apply(updatedSchema);
        }
        return schema;
    }

    public boolean removeDefaultExpressions$default$2() {
        return false;
    }

    public boolean removeDefaultExpressions$default$3() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$tableHasDefaultExpr$1(boolean nullAsDefault$1, StructField f) {
        return f.metadata().contains(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY()) || f.nullable() && nullAsDefault$1;
    }

    private static final /* synthetic */ CaseInsensitiveMap metadataOutputNames$lzycompute$1(LazyRef metadataOutputNames$lzy$1, StructType schema$1) {
        CaseInsensitiveMap caseInsensitiveMap;
        LazyRef lazyRef = metadataOutputNames$lzy$1;
        synchronized (lazyRef) {
            caseInsensitiveMap = metadataOutputNames$lzy$1.initialized() ? (CaseInsensitiveMap)metadataOutputNames$lzy$1.value() : (CaseInsensitiveMap)metadataOutputNames$lzy$1.initialize((Object)CaseInsensitiveMap$.MODULE$.apply(((IterableOnceOps)schema$1.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        }
        return caseInsensitiveMap;
    }

    private static final CaseInsensitiveMap metadataOutputNames$1(LazyRef metadataOutputNames$lzy$1, StructType schema$1) {
        if (metadataOutputNames$lzy$1.initialized()) {
            return (CaseInsensitiveMap)metadataOutputNames$lzy$1.value();
        }
        return ColumnWithDefaultExprUtils$.metadataOutputNames$lzycompute$1(metadataOutputNames$lzy$1, schema$1);
    }

    private ColumnWithDefaultExprUtils$() {
    }
}

