/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass;
import org.apache.spark.sql.catalyst.expressions.DayOfMonth;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Hour;
import org.apache.spark.sql.catalyst.expressions.IntegerLiteral$;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Month;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.StringLiteral$;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.TruncDate;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp;
import org.apache.spark.sql.catalyst.expressions.UserDefinedExpression;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.delta.DateFormatPartitionExpr;
import org.apache.spark.sql.delta.DatePartitionExpr;
import org.apache.spark.sql.delta.DayPartitionExpr;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.ExtractBaseColumn$;
import org.apache.spark.sql.delta.GeneratedColumnsTableFeature$;
import org.apache.spark.sql.delta.HourPartitionExpr;
import org.apache.spark.sql.delta.IdentityPartitionExpr;
import org.apache.spark.sql.delta.MonthPartitionExpr;
import org.apache.spark.sql.delta.OptimizablePartitionExpression;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.SubstringPartitionExpr;
import org.apache.spark.sql.delta.SupportedGenerationExpressions$;
import org.apache.spark.sql.delta.TimestampTruncPartitionExpr;
import org.apache.spark.sql.delta.TruncDatePartitionExpr;
import org.apache.spark.sql.delta.YearMonthDayHourPartitionExpr;
import org.apache.spark.sql.delta.YearMonthDayPartitionExpr;
import org.apache.spark.sql.delta.YearMonthPartitionExpr;
import org.apache.spark.sql.delta.YearPartitionExpr;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.util.AnalysisHelper;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VariantShims$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class GeneratedColumn$
implements DeltaLogging,
AnalysisHelper {
    public static final GeneratedColumn$ MODULE$ = new GeneratedColumn$();
    private static final String DATE_FORMAT_YEAR_MONTH;
    private static final String DATE_FORMAT_YEAR_MONTH_DAY;
    private static final String DATE_FORMAT_YEAR_MONTH_DAY_HOUR;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        LoggingShims.$init$(MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        AnalysisHelper.$init$(MODULE$);
        DATE_FORMAT_YEAR_MONTH = "yyyy-MM";
        DATE_FORMAT_YEAR_MONTH_DAY = "yyyy-MM-dd";
        DATE_FORMAT_YEAR_MONTH_DAY_HOUR = "yyyy-MM-dd-HH";
    }

    @Override
    public Expression tryResolveReferences(SparkSession sparkSession, Expression expr, LogicalPlan planContainingExpr) {
        return AnalysisHelper.tryResolveReferences$(this, sparkSession, expr, planContainingExpr);
    }

    @Override
    public Seq<Expression> tryResolveReferencesForExpressions(SparkSession sparkSession, Seq<Expression> exprs, LogicalPlan planContainingExpr) {
        return AnalysisHelper.tryResolveReferencesForExpressions$((AnalysisHelper)this, sparkSession, exprs, planContainingExpr);
    }

    @Override
    public Seq<Expression> resolveReferencesForExpressions(SparkSession sparkSession, Seq<Expression> exprs, LogicalPlan planProvidingAttrs) {
        return AnalysisHelper.resolveReferencesForExpressions$(this, sparkSession, exprs, planProvidingAttrs);
    }

    @Override
    public Seq<Expression> tryResolveReferencesForExpressions(SparkSession sparkSession, Seq<Expression> exprs, Seq<LogicalPlan> plansProvidingAttrs) {
        return AnalysisHelper.tryResolveReferencesForExpressions$((AnalysisHelper)this, sparkSession, exprs, plansProvidingAttrs);
    }

    @Override
    public Dataset<Row> toDataset(SparkSession sparkSession, LogicalPlan logicalPlan) {
        return AnalysisHelper.toDataset$(this, sparkSession, logicalPlan);
    }

    @Override
    public void improveUnsupportedOpError(Function0<BoxedUnit> f) {
        AnalysisHelper.improveUnsupportedOpError$(this, f);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean satisfyGeneratedColumnProtocol(Protocol protocol) {
        return protocol.isFeatureSupported(GeneratedColumnsTableFeature$.MODULE$);
    }

    public boolean isGeneratedColumn(StructField field) {
        return field.metadata().contains(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY());
    }

    public boolean isGeneratedColumn(Protocol protocol, StructField field) {
        return this.satisfyGeneratedColumnProtocol(protocol) && this.isGeneratedColumn(field);
    }

    public boolean hasGeneratedColumns(StructType schema) {
        return schema.exists((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)));
    }

    public Seq<StructField> getGeneratedColumns(SnapshotDescriptor snapshot) {
        if (this.satisfyGeneratedColumnProtocol(snapshot.protocol())) {
            return (Seq)snapshot.metadata().schema().partition((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)))._1();
        }
        return Nil$.MODULE$;
    }

    public boolean enforcesGeneratedColumns(Protocol protocol, Metadata metadata) {
        return this.satisfyGeneratedColumnProtocol(protocol) && metadata.schema().exists((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)));
    }

    public Option<String> getGenerationExpressionStr(org.apache.spark.sql.types.Metadata metadata) {
        if (metadata.contains(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY())) {
            return new Some((Object)metadata.getString(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY()));
        }
        return None$.MODULE$;
    }

    public Option<Expression> getGenerationExpression(StructField field) {
        return this.getGenerationExpressionStr(field.metadata()).map((Function1 & Serializable)exprStr -> MODULE$.parseGenerationExpression(SparkSession$.MODULE$.active(), (String)exprStr));
    }

    private Option<String> getGenerationExpressionStr(StructField field) {
        return this.getGenerationExpressionStr(field.metadata());
    }

    private Expression parseGenerationExpression(SparkSession spark, String exprString) {
        return spark.sessionState().sqlParser().parseExpression(exprString);
    }

    public void validateColumnReferences(SparkSession spark, String fieldName, Expression expression, StructType schema) {
        Seq allowedBaseColumns = (Seq)((IterableOps)schema.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.$anonfun$validateColumnReferences$1(fieldName, x$1)))).filterNot((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)));
        LocalRelation relation = new LocalRelation(DataTypeUtils$.MODULE$.toAttributes(StructType$.MODULE$.apply(allowedBaseColumns)), LocalRelation$.MODULE$.$lessinit$greater$default$2(), LocalRelation$.MODULE$.$lessinit$greater$default$3());
        try {
            Analyzer analyzer = spark.sessionState().analyzer();
            Expression x$12 = expression;
            String x$2 = fieldName;
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$12, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$12, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$12, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$12, x$2);
            LogicalPlan analyzed = analyzer.execute((LogicalPlan)new Project((Seq)new .colon.colon((Object)new Alias(x$12, x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$), (LogicalPlan)relation));
            analyzer.checkAnalysis(analyzed);
        }
        catch (AnalysisException ex) {
            String string = ex.getErrorClass();
            String string2 = "UNRESOLVED_COLUMN.WITH_SUGGESTION";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw DeltaErrors$.MODULE$.generatedColumnsReferToWrongColumns(ex);
            }
            throw ex;
        }
    }

    public void validateGeneratedColumns(SparkSession spark, StructType schema) {
        Dataset dataset;
        Tuple2 tuple2 = schema.partition((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq generatedColumns = (Seq)tuple2._1();
        Seq normalColumns = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)generatedColumns, (Object)normalColumns);
        Seq generatedColumns2 = (Seq)tuple22._1();
        Seq normalColumns2 = (Seq)tuple22._2();
        generatedColumns2.foreach((Function1 & Serializable)c -> {
            GeneratedColumn$.$anonfun$validateGeneratedColumns$2(c);
            return BoxedUnit.UNIT;
        });
        LocalRelation relation = new LocalRelation(DataTypeUtils$.MODULE$.toAttributes(StructType$.MODULE$.apply(normalColumns2)), LocalRelation$.MODULE$.$lessinit$greater$default$2(), LocalRelation$.MODULE$.$lessinit$greater$default$3());
        Seq selectExprs = (Seq)generatedColumns2.map((Function1 & Serializable)f -> {
            Option<String> option = MODULE$.getGenerationExpressionStr((StructField)f);
            if (option instanceof Some) {
                Some some = (Some)option;
                String exprString = (String)some.value();
                Expression expr = MODULE$.parseGenerationExpression(spark, exprString);
                MODULE$.validateColumnReferences(spark, f.name(), expr, schema);
                return Column$.MODULE$.apply(expr).alias(f.name());
            }
            if (None$.MODULE$.equals(option)) {
                throw DeltaErrors$.MODULE$.expressionsNotFoundInGeneratedColumn(f.name());
            }
            throw new MatchError(option);
        });
        try {
            Project plan = new Project((Seq)selectExprs.map((Function1 & Serializable)x$3 -> (NamedExpression)x$3.expr()), (LogicalPlan)relation);
            dataset = Dataset$.MODULE$.ofRows(spark, (LogicalPlan)plan);
        }
        catch (Throwable throwable) {
            AnalysisException analysisException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AnalysisException && (analysisException = (AnalysisException)throwable2).getMessage() != null) {
                .colon.colon regexCandidates = new .colon.colon((Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("A column, variable, or function parameter with name .*?cannot be resolved. Did you mean one of the following?.*?")), (List)new .colon.colon((Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("cannot resolve.*?given input columns:.*?")), (List)new .colon.colon((Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("Column.*?does not exist.")), (List)Nil$.MODULE$)));
                if (regexCandidates.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.$anonfun$validateGeneratedColumns$5(analysisException, x$4)))) {
                    throw DeltaErrors$.MODULE$.generatedColumnsReferToWrongColumns(analysisException);
                }
                throw analysisException;
            }
            throw throwable;
        }
        Dataset dfWithExprs = dataset;
        dfWithExprs.queryExecution().analyzed().transformAllExpressions((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Alias) {
                    Alias alias = (Alias)A1;
                    return (B1)alias;
                }
                if (A1 instanceof GetStructField ? true : A1 instanceof GetArrayItem) {
                    return (B1)A1;
                }
                if (A1 instanceof UserDefinedExpression) {
                    A1 A12 = A1;
                    throw DeltaErrors$.MODULE$.generatedColumnsUDF(A12);
                }
                if (!A1.deterministic()) {
                    throw DeltaErrors$.MODULE$.generatedColumnsNonDeterministicExpression(A1);
                }
                if (A1 instanceof AggregateExpression) {
                    throw DeltaErrors$.MODULE$.generatedColumnsAggregateExpression(A1);
                }
                if (!SupportedGenerationExpressions$.MODULE$.expressions().contains((Object)A1.getClass())) {
                    throw DeltaErrors$.MODULE$.generatedColumnsUnsupportedExpression(A1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (expression instanceof Alias) {
                    return true;
                }
                if (expression instanceof GetStructField ? true : expression instanceof GetArrayItem) {
                    return true;
                }
                if (expression instanceof UserDefinedExpression) {
                    return true;
                }
                if (!expression.deterministic()) {
                    return true;
                }
                if (expression instanceof AggregateExpression) {
                    return true;
                }
                return !SupportedGenerationExpressions$.MODULE$.expressions().contains((Object)expression.getClass());
            }
        });
        ((IterableOnceOps)generatedColumns2.zip((IterableOnce)dfWithExprs.schema())).foreach((Function1 & Serializable)x0$1 -> {
            GeneratedColumn$.$anonfun$validateGeneratedColumns$7(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getGeneratedColumnsAndColumnsUsedByGeneratedColumns(StructType schema) {
        Seq generationExprs = (Seq)schema.flatMap((Function1 & Serializable)col -> MODULE$.getGenerationExpressionStr((StructField)col).map((Function1 & Serializable)exprStr -> {
            Expression expr = MODULE$.parseGenerationExpression(SparkSession$.MODULE$.active(), (String)exprStr);
            return Column$.MODULE$.apply(expr).alias(col.name());
        }));
        if (generationExprs.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        Dataset df = Dataset$.MODULE$.ofRows(SparkSession$.MODULE$.active(), (LogicalPlan)new LocalRelation(DataTypeUtils$.MODULE$.toAttributes(schema), LocalRelation$.MODULE$.$lessinit$greater$default$2(), LocalRelation$.MODULE$.$lessinit$greater$default$3()));
        LogicalPlan logicalPlan = df.select(generationExprs).queryExecution().analyzed();
        if (!(logicalPlan instanceof Project)) {
            throw DeltaErrors$.MODULE$.unexpectedProject(logicalPlan.toString());
        }
        Project project = (Project)logicalPlan;
        Seq exprs = project.projectList();
        Seq generatedColumnsAndColumnsUsedByGeneratedColumns = (Seq)exprs.flatMap((Function1 & Serializable)x0$1 -> {
            NamedExpression namedExpression = x0$1;
            if (namedExpression instanceof Alias) {
                Alias alias = (Alias)namedExpression;
                Expression expr = alias.child();
                String column = alias.name();
                return (Seq)((IterableOnceOps)expr.references().map((Function1 & Serializable)x0$2 -> {
                    Attribute attribute = x0$2;
                    if (attribute instanceof AttributeReference) {
                        AttributeReference attributeReference = (AttributeReference)attribute;
                        return attributeReference.name();
                    }
                    throw DeltaErrors$.MODULE$.unexpectedAttributeReference(String.valueOf(attribute));
                })).toSeq().$colon$plus((Object)column);
            }
            throw DeltaErrors$.MODULE$.unexpectedAlias(String.valueOf(namedExpression));
        });
        return ((IterableOnceOps)generatedColumnsAndColumnsUsedByGeneratedColumns.map((Function1 & Serializable)x$5 -> x$5.toLowerCase(Locale.ROOT))).toSet();
    }

    private String createFieldPath(Seq<String> nameParts) {
        return ((IterableOnceOps)nameParts.map((Function1 & Serializable)part -> package$.MODULE$.quoteIfNeeded(part))).mkString(".");
    }

    public Map<String, Seq<OptimizablePartitionExpression>> getOptimizablePartitionExpressions(StructType schema, StructType partitionSchema) {
        Seq partitionGenerationExprs = (Seq)partitionSchema.flatMap((Function1 & Serializable)col -> MODULE$.getGenerationExpressionStr((StructField)col).map((Function1 & Serializable)exprStr -> {
            Expression expr = MODULE$.parseGenerationExpression(SparkSession$.MODULE$.active(), (String)exprStr);
            return Column$.MODULE$.apply(expr).alias(col.name());
        }));
        if (partitionGenerationExprs.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        SparkSession spark = SparkSession$.MODULE$.active();
        Function2 resolver = spark.sessionState().analyzer().resolver();
        Function1 & Serializable nameNormalizer = spark.sessionState().conf().caseSensitiveAnalysis() ? (Function1 & Serializable)x -> x : (Function1 & Serializable)x$6 -> x$6.toLowerCase(Locale.ROOT);
        Dataset df = Dataset$.MODULE$.ofRows(SparkSession$.MODULE$.active(), (LogicalPlan)new LocalRelation(DataTypeUtils$.MODULE$.toAttributes(schema), LocalRelation$.MODULE$.$lessinit$greater$default$2(), LocalRelation$.MODULE$.$lessinit$greater$default$3()));
        LogicalPlan logicalPlan = df.select(partitionGenerationExprs).queryExecution().analyzed();
        if (!(logicalPlan instanceof Project)) {
            throw DeltaErrors$.MODULE$.unexpectedProject(logicalPlan.toString());
        }
        Project project = (Project)logicalPlan;
        Seq exprs = project.projectList();
        Seq extractedPartitionExprs = (Seq)exprs.flatMap((Function1 & Serializable)x0$1 -> {
            NamedExpression namedExpression = x0$1;
            if (namedExpression instanceof Alias) {
                Option<Tuple2<Seq<String>, DataType>> option;
                Option<Tuple2<Seq<String>, DataType>> option2;
                Hour hour;
                Expression expression;
                DayOfMonth dayOfMonth;
                Expression expression2;
                Month month;
                Expression expression3;
                Expression expression4;
                Expression expression5;
                Alias alias = (Alias)namedExpression;
                Expression expr = alias.child();
                String partColName = alias.name();
                boolean bl = false;
                Cast cast = null;
                boolean bl2 = false;
                Year year = null;
                boolean bl3 = false;
                DateFormatClass dateFormatClass = null;
                boolean bl4 = false;
                TruncTimestamp truncTimestamp = null;
                boolean bl5 = false;
                TruncDate truncDate = null;
                Expression expression6 = expr;
                if (expression6 instanceof Cast) {
                    Option<Tuple2<Seq<String>, DataType>> option3;
                    bl = true;
                    cast = (Cast)expression6;
                    Expression expression7 = cast.child();
                    DataType dataType = cast.dataType();
                    if (expression7 != null && !(option3 = ExtractBaseColumn$.MODULE$.unapply(expression7)).isEmpty()) {
                        Seq name = (Seq)((Tuple2)option3.get())._1();
                        DataType dataType2 = (DataType)((Tuple2)option3.get())._2();
                        if (TimestampType$.MODULE$.equals(dataType2) && DateType$.MODULE$.equals(dataType)) {
                            return this.createExpr$1(name, (Function0 & Serializable)() -> new DatePartitionExpr(partColName), resolver, schema, nameNormalizer);
                        }
                    }
                }
                if (bl) {
                    Option<Tuple2<Seq<String>, DataType>> option4;
                    Expression expression8 = cast.child();
                    DataType dataType = cast.dataType();
                    if (expression8 != null && !(option4 = ExtractBaseColumn$.MODULE$.unapply(expression8)).isEmpty()) {
                        Seq name = (Seq)((Tuple2)option4.get())._1();
                        DataType dataType3 = (DataType)((Tuple2)option4.get())._2();
                        if (DateType$.MODULE$.equals(dataType3) && DateType$.MODULE$.equals(dataType)) {
                            return this.createExpr$1(name, (Function0 & Serializable)() -> new DatePartitionExpr(partColName), resolver, schema, nameNormalizer);
                        }
                    }
                }
                if (expression6 instanceof Year) {
                    Option<Tuple2<Seq<String>, DataType>> option5;
                    bl2 = true;
                    year = (Year)expression6;
                    Expression expression9 = year.child();
                    if (expression9 != null && !(option5 = ExtractBaseColumn$.MODULE$.unapply(expression9)).isEmpty()) {
                        Seq name = (Seq)((Tuple2)option5.get())._1();
                        DataType dataType = (DataType)((Tuple2)option5.get())._2();
                        if (DateType$.MODULE$.equals(dataType)) {
                            return this.createExpr$1(name, (Function0 & Serializable)() -> new YearPartitionExpr(partColName), resolver, schema, nameNormalizer);
                        }
                    }
                }
                if (bl2 && (expression5 = year.child()) instanceof Cast) {
                    Option<Tuple2<Seq<String>, DataType>> option6;
                    Cast cast2 = (Cast)expression5;
                    Expression expression10 = cast2.child();
                    DataType dataType = cast2.dataType();
                    if (expression10 != null && !(option6 = ExtractBaseColumn$.MODULE$.unapply(expression10)).isEmpty()) {
                        Seq name = (Seq)((Tuple2)option6.get())._1();
                        DataType dataType4 = (DataType)((Tuple2)option6.get())._2();
                        if (TimestampType$.MODULE$.equals(dataType4) && DateType$.MODULE$.equals(dataType)) {
                            return this.createExpr$1(name, (Function0 & Serializable)() -> new YearPartitionExpr(partColName), resolver, schema, nameNormalizer);
                        }
                    }
                }
                if (bl2 && (expression4 = year.child()) instanceof Cast) {
                    Option<Tuple2<Seq<String>, DataType>> option7;
                    Cast cast3 = (Cast)expression4;
                    Expression expression11 = cast3.child();
                    DataType dataType = cast3.dataType();
                    if (expression11 != null && !(option7 = ExtractBaseColumn$.MODULE$.unapply(expression11)).isEmpty()) {
                        Seq name = (Seq)((Tuple2)option7.get())._1();
                        DataType dataType5 = (DataType)((Tuple2)option7.get())._2();
                        if (DateType$.MODULE$.equals(dataType5) && DateType$.MODULE$.equals(dataType)) {
                            return this.createExpr$1(name, (Function0 & Serializable)() -> new YearPartitionExpr(partColName), resolver, schema, nameNormalizer);
                        }
                    }
                }
                if (expression6 instanceof Month && (expression3 = (month = (Month)expression6).child()) instanceof Cast) {
                    Option<Tuple2<Seq<String>, DataType>> option8;
                    Cast cast4 = (Cast)expression3;
                    Expression expression12 = cast4.child();
                    DataType dataType = cast4.dataType();
                    if (expression12 != null && !(option8 = ExtractBaseColumn$.MODULE$.unapply(expression12)).isEmpty()) {
                        Seq name = (Seq)((Tuple2)option8.get())._1();
                        DataType dataType6 = (DataType)((Tuple2)option8.get())._2();
                        if (TimestampType$.MODULE$.equals(dataType6) && DateType$.MODULE$.equals(dataType)) {
                            return this.createExpr$1(name, (Function0 & Serializable)() -> new MonthPartitionExpr(partColName), resolver, schema, nameNormalizer);
                        }
                    }
                }
                if (expression6 instanceof DateFormatClass) {
                    bl3 = true;
                    dateFormatClass = (DateFormatClass)expression6;
                    Expression expression13 = dateFormatClass.left();
                    Expression expression14 = dateFormatClass.right();
                    if (expression13 instanceof Cast) {
                        Option<Tuple2<Seq<String>, DataType>> option9;
                        Cast cast5 = (Cast)expression13;
                        Expression expression15 = cast5.child();
                        DataType dataType = cast5.dataType();
                        if (expression15 != null && !(option9 = ExtractBaseColumn$.MODULE$.unapply(expression15)).isEmpty()) {
                            Option option10;
                            Seq name = (Seq)((Tuple2)option9.get())._1();
                            DataType dataType7 = (DataType)((Tuple2)option9.get())._2();
                            if (DateType$.MODULE$.equals(dataType7) && TimestampType$.MODULE$.equals(dataType) && expression14 != null && !(option10 = StringLiteral$.MODULE$.unapply((Object)expression14)).isEmpty()) {
                                String format;
                                String string = format = (String)option10.get();
                                String string2 = MODULE$.DATE_FORMAT_YEAR_MONTH();
                                String string3 = string;
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    return this.createExpr$1(name, (Function0 & Serializable)() -> new DateFormatPartitionExpr(partColName, MODULE$.DATE_FORMAT_YEAR_MONTH()), resolver, schema, nameNormalizer);
                                }
                                return None$.MODULE$;
                            }
                        }
                    }
                }
                if (bl3) {
                    Option<Tuple2<Seq<String>, DataType>> option11;
                    Expression expression16 = dateFormatClass.left();
                    Expression expression17 = dateFormatClass.right();
                    if (expression16 != null && !(option11 = ExtractBaseColumn$.MODULE$.unapply(expression16)).isEmpty()) {
                        Option option12;
                        Seq name = (Seq)((Tuple2)option11.get())._1();
                        DataType dataType = (DataType)((Tuple2)option11.get())._2();
                        if (TimestampType$.MODULE$.equals(dataType) && expression17 != null && !(option12 = StringLiteral$.MODULE$.unapply((Object)expression17)).isEmpty()) {
                            String format;
                            String string = format = (String)option12.get();
                            String string4 = MODULE$.DATE_FORMAT_YEAR_MONTH();
                            String string5 = string;
                            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                                return this.createExpr$1(name, (Function0 & Serializable)() -> new DateFormatPartitionExpr(partColName, MODULE$.DATE_FORMAT_YEAR_MONTH()), resolver, schema, nameNormalizer);
                            }
                            String string6 = MODULE$.DATE_FORMAT_YEAR_MONTH_DAY();
                            String string7 = string;
                            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                return this.createExpr$1(name, (Function0 & Serializable)() -> new DateFormatPartitionExpr(partColName, MODULE$.DATE_FORMAT_YEAR_MONTH_DAY()), resolver, schema, nameNormalizer);
                            }
                            String string8 = MODULE$.DATE_FORMAT_YEAR_MONTH_DAY_HOUR();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                return this.createExpr$1(name, (Function0 & Serializable)() -> new DateFormatPartitionExpr(partColName, MODULE$.DATE_FORMAT_YEAR_MONTH_DAY_HOUR()), resolver, schema, nameNormalizer);
                            }
                            return None$.MODULE$;
                        }
                    }
                }
                if (expression6 instanceof DayOfMonth && (expression2 = (dayOfMonth = (DayOfMonth)expression6).child()) instanceof Cast) {
                    Option<Tuple2<Seq<String>, DataType>> option13;
                    Cast cast6 = (Cast)expression2;
                    Expression expression18 = cast6.child();
                    DataType dataType = cast6.dataType();
                    if (expression18 != null && !(option13 = ExtractBaseColumn$.MODULE$.unapply(expression18)).isEmpty()) {
                        Seq name = (Seq)((Tuple2)option13.get())._1();
                        DataType dataType8 = (DataType)((Tuple2)option13.get())._2();
                        if (TimestampType$.MODULE$.equals(dataType8) && DateType$.MODULE$.equals(dataType)) {
                            return this.createExpr$1(name, (Function0 & Serializable)() -> new DayPartitionExpr(partColName), resolver, schema, nameNormalizer);
                        }
                    }
                }
                if (expression6 instanceof Hour && (expression = (hour = (Hour)expression6).child()) != null && !(option2 = ExtractBaseColumn$.MODULE$.unapply(expression)).isEmpty()) {
                    Seq name = (Seq)((Tuple2)option2.get())._1();
                    DataType dataType = (DataType)((Tuple2)option2.get())._2();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        return this.createExpr$1(name, (Function0 & Serializable)() -> new HourPartitionExpr(partColName), resolver, schema, nameNormalizer);
                    }
                }
                if (expression6 instanceof Substring) {
                    Option<Tuple2<Seq<String>, DataType>> option14;
                    Substring substring = (Substring)expression6;
                    Expression expression19 = substring.str();
                    Expression expression20 = substring.pos();
                    Expression expression21 = substring.len();
                    if (expression19 != null && !(option14 = ExtractBaseColumn$.MODULE$.unapply(expression19)).isEmpty()) {
                        Option option15;
                        Seq name = (Seq)((Tuple2)option14.get())._1();
                        DataType dataType = (DataType)((Tuple2)option14.get())._2();
                        if (StringType$.MODULE$.equals(dataType) && expression20 != null && !(option15 = IntegerLiteral$.MODULE$.unapply((Object)expression20)).isEmpty()) {
                            Option option16;
                            int pos = BoxesRunTime.unboxToInt((Object)option15.get());
                            if (expression21 != null && !(option16 = IntegerLiteral$.MODULE$.unapply((Object)expression21)).isEmpty()) {
                                int len = BoxesRunTime.unboxToInt((Object)option16.get());
                                return this.createExpr$1(name, (Function0 & Serializable)() -> new SubstringPartitionExpr(partColName, pos, len), resolver, schema, nameNormalizer);
                            }
                        }
                    }
                }
                if (expression6 instanceof TruncTimestamp) {
                    Option option17;
                    bl4 = true;
                    truncTimestamp = (TruncTimestamp)expression6;
                    Expression expression22 = truncTimestamp.format();
                    Expression expression23 = truncTimestamp.timestamp();
                    if (expression22 != null && !(option17 = StringLiteral$.MODULE$.unapply((Object)expression22)).isEmpty()) {
                        Option<Tuple2<Seq<String>, DataType>> option18;
                        String format = (String)option17.get();
                        if (expression23 != null && !(option18 = ExtractBaseColumn$.MODULE$.unapply(expression23)).isEmpty()) {
                            Seq name = (Seq)((Tuple2)option18.get())._1();
                            DataType dataType = (DataType)((Tuple2)option18.get())._2();
                            if (TimestampType$.MODULE$.equals(dataType)) {
                                return this.createExpr$1(name, (Function0 & Serializable)() -> new TimestampTruncPartitionExpr(format, partColName), resolver, schema, nameNormalizer);
                            }
                        }
                    }
                }
                if (bl4) {
                    Option option19;
                    Expression expression24 = truncTimestamp.format();
                    Expression expression25 = truncTimestamp.timestamp();
                    if (expression24 != null && !(option19 = StringLiteral$.MODULE$.unapply((Object)expression24)).isEmpty()) {
                        String format = (String)option19.get();
                        if (expression25 instanceof Cast) {
                            Option<Tuple2<Seq<String>, DataType>> option20;
                            Cast cast7 = (Cast)expression25;
                            Expression expression26 = cast7.child();
                            DataType dataType = cast7.dataType();
                            if (expression26 != null && !(option20 = ExtractBaseColumn$.MODULE$.unapply(expression26)).isEmpty()) {
                                Seq name = (Seq)((Tuple2)option20.get())._1();
                                DataType dataType9 = (DataType)((Tuple2)option20.get())._2();
                                if (DateType$.MODULE$.equals(dataType9) && TimestampType$.MODULE$.equals(dataType)) {
                                    return this.createExpr$1(name, (Function0 & Serializable)() -> new TimestampTruncPartitionExpr(format, partColName), resolver, schema, nameNormalizer);
                                }
                            }
                        }
                    }
                }
                if (expression6 != null && !(option = ExtractBaseColumn$.MODULE$.unapply(expression6)).isEmpty()) {
                    Seq name = (Seq)((Tuple2)option.get())._1();
                    return this.createExpr$1(name, (Function0 & Serializable)() -> new IdentityPartitionExpr(partColName), resolver, schema, nameNormalizer);
                }
                if (expression6 instanceof TruncDate) {
                    Option<Tuple2<Seq<String>, DataType>> option21;
                    bl5 = true;
                    truncDate = (TruncDate)expression6;
                    Expression expression27 = truncDate.date();
                    Expression expression28 = truncDate.format();
                    if (expression27 != null && !(option21 = ExtractBaseColumn$.MODULE$.unapply(expression27)).isEmpty()) {
                        Option option22;
                        Seq name = (Seq)((Tuple2)option21.get())._1();
                        DataType dataType = (DataType)((Tuple2)option21.get())._2();
                        if (DateType$.MODULE$.equals(dataType) && expression28 != null && !(option22 = StringLiteral$.MODULE$.unapply((Object)expression28)).isEmpty()) {
                            String format = (String)option22.get();
                            return this.createExpr$1(name, (Function0 & Serializable)() -> new TruncDatePartitionExpr(partColName, format), resolver, schema, nameNormalizer);
                        }
                    }
                }
                if (bl5) {
                    Expression expression29 = truncDate.date();
                    Expression expression30 = truncDate.format();
                    if (expression29 instanceof Cast) {
                        Option<Tuple2<Seq<String>, DataType>> option23;
                        Cast cast8 = (Cast)expression29;
                        Expression expression31 = cast8.child();
                        DataType dataType = cast8.dataType();
                        if (expression31 != null && !(option23 = ExtractBaseColumn$.MODULE$.unapply(expression31)).isEmpty()) {
                            Option option24;
                            Seq name = (Seq)((Tuple2)option23.get())._1();
                            DataType dataType10 = (DataType)((Tuple2)option23.get())._2();
                            if ((TimestampType$.MODULE$.equals(dataType10) ? true : StringType$.MODULE$.equals(dataType10)) && DateType$.MODULE$.equals(dataType) && expression30 != null && !(option24 = StringLiteral$.MODULE$.unapply((Object)expression30)).isEmpty()) {
                                String format = (String)option24.get();
                                return this.createExpr$1(name, (Function0 & Serializable)() -> new TruncDatePartitionExpr(partColName, format), resolver, schema, nameNormalizer);
                            }
                        }
                    }
                }
                return None$.MODULE$;
            }
            throw DeltaErrors$.MODULE$.unexpectedAlias(String.valueOf(namedExpression));
        });
        return (Map)extractedPartitionExprs.groupBy((Function1 & Serializable)x$7 -> (String)x$7._1()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq group = (Seq)tuple2._2();
                Seq groupedExprs = (Seq)group.map((Function1 & Serializable)x$8 -> (OptimizablePartitionExpression)x$8._2());
                Seq<OptimizablePartitionExpression> mergedExprs = MODULE$.mergePartitionExpressionsIfPossible((Seq<OptimizablePartitionExpression>)groupedExprs);
                if (MODULE$.log().isDebugEnabled()) {
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Optimizable partition expressions for column ").append(name).append(":").toString());
                    mergedExprs.foreach((Function1 & Serializable)expr -> {
                        GeneratedColumn$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> expr.toString());
                        return BoxedUnit.UNIT;
                    });
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), mergedExprs);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Seq<OptimizablePartitionExpression> mergePartitionExpressionsIfPossible(Seq<OptimizablePartitionExpression> exprs) {
        SeqOps seqOps;
        SeqOps seqOps2;
        Option year = ((IterableOps)exprs.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends OptimizablePartitionExpression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof YearPartitionExpr) {
                    YearPartitionExpr yearPartitionExpr = (YearPartitionExpr)A1;
                    return (B1)yearPartitionExpr;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(OptimizablePartitionExpression x1) {
                OptimizablePartitionExpression optimizablePartitionExpression = x1;
                return optimizablePartitionExpression instanceof YearPartitionExpr;
            }
        })).headOption();
        Option month = ((IterableOps)exprs.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends OptimizablePartitionExpression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof MonthPartitionExpr) {
                    MonthPartitionExpr monthPartitionExpr = (MonthPartitionExpr)A1;
                    return (B1)monthPartitionExpr;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(OptimizablePartitionExpression x2) {
                OptimizablePartitionExpression optimizablePartitionExpression = x2;
                return optimizablePartitionExpression instanceof MonthPartitionExpr;
            }
        })).headOption();
        Option day = ((IterableOps)exprs.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends OptimizablePartitionExpression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 instanceof DayPartitionExpr) {
                    DayPartitionExpr dayPartitionExpr = (DayPartitionExpr)A1;
                    return (B1)dayPartitionExpr;
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(OptimizablePartitionExpression x3) {
                OptimizablePartitionExpression optimizablePartitionExpression = x3;
                return optimizablePartitionExpression instanceof DayPartitionExpr;
            }
        })).headOption();
        Option hour = ((IterableOps)exprs.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends OptimizablePartitionExpression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                if (A1 instanceof HourPartitionExpr) {
                    HourPartitionExpr hourPartitionExpr = (HourPartitionExpr)A1;
                    return (B1)hourPartitionExpr;
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(OptimizablePartitionExpression x4) {
                OptimizablePartitionExpression optimizablePartitionExpression = x4;
                return optimizablePartitionExpression instanceof HourPartitionExpr;
            }
        })).headOption();
        boolean bl = false;
        Seq seq = null;
        Iterable iterable = (Iterable)((IterableOps)((IterableOps)Option$.MODULE$.option2Iterable(year).$plus$plus((IterableOnce)month)).$plus$plus((IterableOnce)day)).$plus$plus((IterableOnce)hour);
        if (iterable instanceof Seq) {
            bl = true;
            seq = (Seq)iterable;
            SeqOps seqOps3 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq);
            if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 4) == 0) {
                Product year2 = (Product)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
                Product month2 = (Product)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
                Product day2 = (Product)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2);
                Product hour2 = (Product)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 3);
                if (year2 instanceof YearPartitionExpr) {
                    YearPartitionExpr yearPartitionExpr = (YearPartitionExpr)year2;
                    if (month2 instanceof MonthPartitionExpr) {
                        MonthPartitionExpr monthPartitionExpr = (MonthPartitionExpr)month2;
                        if (day2 instanceof DayPartitionExpr) {
                            DayPartitionExpr dayPartitionExpr = (DayPartitionExpr)day2;
                            if (hour2 instanceof HourPartitionExpr) {
                                HourPartitionExpr hourPartitionExpr = (HourPartitionExpr)hour2;
                                return (Seq)((SeqOps)exprs.filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.isRedundantPartitionExpr$1(f)))).$colon$plus((Object)new YearMonthDayHourPartitionExpr(yearPartitionExpr.yearPart(), monthPartitionExpr.monthPart(), dayPartitionExpr.dayPart(), hourPartitionExpr.hourPart()));
                            }
                        }
                    }
                }
            }
        }
        if (bl && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 3) == 0) {
            Product year3 = (Product)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Product month3 = (Product)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            Product day3 = (Product)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2);
            if (year3 instanceof YearPartitionExpr) {
                YearPartitionExpr yearPartitionExpr = (YearPartitionExpr)year3;
                if (month3 instanceof MonthPartitionExpr) {
                    MonthPartitionExpr monthPartitionExpr = (MonthPartitionExpr)month3;
                    if (day3 instanceof DayPartitionExpr) {
                        DayPartitionExpr dayPartitionExpr = (DayPartitionExpr)day3;
                        return (Seq)((SeqOps)exprs.filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.isRedundantPartitionExpr$1(f)))).$colon$plus((Object)new YearMonthDayPartitionExpr(yearPartitionExpr.yearPart(), monthPartitionExpr.monthPart(), dayPartitionExpr.dayPart()));
                    }
                }
            }
        }
        if (bl && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Product year4 = (Product)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Product month4 = (Product)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (year4 instanceof YearPartitionExpr) {
                YearPartitionExpr yearPartitionExpr = (YearPartitionExpr)year4;
                if (month4 instanceof MonthPartitionExpr) {
                    MonthPartitionExpr monthPartitionExpr = (MonthPartitionExpr)month4;
                    return (Seq)((SeqOps)exprs.filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.isRedundantPartitionExpr$1(f)))).$colon$plus((Object)new YearMonthPartitionExpr(yearPartitionExpr.yearPart(), monthPartitionExpr.monthPart()));
                }
            }
        }
        return exprs;
    }

    public boolean partitionFilterOptimizationEnabled(SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.GENERATED_COLUMN_PARTITION_FILTER_OPTIMIZATION_ENABLED()));
    }

    public Seq<Expression> generatePartitionFilters(SparkSession spark, SnapshotDescriptor snapshot, Seq<Expression> dataFilters, LogicalPlan delta) {
        if (!this.satisfyGeneratedColumnProtocol(snapshot.protocol())) {
            return Nil$.MODULE$;
        }
        if (snapshot.metadata().optimizablePartitionExpressions().isEmpty()) {
            return Nil$.MODULE$;
        }
        CaseInsensitiveMap optimizablePartitionExpressions = spark.sessionState().conf().caseSensitiveAnalysis() ? snapshot.metadata().optimizablePartitionExpressions() : CaseInsensitiveMap$.MODULE$.apply(snapshot.metadata().optimizablePartitionExpressions());
        Seq partitionFilters = (Seq)dataFilters.flatMap(arg_0 -> GeneratedColumn$.$anonfun$generatePartitionFilters$3(this, (Map)optimizablePartitionExpressions, arg_0));
        Seq<Expression> resolvedPartitionFilters = this.resolveReferencesForExpressions(spark, (Seq<Expression>)partitionFilters, delta);
        if (this.log().isDebugEnabled()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "User provided data filters:");
            dataFilters.foreach((Function1 & Serializable)f -> {
                GeneratedColumn$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> f.sql());
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Auto generated partition filters:");
            partitionFilters.foreach((Function1 & Serializable)f -> {
                GeneratedColumn$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> f.sql());
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Resolved generated partition filters:");
            resolvedPartitionFilters.foreach((Function1 & Serializable)f -> {
                GeneratedColumn$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> f.sql());
                return BoxedUnit.UNIT;
            });
        }
        String executionId = (String)Option$.MODULE$.apply((Object)spark.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY())).getOrElse((Function0 & Serializable)() -> "unknown");
        DeltaLog x$1 = snapshot.deltaLog();
        String x$2 = "delta.generatedColumns.optimize";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executionId"), (Object)executionId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"triggered"), (Object)BoxesRunTime.boxToBoolean((boolean)resolvedPartitionFilters.nonEmpty()))}));
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, "delta.generatedColumns.optimize", x$4, x$3, x$5);
        return resolvedPartitionFilters;
    }

    private String DATE_FORMAT_YEAR_MONTH() {
        return DATE_FORMAT_YEAR_MONTH;
    }

    private String DATE_FORMAT_YEAR_MONTH_DAY() {
        return DATE_FORMAT_YEAR_MONTH_DAY;
    }

    private String DATE_FORMAT_YEAR_MONTH_DAY_HOUR() {
        return DATE_FORMAT_YEAR_MONTH_DAY_HOUR;
    }

    public static final /* synthetic */ boolean $anonfun$validateColumnReferences$1(String fieldName$1, StructField x$1) {
        String string = x$1.name();
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateGeneratedColumns$2(StructField c) {
        if (VariantShims$.MODULE$.isVariantType(c.dataType())) {
            throw DeltaErrors$.MODULE$.generatedColumnsUnsupportedType(c.dataType());
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateGeneratedColumns$5(AnalysisException x5$1, Regex x$4) {
        return x$4.findFirstMatchIn((CharSequence)x5$1.getMessage()).isDefined();
    }

    public static final /* synthetic */ void $anonfun$validateGeneratedColumns$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField column = (StructField)tuple2._1();
            StructField expr = (StructField)tuple2._2();
            if (!DataType$.MODULE$.equalsIgnoreNullability(column.dataType(), expr.dataType())) {
                throw DeltaErrors$.MODULE$.generatedColumnsExprTypeMismatch(column.name(), column.dataType(), expr.dataType());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final Option createExpr$1(Seq nameParts, Function0 func, Function2 resolver$1, StructType schema$2, Function1 nameNormalizer$1) {
        Origin x$4;
        Seq x$1 = nameParts;
        Function2 x$2 = resolver$1;
        boolean x$3 = schema$2.findNestedField$default$2();
        if (schema$2.findNestedField(x$1, x$3, x$2, x$4 = schema$2.findNestedField$default$4()).isDefined()) {
            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nameNormalizer$1.apply((Object)this.createFieldPath((Seq<String>)nameParts))), func.apply()));
        }
        return None$.MODULE$;
    }

    private static final boolean isRedundantPartitionExpr$1(OptimizablePartitionExpression f) {
        return f instanceof YearPartitionExpr || f instanceof MonthPartitionExpr || f instanceof DayPartitionExpr || f instanceof HourPartitionExpr;
    }

    private static final Expression preprocess$1(Expression filter) {
        Expression expression = filter;
        if (expression instanceof LessThan) {
            LessThan lessThan = (LessThan)expression;
            Expression lit = lessThan.left();
            Expression e = lessThan.right();
            if (lit instanceof Literal) {
                Literal literal = (Literal)lit;
                if (e != null) {
                    Expression expression2 = e;
                    return new GreaterThan(expression2, (Expression)literal);
                }
            }
        }
        if (expression instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
            Expression lit = lessThanOrEqual.left();
            Expression e = lessThanOrEqual.right();
            if (lit instanceof Literal) {
                Literal literal = (Literal)lit;
                if (e != null) {
                    Expression expression3 = e;
                    return new GreaterThanOrEqual(expression3, (Expression)literal);
                }
            }
        }
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Expression lit = equalTo.left();
            Expression e = equalTo.right();
            if (lit instanceof Literal) {
                Literal literal = (Literal)lit;
                if (e != null) {
                    Expression expression4 = e;
                    return new EqualTo(expression4, (Expression)literal);
                }
            }
        }
        if (expression instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)expression;
            Expression lit = greaterThan.left();
            Expression e = greaterThan.right();
            if (lit instanceof Literal) {
                Literal literal = (Literal)lit;
                if (e != null) {
                    Expression expression5 = e;
                    return new LessThan(expression5, (Expression)literal);
                }
            }
        }
        if (expression instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression lit = greaterThanOrEqual.left();
            Expression e = greaterThanOrEqual.right();
            if (lit instanceof Literal) {
                Literal literal = (Literal)lit;
                if (e != null) {
                    Expression expression6 = e;
                    return new LessThanOrEqual(expression6, (Expression)literal);
                }
            }
        }
        return expression;
    }

    private final Seq toPartitionFilter$1(Seq nameParts, Function1 func, Map optimizablePartitionExpressions$1) {
        return (Seq)Option$.MODULE$.option2Iterable(optimizablePartitionExpressions$1.get((Object)this.createFieldPath((Seq<String>)nameParts))).toSeq().flatMap((Function1 & Serializable)exprs -> (Seq)exprs.flatMap((Function1 & Serializable)expr -> (Option)func.apply(expr)));
    }

    public static final /* synthetic */ Seq $anonfun$generatePartitionFilters$3(GeneratedColumn$ $this, Map optimizablePartitionExpressions$1, Expression filter) {
        Option<Tuple2<Seq<String>, DataType>> option;
        IsNull isNull;
        Expression expression;
        Expression expression2 = GeneratedColumn$.preprocess$1(filter);
        if (expression2 instanceof LessThan) {
            Option<Tuple2<Seq<String>, DataType>> option2;
            LessThan lessThan = (LessThan)expression2;
            Expression expression3 = lessThan.left();
            Expression lit = lessThan.right();
            if (expression3 != null && !(option2 = ExtractBaseColumn$.MODULE$.unapply(expression3)).isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option2.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable)x$9 -> x$9.lessThan(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (expression2 instanceof LessThanOrEqual) {
            Option<Tuple2<Seq<String>, DataType>> option3;
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression2;
            Expression expression4 = lessThanOrEqual.left();
            Expression lit = lessThanOrEqual.right();
            if (expression4 != null && !(option3 = ExtractBaseColumn$.MODULE$.unapply(expression4)).isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option3.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable)x$10 -> x$10.lessThanOrEqual(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (expression2 instanceof EqualTo) {
            Option<Tuple2<Seq<String>, DataType>> option4;
            EqualTo equalTo = (EqualTo)expression2;
            Expression expression5 = equalTo.left();
            Expression lit = equalTo.right();
            if (expression5 != null && !(option4 = ExtractBaseColumn$.MODULE$.unapply(expression5)).isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option4.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable)x$11 -> x$11.equalTo(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (expression2 instanceof GreaterThan) {
            Option<Tuple2<Seq<String>, DataType>> option5;
            GreaterThan greaterThan = (GreaterThan)expression2;
            Expression expression6 = greaterThan.left();
            Expression lit = greaterThan.right();
            if (expression6 != null && !(option5 = ExtractBaseColumn$.MODULE$.unapply(expression6)).isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option5.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable)x$12 -> x$12.greaterThan(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (expression2 instanceof GreaterThanOrEqual) {
            Option<Tuple2<Seq<String>, DataType>> option6;
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression2;
            Expression expression7 = greaterThanOrEqual.left();
            Expression lit = greaterThanOrEqual.right();
            if (expression7 != null && !(option6 = ExtractBaseColumn$.MODULE$.unapply(expression7)).isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option6.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable)x$13 -> x$13.greaterThanOrEqual(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (expression2 instanceof IsNull && (expression = (isNull = (IsNull)expression2).child()) != null && !(option = ExtractBaseColumn$.MODULE$.unapply(expression)).isEmpty()) {
            Seq nameParts = (Seq)((Tuple2)option.get())._1();
            return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable)x$14 -> x$14.isNull(), optimizablePartitionExpressions$1);
        }
        return Nil$.MODULE$;
    }

    private GeneratedColumn$() {
    }
}

