/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.DeltaDelete;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaFullTable$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.commands.DeleteCommand;
import org.apache.spark.sql.delta.files.TahoeLogFileIndex;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.runtime.ModuleSerializationProxy;

public final class DeleteCommand$
implements Serializable {
    public static final DeleteCommand$ MODULE$ = new DeleteCommand$();
    private static final String FILE_NAME_COLUMN = "_input_file_name_";
    private static final String FINDING_TOUCHED_FILES_MSG = "Finding files to rewrite for DELETE operation";

    public DeleteCommand apply(DeltaDelete delete) {
        Option<Tuple2<LogicalRelation, TahoeLogFileIndex>> option;
        LogicalPlan logicalPlan = EliminateSubqueryAliases$.MODULE$.apply(delete.child());
        if (logicalPlan != null && !(option = DeltaFullTable$.MODULE$.unapply(logicalPlan)).isEmpty()) {
            LogicalRelation relation = (LogicalRelation)((Tuple2)option.get())._1();
            TahoeLogFileIndex fileIndex = (TahoeLogFileIndex)((Tuple2)option.get())._2();
            return new DeleteCommand(fileIndex.deltaLog(), (Option<CatalogTable>)relation.catalogTable(), delete.child(), delete.condition());
        }
        throw DeltaErrors$.MODULE$.notADeltaSourceException("DELETE", (Option<LogicalPlan>)new Some((Object)logicalPlan));
    }

    public String FILE_NAME_COLUMN() {
        return FILE_NAME_COLUMN;
    }

    public String FINDING_TOUCHED_FILES_MSG() {
        return FINDING_TOUCHED_FILES_MSG;
    }

    public String rewritingFilesMsg(long numFilesToRewrite) {
        return new StringBuilder(37).append("Rewriting ").append(numFilesToRewrite).append(" files for DELETE operation").toString();
    }

    public DeleteCommand apply(DeltaLog deltaLog, Option<CatalogTable> catalogTable, LogicalPlan target, Option<Expression> condition) {
        return new DeleteCommand(deltaLog, catalogTable, target, condition);
    }

    public Option<Tuple4<DeltaLog, Option<CatalogTable>, LogicalPlan, Option<Expression>>> unapply(DeleteCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.deltaLog(), x$0.catalogTable(), (Object)x$0.target(), x$0.condition()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeleteCommand$.class);
    }

    private DeleteCommand$() {
    }
}

