/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.constraints;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.constraints.CharVarcharConstraint$;
import org.apache.spark.sql.delta.constraints.Constraint;
import org.apache.spark.sql.delta.constraints.Constraints;
import org.apache.spark.sql.delta.constraints.Invariants$;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class Constraints$ {
    public static final Constraints$ MODULE$ = new Constraints$();

    public Seq<String> getCheckConstraintNames(Metadata metadata) {
        return ((IterableOnceOps)metadata.configuration().keys().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.toLowerCase(Locale.ROOT).startsWith("delta.constraints.")) {
                    return (B1)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(A1), "delta.constraints.");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                return string.toLowerCase(Locale.ROOT).startsWith("delta.constraints.");
            }
        })).toSeq();
    }

    public Seq<Constraint> getCheckConstraints(Metadata metadata, SparkSession spark) {
        return ((IterableOnceOps)metadata.configuration().collect((PartialFunction)new Serializable(spark){
            private static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    String constraintText = (String)A1._2();
                    if (key.toLowerCase(Locale.ROOT).startsWith("delta.constraints.")) {
                        String name = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(key), "delta.constraints.");
                        Expression expression = this.spark$1.sessionState().sqlParser().parseExpression(constraintText);
                        return (B1)new Constraints.Check(name, expression);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String key;
                Tuple2<String, String> tuple2 = x1;
                return tuple2 != null && (key = (String)tuple2._1()).toLowerCase(Locale.ROOT).startsWith("delta.constraints.");
            }
            {
                this.spark$1 = spark$1;
            }
        })).toSeq();
    }

    public Seq<Constraint> getAll(Metadata metadata, SparkSession spark) {
        Seq<Constraint> checkConstraints = this.getCheckConstraints(metadata, spark);
        Seq<Constraint> constraintsFromSchema = Invariants$.MODULE$.getFromSchema(metadata.schema(), spark);
        Seq<Constraint> charVarcharLengthChecks = spark.sessionState().conf().charVarcharAsString() ? Nil$.MODULE$ : CharVarcharConstraint$.MODULE$.stringConstraints(metadata.schema());
        return ((Seq)((IterableOps)checkConstraints.$plus$plus(constraintsFromSchema)).$plus$plus(charVarcharLengthChecks)).toSeq();
    }

    public Option<String> getExprTextByName(String name, Metadata metadata, SparkSession spark) {
        return metadata.configuration().get((Object)this.checkConstraintPropertyName(name));
    }

    public String checkConstraintPropertyName(String constraintName) {
        return new StringBuilder(18).append("delta.constraints.").append(constraintName.toLowerCase(Locale.ROOT)).toString();
    }

    public Map<String, String> findDependentConstraints(SparkSession sparkSession, Seq<String> columnName, Metadata metadata) {
        return (Map)metadata.configuration().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Constraints$.$anonfun$findDependentConstraints$1(sparkSession, columnName, metadata, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$findDependentConstraints$1(SparkSession sparkSession$1, Seq columnName$1, Metadata metadata$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String constraint = (String)tuple2._2();
            if (key.toLowerCase(Locale.ROOT).startsWith("delta.constraints.")) {
                return SchemaUtils$.MODULE$.containsDependentExpression(sparkSession$1, (Seq<String>)columnName$1, constraint, metadata$1.schema(), (Function2<String, String, Object>)sparkSession$1.sessionState().conf().resolver());
            }
        }
        return false;
    }

    private Constraints$() {
    }
}

