/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.storage.HadoopFileSystemLogStore;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001\u0002\t\u0012\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)q\u0007\u0001C\u0001q!)A\b\u0001C\t{!)A\b\u0001C\t'\"9q\u000b\u0001b\u0001\n\u0003A\u0006BB1\u0001A\u0003%\u0011\fC\u0003c\u0001\u0011\u00053\rC\u0005\u0002\u0006\u0001\t\n\u0011\"\u0001\u0002\b!1!\r\u0001C!\u0003;Aq!a\n\u0001\t\u0013\tI\u0003C\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA#\u0001\u0011\u0005\u00131\n\u0002\r\u0011\u001235\u000bT8h'R|'/\u001a\u0006\u0003%M\tqa\u001d;pe\u0006<WM\u0003\u0002\u0015+\u0005)A-\u001a7uC*\u0011acF\u0001\u0004gFd'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aH\u0012\u0011\u0005\u0001\nS\"A\t\n\u0005\t\n\"\u0001\u0007%bI>|\u0007OR5mKNK8\u000f^3n\u0019><7\u000b^8sKB\u0011AeJ\u0007\u0002K)\u0011aeF\u0001\tS:$XM\u001d8bY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002,Y5\tq#\u0003\u0002./\tI1\u000b]1sW\u000e{gNZ\u0001\u0012I\u00164\u0017-\u001e7u\u0011\u0006$wn\u001c9D_:4\u0007C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011\u0019wN\u001c4\u000b\u0005QJ\u0012A\u00025bI>|\u0007/\u0003\u00027c\ti1i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDcA\u001d;wA\u0011\u0001\u0005\u0001\u0005\u0006S\r\u0001\rA\u000b\u0005\u0006]\r\u0001\raL\u0001\u000fO\u0016$h)\u001b7f\u0007>tG/\u001a=u)\tqD\t\u0005\u0002@\u00056\t\u0001I\u0003\u0002Bg\u0005\u0011am]\u0005\u0003\u0007\u0002\u00131BR5mK\u000e{g\u000e^3yi\")Q\t\u0002a\u0001\r\u0006!\u0001/\u0019;i!\tyt)\u0003\u0002I\u0001\n!\u0001+\u0019;iQ\u0011!!\nU)\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0003I\u000b1iY1mY\u0002\"\b.\u001a\u0011nKRDw\u000e\u001a\u0011uQ\u0006$\b%Y:lg\u00022wN\u001d\u0011bA!\u000bGm\\8qA\r{gNZ5hkJ\fG/[8oA=\u0014'.Z2uA%t7\u000f^3bIR\u0019a\bV+\t\u000b\u0015+\u0001\u0019\u0001$\t\u000bY+\u0001\u0019A\u0018\u0002\u0015!\fGm\\8q\u0007>tg-\u0001\u0013o_\u0006\u00137\u000f\u001e:bGR4\u0015\u000e\\3TsN$X-\\#yG\u0016\u0004H/[8o\u001b\u0016\u001c8/Y4f+\u0005I\u0006C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011a\u0017M\\4\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u0007'R\u0014\u0018N\\4\u0002K9|\u0017IY:ue\u0006\u001cGOR5mKNK8\u000f^3n\u000bb\u001cW\r\u001d;j_:lUm]:bO\u0016\u0004\u0013!B<sSR,G\u0003\u00023hQv\u0004\"aS3\n\u0005\u0019d%\u0001B+oSRDQ!\u0012\u0005A\u0002\u0019CQ!\u001b\u0005A\u0002)\fq!Y2uS>t7\u000fE\u0002lgZt!\u0001\\9\u000f\u00055\u0004X\"\u00018\u000b\u0005=l\u0012A\u0002\u001fs_>$h(C\u0001N\u0013\t\u0011H*A\u0004qC\u000e\\\u0017mZ3\n\u0005Q,(\u0001C%uKJ\fGo\u001c:\u000b\u0005Id\u0005CA<|\u001d\tA\u0018\u0010\u0005\u0002n\u0019&\u0011!\u0010T\u0001\u0007!J,G-\u001a4\n\u0005\u0001d(B\u0001>M\u0011\u001dq\b\u0002%AA\u0002}\f\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0011\u0007-\u000b\t!C\u0002\u0002\u00041\u0013qAQ8pY\u0016\fg.A\bxe&$X\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tIAK\u0002\u0000\u0003\u0017Y#!!\u0004\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/a\u0015AC1o]>$\u0018\r^5p]&!\u00111DA\t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\nI\u0006}\u0011\u0011EA\u0012\u0003KAQ!\u0012\u0006A\u0002\u0019CQ!\u001b\u0006A\u0002)DQA \u0006A\u0002}DQA\u0016\u0006A\u0002=\nQb\u001e:ji\u0016Le\u000e^3s]\u0006dG#\u00033\u0002,\u00055\u0012qFA\u0019\u0011\u0015)5\u00021\u0001G\u0011\u0015I7\u00021\u0001k\u0011\u0015q8\u00021\u0001\u0000\u0011\u001516\u00021\u00010\u0003Ai7/\u001f8d\u0013\u001a\u001cV\u000f\u001d9peR,G\rF\u0003e\u0003o\tI\u0004C\u0003F\u0019\u0001\u0007a\tC\u0003W\u0019\u0001\u0007q&\u0001\tuef\u0014V-\\8wK\u000e\u00138MR5mKR)A-a\u0010\u0002D!1\u0011\u0011I\u0007A\u0002y\n!AZ2\t\u000b\u0015k\u0001\u0019\u0001$\u0002+%\u001c\b+\u0019:uS\u0006dwK]5uKZK7/\u001b2mKR\u0019q0!\u0013\t\u000b\u0015s\u0001\u0019\u0001$\u0015\u000b}\fi%a\u0014\t\u000b\u0015{\u0001\u0019\u0001$\t\u000bY{\u0001\u0019A\u0018")
public class HDFSLogStore
extends HadoopFileSystemLogStore
implements Logging {
    private final SparkConf sparkConf;
    private final String noAbstractFileSystemExceptionMessage;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FileContext getFileContext(Path path) {
        return FileContext.getFileContext((URI)path.toUri(), (Configuration)this.getHadoopConfiguration());
    }

    public FileContext getFileContext(Path path, Configuration hadoopConf) {
        return FileContext.getFileContext((URI)path.toUri(), (Configuration)hadoopConf);
    }

    public String noAbstractFileSystemExceptionMessage() {
        return this.noAbstractFileSystemExceptionMessage;
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        this.write(path, actions, overwrite, this.getHadoopConfiguration());
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        boolean isLocalFs = path.getFileSystem(hadoopConf) instanceof RawLocalFileSystem;
        if (isLocalFs) {
            HDFSLogStore hDFSLogStore = this;
            synchronized (hDFSLogStore) {
                this.writeInternal(path, actions, overwrite, hadoopConf);
            }
            return;
        }
        this.writeInternal(path, actions, overwrite, hadoopConf);
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    private void writeInternal(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        FileContext fileContext;
        try {
            fileContext = this.getFileContext(path, hadoopConf);
        }
        catch (Throwable throwable) {
            IOException iOException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException && (iOException = (IOException)throwable2).getMessage().contains(this.noAbstractFileSystemExceptionMessage())) {
                Throwable newException = DeltaErrors$.MODULE$.incorrectLogStoreImplementationException(this.sparkConf, iOException);
                this.logError((Function0<String>)(Function0 & Serializable)() -> newException.getMessage(), newException.getCause());
                throw newException;
            }
            throw throwable;
        }
        FileContext fc = fileContext;
        if (!overwrite && fc.util().exists(path)) {
            throw DeltaErrors$.MODULE$.fileAlreadyExists(path.toString());
        }
        Path tempPath = this.createTempPath(path);
        boolean streamClosed = false;
        boolean renameDone = false;
        FSDataOutputStream stream = fc.create(tempPath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.checksumParam((Options.ChecksumOpt)Options.ChecksumOpt.createDisabled())});
        try {
            actions.map((Function1 & Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append("\n").toString()).map((Function1 & Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                Options.Rename renameOpt = overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE;
                fc.rename(tempPath, path, new Options.Rename[]{renameOpt});
                renameDone = true;
                this.tryRemoveCrcFile(fc, tempPath);
            }
            catch (FileAlreadyExistsException e) {
                throw DeltaErrors$.MODULE$.fileAlreadyExists(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!renameDone) {
                fc.delete(tempPath, false);
            }
        }
        this.msyncIfSupported(path, hadoopConf);
    }

    private void msyncIfSupported(Path path, Configuration hadoopConf) {
        try {
            FileSystem fs = path.getFileSystem(hadoopConf);
            Method msync = fs.getClass().getMethod("msync", new Class[0]);
            msync.invoke((Object)fs, new Object[0]);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
            }
            throw throwable;
        }
    }

    private void tryRemoveCrcFile(FileContext fc, Path path) {
        try {
            Path checksumFile = new Path(path.getParent(), new StringBuilder(5).append(".").append(path.getName()).append(".crc").toString());
            if (fc.util().exists(checksumFile)) {
                fc.delete(checksumFile, true);
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
            }
            throw throwable;
        }
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    @Override
    public boolean isPartialWriteVisible(Path path, Configuration hadoopConf) {
        return true;
    }

    public HDFSLogStore(SparkConf sparkConf, Configuration defaultHadoopConf) {
        this.sparkConf = sparkConf;
        super(sparkConf, defaultHadoopConf);
        Logging.$init$((Logging)this);
        this.noAbstractFileSystemExceptionMessage = "No AbstractFileSystem";
    }
}

