/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.CheckpointProtectionPreDowngradeCommand;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.PreDowngradeTableFeatureCommand;
import org.apache.spark.sql.delta.RemovableFeature;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.WriterFeature;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

public final class CheckpointProtectionTableFeature$
extends WriterFeature
implements RemovableFeature {
    public static final CheckpointProtectionTableFeature$ MODULE$ = new CheckpointProtectionTableFeature$();

    static {
        RemovableFeature.$init$(MODULE$);
    }

    @Override
    public boolean historyContainsFeature(SparkSession spark, Snapshot downgradeTxnReadSnapshot) {
        return RemovableFeature.historyContainsFeature$(this, spark, downgradeTxnReadSnapshot);
    }

    public long getCheckpointProtectionVersion(Snapshot snapshot) {
        if (!snapshot.protocol().isFeatureSupported(this)) {
            return 0L;
        }
        return BoxesRunTime.unboxToLong((Object)DeltaConfigs$.MODULE$.REQUIRE_CHECKPOINT_PROTECTION_BEFORE_VERSION().fromMetaData(snapshot.metadata()));
    }

    public Metadata metadataWithCheckpointProtection(Metadata metadata, long version) {
        String versionPropKey = DeltaConfigs$.MODULE$.REQUIRE_CHECKPOINT_PROTECTION_BEFORE_VERSION().key();
        Tuple2 versionConf = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)versionPropKey), (Object)Long.toString(version));
        Map x$1 = (Map)metadata.configuration().$plus(versionConf);
        String x$2 = metadata.copy$default$1();
        String x$3 = metadata.copy$default$2();
        String x$4 = metadata.copy$default$3();
        Format x$5 = metadata.copy$default$4();
        String x$6 = metadata.copy$default$5();
        Seq<String> x$7 = metadata.copy$default$6();
        Option<Object> x$8 = metadata.copy$default$8();
        return metadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
    }

    private boolean deltasUpToVersionAreTruncated(DeltaLog deltaLog, long toVersion) {
        return deltaLog.getChangeLogFiles(0L, toVersion, false).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                FileStatus file = (FileStatus)tuple2._2();
                return file;
            }
            throw new MatchError((Object)tuple2);
        }).filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FileNames$.MODULE$.isDeltaFile(file))).take(1).isEmpty();
    }

    public boolean historyPriorToCheckpointProtectionVersionIsTruncated(Snapshot snapshot) {
        long checkpointProtectionVersion = this.getCheckpointProtectionVersion(snapshot);
        if (checkpointProtectionVersion <= 0L) {
            return true;
        }
        DeltaLog deltaLog = snapshot.deltaLog();
        return deltaLog.findEarliestReliableCheckpoint().exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$8 -> x$8 >= checkpointProtectionVersion) && this.deltasUpToVersionAreTruncated(deltaLog, checkpointProtectionVersion - 1L);
    }

    @Override
    public boolean requiresHistoryProtection() {
        return false;
    }

    @Override
    public PreDowngradeTableFeatureCommand preDowngradeCommand(DeltaTableV2 table) {
        return new CheckpointProtectionPreDowngradeCommand(table);
    }

    @Override
    public boolean validateRemoval(Snapshot snapshot) {
        String property = DeltaConfigs$.MODULE$.REQUIRE_CHECKPOINT_PROTECTION_BEFORE_VERSION().key();
        return !snapshot.metadata().configuration().contains((Object)property);
    }

    @Override
    public boolean actionUsesFeature(Action action) {
        return false;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CheckpointProtectionTableFeature$.class);
    }

    private CheckpointProtectionTableFeature$() {
        super("checkpointProtection");
    }
}

