/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.CheckpointProvider;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaLogFileIndex;
import org.apache.spark.sql.delta.DeltaLogFileIndex$;
import org.apache.spark.sql.delta.LazyCompleteCheckpointProvider;
import org.apache.spark.sql.delta.PreloadedCheckpointProvider;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.SnapshotManagement$;
import org.apache.spark.sql.delta.UninitializedCheckpointProvider;
import org.apache.spark.sql.delta.UninitializedV1OrV2ParquetCheckpointProvider;
import org.apache.spark.sql.delta.UninitializedV2CheckpointProvider;
import org.apache.spark.sql.delta.V2CheckpointProvider$;
import org.apache.spark.sql.delta.V2CheckpointTableFeature$;
import org.apache.spark.sql.delta.VersionChecksum;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.CheckpointMetadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.SidecarFile;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.threads.NonFateSharingFuture;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class CheckpointProvider$
implements DeltaLogging {
    public static final CheckpointProvider$ MODULE$ = new CheckpointProvider$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        LoggingShims.$init$(MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DeltaLogFileIndex checkpointFileIndex(Seq<FileStatus> checkpointFiles) {
        Predef$.MODULE$.assert(checkpointFiles.nonEmpty(), (Function0 & Serializable)() -> "checkpointFiles must not be empty");
        return (DeltaLogFileIndex)DeltaLogFileIndex$.MODULE$.apply((FileFormat)DeltaLogFileIndex$.MODULE$.CHECKPOINT_FILE_FORMAT_PARQUET(), checkpointFiles).get();
    }

    public CheckpointProvider apply(SparkSession spark2, SnapshotDescriptor snapshotDescriptor, Option<VersionChecksum> checksumOpt, UninitializedCheckpointProvider uninitializedCheckpointProvider) {
        boolean bl = false;
        UninitializedV1OrV2ParquetCheckpointProvider uninitializedV1OrV2ParquetCheckpointProvider = null;
        UninitializedCheckpointProvider uninitializedCheckpointProvider2 = uninitializedCheckpointProvider;
        if (uninitializedCheckpointProvider2 instanceof UninitializedV2CheckpointProvider) {
            UninitializedV2CheckpointProvider uninitializedV2CheckpointProvider = (UninitializedV2CheckpointProvider)uninitializedCheckpointProvider2;
            return new LazyCompleteCheckpointProvider(uninitializedV2CheckpointProvider, snapshotDescriptor){
                private final UninitializedV2CheckpointProvider x2$1;
                private final SnapshotDescriptor snapshotDescriptor$1;

                public CheckpointProvider createCheckpointProvider() {
                    Tuple2<Option<CheckpointMetadata>, Seq<SidecarFile>> tuple2 = this.x2$1.nonFateSharingCheckpointReadFuture().get((Duration)Duration$.MODULE$.Inf());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Option checkpointMetadataOpt2 = (Option)tuple2._1();
                    Seq sidecarFiles = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)checkpointMetadataOpt2, (Object)sidecarFiles);
                    Option checkpointMetadataOpt3 = (Option)tuple22._1();
                    Seq sidecarFiles2 = (Seq)tuple22._2();
                    CheckpointMetadata checkpointMetadata = (CheckpointMetadata)checkpointMetadataOpt3.getOrElse((Function0 & Serializable)() -> {
                        FileStatus checkpointFile = (FileStatus)$this.x2$1.topLevelFiles().head();
                        throw new IllegalStateException(new StringBuilder(47).append("V2 Checkpoint ").append(checkpointFile.getPath()).append(" ").append("has no CheckpointMetadata action").toString());
                    });
                    Predef$.MODULE$.require(CheckpointProvider$.MODULE$.isV2CheckpointEnabled(this.snapshotDescriptor$1.protocol()));
                    return V2CheckpointProvider$.MODULE$.apply(this.x2$1, checkpointMetadata, (Seq<SidecarFile>)sidecarFiles2);
                }
                {
                    this.x2$1 = x2$1;
                    this.snapshotDescriptor$1 = snapshotDescriptor$1;
                    super(x2$1);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createCheckpointProvider$1(org.apache.spark.sql.delta.CheckpointProvider$$anon$1 )}, serializedLambda);
                }
            };
        }
        if (uninitializedCheckpointProvider2 instanceof UninitializedV1OrV2ParquetCheckpointProvider) {
            bl = true;
            uninitializedV1OrV2ParquetCheckpointProvider = (UninitializedV1OrV2ParquetCheckpointProvider)uninitializedCheckpointProvider2;
            if (this.isV2CheckpointEnabled(checksumOpt).contains((Object)BoxesRunTime.boxToBoolean((boolean)false))) {
                return new PreloadedCheckpointProvider(uninitializedV1OrV2ParquetCheckpointProvider.topLevelFiles(), uninitializedV1OrV2ParquetCheckpointProvider.lastCheckpointInfoOpt());
            }
        }
        if (bl) {
            NonFateSharingFuture future = SnapshotManagement$.MODULE$.checkpointV2ThreadPool().submitNonFateSharing((Function1 & Serializable)spark -> MODULE$.readV2ActionsFromParquetCheckpoint((SparkSession)spark, uninitializedV1OrV2ParquetCheckpointProvider.logPath(), uninitializedV1OrV2ParquetCheckpointProvider.fileStatus(), snapshotDescriptor.deltaLog().options()));
            return new LazyCompleteCheckpointProvider(uninitializedV1OrV2ParquetCheckpointProvider, future, snapshotDescriptor){
                private final NonFateSharingFuture future$1;
                private final SnapshotDescriptor snapshotDescriptor$1;
                private final UninitializedV1OrV2ParquetCheckpointProvider x3$1;

                public CheckpointProvider createCheckpointProvider() {
                    Tuple2 tuple2 = (Tuple2)this.future$1.get((Duration)Duration$.MODULE$.Inf());
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Option checkpointMetadataOpt2 = (Option)tuple2._1();
                    Seq sidecarFiles = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)checkpointMetadataOpt2, (Object)sidecarFiles);
                    Option checkpointMetadataOpt3 = (Option)tuple22._1();
                    Seq sidecarFiles2 = (Seq)tuple22._2();
                    Option option = checkpointMetadataOpt3;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        CheckpointMetadata cm = (CheckpointMetadata)some.value();
                        Predef$.MODULE$.require(CheckpointProvider$.MODULE$.isV2CheckpointEnabled(this.snapshotDescriptor$1));
                        return V2CheckpointProvider$.MODULE$.apply(this.x3$1, cm, (Seq<SidecarFile>)sidecarFiles2);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return new PreloadedCheckpointProvider(this.x3$1.topLevelFiles(), this.x3$1.lastCheckpointInfoOpt());
                    }
                    throw new MatchError((Object)option);
                }
                {
                    this.future$1 = future$1;
                    this.snapshotDescriptor$1 = snapshotDescriptor$1;
                    this.x3$1 = x3$1;
                    super(x3$1);
                }
            };
        }
        throw new MatchError((Object)uninitializedCheckpointProvider2);
    }

    public boolean isV2CheckpointEnabled(Protocol protocol) {
        return protocol.isFeatureSupported(V2CheckpointTableFeature$.MODULE$);
    }

    public boolean isV2CheckpointEnabled(SnapshotDescriptor snapshotDescriptor) {
        return this.isV2CheckpointEnabled(snapshotDescriptor.protocol());
    }

    public Option<Object> isV2CheckpointEnabled(Option<VersionChecksum> checksumOpt) {
        return checksumOpt.flatMap((Function1 & Serializable)checksum -> Option$.MODULE$.apply((Object)checksum.protocol())).map((Function1 & Serializable)protocol -> BoxesRunTime.boxToBoolean((boolean)CheckpointProvider$.MODULE$.isV2CheckpointEnabled(protocol)));
    }

    private void sendEventForV2CheckpointRead(long startTimeMs, FileStatus fileStatus, String fileType, Path logPath, Option<Throwable> exception) {
        Object x$1 = null;
        String x$2 = "delta.checkpointV2.readV2ActionsFromCheckpoint";
        Map x$32 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeTakenMs"), (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTimeMs))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v2CheckpointPath"), (Object)fileStatus.getPath().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v2CheckpointSize"), (Object)BoxesRunTime.boxToLong((long)fileStatus.getLen())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"errorMessage"), exception.map((Function1 & Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileType"), (Object)fileType)}));
        Some x$4 = new Some((Object)logPath.getParent());
        Map<TagDefinition, String> x$5 = this.recordDeltaEvent$default$3();
        this.recordDeltaEvent(null, "delta.checkpointV2.readV2ActionsFromCheckpoint", x$5, x$32, (Option<Path>)x$4);
    }

    public Tuple2<CheckpointMetadata, Seq<SidecarFile>> readV2ActionsFromJsonCheckpoint(LogStore logStore, Path logPath, FileStatus fileStatus, Configuration hadoopConf) {
        Tuple2 tuple2;
        long startTimeMs = System.currentTimeMillis();
        try {
            ObjectRef checkpointMetadataOpt2 = ObjectRef.create((Object)None$.MODULE$);
            ArrayBuffer sidecarFileActions = ArrayBuffer$.MODULE$.empty();
            logStore.readAsIterator(fileStatus, hadoopConf).processAndClose((Function1 & Serializable)x$4 -> {
                CheckpointProvider$.$anonfun$readV2ActionsFromJsonCheckpoint$1(checkpointMetadataOpt2, sidecarFileActions, x$4);
                return BoxedUnit.UNIT;
            });
            CheckpointMetadata checkpointMetadata = (CheckpointMetadata)((Option)checkpointMetadataOpt2.elem).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("Json V2 Checkpoint has no CheckpointMetadata action");
            });
            this.sendEventForV2CheckpointRead(startTimeMs, fileStatus, "json", logPath, (Option<Throwable>)None$.MODULE$);
            tuple2 = new Tuple2((Object)checkpointMetadata, (Object)sidecarFileActions.toSeq());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.sendEventForV2CheckpointRead(startTimeMs, fileStatus, "json", logPath, (Option<Throwable>)new Some((Object)throwable2));
                throw throwable2;
            }
            throw throwable;
        }
        return tuple2;
    }

    public Tuple2<Option<CheckpointMetadata>, Seq<SidecarFile>> readV2ActionsFromParquetCheckpoint(SparkSession spark, Path logPath, FileStatus fileStatus, Map<String, String> deltaLogOptions) {
        Tuple2 tuple2;
        long startTimeMs = System.currentTimeMillis();
        try {
            LogicalRelation relation = DeltaLog$.MODULE$.indexToRelation(spark, this.checkpointFileIndex((Seq<FileStatus>)new .colon.colon((Object)fileStatus, (List)Nil$.MODULE$)), deltaLogOptions, Action$.MODULE$.logSchema());
            Tuple2[] rows = (Tuple2[])Dataset$.MODULE$.ofRows(spark, (LogicalPlan)relation).select("checkpointMetadata", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sidecar"})).where("checkpointMetadata.version is not null or sidecar.path is not null").as(package$.MODULE$.v2CheckpointActionsEncoder()).collect();
            ObjectRef checkpointMetadata = ObjectRef.create((Object)None$.MODULE$);
            ArrayBuffer checkpointSidecarFiles = ArrayBuffer$.MODULE$.empty();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])rows), (Function1 & Serializable)x0$1 -> {
                SidecarFile sf;
                CheckpointMetadata cm;
                CheckpointMetadata cm2;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null && (cm2 = (CheckpointMetadata)tuple2._1()) != null) {
                    CheckpointMetadata checkpointMetadata = cm2;
                    if (((Option)checkpointMetadata$1.elem).isEmpty()) {
                        checkpointMetadata$1.elem = new Some((Object)checkpointMetadata);
                        return BoxedUnit.UNIT;
                    }
                }
                if (tuple2 != null && (cm = (CheckpointMetadata)tuple2._1()) != null) {
                    throw new IllegalStateException("More than 1 CheckpointMetadata actions found in the checkpoint file");
                }
                if (tuple2 != null && (sf = (SidecarFile)tuple2._2()) != null) {
                    SidecarFile sidecarFile = sf;
                    return checkpointSidecarFiles.append((Object)sidecarFile);
                }
                throw new MatchError((Object)tuple2);
            });
            if (((Option)checkpointMetadata.elem).isEmpty() && checkpointSidecarFiles.nonEmpty()) {
                throw new IllegalStateException("sidecar files present in checkpoint even when checkpoint metadata is missing");
            }
            this.sendEventForV2CheckpointRead(startTimeMs, fileStatus, "parquet", logPath, (Option<Throwable>)None$.MODULE$);
            tuple2 = new Tuple2((Object)((Option)checkpointMetadata.elem), (Object)checkpointSidecarFiles.toSeq());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.sendEventForV2CheckpointRead(startTimeMs, fileStatus, "parquet", logPath, (Option<Throwable>)new Some((Object)throwable2));
                throw throwable2;
            }
            throw throwable;
        }
        return tuple2;
    }

    public static final /* synthetic */ void $anonfun$readV2ActionsFromJsonCheckpoint$1(ObjectRef checkpointMetadataOpt$1, ArrayBuffer sidecarFileActions$1, Iterator x$4) {
        x$4.map((Function1 & Serializable)json -> Action$.MODULE$.fromJson((String)json)).foreach((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            CheckpointMetadata checkpointMetadata = null;
            Action action = x0$1;
            if (action instanceof CheckpointMetadata) {
                bl = true;
                checkpointMetadata = (CheckpointMetadata)action;
                if (((Option)checkpointMetadataOpt$1.elem).isEmpty()) {
                    checkpointMetadataOpt$1.elem = new Some((Object)checkpointMetadata);
                    return BoxedUnit.UNIT;
                }
            }
            if (bl) {
                throw new IllegalStateException("More than 1 CheckpointMetadata actions found in the checkpoint file");
            }
            if (action instanceof SidecarFile) {
                SidecarFile sidecarFile = (SidecarFile)action;
                return sidecarFileActions$1.append((Object)sidecarFile);
            }
            return BoxedUnit.UNIT;
        });
    }

    private CheckpointProvider$() {
    }
}

