/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.CharVarcharCodegenUtils;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.delta.ColumnWithDefaultExprUtils$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.metering.LogThrottler;
import org.apache.spark.sql.delta.metering.LogThrottler$;
import org.apache.spark.sql.delta.skipping.clustering.temp.ClusterByTransform;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelationWithTable$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class DeltaTableUtils$
implements PredicateHelper,
DeltaLogging {
    public static final DeltaTableUtils$ MODULE$ = new DeltaTableUtils$();
    private static final List<String> validDeltaTableHadoopPrefixes;
    private static final LogThrottler logThrottler;
    private static final Seq<String> SPARK_INTERNAL_METADATA_KEYS;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        AliasHelper.$init$((AliasHelper)MODULE$);
        Logging.$init$((Logging)MODULE$);
        PredicateHelper.$init$((PredicateHelper)MODULE$);
        LoggingShims.$init$(MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        validDeltaTableHadoopPrefixes = new .colon.colon((Object)"fs.", (List)new .colon.colon((Object)"dfs.", (List)Nil$.MODULE$));
        logThrottler = new LogThrottler(LogThrottler$.MODULE$.$lessinit$greater$default$1(), LogThrottler$.MODULE$.$lessinit$greater$default$2(), LogThrottler$.MODULE$.$lessinit$greater$default$3());
        SPARK_INTERNAL_METADATA_KEYS = new .colon.colon((Object)"__autoGeneratedAlias", (List)new .colon.colon((Object)"__metadata_col", (List)new .colon.colon((Object)"__supports_qualified_star", (List)new .colon.colon((Object)"__qualified_access_only", (List)new .colon.colon((Object)"__file_source_metadata_col", (List)new .colon.colon((Object)"__file_source_constant_metadata_col", (List)new .colon.colon((Object)"__file_source_generated_metadata_col", (List)Nil$.MODULE$)))))));
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<String> validDeltaTableHadoopPrefixes() {
        return validDeltaTableHadoopPrefixes;
    }

    public boolean isDeltaTable(CatalogTable table) {
        return DeltaSourceUtils$.MODULE$.isDeltaTable((Option<String>)table.provider());
    }

    public boolean isDeltaTable(SparkSession spark, TableIdentifier tableName) {
        SessionCatalog catalog = spark.sessionState().catalog();
        boolean tableIsNotTemporaryTable = !catalog.isTempView(tableName);
        boolean tableExists = (tableName.database().isEmpty() || catalog.databaseExists((String)tableName.database().get())) && catalog.tableExists(tableName);
        return tableIsNotTemporaryTable && tableExists && this.isDeltaTable(catalog.getTableMetadata(tableName));
    }

    public boolean isDeltaTable(SparkSession spark, Path path, Map<String, String> options) {
        return this.findDeltaTableRoot(spark, path, options).isDefined();
    }

    public Map<String, String> isDeltaTable$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean isCatalogTable(SessionCatalog catalog, TableIdentifier tableIdent) {
        Tuple2<Object, Object> tuple2 = this.dbExistsAndAssumePath(catalog, tableIdent);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean dbExists = tuple2._1$mcZ$sp();
        boolean assumePath = tuple2._2$mcZ$sp();
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(dbExists, assumePath);
        boolean dbExists2 = sp2._1$mcZ$sp();
        boolean assumePath2 = sp2._2$mcZ$sp();
        if (assumePath2) {
            return false;
        }
        if ((dbExists2 || tableIdent.database().isEmpty()) && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> catalog.tableExists(tableIdent)).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            return true;
        }
        if (this.isValidPath(tableIdent)) {
            return false;
        }
        throw new NoSuchTableException((String)tableIdent.database().getOrElse((Function0 & Serializable)() -> ""), tableIdent.table());
    }

    private Tuple2<Object, Object> dbExistsAndAssumePath(SessionCatalog catalog, TableIdentifier ident) {
        boolean bl;
        boolean bl2 = false;
        Success success = null;
        boolean bl3 = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> DeltaTableUtils$.databaseExists$1(ident, catalog));
        if (try_ instanceof Success) {
            bl2 = true;
            success = (Success)try_;
            boolean bl4 = BoxesRunTime.unboxToBoolean((Object)success.value());
            if (bl4) {
                return new Tuple2.mcZZ.sp(true, false);
            }
        }
        if (bl2 && !(bl = BoxesRunTime.unboxToBoolean((Object)success.value()))) {
            return new Tuple2.mcZZ.sp(false, new Path(ident.table()).isAbsolute());
        }
        if (try_ instanceof Failure) {
            bl3 = true;
            failure = (Failure)try_;
            if (this.isValidPath(ident)) {
                return new Tuple2.mcZZ.sp(false, true);
            }
        }
        if (bl3) {
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public boolean isValidPath(TableIdentifier tableIdent) {
        return DeltaSourceUtils$.MODULE$.isDeltaDataSourceName((String)tableIdent.database().getOrElse((Function0 & Serializable)() -> "")) && new Path(tableIdent.table()).isAbsolute();
    }

    public Option<Path> findDeltaTableRoot(SparkSession spark, Path path, Map<String, String> options) {
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConfWithOptions(options));
        return this.findDeltaTableRoot(fs, path);
    }

    public Option<Path> findDeltaTableRoot(FileSystem fs, Path path) {
        return this.findDeltaTableRoot(fs, path, BoxesRunTime.unboxToBoolean((Object)SparkSession$.MODULE$.active().conf().get(DeltaSQLConf$.MODULE$.DELTA_IS_DELTA_TABLE_THROW_ON_ERROR())));
    }

    public Option<Path> findDeltaTableRoot(FileSystem fs, Path path, boolean throwOnError) {
        if (throwOnError) {
            return this.findDeltaTableRootThrowOnError(fs, path);
        }
        return this.findDeltaTableRootNoExceptions(fs, path);
    }

    public Map<String, String> findDeltaTableRoot$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private Option<Path> findDeltaTableRootNoExceptions(FileSystem fs, Path path) {
        for (Path currentPath = path; currentPath != null; currentPath = currentPath.getParent()) {
            String string = currentPath.getName();
            String string2 = "_delta_log";
            if (!(string == null ? string2 != null : !string.equals(string2))) break;
            String string3 = currentPath.getName();
            String string4 = "_samples";
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break;
            Path deltaLogPath = this.safeConcatPaths(currentPath, "_delta_log");
            if (!BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> fs.exists(deltaLogPath)).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) continue;
            return Option$.MODULE$.apply((Object)currentPath);
        }
        return None$.MODULE$;
    }

    private Option<Path> findDeltaTableRootThrowOnError(FileSystem fs, Path path) {
        ObjectRef firstError = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef currentPath = ObjectRef.create((Object)path);
        while ((Path)currentPath.elem != null) {
            String string = ((Path)currentPath.elem).getName();
            String string2 = "_delta_log";
            if (!(string == null ? string2 != null : !string.equals(string2))) break;
            String string3 = ((Path)currentPath.elem).getName();
            String string4 = "_samples";
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break;
            Path deltaLogPath = this.safeConcatPaths((Path)currentPath.elem, "_delta_log");
            try {
                if (fs.exists(deltaLogPath)) {
                    return Option$.MODULE$.apply((Object)((Path)currentPath.elem));
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    Path path2 = (Path)currentPath.elem;
                    Path path3 = path;
                    if (!(path2 != null ? !path2.equals(path3) : path3 != null)) {
                        firstError.elem = new Some((Object)ex);
                    }
                }
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    this.logThrottler().throttledWithSkippedLogMessage((Function1<MessageWithContext, BoxedUnit>)(Function1 & Serializable)skippedStr -> {
                        DeltaTableUtils$.MODULE$.logWarning(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> DeltaTableUtils$.MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Access error while exploring path hierarchy for a delta log."}))).log((Seq<MDC>)Nil$.MODULE$).$plus(DeltaTableUtils$.MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"original path=", ", "}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), path$1)}))).$plus(DeltaTableUtils$.MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"path with error=", "."}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH2(), (Path)currentPath$1.elem)}))).$plus(skippedStr)), throwable2);
                        return BoxedUnit.UNIT;
                    });
                    return DeltaTableUtils$.noneOrError$1(firstError);
                }
                throw throwable;
            }
            currentPath.elem = ((Path)currentPath.elem).getParent();
        }
        return DeltaTableUtils$.noneOrError$1(firstError);
    }

    private LogThrottler logThrottler() {
        return logThrottler;
    }

    public boolean isHiddenDirectory(Seq<String> partitionColumnNames, String pathName, boolean shouldIcebergMetadataDirBeHidden) {
        return shouldIcebergMetadataDirBeHidden && pathName.equals("metadata") || (pathName.startsWith(".") || pathName.startsWith("_")) && !pathName.startsWith("_delta_index") && !pathName.startsWith("_change_data") && !partitionColumnNames.exists((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)pathName.startsWith(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(c), "="))));
    }

    public boolean isHiddenDirectory$default$3() {
        return true;
    }

    public boolean isPredicatePartitionColumnsOnly(Expression condition, Seq<String> partitionColumns, SparkSession spark) {
        Function2 nameEquality = spark.sessionState().analyzer().resolver();
        return condition.references().forall((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)partitionColumns.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.$anonfun$isPredicatePartitionColumnsOnly$2(nameEquality$1, r, x$3)))));
    }

    public Tuple2<Seq<Expression>, Seq<Expression>> splitMetadataAndDataPredicates(Expression condition2, Seq<String> partitionColumns, SparkSession spark) {
        Tuple2 tuple2 = this.splitConjunctivePredicates(condition2).partition((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.MODULE$.isPredicateMetadataOnly(x$4, (Seq<String>)partitionColumns, spark)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq metadataPredicates = (Seq)tuple2._1();
        Seq dataPredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metadataPredicates, (Object)dataPredicates);
        Seq metadataPredicates2 = (Seq)tuple22._1();
        Seq dataPredicates2 = (Seq)tuple22._2();
        Seq extraMetadataPredicates = dataPredicates2.nonEmpty() ? (Seq)this.extractMetadataPredicates((Expression)dataPredicates2.reduce((Function2)And$.MODULE$), partitionColumns, spark).map((Function1 & Serializable)condition -> MODULE$.splitConjunctivePredicates((Expression)condition)).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty()) : (Seq)package$.MODULE$.Seq().empty();
        return new Tuple2(metadataPredicates2.$plus$plus((IterableOnce)extraMetadataPredicates), (Object)dataPredicates2);
    }

    private Option<Expression> extractMetadataPredicates(Expression condition, Seq<String> partitionColumns, SparkSession spark) {
        Expression expression = condition;
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            Option<Expression> lhs2 = this.extractMetadataPredicates(left, partitionColumns, spark);
            Option<Expression> rhs = this.extractMetadataPredicates(right, partitionColumns, spark);
            return ((IterableOnceOps)Option$.MODULE$.option2Iterable(lhs2).toSeq().$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(rhs).toSeq())).reduceOption((Function2)And$.MODULE$);
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.extractMetadataPredicates(left, partitionColumns, spark).flatMap((Function1 & Serializable)lhs -> MODULE$.extractMetadataPredicates(right, partitionColumns, spark).map((Function1 & Serializable)rhs -> new Or(lhs, rhs)));
        }
        if (this.isPredicatePartitionColumnsOnly(expression, partitionColumns, spark)) {
            return new Some((Object)expression);
        }
        return None$.MODULE$;
    }

    public boolean containsSubquery(Expression condition) {
        return SubqueryExpression$.MODULE$.hasSubquery(condition);
    }

    public boolean isPredicateMetadataOnly(Expression condition, Seq<String> partitionColumns, SparkSession spark) {
        return this.isPredicatePartitionColumnsOnly(condition, partitionColumns, spark) && !this.containsSubquery(condition);
    }

    public LogicalPlan replaceFileIndex(LogicalPlan target, FileIndex fileIndex) {
        return (LogicalPlan)target.transform((PartialFunction)new Serializable(fileIndex){
            private static final long serialVersionUID = 0L;
            private final FileIndex fileIndex$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BaseRelation hfsr;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)A1)).isEmpty() && (hfsr = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)hfsr;
                    return (B1)logicalRelation.copy((BaseRelation)hadoopFsRelation.copy(this.fileIndex$1, hadoopFsRelation.copy$default$2(), hadoopFsRelation.copy$default$3(), hadoopFsRelation.copy$default$4(), hadoopFsRelation.copy$default$5(), hadoopFsRelation.copy$default$6(), hadoopFsRelation.sparkSession()), logicalRelation.copy$default$2(), logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                BaseRelation hfsr;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan)).isEmpty() && (hfsr = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation;
            }
            {
                this.fileIndex$1 = fileIndex$1;
            }
        });
    }

    public LogicalPlan dropColumns(SparkSession spark, LogicalPlan target, Seq<String> columnsToDrop) {
        Function2 resolver = spark.sessionState().analyzer().resolver();
        boolean hasChar = target.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.$anonfun$dropColumns$1(x0$1)));
        return (LogicalPlan)target.transformUp((PartialFunction)new Serializable(columnsToDrop, resolver, hasChar){
            private static final long serialVersionUID = 0L;
            private final Seq columnsToDrop$1;
            private final Function2 resolver$1;
            private final boolean hasChar$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BaseRelation hfsr;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)A1)).isEmpty() && (hfsr = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation) {
                    StructType prunedSchema;
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)hfsr;
                    Seq prunedOutput = (Seq)logicalRelation.output().filterNot((Function1 & Serializable)col -> BoxesRunTime.boxToBoolean((boolean)anonfun.dropColumns.4.$anonfun$applyOrElse$1(this, col)));
                    StructType x$1 = prunedSchema = StructType$.MODULE$.apply((Seq)prunedOutput.map((Function1 & Serializable)attr -> new StructField(attr.name(), attr.dataType(), attr.nullable(), attr.metadata())));
                    FileIndex x$2 = hadoopFsRelation.copy$default$1();
                    StructType x$3 = hadoopFsRelation.copy$default$2();
                    Option x$4 = hadoopFsRelation.copy$default$4();
                    FileFormat x$5 = hadoopFsRelation.copy$default$5();
                    Map x$6 = hadoopFsRelation.copy$default$6();
                    SparkSession x$7 = hadoopFsRelation.sparkSession();
                    HadoopFsRelation newBaseRelation = hadoopFsRelation.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7);
                    return (B1)logicalRelation.copy((BaseRelation)newBaseRelation, prunedOutput, logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                }
                if (A1 instanceof Project) {
                    Project project = (Project)A1;
                    Seq projectList = project.projectList();
                    LogicalPlan child = project.child();
                    if (this.hasChar$1) {
                        Seq newProjectList = (Seq)projectList.filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)anonfun.dropColumns.4.$anonfun$applyOrElse$4(child, e)));
                        return (B1)project.copy(newProjectList, project.copy$default$2());
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                BaseRelation hfsr;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan)).isEmpty() && (hfsr = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation) {
                    return true;
                }
                return logicalPlan instanceof Project && this.hasChar$1;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2(anonfun.dropColumns.4 $this, AttributeReference col$1, String x$6) {
                return BoxesRunTime.unboxToBoolean((Object)$this.resolver$1.apply((Object)x$6, (Object)col$1.name()));
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(anonfun.dropColumns.4 $this, AttributeReference col) {
                return $this.columnsToDrop$1.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anonfun.dropColumns.4.$anonfun$applyOrElse$2($this, col, x$6)));
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$4(LogicalPlan child$1, NamedExpression e) {
                return ((Expression)e).references().subsetOf(child$1.outputSet());
            }
            {
                this.columnsToDrop$1 = columnsToDrop$1;
                this.resolver$1 = resolver$1;
                this.hasChar$1 = hasChar$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.delta.DeltaTableUtils$$anonfun$dropColumns$4 org.apache.spark.sql.catalyst.expressions.AttributeReference ), $anonfun$applyOrElse$2$adapted(org.apache.spark.sql.delta.DeltaTableUtils$$anonfun$dropColumns$4 org.apache.spark.sql.catalyst.expressions.AttributeReference java.lang.String ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.expressions.AttributeReference ), $anonfun$applyOrElse$4$adapted(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.catalyst.expressions.NamedExpression )}, serializedLambda);
            }
        });
    }

    public Column getFileMetadataColumn(Dataset<Row> df) {
        return df.metadataColumn(FileFormat$.MODULE$.METADATA_NAME());
    }

    public LogicalPlan replaceFileFormat(LogicalPlan target, FileFormat updatedFileFormat) {
        return (LogicalPlan)target.transform((PartialFunction)new Serializable(updatedFileFormat){
            private static final long serialVersionUID = 0L;
            private final FileFormat updatedFileFormat$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BaseRelation hfsr;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)A1)).isEmpty() && (hfsr = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)hfsr;
                    FileFormat x$1 = this.updatedFileFormat$1;
                    FileIndex x$2 = hadoopFsRelation.copy$default$1();
                    StructType x$3 = hadoopFsRelation.copy$default$2();
                    StructType x$4 = hadoopFsRelation.copy$default$3();
                    Option x$5 = hadoopFsRelation.copy$default$4();
                    Map x$6 = hadoopFsRelation.copy$default$6();
                    SparkSession x$7 = hadoopFsRelation.sparkSession();
                    return (B1)logicalRelation.copy((BaseRelation)hadoopFsRelation.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7), logicalRelation.copy$default$2(), logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                BaseRelation hfsr;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan)).isEmpty() && (hfsr = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation;
            }
            {
                this.updatedFileFormat$1 = updatedFileFormat$1;
            }
        });
    }

    public Tuple2<String, Option<DeltaTimeTravelSpec>> extractIfPathContainsTimeTravel(SparkSession session, String path, Map<String, String> options) {
        SQLConf conf = session.sessionState().conf();
        if (!DeltaTimeTravelSpec$.MODULE$.isApplicable(conf, path)) {
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)None$.MODULE$);
        }
        Path maybePath = new Path(path);
        FileSystem fs = maybePath.getFileSystem(session.sessionState().newHadoopConfWithOptions(options));
        if (fs.exists(maybePath)) {
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)None$.MODULE$);
        }
        Tuple2<DeltaTimeTravelSpec, String> tuple2 = DeltaTimeTravelSpec$.MODULE$.resolvePath(conf, path);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DeltaTimeTravelSpec tt = (DeltaTimeTravelSpec)tuple2._1();
        String realPath = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tt, (Object)realPath);
        DeltaTimeTravelSpec tt2 = (DeltaTimeTravelSpec)tuple22._1();
        String realPath2 = (String)tuple22._2();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)realPath2), (Object)new Some((Object)tt2));
    }

    public Tuple2<Object, String> resolveTimeTravelVersion(SQLConf conf, DeltaLog deltaLog, DeltaTimeTravelSpec tt, boolean canReturnLastCommit) {
        if (tt.version().isDefined()) {
            long userVersion = BoxesRunTime.unboxToLong((Object)tt.version().get());
            deltaLog.history().checkVersionExists(userVersion, deltaLog.history().checkVersionExists$default$2(), deltaLog.history().checkVersionExists$default$3());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)userVersion)), (Object)"version");
        }
        Timestamp timestamp = tt.getTimestamp(conf);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)deltaLog.history().getActiveCommitAtTime(timestamp, canReturnLastCommit, deltaLog.history().getActiveCommitAtTime$default$3(), deltaLog.history().getActiveCommitAtTime$default$4()).version())), (Object)"timestamp");
    }

    public boolean resolveTimeTravelVersion$default$4() {
        return false;
    }

    public IdentityTransform parseColToTransform(String col) {
        return new IdentityTransform((NamedReference)new FieldReference((Seq)new .colon.colon((Object)col, (List)Nil$.MODULE$)));
    }

    public ClusterByTransform parseColsToClusterByTransform(Seq<String> cols) {
        return new ClusterByTransform((Seq<NamedReference>)((Seq)cols.map((Function1 & Serializable)x$8 -> FieldReference$.MODULE$.apply(x$8))));
    }

    public <T> T withActiveSession(SparkSession spark, Function0<T> body) {
        return (T)spark.withActive(body);
    }

    public Path safeConcatPaths(Path basePath, String relativeChildPath) {
        boolean useWorkaround = SparkSession$.MODULE$.getActiveSession().map((Function1 & Serializable)x$9 -> x$9.sessionState().conf()).exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.$anonfun$safeConcatPaths$2(x$10)));
        if (useWorkaround) {
            return Path.mergePaths((Path)basePath, (Path)new Path(new StringBuilder(1).append("/").append(relativeChildPath).toString()));
        }
        if (basePath.toUri().getPath().isEmpty()) {
            return new Path(basePath, new StringBuilder(1).append("/").append(relativeChildPath).toString());
        }
        return new Path(basePath, relativeChildPath);
    }

    public Seq<String> SPARK_INTERNAL_METADATA_KEYS() {
        return SPARK_INTERNAL_METADATA_KEYS;
    }

    public StructType removeSparkInternalMetadata(SparkSession spark, StructType schema) {
        if (BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_SCHEMA_REMOVE_SPARK_INTERNAL_METADATA()))) {
            BooleanRef updated = BooleanRef.create((boolean)false);
            Seq updatedSchema = (Seq)schema.map((Function1 & Serializable)field -> {
                if (MODULE$.SPARK_INTERNAL_METADATA_KEYS().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.$anonfun$removeSparkInternalMetadata$2(field, key)))) {
                    updated$1.elem = true;
                    MetadataBuilder newMetadata = new MetadataBuilder().withMetadata(field.metadata());
                    MODULE$.SPARK_INTERNAL_METADATA_KEYS().foreach((Function1 & Serializable)key -> newMetadata.remove(key));
                    Metadata x$1 = newMetadata.build();
                    String x$2 = field.copy$default$1();
                    DataType x$3 = field.copy$default$2();
                    boolean x$4 = field.copy$default$3();
                    return field.copy(x$2, x$3, x$4, x$1);
                }
                return field;
            });
            if (updated.elem) {
                return StructType$.MODULE$.apply(updatedSchema);
            }
            return schema;
        }
        return schema;
    }

    public StructType removeInternalWriterMetadata(SparkSession spark, StructType schema) {
        return ColumnWithDefaultExprUtils$.MODULE$.removeDefaultExpressions(this.removeSparkInternalMetadata(spark, schema), ColumnWithDefaultExprUtils$.MODULE$.removeDefaultExpressions$default$2(), ColumnWithDefaultExprUtils$.MODULE$.removeDefaultExpressions$default$3());
    }

    private static final boolean databaseExists$1(TableIdentifier ident$1, SessionCatalog catalog$2) {
        return ident$1.database().forall((Function1 & Serializable)db -> BoxesRunTime.boxToBoolean((boolean)catalog$2.databaseExists(db)));
    }

    private static final Option noneOrError$1(ObjectRef firstError$1) {
        Option option = (Option)firstError$1.elem;
        if (option instanceof Some) {
            Some some = (Some)option;
            Throwable ex = (Throwable)some.value();
            throw ex;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$isPredicatePartitionColumnsOnly$2(Function2 nameEquality$1, Attribute r$1, String x$3) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)r$1.name(), (Object)x$3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$dropColumns$2(Expression x0$1) {
        Expression expression = x0$1;
        if (!(expression instanceof StaticInvoke)) return false;
        StaticInvoke staticInvoke = (StaticInvoke)expression;
        Class clazz = staticInvoke.staticObject();
        Class<CharVarcharCodegenUtils> clazz2 = CharVarcharCodegenUtils.class;
        if (clazz == null) {
            if (clazz2 != null) {
                return false;
            }
        } else if (!clazz.equals(clazz2)) return false;
        String string = staticInvoke.functionName();
        String string2 = "readSidePadding";
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    private static final boolean hasCharPadding$1(Expression e) {
        return e.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.$anonfun$dropColumns$2(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$dropColumns$3(NamedExpression x0$2) {
        NamedExpression namedExpression = x0$2;
        if (namedExpression instanceof Alias) {
            Alias alias = (Alias)namedExpression;
            return DeltaTableUtils$.hasCharPadding$1(alias.child()) && alias.references().size() == 1;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$dropColumns$1(LogicalPlan x0$1) {
        LogicalPlan logicalPlan = x0$1;
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Seq projectList = project.projectList();
            return projectList.exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.$anonfun$dropColumns$3(x0$2)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$safeConcatPaths$2(SQLConf x$10) {
        return BoxesRunTime.unboxToBoolean((Object)x$10.getConf(DeltaSQLConf$.MODULE$.DELTA_WORK_AROUND_COLONS_IN_HADOOP_PATHS()));
    }

    public static final /* synthetic */ boolean $anonfun$removeSparkInternalMetadata$2(StructField field$1, String key) {
        return field$1.metadata().contains(key);
    }

    private DeltaTableUtils$() {
    }
}

