/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.MaterializedRowCommitVersion$;
import org.apache.spark.sql.delta.RowCommitVersion$MetadataStructField$;
import org.apache.spark.sql.delta.RowTracking$;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.Option;

public final class RowCommitVersion$ {
    public static final RowCommitVersion$ MODULE$ = new RowCommitVersion$();
    private static final String METADATA_STRUCT_FIELD_NAME = "row_commit_version";
    private static final String QUALIFIED_COLUMN_NAME = new StringBuilder(1).append(FileFormat$.MODULE$.METADATA_NAME()).append(".").append(MODULE$.METADATA_STRUCT_FIELD_NAME()).toString();

    public String METADATA_STRUCT_FIELD_NAME() {
        return METADATA_STRUCT_FIELD_NAME;
    }

    public String QUALIFIED_COLUMN_NAME() {
        return QUALIFIED_COLUMN_NAME;
    }

    public Option<StructField> createMetadataStructField(Protocol protocol, Metadata metadata, boolean nullable) {
        return MaterializedRowCommitVersion$.MODULE$.getMaterializedColumnName(protocol, metadata).map((Function1 & Serializable)x$1 -> RowCommitVersion$MetadataStructField$.MODULE$.apply((String)x$1, nullable));
    }

    public boolean createMetadataStructField$default$3() {
        return false;
    }

    public Dataset<Row> preserveRowCommitVersions(Dataset<Row> dataFrame, SnapshotDescriptor snapshot) {
        if (!RowTracking$.MODULE$.isEnabled(snapshot.protocol(), snapshot.metadata())) {
            return dataFrame;
        }
        String materializedColumnName = MaterializedRowCommitVersion$.MODULE$.getMaterializedColumnNameOrThrow(snapshot.protocol(), snapshot.metadata(), snapshot.deltaLog().tableId());
        Column rowCommitVersionColumn = DeltaTableUtils$.MODULE$.getFileMetadataColumn(dataFrame).getField(this.METADATA_STRUCT_FIELD_NAME());
        return this.preserveRowCommitVersionsUnsafe(dataFrame, materializedColumnName, rowCommitVersionColumn);
    }

    public Dataset<Row> preserveRowCommitVersionsUnsafe(Dataset<Row> dataFrame, String materializedColumnName, Column rowCommitVersionColumn) {
        return dataFrame.withColumn(materializedColumnName, rowCommitVersionColumn).withMetadata(materializedColumnName, RowCommitVersion$MetadataStructField$.MODULE$.metadata(materializedColumnName));
    }

    public org.apache.spark.sql.types.Metadata columnMetadata(String materializedColumnName) {
        return RowCommitVersion$MetadataStructField$.MODULE$.metadata(materializedColumnName);
    }

    private RowCommitVersion$() {
    }
}

