/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CheckpointOnlyAction;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.LogReplay;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]e\u0001B\u001c9\u0001\u0015C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005+\")\u0001\f\u0001C\u00013\"9Q\f\u0001a\u0001\n\u0013q\u0006b\u00022\u0001\u0001\u0004%Ia\u0019\u0005\u0007S\u0002\u0001\u000b\u0015B0\t\u000f)\u0004\u0001\u0019!C\u0005W\"9A\u000e\u0001a\u0001\n\u0013i\u0007BB8\u0001A\u0003&\u0011\u000bC\u0004q\u0001\u0001\u0007I\u0011B9\t\u000fU\u0004\u0001\u0019!C\u0005m\"1\u0001\u0010\u0001Q!\nIDq!\u001f\u0001C\u0002\u0013%!\u0010C\u0004\u0002$\u0001\u0001\u000b\u0011B>\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005\u001d\u0002\u0002CA\u001b\u0001\u0001\u0006I!!\u000b\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002\u0002\u0003B%\u0001\u0001\u0006I!a\u000f\t\u0013\t-\u0003A1A\u0005\n\t5\u0003\u0002\u0003B,\u0001\u0001\u0006IAa\u0014\t\u000f\te\u0003\u0001\"\u0011\u0003\\!9!Q\u000e\u0001\u0005\n\t=\u0004\u0002\u0003B?\u0001\u0011\u0005!Ha \t\u0011\t\r\u0005\u0001\"\u0001;\u0005\u000bCqA!#\u0001\t\u0003\u0012Y\t\u0003\u0005\u0003\u000e\u0002!\tA\u000fBH\u000f\u001d\t\t\u0005\u000fE\u0001\u0003\u00072aa\u000e\u001d\t\u0002\u0005\u0015\u0003B\u0002-\u001d\t\u0003\t9E\u0002\u0004\u0002Jq\u0011\u00151\n\u0005\u000b\u0003Kr\"Q3A\u0005\u0002\u0005\u001d\u0004BCA==\tE\t\u0015!\u0003\u0002j!Q\u00111\u0010\u0010\u0003\u0016\u0004%\t!! \t\u0015\u0005\u0005eD!E!\u0002\u0013\ty\b\u0003\u0004Y=\u0011\u0005\u00111\u0011\u0005\n\u0003\u001bs\u0012\u0011!C\u0001\u0003\u001fC\u0011\"!&\u001f#\u0003%\t!a&\t\u0013\u00055f$%A\u0005\u0002\u0005=\u0006\"CAZ=\u0005\u0005I\u0011IA[\u0011%\t\tMHA\u0001\n\u0003\t\u0019\rC\u0005\u0002Lz\t\t\u0011\"\u0001\u0002N\"I\u0011q\u001b\u0010\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\n\u0003Gt\u0012\u0011!C\u0001\u0003KD\u0011\"a<\u001f\u0003\u0003%\t%!=\t\u0013\u0005Uh$!A\u0005B\u0005]\b\"CA}=\u0005\u0005I\u0011IA~\u0011%\tiPHA\u0001\n\u0003\nypB\u0005\u0003\u0004q\t\t\u0011#\u0001\u0003\u0006\u0019I\u0011\u0011\n\u000f\u0002\u0002#\u0005!q\u0001\u0005\u00071F\"\tAa\b\t\u0013\u0005e\u0018'!A\u0005F\u0005m\b\"\u0003B\u0011c\u0005\u0005I\u0011\u0011B\u0012\u0011%\u0011I#MA\u0001\n\u0003\u0013Y\u0003C\u0005\u0003:E\n\t\u0011\"\u0003\u0003<\t\t\u0012J\\'f[>\u0014\u0018\u0010T8h%\u0016\u0004H.Y=\u000b\u0005eR\u0014aB1di&|gn\u001d\u0006\u0003wq\nQ\u0001Z3mi\u0006T!!\u0010 \u0002\u0007M\fHN\u0003\u0002@\u0001\u0006)1\u000f]1sW*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001$M!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u0019\te.\u001f*fMB\u0011QJT\u0007\u0002q%\u0011q\n\u000f\u0002\n\u0019><'+\u001a9mCf\f\u0011$\\5o\r&dWMU3uK:$\u0018n\u001c8US6,7\u000f^1naB\u0011qIU\u0005\u0003'\"\u0013A\u0001T8oO\u0006\u0019S.\u001b8TKR$&/\u00198tC\u000e$\u0018n\u001c8SKR,g\u000e^5p]RKW.Z:uC6\u0004\bcA$W#&\u0011q\u000b\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0002\rqJg.\u001b;?)\rQ6\f\u0018\t\u0003\u001b\u0002AQ\u0001U\u0002A\u0002ECQ\u0001V\u0002A\u0002U\u000bacY;se\u0016tG\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\\\u000b\u0002?B\u0011Q\nY\u0005\u0003Cb\u0012\u0001\u0002\u0015:pi>\u001cw\u000e\\\u0001\u001bGV\u0014(/\u001a8u!J|Go\\2pYZ+'o]5p]~#S-\u001d\u000b\u0003I\u001e\u0004\"aR3\n\u0005\u0019D%\u0001B+oSRDq\u0001[\u0003\u0002\u0002\u0003\u0007q,A\u0002yIE\nqcY;se\u0016tG\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c\u0011\u0002\u001d\r,(O]3oiZ+'o]5p]V\t\u0011+\u0001\ndkJ\u0014XM\u001c;WKJ\u001c\u0018n\u001c8`I\u0015\fHC\u00013o\u0011\u001dA\u0007\"!AA\u0002E\u000bqbY;se\u0016tGOV3sg&|g\u000eI\u0001\u0010GV\u0014(/\u001a8u\u001b\u0016$\u0018\rR1uCV\t!\u000f\u0005\u0002Ng&\u0011A\u000f\u000f\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006\u00192-\u001e:sK:$X*\u001a;b\t\u0006$\u0018m\u0018\u0013fcR\u0011Am\u001e\u0005\bQ.\t\t\u00111\u0001s\u0003A\u0019WO\u001d:f]RlU\r^1ECR\f\u0007%\u0001\u0007ue\u0006t7/Y2uS>t7/F\u0001|!\u001da\u00181AA\u0004\u0003;i\u0011! \u0006\u0003}~\fq!\\;uC\ndWMC\u0002\u0002\u0002!\u000b!bY8mY\u0016\u001cG/[8o\u0013\r\t)! \u0002\b\u0011\u0006\u001c\b.T1q!\u0011\tI!a\u0006\u000f\t\u0005-\u00111\u0003\t\u0004\u0003\u001bAUBAA\b\u0015\r\t\t\u0002R\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U\u0001*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tYB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003+A\u0005cA'\u0002 %\u0019\u0011\u0011\u0005\u001d\u0003\u001dM+G\u000f\u0016:b]N\f7\r^5p]\u0006iAO]1og\u0006\u001cG/[8og\u0002\nq\u0002Z8nC&tW*\u001a;bI\u0006$\u0018m]\u000b\u0003\u0003S\u0001r\u0001`A\u0016\u0003\u000f\ty#C\u0002\u0002.u\u00141!T1q!\ri\u0015\u0011G\u0005\u0004\u0003gA$A\u0004#p[\u0006Lg.T3uC\u0012\fG/Y\u0001\u0011I>l\u0017-\u001b8NKR\fG-\u0019;bg\u0002\n1\"Y2uSZ,g)\u001b7fgV\u0011\u00111\b\t\by\u0006\r\u0011Q\bB\"!\r\tyD\b\b\u0003\u001bn\t\u0011#\u00138NK6|'/\u001f'pOJ+\u0007\u000f\\1z!\tiEd\u0005\u0002\u001d\rR\u0011\u00111\t\u0002\u0016+:L\u0017/^3GS2,\u0017i\u0019;j_:$V\u000f\u001d7f'\u0019qb)!\u0014\u0002TA\u0019q)a\u0014\n\u0007\u0005E\u0003JA\u0004Qe>$Wo\u0019;\u0011\t\u0005U\u0013q\f\b\u0005\u0003/\nYF\u0004\u0003\u0002\u000e\u0005e\u0013\"A%\n\u0007\u0005u\u0003*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00141\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003;B\u0015a\u00024jY\u0016,&+S\u000b\u0003\u0003S\u0002B!a\u001b\u0002v5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0002oKRT!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niGA\u0002V%&\u000b\u0001BZ5mKV\u0013\u0016\nI\u0001\u0012I\u0016dW\r^5p]Z+7\r^8s+JKUCAA@!\u00119e+a\u0002\u0002%\u0011,G.\u001a;j_:4Vm\u0019;peV\u0013\u0016\n\t\u000b\u0007\u0003\u000b\u000bI)a#\u0011\u0007\u0005\u001de$D\u0001\u001d\u0011\u001d\t)g\ta\u0001\u0003SBq!a\u001f$\u0001\u0004\ty(\u0001\u0003d_BLHCBAC\u0003#\u000b\u0019\nC\u0005\u0002f\u0011\u0002\n\u00111\u0001\u0002j!I\u00111\u0010\u0013\u0011\u0002\u0003\u0007\u0011qP\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIJ\u000b\u0003\u0002j\u0005m5FAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\u0006*\u0001\u0006b]:|G/\u0019;j_:LA!a+\u0002\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0017\u0016\u0005\u0003\u007f\nY*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003o\u0003B!!/\u0002@6\u0011\u00111\u0018\u0006\u0005\u0003{\u000b\t(\u0001\u0003mC:<\u0017\u0002BA\r\u0003w\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!2\u0011\u0007\u001d\u000b9-C\u0002\u0002J\"\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a4\u0002VB\u0019q)!5\n\u0007\u0005M\u0007JA\u0002B]fD\u0001\u0002[\u0015\u0002\u0002\u0003\u0007\u0011QY\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001c\t\u0007\u0003;\fy.a4\u000e\u0003}L1!!9\u0000\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d\u0018Q\u001e\t\u0004\u000f\u0006%\u0018bAAv\u0011\n9!i\\8mK\u0006t\u0007\u0002\u00035,\u0003\u0003\u0005\r!a4\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003o\u000b\u0019\u0010\u0003\u0005iY\u0005\u0005\t\u0019AAc\u0003!A\u0017m\u001d5D_\u0012,GCAAc\u0003!!xn\u0015;sS:<GCAA\\\u0003\u0019)\u0017/^1mgR!\u0011q\u001dB\u0001\u0011!Aw&!AA\u0002\u0005=\u0017!F+oSF,XMR5mK\u0006\u001bG/[8o)V\u0004H.\u001a\t\u0004\u0003\u000f\u000b4#B\u0019\u0003\n\tU\u0001C\u0003B\u0006\u0005#\tI'a \u0002\u00066\u0011!Q\u0002\u0006\u0004\u0005\u001fA\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005'\u0011iAA\tBEN$(/Y2u\rVt7\r^5p]J\u0002BAa\u0006\u0003\u001e5\u0011!\u0011\u0004\u0006\u0005\u00057\t\t(\u0001\u0002j_&!\u0011\u0011\rB\r)\t\u0011)!A\u0003baBd\u0017\u0010\u0006\u0004\u0002\u0006\n\u0015\"q\u0005\u0005\b\u0003K\"\u0004\u0019AA5\u0011\u001d\tY\b\u000ea\u0001\u0003\u007f\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003.\tU\u0002\u0003B$W\u0005_\u0001ra\u0012B\u0019\u0003S\ny(C\u0002\u00034!\u0013a\u0001V;qY\u0016\u0014\u0004\"\u0003B\u001ck\u0005\u0005\t\u0019AAC\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005{\u0001B!!/\u0003@%!!\u0011IA^\u0005\u0019y%M[3diB\u0019QJ!\u0012\n\u0007\t\u001d\u0003HA\u0004BI\u00124\u0015\u000e\\3\u0002\u0019\u0005\u001cG/\u001b<f\r&dWm\u001d\u0011\u0002\u0015Q|WNY:u_:,7/\u0006\u0002\u0003PA9A0a\u0001\u0002>\tE\u0003cA'\u0003T%\u0019!Q\u000b\u001d\u0003\u0015I+Wn\u001c<f\r&dW-A\u0006u_6\u00147\u000f^8oKN\u0004\u0013AB1qa\u0016tG\rF\u0003e\u0005;\u0012\t\u0007\u0003\u0004\u0003`U\u0001\r!U\u0001\bm\u0016\u00148/[8o\u0011\u0019IT\u00031\u0001\u0003dA1\u0011Q\u000bB3\u0005OJA!!9\u0002dA\u0019QJ!\u001b\n\u0007\t-\u0004H\u0001\u0004BGRLwN\\\u0001\u000eO\u0016$Hk\\7cgR|g.Z:\u0016\u0005\tE\u0004CBA+\u0005g\u00129(\u0003\u0003\u0003v\u0005\r$\u0001C%uKJ\f'\r\\3\u0011\u00075\u0013I(C\u0002\u0003|a\u0012!BR5mK\u0006\u001bG/[8o\u0003=9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cXC\u0001BA!\u0019\t)Fa\u001d\u0002\u001e\u0005\u0011r-\u001a;E_6\f\u0017N\\'fi\u0006$\u0017\r^1t+\t\u00119\t\u0005\u0004\u0002V\tM\u0014qF\u0001\u000bG\",7m\u001b9pS:$XC\u0001B2\u0003!\tG\u000e\u001c$jY\u0016\u001cXC\u0001BI!\u0019\t)Fa%\u0003D%!!QSA2\u0005\r\u0019V-\u001d")
public class InMemoryLogReplay
implements LogReplay {
    private final long minFileRetentionTimestamp;
    private final Option<Object> minSetTransactionRetentionTimestamp;
    private Protocol currentProtocolVersion;
    private long currentVersion;
    private Metadata currentMetaData;
    private final HashMap<String, SetTransaction> transactions;
    private final Map<String, DomainMetadata> domainMetadatas;
    private final HashMap<UniqueFileActionTuple, AddFile> activeFiles;
    private final HashMap<UniqueFileActionTuple, RemoveFile> tombstones;

    private Protocol currentProtocolVersion() {
        return this.currentProtocolVersion;
    }

    private void currentProtocolVersion_$eq(Protocol x$1) {
        this.currentProtocolVersion = x$1;
    }

    private long currentVersion() {
        return this.currentVersion;
    }

    private void currentVersion_$eq(long x$1) {
        this.currentVersion = x$1;
    }

    private Metadata currentMetaData() {
        return this.currentMetaData;
    }

    private void currentMetaData_$eq(Metadata x$1) {
        this.currentMetaData = x$1;
    }

    private HashMap<String, SetTransaction> transactions() {
        return this.transactions;
    }

    private Map<String, DomainMetadata> domainMetadatas() {
        return this.domainMetadatas;
    }

    private HashMap<UniqueFileActionTuple, AddFile> activeFiles() {
        return this.activeFiles;
    }

    private HashMap<UniqueFileActionTuple, RemoveFile> tombstones() {
        return this.tombstones;
    }

    @Override
    public void append(long version, Iterator<Action> actions) {
        Predef$.MODULE$.assert(this.currentVersion() == -1L || version == this.currentVersion() + 1L, (Function0 & Serializable)() -> new StringBuilder(46).append("Attempted to replay version ").append(version).append(", but state is at ").append(this.currentVersion()).toString());
        this.currentVersion_$eq(version);
        actions.foreach((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            DomainMetadata domainMetadata = null;
            Action action = x0$1;
            if (action instanceof SetTransaction) {
                SetTransaction setTransaction = (SetTransaction)action;
                this.transactions().update((Object)setTransaction.appId(), (Object)setTransaction);
                return BoxedUnit.UNIT;
            }
            if (action instanceof DomainMetadata) {
                bl = true;
                domainMetadata = (DomainMetadata)action;
                if (domainMetadata.removed()) {
                    return this.domainMetadatas().remove((Object)domainMetadata.domain());
                }
            }
            if (bl && !domainMetadata.removed()) {
                this.domainMetadatas().update((Object)domainMetadata.domain(), (Object)domainMetadata);
                return BoxedUnit.UNIT;
            }
            if (action instanceof CheckpointOnlyAction) {
                return BoxedUnit.UNIT;
            }
            if (action instanceof Metadata) {
                Metadata metadata = (Metadata)action;
                this.currentMetaData_$eq(metadata);
                return BoxedUnit.UNIT;
            }
            if (action instanceof Protocol) {
                Protocol protocol = (Protocol)action;
                this.currentProtocolVersion_$eq(protocol);
                return BoxedUnit.UNIT;
            }
            if (action instanceof AddFile) {
                AddFile addFile = (AddFile)action;
                UniqueFileActionTuple uniquePath = new UniqueFileActionTuple(addFile.pathAsUri(), addFile.getDeletionVectorUniqueId());
                boolean x$1 = false;
                String x$2 = addFile.copy$default$1();
                scala.collection.immutable.Map<String, String> x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                String x$6 = addFile.copy$default$6();
                scala.collection.immutable.Map<String, String> x$7 = addFile.copy$default$7();
                DeletionVectorDescriptor x$8 = addFile.copy$default$8();
                Option<Object> x$9 = addFile.copy$default$9();
                Option<Object> x$10 = addFile.copy$default$10();
                Option<String> x$11 = addFile.copy$default$11();
                this.activeFiles().update((Object)uniquePath, (Object)addFile.copy(x$2, x$3, x$4, x$5, false, x$6, x$7, x$8, x$9, x$10, x$11));
                return this.tombstones().remove((Object)uniquePath);
            }
            if (action instanceof RemoveFile) {
                RemoveFile removeFile = (RemoveFile)action;
                UniqueFileActionTuple uniquePath = new UniqueFileActionTuple(removeFile.pathAsUri(), removeFile.getDeletionVectorUniqueId());
                this.activeFiles().remove((Object)uniquePath);
                boolean x$12 = false;
                String x$13 = removeFile.copy$default$1();
                Option<Object> x$14 = removeFile.copy$default$2();
                Option<Object> x$15 = removeFile.copy$default$4();
                scala.collection.immutable.Map<String, String> x$16 = removeFile.copy$default$5();
                Option<Object> x$17 = removeFile.copy$default$6();
                scala.collection.immutable.Map<String, String> x$18 = removeFile.copy$default$7();
                DeletionVectorDescriptor x$19 = removeFile.copy$default$8();
                Option<Object> x$20 = removeFile.copy$default$9();
                Option<Object> x$21 = removeFile.copy$default$10();
                String x$22 = removeFile.copy$default$11();
                this.tombstones().update((Object)uniquePath, (Object)removeFile.copy(x$13, x$14, false, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22));
                return BoxedUnit.UNIT;
            }
            if (action instanceof CommitInfo) {
                return BoxedUnit.UNIT;
            }
            if (action instanceof AddCDCFile) {
                return BoxedUnit.UNIT;
            }
            if (action == null) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)action);
        });
    }

    private Iterable<FileAction> getTombstones() {
        return (Iterable)this.tombstones().values().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InMemoryLogReplay.$anonfun$getTombstones$1(this, x$1)));
    }

    public Iterable<SetTransaction> getTransactions() {
        if (this.minSetTransactionRetentionTimestamp.isEmpty()) {
            return this.transactions().values();
        }
        return (Iterable)this.transactions().values().filter((Function1 & Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)InMemoryLogReplay.$anonfun$getTransactions$1(this, txn)));
    }

    public Iterable<DomainMetadata> getDomainMetadatas() {
        return this.domainMetadatas().values();
    }

    @Override
    public Iterator<Action> checkpoint() {
        Seq fileActions = (Seq)((IterableOnceOps)this.activeFiles().values().$plus$plus(this.getTombstones())).toSeq().sortBy((Function1 & Serializable)x$3 -> x$3.path(), (Ordering)Ordering.String$.MODULE$);
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.currentProtocolVersion())).toIterator().$plus$plus((Function0 & Serializable)() -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.currentMetaData())).toIterator()).$plus$plus((Function0 & Serializable)() -> this.getDomainMetadatas()).$plus$plus((Function0 & Serializable)() -> this.getTransactions()).$plus$plus((Function0 & Serializable)() -> fileActions.toIterator());
    }

    public Seq<AddFile> allFiles() {
        return this.activeFiles().values().toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$getTombstones$1(InMemoryLogReplay $this, RemoveFile x$1) {
        return x$1.delTimestamp() > $this.minFileRetentionTimestamp;
    }

    public static final /* synthetic */ boolean $anonfun$getTransactions$1(InMemoryLogReplay $this, SetTransaction txn) {
        return txn.lastUpdated().exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> x$2 > BoxesRunTime.unboxToLong((Object)$this.minSetTransactionRetentionTimestamp.get()));
    }

    public InMemoryLogReplay(long minFileRetentionTimestamp, Option<Object> minSetTransactionRetentionTimestamp) {
        this.minFileRetentionTimestamp = minFileRetentionTimestamp;
        this.minSetTransactionRetentionTimestamp = minSetTransactionRetentionTimestamp;
        this.currentProtocolVersion = null;
        this.currentVersion = -1L;
        this.currentMetaData = null;
        this.transactions = new HashMap();
        this.domainMetadatas = (Map)Map$.MODULE$.empty();
        this.activeFiles = new HashMap();
        this.tombstones = new HashMap();
    }

    public static final class UniqueFileActionTuple
    implements Product,
    Serializable {
        private final URI fileURI;
        private final Option<String> deletionVectorURI;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public URI fileURI() {
            return this.fileURI;
        }

        public Option<String> deletionVectorURI() {
            return this.deletionVectorURI;
        }

        public UniqueFileActionTuple copy(URI fileURI, Option<String> deletionVectorURI) {
            return new UniqueFileActionTuple(fileURI, deletionVectorURI);
        }

        public URI copy$default$1() {
            return this.fileURI();
        }

        public Option<String> copy$default$2() {
            return this.deletionVectorURI();
        }

        public String productPrefix() {
            return "UniqueFileActionTuple";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.fileURI();
                }
                case 1: {
                    return this.deletionVectorURI();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UniqueFileActionTuple;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "fileURI";
                }
                case 1: {
                    return "deletionVectorURI";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UniqueFileActionTuple)) return false;
            boolean bl = true;
            if (!bl) return false;
            UniqueFileActionTuple uniqueFileActionTuple = (UniqueFileActionTuple)x$1;
            URI uRI = this.fileURI();
            URI uRI2 = uniqueFileActionTuple.fileURI();
            if (uRI == null) {
                if (uRI2 != null) {
                    return false;
                }
            } else if (!((Object)uRI).equals(uRI2)) return false;
            Option<String> option = this.deletionVectorURI();
            Option<String> option2 = uniqueFileActionTuple.deletionVectorURI();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public UniqueFileActionTuple(URI fileURI, Option<String> deletionVectorURI) {
            this.fileURI = fileURI;
            this.deletionVectorURI = deletionVectorURI;
            Product.$init$((Product)this);
        }
    }
}

