/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.NumRecordsStats;
import org.apache.spark.sql.delta.NumRecordsStats$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.RowTracking$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DMLWithDeletionVectorsHelper$;
import org.apache.spark.sql.delta.commands.DeleteCommand$;
import org.apache.spark.sql.delta.commands.DeleteCommandMetrics;
import org.apache.spark.sql.delta.commands.DeleteMetric;
import org.apache.spark.sql.delta.commands.DeleteMetric$;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.MergeIntoCommandBase$;
import org.apache.spark.sql.delta.commands.TouchedFileWithDV;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex$;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.metric.IncrementMetric;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\teg\u0001\u0002\u0016,\u0001bB\u0001\u0002\u001a\u0001\u0003\u0016\u0004%\t!\u001a\u0005\tU\u0002\u0011\t\u0012)A\u0005M\"A1\u000e\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005w\u0001\tE\t\u0015!\u0003n\u0011!9\bA!f\u0001\n\u0003A\b\u0002C=\u0001\u0005#\u0005\u000b\u0011B\u001d\t\u0011i\u0004!Q3A\u0005\u0002mD\u0011\"a\u0002\u0001\u0005#\u0005\u000b\u0011\u0002?\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011q\u0003\u0001\u0005B\u0005e\u0001\"CA!\u0001\t\u0007I\u0011IA\"\u0011!\ti\u0005\u0001Q\u0001\n\u0005\u0015\u0003BCA(\u0001!\u0015\r\u0011\"\u0011\u0002R!9\u0011Q\u000f\u0001\u0005F\u0005]\u0004bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003s\u0003A\u0011BA^\u0011\u001d\t)\u0010\u0001C\u0001\u0003oD\u0011Ba\u0001\u0001\u0003\u0003%\tA!\u0002\t\u0013\t=\u0001!%A\u0005\u0002\tE\u0001\"\u0003B\u0014\u0001E\u0005I\u0011\u0001B\u0015\u0011%\u0011i\u0003AI\u0001\n\u0003\u0011y\u0003C\u0005\u00034\u0001\t\n\u0011\"\u0001\u00036!I!\u0011\b\u0001\u0002\u0002\u0013\u0005#1\b\u0005\n\u0005\u0017\u0002\u0011\u0011!C\u0001\u0005\u001bB\u0011B!\u0016\u0001\u0003\u0003%\tAa\u0016\t\u0013\tu\u0003!!A\u0005B\t}\u0003\"\u0003B7\u0001\u0005\u0005I\u0011\u0001B8\u0011%\u0011\u0019\bAA\u0001\n\u0003\u0012)\bC\u0005\u0003z\u0001\t\t\u0011\"\u0011\u0003|\u001d9!qP\u0016\t\u0002\t\u0005eA\u0002\u0016,\u0011\u0003\u0011\u0019\tC\u0004\u0002\n}!\tA!&\t\u000f\t]u\u0004\"\u0001\u0003\u001a\"I!QU\u0010C\u0002\u0013\u0005!q\u0015\u0005\t\u0005S{\u0002\u0015!\u0003\u0002d!I!1V\u0010C\u0002\u0013\u0005!q\u0015\u0005\t\u0005[{\u0002\u0015!\u0003\u0002d!9!qV\u0010\u0005\u0002\tE\u0006\"\u0003BL?\u0005\u0005I\u0011\u0011B[\u0011%\u0011ylHA\u0001\n\u0003\u0013\t\rC\u0005\u0003P~\t\t\u0011\"\u0003\u0003R\niA)\u001a7fi\u0016\u001cu.\\7b]\u0012T!\u0001L\u0017\u0002\u0011\r|W.\\1oINT!AL\u0018\u0002\u000b\u0011,G\u000e^1\u000b\u0005A\n\u0014aA:rY*\u0011!gM\u0001\u0006gB\f'o\u001b\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001I4iS(S1B\u0011!(Q\u0007\u0002w)\u0011A(P\u0001\bY><\u0017nY1m\u0015\tqt(A\u0003qY\u0006t7O\u0003\u0002A_\u0005A1-\u0019;bYf\u001cH/\u0003\u0002Cw\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t!\u0015*D\u0001F\u0015\t1u)A\u0004d_6l\u0017M\u001c3\u000b\u0005!{\u0013!C3yK\u000e,H/[8o\u0013\tQUIA\nMK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002M\u001b6\t1&\u0003\u0002OW\taA)\u001a7uC\u000e{W.\\1oIB\u0011A\nU\u0005\u0003#.\u0012A\u0003R3mKR,7i\\7nC:$W*\u001a;sS\u000e\u001c\bCA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&a\u0002)s_\u0012,8\r\u001e\t\u00033\u0006t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005u;\u0014A\u0002\u001fs_>$h(C\u0001V\u0013\t\u0001G+A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'\u0001D*fe&\fG.\u001b>bE2,'B\u00011U\u0003!!W\r\u001c;b\u0019><W#\u00014\u0011\u0005\u001dDW\"A\u0017\n\u0005%l#\u0001\u0003#fYR\fGj\\4\u0002\u0013\u0011,G\u000e^1M_\u001e\u0004\u0013\u0001D2bi\u0006dwn\u001a+bE2,W#A7\u0011\u0007Ms\u0007/\u0003\u0002p)\n1q\n\u001d;j_:\u0004\"!\u001d;\u000e\u0003IT!a] \u0002\u000f\r\fG/\u00197pO&\u0011QO\u001d\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.Z\u0001\u000eG\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0011\u0002\rQ\f'oZ3u+\u0005I\u0014a\u0002;be\u001e,G\u000fI\u0001\nG>tG-\u001b;j_:,\u0012\u0001 \t\u0004':l\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002}\n1\"\u001a=qe\u0016\u001c8/[8og&\u0019\u0011QA@\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0006d_:$\u0017\u000e^5p]\u0002\na\u0001P5oSRtDCCA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016A\u0011A\n\u0001\u0005\u0006I&\u0001\rA\u001a\u0005\u0006W&\u0001\r!\u001c\u0005\u0006o&\u0001\r!\u000f\u0005\u0006u&\u0001\r\u0001`\u0001\u000eS:tWM]\"iS2$'/\u001a8\u0016\u0005\u0005m\u0001#B-\u0002\u001e\u0005\u0005\u0012bAA\u0010G\n\u00191+Z91\t\u0005\r\u0012q\u0006\t\u0007\u0003K\t9#a\u000b\u000e\u0003uJ1!!\u000b>\u0005%\tV/\u001a:z!2\fg\u000e\u0005\u0003\u0002.\u0005=B\u0002\u0001\u0003\f\u0003cQ\u0011\u0011!A\u0001\u0006\u0003\t\u0019DA\u0002`IE\nB!!\u000e\u0002<A\u00191+a\u000e\n\u0007\u0005eBKA\u0004O_RD\u0017N\\4\u0011\u0007M\u000bi$C\u0002\u0002@Q\u00131!\u00118z\u0003\u0019yW\u000f\u001e9viV\u0011\u0011Q\t\t\u00063\u0006u\u0011q\t\t\u0004}\u0006%\u0013bAA&\u007f\nI\u0011\t\u001e;sS\n,H/Z\u0001\b_V$\b/\u001e;!\u0003\u001diW\r\u001e:jGN,\"!a\u0015\u0011\u0011\u0005U\u0013QLA2\u0003SrA!a\u0016\u0002ZA\u00111\fV\u0005\u0004\u00037\"\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002`\u0005\u0005$aA'ba*\u0019\u00111\f+\u0011\t\u0005U\u0013QM\u0005\u0005\u0003O\n\tG\u0001\u0004TiJLgn\u001a\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN$\u0002\r5,GO]5d\u0013\u0011\t\u0019(!\u001c\u0003\u0013M\u000bF*T3ue&\u001c\u0017a\u0001:v]R!\u0011\u0011PAB!\u0015I\u0016QDA>!\u0011\ti(a \u000e\u0003=J1!!!0\u0005\r\u0011vn\u001e\u0005\b\u0003\u000bs\u0001\u0019AAD\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\ti(!#\n\u0007\u0005-uF\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0007qKJ4wN]7EK2,G/\u001a\u000b\t\u0003#\u000bY+!,\u00020B91+a%\u0002\u0018\u0006\u0015\u0016bAAK)\n1A+\u001e9mKJ\u0002R!WA\u000f\u00033\u0003B!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0004\u0003?k\u0013aB1di&|gn]\u0005\u0005\u0003G\u000biJ\u0001\u0004BGRLwN\u001c\t\u0004\u0019\u0006\u001d\u0016bAAUW\taA)\u001a7fi\u0016lU\r\u001e:jG\"9\u0011QQ\bA\u0002\u0005\u001d\u0005\"\u00023\u0010\u0001\u00041\u0007bBAY\u001f\u0001\u0007\u00111W\u0001\u0004ibt\u0007cA4\u00026&\u0019\u0011qW\u0017\u0003+=\u0003H/[7jgRL7\r\u0016:b]N\f7\r^5p]\u0006a!/Z<sSR,g)\u001b7fgRQ\u0011QXAc\u0003\u000f\f9/a;\u0011\u000be\u000bi\"a0\u0011\t\u0005m\u0015\u0011Y\u0005\u0005\u0003\u0007\fiJ\u0001\u0006GS2,\u0017i\u0019;j_:Dq!!-\u0011\u0001\u0004\t\u0019\fC\u0004\u0002JB\u0001\r!a3\u0002\u0011\t\f7/\u001a#bi\u0006\u0004B!!4\u0002b:!\u0011qZAp\u001d\u0011\t\t.!8\u000f\t\u0005M\u00171\u001c\b\u0005\u0003+\fIND\u0002\\\u0003/L\u0011AN\u0005\u0003iUJ!AM\u001a\n\u0005A\n\u0014B\u000110\u0013\u0011\t\u0019/!:\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u000110\u0011\u0019\tI\u000f\u0005a\u0001{\u0006ya-\u001b7uKJ\u001cuN\u001c3ji&|g\u000eC\u0004\u0002nB\u0001\r!a<\u0002#9,XNR5mKN$vNU3xe&$X\rE\u0002T\u0003cL1!a=U\u0005\u0011auN\\4\u0002IMDw.\u001e7e/JLG/\u001a)feNL7\u000f^3oi\u0012+G.\u001a;j_:4Vm\u0019;peN$b!!?\u0002\u0000\n\u0005\u0001cA*\u0002|&\u0019\u0011Q +\u0003\u000f\t{w\u000e\\3b]\"1!'\u0005a\u0001\u0003\u000fCq!!-\u0012\u0001\u0004\t\u0019,\u0001\u0003d_BLHCCA\u0007\u0005\u000f\u0011IAa\u0003\u0003\u000e!9AM\u0005I\u0001\u0002\u00041\u0007bB6\u0013!\u0003\u0005\r!\u001c\u0005\boJ\u0001\n\u00111\u0001:\u0011\u001dQ(\u0003%AA\u0002q\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0014)\u001aaM!\u0006,\u0005\t]\u0001\u0003\u0002B\r\u0005Gi!Aa\u0007\u000b\t\tu!qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\tU\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005K\u0011YBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003,)\u001aQN!\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0007\u0016\u0004s\tU\u0011AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005oQ3\u0001 B\u000b\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\b\t\u0005\u0005\u007f\u0011I%\u0004\u0002\u0003B)!!1\tB#\u0003\u0011a\u0017M\\4\u000b\u0005\t\u001d\u0013\u0001\u00026bm\u0006LA!a\u001a\u0003B\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\n\t\u0004'\nE\u0013b\u0001B*)\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111\bB-\u0011%\u0011Y&GA\u0001\u0002\u0004\u0011y%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005C\u0002bAa\u0019\u0003j\u0005mRB\u0001B3\u0015\r\u00119\u0007V\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B6\u0005K\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011 B9\u0011%\u0011YfGA\u0001\u0002\u0004\tY$\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u001f\u0005oB\u0011Ba\u0017\u001d\u0003\u0003\u0005\rAa\u0014\u0002\r\u0015\fX/\u00197t)\u0011\tIP! \t\u0013\tmS$!AA\u0002\u0005m\u0012!\u0004#fY\u0016$XmQ8n[\u0006tG\r\u0005\u0002M?M)qD!\"\u0003\fB\u00191Ka\"\n\u0007\t%EK\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0005\u001b\u0013\u0019*\u0004\u0002\u0003\u0010*!!\u0011\u0013B#\u0003\tIw.C\u0002c\u0005\u001f#\"A!!\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\u00055!1\u0014\u0005\b\u0005;\u000b\u0003\u0019\u0001BP\u0003\u0019!W\r\\3uKB\u0019!H!)\n\u0007\t\r6HA\u0006EK2$\u0018\rR3mKR,\u0017\u0001\u0005$J\u0019\u0016{f*Q'F?\u000e{E*V'O+\t\t\u0019'A\tG\u00132+uLT!N\u000b~\u001bu\nT+N\u001d\u0002\n\u0011DR%O\t&sui\u0018+P+\u000eCU\tR0G\u00132+5kX'T\u000f\u0006Qb)\u0013(E\u0013:;u\fV(V\u0007\"+Ei\u0018$J\u0019\u0016\u001bv,T*HA\u0005\t\"/Z<sSRLgn\u001a$jY\u0016\u001cXj]4\u0015\t\u0005\r$1\u0017\u0005\b\u0003[4\u0003\u0019AAx))\tiAa.\u0003:\nm&Q\u0018\u0005\u0006I\u001e\u0002\rA\u001a\u0005\u0006W\u001e\u0002\r!\u001c\u0005\u0006o\u001e\u0002\r!\u000f\u0005\u0006u\u001e\u0002\r\u0001`\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ma3\u0011\tMs'Q\u0019\t\b'\n\u001dg-\\\u001d}\u0013\r\u0011I\r\u0016\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\t5\u0007&!AA\u0002\u00055\u0011a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u001b\t\u0005\u0005\u007f\u0011).\u0003\u0003\u0003X\n\u0005#AB(cU\u0016\u001cG\u000f")
public class DeleteCommand
extends LogicalPlan
implements LeafRunnableCommand,
DeltaCommand,
DeleteCommandMetrics,
Serializable {
    private Map<String, SQLMetric> metrics;
    private final DeltaLog deltaLog;
    private final Option<CatalogTable> catalogTable;
    private final LogicalPlan target;
    private final Option<Expression> condition;
    private final Seq<Attribute> output;
    private transient SparkContext org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<DeltaLog, Option<CatalogTable>, LogicalPlan, Option<Expression>>> unapply(DeleteCommand x$0) {
        return DeleteCommand$.MODULE$.unapply(x$0);
    }

    public static String rewritingFilesMsg(long numFilesToRewrite) {
        return DeleteCommand$.MODULE$.rewritingFilesMsg(numFilesToRewrite);
    }

    public static String FINDING_TOUCHED_FILES_MSG() {
        return DeleteCommand$.MODULE$.FINDING_TOUCHED_FILES_MSG();
    }

    public static String FILE_NAME_COLUMN() {
        return DeleteCommand$.MODULE$.FILE_NAME_COLUMN();
    }

    @Override
    public Map<String, SQLMetric> createMetrics() {
        return DeleteCommandMetrics.createMetrics$(this);
    }

    @Override
    public Option<Object> getDeletedRowsFromAddFilesAndUpdateMetrics(Seq<AddFile> files) {
        return DeleteCommandMetrics.getDeletedRowsFromAddFilesAndUpdateMetrics$(this, files);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String escapedFilePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, escapedFilePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private SparkContext org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc$lzycompute() {
        DeleteCommand deleteCommand = this;
        synchronized (deleteCommand) {
            if (!this.bitmap$trans$0) {
                this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc = DeleteCommandMetrics.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc;
    }

    @Override
    public SparkContext org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc() {
        if (!this.bitmap$trans$0) {
            return this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc$lzycompute();
        }
        return this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public Option<CatalogTable> catalogTable() {
        return this.catalogTable;
    }

    public LogicalPlan target() {
        return this.target;
    }

    public Option<Expression> condition() {
        return this.condition;
    }

    public Seq<QueryPlan<?>> innerChildren() {
        return new .colon.colon((Object)this.target(), (List)Nil$.MODULE$);
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DeleteCommand deleteCommand = this;
        synchronized (deleteCommand) {
            if (!this.bitmap$0) {
                this.metrics = this.createMetrics();
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Row> run(SparkSession sparkSession) {
        Seq seq;
        Object object = new Object();
        try {
            this.recordDeltaOperation(this.deltaLog(), "delta.dml.delete", this.recordDeltaOperation$default$3(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.deltaLog().withNewTransaction(this.catalogTable(), this.deltaLog().withNewTransaction$default$2(), (Function1 & Serializable)txn -> {
                    DeleteCommand.$anonfun$run$2(this, sparkSession, object, txn);
                    return BoxedUnit.UNIT;
                });
                sparkSession.sharedState().cacheManager().recacheByPlan(sparkSession, this.target());
            });
            seq = ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).value() > 0L && ((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value() == 0L ? new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-1L)})), (List)Nil$.MODULE$) : new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value())})), (List)Nil$.MODULE$);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    public Tuple2<Seq<Action>, DeleteMetric> performDelete(SparkSession sparkSession, DeltaLog deltaLog, OptimisticTransaction txn) {
        Seq seq;
        long numRemovedFiles = 0L;
        long numAddedFiles = 0L;
        long numAddedChangeFiles = 0L;
        long scanTimeMs = 0L;
        long rewriteTimeMs = 0L;
        long numAddedBytes = 0L;
        long changeFileBytes = 0L;
        long numRemovedBytes = 0L;
        long numFilesBeforeSkipping = 0L;
        long numBytesBeforeSkipping = 0L;
        long numFilesAfterSkipping = 0L;
        long numBytesAfterSkipping = 0L;
        None$ numPartitionsAfterSkipping = None$.MODULE$;
        None$ numPartitionsRemovedFrom = None$.MODULE$;
        None$ numPartitionsAddedTo = None$.MODULE$;
        Some numDeletedRows = None$.MODULE$;
        None$ numCopiedRows = None$.MODULE$;
        long numDeletionVectorsAdded = 0L;
        long numDeletionVectorsRemoved = 0L;
        long numDeletionVectorsUpdated = 0L;
        long startTime = System.nanoTime();
        long numFilesTotal = txn.snapshot().numOfFiles();
        Option<Expression> option = this.condition();
        if (None$.MODULE$.equals(option)) {
            boolean reportRowLevelMetrics = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.DELTA_DML_METRICS_FROM_METADATA()));
            Seq<AddFile> allFiles = txn.filterFiles((Seq<Expression>)Nil$.MODULE$, reportRowLevelMetrics);
            numRemovedFiles = allFiles.size();
            numDeletionVectorsRemoved = allFiles.count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteCommand.$anonfun$performDelete$1(x$2)));
            scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
            Tuple2<Object, Object> tuple2 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues(allFiles);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long numBytes = tuple2._1$mcJ$sp();
            int numPartitions = tuple2._2$mcI$sp();
            Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(numBytes, numPartitions);
            long numBytes2 = sp2._1$mcJ$sp();
            int numPartitions2 = sp2._2$mcI$sp();
            numRemovedBytes = numBytes2;
            numFilesBeforeSkipping = numRemovedFiles;
            numBytesBeforeSkipping = numBytes2;
            numFilesAfterSkipping = numRemovedFiles;
            numBytesAfterSkipping = numBytes2;
            numDeletedRows = this.getDeletedRowsFromAddFilesAndUpdateMetrics(allFiles);
            if (txn.metadata().partitionColumns().nonEmpty()) {
                numPartitionsAfterSkipping = new Some((Object)BoxesRunTime.boxToLong((long)numPartitions2));
                numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)numPartitions2));
                numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)0L));
            }
            long operationTimestamp = System.currentTimeMillis();
            seq = (Seq)allFiles.map((Function1 & Serializable)x$4 -> x$4.removeWithTimestamp(operationTimestamp, x$4.removeWithTimestamp$default$2()));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Expression cond = (Expression)some.value();
            Tuple2<Seq<Expression>, Seq<Expression>> tuple2 = DeltaTableUtils$.MODULE$.splitMetadataAndDataPredicates(cond, txn.metadata().partitionColumns(), sparkSession);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq metadataPredicates = (Seq)tuple2._1();
            Seq otherPredicates = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)metadataPredicates, (Object)otherPredicates);
            Seq metadataPredicates2 = (Seq)tuple22._1();
            Seq otherPredicates2 = (Seq)tuple22._2();
            numFilesBeforeSkipping = txn.snapshot().numOfFiles();
            numBytesBeforeSkipping = txn.snapshot().sizeInBytes();
            if (otherPredicates2.isEmpty()) {
                long operationTimestamp = System.currentTimeMillis();
                boolean reportRowLevelMetrics = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.DELTA_DML_METRICS_FROM_METADATA()));
                Seq<AddFile> candidateFiles = txn.filterFiles((Seq<Expression>)metadataPredicates2, reportRowLevelMetrics);
                scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
                numRemovedFiles = candidateFiles.size();
                numRemovedBytes = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)candidateFiles.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                numFilesAfterSkipping = candidateFiles.size();
                numDeletionVectorsRemoved = candidateFiles.count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteCommand.$anonfun$performDelete$4(x$7)));
                Tuple2<Object, Object> tuple23 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues(candidateFiles);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                long numCandidateBytes = tuple23._1$mcJ$sp();
                int numCandidatePartitions = tuple23._2$mcI$sp();
                Tuple2.mcJI.sp sp3 = new Tuple2.mcJI.sp(numCandidateBytes, numCandidatePartitions);
                long numCandidateBytes2 = sp3._1$mcJ$sp();
                int numCandidatePartitions2 = sp3._2$mcI$sp();
                numBytesAfterSkipping = numCandidateBytes2;
                numDeletedRows = this.getDeletedRowsFromAddFilesAndUpdateMetrics(candidateFiles);
                if (txn.metadata().partitionColumns().nonEmpty()) {
                    numPartitionsAfterSkipping = new Some((Object)BoxesRunTime.boxToLong((long)numCandidatePartitions2));
                    numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)numCandidatePartitions2));
                    numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                }
                seq = (Seq)candidateFiles.map((Function1 & Serializable)x$9 -> x$9.removeWithTimestamp(operationTimestamp, x$9.removeWithTimestamp$default$2()));
            } else {
                boolean shouldWriteDVs = this.shouldWritePersistentDeletionVectors(sparkSession, txn);
                Seq<AddFile> candidateFiles = txn.filterFiles((Seq<Expression>)((Seq)metadataPredicates2.$plus$plus((IterableOnce)otherPredicates2)), shouldWriteDVs);
                numFilesAfterSkipping = candidateFiles.size();
                Tuple2<Object, Object> tuple24 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues(candidateFiles);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                long numCandidateBytes = tuple24._1$mcJ$sp();
                int numCandidatePartitions = tuple24._2$mcI$sp();
                Tuple2.mcJI.sp sp4 = new Tuple2.mcJI.sp(numCandidateBytes, numCandidatePartitions);
                long numCandidateBytes3 = sp4._1$mcJ$sp();
                int numCandidatePartitions3 = sp4._2$mcI$sp();
                numBytesAfterSkipping = numCandidateBytes3;
                if (txn.metadata().partitionColumns().nonEmpty()) {
                    numPartitionsAfterSkipping = new Some((Object)BoxesRunTime.boxToLong((long)numCandidatePartitions3));
                }
                Map<String, AddFile> nameToAddFileMap = this.generateCandidateFileMap(deltaLog.dataPath(), candidateFiles);
                TahoeBatchFileIndex fileIndex = new TahoeBatchFileIndex(sparkSession, "delete", candidateFiles, deltaLog, deltaLog.dataPath(), txn.snapshot(), TahoeBatchFileIndex$.MODULE$.$lessinit$greater$default$7());
                if (shouldWriteDVs) {
                    Dataset<Row> targetDf = DMLWithDeletionVectorsHelper$.MODULE$.createTargetDfForScanningForMatches(sparkSession, this.target(), fileIndex);
                    boolean mustReadDeletionVectors = DeletionVectorUtils$.MODULE$.deletionVectorsReadable(txn.snapshot(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$3());
                    Seq<TouchedFileWithDV> touchedFiles = DMLWithDeletionVectorsHelper$.MODULE$.findTouchedFiles(sparkSession, txn, mustReadDeletionVectors, deltaLog, targetDf, fileIndex, cond, "DELETE");
                    if (touchedFiles.nonEmpty()) {
                        Tuple2<Seq<FileAction>, Map<String, Object>> tuple25 = DMLWithDeletionVectorsHelper$.MODULE$.processUnmodifiedData(sparkSession, touchedFiles, txn.snapshot());
                        if (tuple25 == null) {
                            throw new MatchError(tuple25);
                        }
                        Seq actions = (Seq)tuple25._1();
                        Map metricMap = (Map)tuple25._2();
                        Tuple2 tuple26 = new Tuple2((Object)actions, (Object)metricMap);
                        Seq actions2 = (Seq)tuple26._1();
                        Map metricMap2 = (Map)tuple26._2();
                        ((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).set(BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numModifiedRows")));
                        numDeletionVectorsAdded = BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numDeletionVectorsAdded"));
                        numDeletionVectorsRemoved = BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numDeletionVectorsRemoved"));
                        numDeletionVectorsUpdated = BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numDeletionVectorsUpdated"));
                        numRemovedFiles = BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numRemovedFiles"));
                        seq = actions2;
                    } else {
                        seq = Nil$.MODULE$;
                    }
                } else {
                    LogicalPlan newTarget = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), fileIndex);
                    Dataset data = Dataset$.MODULE$.ofRows(sparkSession, newTarget);
                    IncrementMetric incrDeletedCountExpr = new IncrementMetric((Expression)Literal$.MODULE$.TrueLiteral(), (SQLMetric)this.metrics().apply((Object)"numDeletedRows"));
                    String[] filesToRewrite = (String[])this.withStatusCode("DELTA", DeleteCommand$.MODULE$.FINDING_TOUCHED_FILES_MSG(), this.withStatusCode$default$3(), (Function0 & Serializable)() -> {
                        if (candidateFiles.isEmpty()) {
                            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
                        }
                        return (String[])data.filter(Column$.MODULE$.apply(cond)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.input_file_name()})).filter(Column$.MODULE$.apply((Expression)incrDeletedCountExpr)).distinct().as(package$.MODULE$.stringEncoder()).collect();
                    });
                    numRemovedFiles = filesToRewrite.length;
                    scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
                    if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite))) {
                        if (txn.metadata().partitionColumns().nonEmpty()) {
                            numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                            numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                        }
                        seq = Nil$.MODULE$;
                    } else {
                        Not filterCond;
                        HadoopFsRelation baseRelation = this.buildBaseRelation(sparkSession, txn, "delete", deltaLog.dataPath(), (Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)filesToRewrite), nameToAddFileMap);
                        LogicalPlan newTarget2 = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), baseRelation.location());
                        Dataset<Row> targetDF = RowTracking$.MODULE$.preserveRowTrackingColumns((Dataset<Row>)Dataset$.MODULE$.ofRows(sparkSession, newTarget2), txn.snapshot());
                        Seq<FileAction> rewrittenActions = this.rewriteFiles(txn, targetDF, (Expression)(filterCond = new Not((Expression)new EqualNullSafe(cond, (Expression)Literal$.MODULE$.TrueLiteral()))), filesToRewrite.length);
                        Tuple2 tuple27 = rewrittenActions.partition((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DeleteCommand.$anonfun$performDelete$7(x$12)));
                        if (tuple27 == null) {
                            throw new MatchError((Object)tuple27);
                        }
                        Seq changeFiles = (Seq)tuple27._1();
                        Seq rewrittenFiles = (Seq)tuple27._2();
                        Tuple2 tuple28 = new Tuple2((Object)changeFiles, (Object)rewrittenFiles);
                        Seq changeFiles2 = (Seq)tuple28._1();
                        Seq rewrittenFiles2 = (Seq)tuple28._2();
                        numAddedFiles = rewrittenFiles2.size();
                        AddFile[] removedFiles = (AddFile[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite), (Function1 & Serializable)f -> this.getTouchedFile(deltaLog.dataPath(), (String)f, nameToAddFileMap), ClassTag$.MODULE$.apply(AddFile.class));
                        Tuple2<Object, Object> tuple29 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)removedFiles));
                        if (tuple29 == null) {
                            throw new MatchError(tuple29);
                        }
                        long removedBytes = tuple29._1$mcJ$sp();
                        int removedPartitions = tuple29._2$mcI$sp();
                        Tuple2.mcJI.sp sp5 = new Tuple2.mcJI.sp(removedBytes, removedPartitions);
                        long removedBytes2 = sp5._1$mcJ$sp();
                        int removedPartitions2 = sp5._2$mcI$sp();
                        numRemovedBytes = removedBytes2;
                        Tuple2<Object, Object> tuple210 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)rewrittenFiles2);
                        if (tuple210 == null) {
                            throw new MatchError(tuple210);
                        }
                        long rewrittenBytes = tuple210._1$mcJ$sp();
                        int rewrittenPartitions = tuple210._2$mcI$sp();
                        Tuple2.mcJI.sp sp6 = new Tuple2.mcJI.sp(rewrittenBytes, rewrittenPartitions);
                        long rewrittenBytes2 = sp6._1$mcJ$sp();
                        int rewrittenPartitions2 = sp6._2$mcI$sp();
                        numAddedBytes = rewrittenBytes2;
                        if (txn.metadata().partitionColumns().nonEmpty()) {
                            numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)removedPartitions2));
                            numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)rewrittenPartitions2));
                        }
                        numAddedChangeFiles = changeFiles2.size();
                        changeFileBytes = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)changeFiles2.collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof AddCDCFile) {
                                    AddCDCFile addCDCFile = (AddCDCFile)A1;
                                    return (B1)BoxesRunTime.boxToLong((long)addCDCFile.size());
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(FileAction x1) {
                                FileAction fileAction = x1;
                                return fileAction instanceof AddCDCFile;
                            }
                        })).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                        rewriteTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) - scanTimeMs;
                        numDeletedRows = new Some((Object)BoxesRunTime.boxToLong((long)((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value()));
                        numCopiedRows = new Some((Object)BoxesRunTime.boxToLong((long)(((SQLMetric)this.metrics().apply((Object)"numTouchedRows")).value() - ((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value())));
                        numDeletionVectorsRemoved = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])removedFiles), (Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DeleteCommand.$anonfun$performDelete$9(x$16)));
                        long operationTimestamp = System.currentTimeMillis();
                        seq = (Seq)this.removeFilesFromPaths(deltaLog, nameToAddFileMap, (Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)filesToRewrite), operationTimestamp).$plus$plus(rewrittenActions);
                    }
                }
            }
        } else {
            throw new MatchError(option);
        }
        Seq deleteActions = seq;
        ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).set(numRemovedFiles);
        ((SQLMetric)this.metrics().apply((Object)"numAddedFiles")).set(numAddedFiles);
        long executionTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
        ((SQLMetric)this.metrics().apply((Object)"executionTimeMs")).set(executionTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"scanTimeMs")).set(scanTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"rewriteTimeMs")).set(rewriteTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"numAddedChangeFiles")).set(numAddedChangeFiles);
        ((SQLMetric)this.metrics().apply((Object)"changeFileBytes")).set(changeFileBytes);
        ((SQLMetric)this.metrics().apply((Object)"numAddedBytes")).set(numAddedBytes);
        ((SQLMetric)this.metrics().apply((Object)"numRemovedBytes")).set(numRemovedBytes);
        ((SQLMetric)this.metrics().apply((Object)"numFilesBeforeSkipping")).set(numFilesBeforeSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numBytesBeforeSkipping")).set(numBytesBeforeSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numFilesAfterSkipping")).set(numFilesAfterSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numBytesAfterSkipping")).set(numBytesAfterSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numDeletionVectorsAdded")).set(numDeletionVectorsAdded);
        ((SQLMetric)this.metrics().apply((Object)"numDeletionVectorsRemoved")).set(numDeletionVectorsRemoved);
        ((SQLMetric)this.metrics().apply((Object)"numDeletionVectorsUpdated")).set(numDeletionVectorsUpdated);
        SQLMetric sQLMetric = (SQLMetric)this.metrics().apply((Object)"numPartitionsAfterSkipping");
        numPartitionsAfterSkipping.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)v -> sQLMetric.set(v));
        SQLMetric sQLMetric2 = (SQLMetric)this.metrics().apply((Object)"numPartitionsAddedTo");
        numPartitionsAddedTo.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)v -> sQLMetric2.set(v));
        SQLMetric sQLMetric3 = (SQLMetric)this.metrics().apply((Object)"numPartitionsRemovedFrom");
        numPartitionsRemovedFrom.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)v -> sQLMetric3.set(v));
        SQLMetric sQLMetric4 = (SQLMetric)this.metrics().apply((Object)"numCopiedRows");
        numCopiedRows.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)v -> sQLMetric4.set(v));
        txn.registerSQLMetrics(sparkSession, this.metrics());
        this.sendDriverMetrics(sparkSession, this.metrics());
        NumRecordsStats numRecordsStats = NumRecordsStats$.MODULE$.fromActions((Seq<Action>)deleteActions);
        String x$1 = (String)this.condition().map((Function1 & Serializable)x$17 -> x$17.sql()).getOrElse((Function0 & Serializable)() -> "true");
        long x$22 = numFilesTotal;
        long x$3 = numFilesAfterSkipping;
        long x$42 = numAddedFiles;
        long x$5 = numRemovedFiles;
        long x$62 = numAddedFiles;
        long x$72 = numAddedChangeFiles;
        long x$8 = numFilesBeforeSkipping;
        long x$92 = numBytesBeforeSkipping;
        long x$10 = numFilesAfterSkipping;
        long x$11 = numBytesAfterSkipping;
        None$ x$122 = numPartitionsAfterSkipping;
        None$ x$13 = numPartitionsAddedTo;
        None$ x$14 = numPartitionsRemovedFrom;
        None$ x$15 = numCopiedRows;
        Some x$162 = numDeletedRows;
        long x$172 = numAddedBytes;
        long x$18 = numRemovedBytes;
        long x$19 = changeFileBytes;
        long x$20 = scanTimeMs;
        long x$21 = rewriteTimeMs;
        long x$222 = numDeletionVectorsAdded;
        long x$23 = numDeletionVectorsRemoved;
        long x$24 = numDeletionVectorsUpdated;
        Option<Object> x$25 = numRecordsStats.numLogicalRecordsAdded();
        Option<Object> x$26 = numRecordsStats.numLogicalRecordsRemoved();
        Option<Object> x$27 = DeleteMetric$.MODULE$.apply$default$25();
        boolean x$28 = DeleteMetric$.MODULE$.apply$default$26();
        DeleteMetric deleteMetric = new DeleteMetric(x$1, x$22, x$3, x$42, x$5, x$62, x$72, x$8, x$92, x$10, x$11, (Option<Object>)x$122, (Option<Object>)x$13, (Option<Object>)x$14, (Option<Object>)x$15, (Option<Object>)x$162, x$172, x$18, x$19, x$20, x$21, x$222, x$23, x$24, x$27, x$28, x$25, x$26);
        Seq actionsToCommit = deleteActions.nonEmpty() ? (Seq)Option$.MODULE$.option2Iterable(this.createSetTransaction(sparkSession, deltaLog, this.createSetTransaction$default$3())).toSeq().$plus$plus((IterableOnce)deleteActions) : (Seq)scala.package$.MODULE$.Seq().empty();
        return new Tuple2((Object)actionsToCommit, (Object)deleteMetric);
    }

    private Seq<FileAction> rewriteFiles(OptimisticTransaction txn, Dataset<Row> baseData, Expression filterCondition, long numFilesToRewrite) {
        boolean shouldWriteCdc = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHANGE_DATA_FEED().fromMetaData(txn.metadata()));
        IncrementMetric incrTouchedCountExpr = new IncrementMetric((Expression)Literal$.MODULE$.TrueLiteral(), (SQLMetric)this.metrics().apply((Object)"numTouchedRows"));
        return (Seq)this.withStatusCode("DELTA", DeleteCommand$.MODULE$.rewritingFilesMsg(numFilesToRewrite), this.withStatusCode$default$3(), (Function0 & Serializable)() -> {
            Dataset dfToWrite = shouldWriteCdc ? baseData.filter(Column$.MODULE$.apply((Expression)incrTouchedCountExpr)).withColumn(CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME(), Column$.MODULE$.apply((Expression)new If(filterCondition, (Expression)CDCReader$.MODULE$.CDC_TYPE_NOT_CDC(), (Expression)CDCReader$.MODULE$.CDC_TYPE_DELETE()))) : baseData.filter(Column$.MODULE$.apply((Expression)incrTouchedCountExpr)).filter(Column$.MODULE$.apply(filterCondition));
            return txn.writeFiles(dfToWrite);
        });
    }

    public boolean shouldWritePersistentDeletionVectors(SparkSession spark, OptimisticTransaction txn) {
        return BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.DELETE_USE_PERSISTENT_DELETION_VECTORS())) && DeletionVectorUtils$.MODULE$.deletionVectorsWritable(txn.snapshot(), DeletionVectorUtils$.MODULE$.deletionVectorsWritable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsWritable$default$3());
    }

    public DeleteCommand copy(DeltaLog deltaLog, Option<CatalogTable> catalogTable, LogicalPlan target, Option<Expression> condition) {
        return new DeleteCommand(deltaLog, catalogTable, target, condition);
    }

    public DeltaLog copy$default$1() {
        return this.deltaLog();
    }

    public Option<CatalogTable> copy$default$2() {
        return this.catalogTable();
    }

    public LogicalPlan copy$default$3() {
        return this.target();
    }

    public Option<Expression> copy$default$4() {
        return this.condition();
    }

    public String productPrefix() {
        return "DeleteCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.deltaLog();
            }
            case 1: {
                return this.catalogTable();
            }
            case 2: {
                return this.target();
            }
            case 3: {
                return this.condition();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeleteCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "deltaLog";
            }
            case 1: {
                return "catalogTable";
            }
            case 2: {
                return "target";
            }
            case 3: {
                return "condition";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeleteCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeleteCommand deleteCommand = (DeleteCommand)x$1;
        DeltaLog deltaLog = this.deltaLog();
        DeltaLog deltaLog2 = deleteCommand.deltaLog();
        if (deltaLog == null) {
            if (deltaLog2 != null) {
                return false;
            }
        } else if (!deltaLog.equals(deltaLog2)) return false;
        Option<CatalogTable> option = this.catalogTable();
        Option<CatalogTable> option2 = deleteCommand.catalogTable();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        LogicalPlan logicalPlan = this.target();
        LogicalPlan logicalPlan2 = deleteCommand.target();
        if (logicalPlan == null) {
            if (logicalPlan2 != null) {
                return false;
            }
        } else if (!logicalPlan.equals(logicalPlan2)) return false;
        Option<Expression> option3 = this.condition();
        Option<Expression> option4 = deleteCommand.condition();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!deleteCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$run$2(DeleteCommand $this, SparkSession sparkSession$1, Object nonLocalReturnKey2$1, OptimisticTransaction txn) {
        DeltaLog$.MODULE$.assertRemovable(txn.snapshot());
        if ($this.hasBeenExecuted(txn, sparkSession$1, $this.hasBeenExecuted$default$3())) {
            $this.sendDriverMetrics(sparkSession$1, $this.metrics());
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)scala.package$.MODULE$.Seq().empty());
        }
        Tuple2<Seq<Action>, DeleteMetric> tuple2 = $this.performDelete(sparkSession$1, $this.deltaLog(), txn);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq deleteActions = (Seq)tuple2._1();
        DeleteMetric deleteMetrics = (DeleteMetric)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)deleteActions, (Object)deleteMetrics);
        Seq deleteActions2 = (Seq)tuple22._1();
        DeleteMetric deleteMetrics2 = (DeleteMetric)tuple22._2();
        Option<Object> commitVersion = txn.commitIfNeeded((Seq<Action>)deleteActions2, new DeltaOperations.Delete((Seq<Expression>)Option$.MODULE$.option2Iterable($this.condition()).toSeq()), RowTracking$.MODULE$.addPreservedRowTrackingTagIfNotSet(txn.snapshot(), RowTracking$.MODULE$.addPreservedRowTrackingTagIfNotSet$default$2()));
        DeltaLog x$29 = $this.deltaLog();
        String x$30 = "delta.dml.delete.stats";
        Option<Object> x$1 = commitVersion;
        String x$2 = deleteMetrics2.copy$default$1();
        long x$3 = deleteMetrics2.copy$default$2();
        long x$4 = deleteMetrics2.copy$default$3();
        long x$5 = deleteMetrics2.copy$default$4();
        long x$6 = deleteMetrics2.copy$default$5();
        long x$7 = deleteMetrics2.copy$default$6();
        long x$8 = deleteMetrics2.copy$default$7();
        long x$9 = deleteMetrics2.copy$default$8();
        long x$10 = deleteMetrics2.copy$default$9();
        long x$11 = deleteMetrics2.copy$default$10();
        long x$12 = deleteMetrics2.copy$default$11();
        Option<Object> x$13 = deleteMetrics2.copy$default$12();
        Option<Object> x$14 = deleteMetrics2.copy$default$13();
        Option<Object> x$15 = deleteMetrics2.copy$default$14();
        Option<Object> x$16 = deleteMetrics2.copy$default$15();
        Option<Object> x$17 = deleteMetrics2.copy$default$16();
        long x$18 = deleteMetrics2.copy$default$17();
        long x$19 = deleteMetrics2.copy$default$18();
        long x$20 = deleteMetrics2.copy$default$19();
        long x$21 = deleteMetrics2.copy$default$20();
        long x$22 = deleteMetrics2.copy$default$21();
        long x$23 = deleteMetrics2.copy$default$22();
        long x$24 = deleteMetrics2.copy$default$23();
        long x$25 = deleteMetrics2.copy$default$24();
        boolean x$26 = deleteMetrics2.copy$default$26();
        Option<Object> x$27 = deleteMetrics2.copy$default$27();
        Option<Object> x$28 = deleteMetrics2.copy$default$28();
        DeleteMetric x$31 = deleteMetrics2.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$1, x$26, x$27, x$28);
        Map<TagDefinition, String> x$32 = $this.recordDeltaEvent$default$3();
        Option<Path> x$33 = $this.recordDeltaEvent$default$5();
        $this.recordDeltaEvent(x$29, "delta.dml.delete.stats", x$32, x$31, x$33);
    }

    public static final /* synthetic */ boolean $anonfun$performDelete$1(AddFile x$2) {
        return x$2.deletionVector() != null;
    }

    public static final /* synthetic */ boolean $anonfun$performDelete$4(AddFile x$7) {
        return x$7.deletionVector() != null;
    }

    public static final /* synthetic */ boolean $anonfun$performDelete$7(FileAction x$12) {
        return x$12 instanceof AddCDCFile;
    }

    public static final /* synthetic */ boolean $anonfun$performDelete$9(AddFile x$16) {
        return x$16.deletionVector() != null;
    }

    public DeleteCommand(DeltaLog deltaLog, Option<CatalogTable> catalogTable, LogicalPlan target, Option<Expression> condition) {
        this.deltaLog = deltaLog;
        this.catalogTable = catalogTable;
        this.target = target;
        this.condition = condition;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        LeafLike.$init$((LeafLike)this);
        LoggingShims.$init$(this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        DeleteCommandMetrics.$init$(this);
        String x$1 = "num_affected_rows";
        LongType$ x$2 = LongType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("num_affected_rows", (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6("num_affected_rows", (DataType)x$2, x$3, x$4);
        this.output = new .colon.colon((Object)new AttributeReference("num_affected_rows", (DataType)x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$);
        Statics.releaseFence();
    }
}

