/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.deletionvectors;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class RoaringBitmapArray$ {
    public static final RoaringBitmapArray$ MODULE$ = new RoaringBitmapArray$();
    private static final long MAX_REPRESENTABLE_VALUE = MODULE$.composeFromHighLowBytes(0x7FFFFFFE, Integer.MIN_VALUE);
    private static final long MAX_BITMAP_CARDINALITY = 0x100000000L;

    public final long MAX_REPRESENTABLE_VALUE() {
        return MAX_REPRESENTABLE_VALUE;
    }

    public final long MAX_BITMAP_CARDINALITY() {
        return MAX_BITMAP_CARDINALITY;
    }

    public RoaringBitmapArray apply(Seq<Object> values) {
        RoaringBitmapArray bitmap = new RoaringBitmapArray();
        bitmap.addAll(values);
        return bitmap;
    }

    public int highBytes(long value) {
        return (int)(value >> 32);
    }

    public int lowBytes(long value) {
        return (int)value;
    }

    public Tuple2<Object, Object> decomposeHighLowBytes(long value) {
        return new Tuple2.mcII.sp(this.highBytes(value), this.lowBytes(value));
    }

    public long composeFromHighLowBytes(int high, int low) {
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    public RoaringBitmapArray readFrom(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        RoaringBitmapArray bitmap = new RoaringBitmapArray();
        bitmap.deserialize(buffer);
        return bitmap;
    }

    private RoaringBitmapArray$() {
    }
}

