/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.deletionvectors;

import java.io.Serializable;
import org.apache.spark.sql.delta.RowIndexFilter;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005!4Q!\u0003\u0006\u0002\"]A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006S\u0001!\tA\u000b\u0005\b[\u0001\u0011\rQ\"\u0001/\u0011\u001d)\u0004A1A\u0007\u00029BQA\u000e\u0001\u0005\n]BQ!\u0010\u0001\u0005ByBQ\u0001\u0015\u0001\u0005BECQa\u0018\u0001\u0005B\u0001\u0014aCU8x\u0013:$W\r_'be.Lgn\u001a$jYR,'o\u001d\u0006\u0003\u00171\tq\u0002Z3mKRLwN\u001c<fGR|'o\u001d\u0006\u0003\u001b9\tQ\u0001Z3mi\u0006T!a\u0004\t\u0002\u0007M\fHN\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\r!!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0003mC:<'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011aa\u00142kK\u000e$\bCA\u0011#\u001b\u0005a\u0011BA\u0012\r\u00059\u0011vn^%oI\u0016Dh)\u001b7uKJ\faAY5u[\u0006\u0004\bC\u0001\u0014(\u001b\u0005Q\u0011B\u0001\u0015\u000b\u0005I\u0011v.\u0019:j]\u001e\u0014\u0015\u000e^7ba\u0006\u0013(/Y=\u0002\rqJg.\u001b;?)\tYC\u0006\u0005\u0002'\u0001!)AE\u0001a\u0001K\u0005\u0011b/\u00197vK^CWM\\\"p]R\f\u0017N\\3e+\u0005y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$\u0001\u0002\"zi\u0016\fQC^1mk\u0016<\u0006.\u001a8O_R\u001cuN\u001c;bS:,G-A\njg\u000e{g\u000e^1j]\u0016$\u0017J\u001c\"ji6\f\u0007\u000f\u0006\u00020q!)\u0011(\u0002a\u0001u\u0005A!o\\<J]\u0012,\u0007\u0010\u0005\u00021w%\u0011A(\r\u0002\u0005\u0019>tw-A\u000bnCR,'/[1mSj,\u0017J\u001c;p-\u0016\u001cGo\u001c:\u0015\t}\u0012EI\u0012\t\u0003a\u0001K!!Q\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0007\u001a\u0001\rAO\u0001\u0006gR\f'\u000f\u001e\u0005\u0006\u000b\u001a\u0001\rAO\u0001\u0004K:$\u0007\"B$\u0007\u0001\u0004A\u0015!\u00022bi\u000eD\u0007CA%O\u001b\u0005Q%BA&M\u0003)1Xm\u0019;pe&TX\r\u001a\u0006\u0003\u001b:\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005=S%\u0001F,sSR\f'\r\\3D_2,XN\u001c,fGR|'/A\u0011nCR,'/[1mSj,\u0017J\u001c;p-\u0016\u001cGo\u001c:XSRD'k\\<J]\u0012,\u0007\u0010\u0006\u0003@%^s\u0006\"B*\b\u0001\u0004!\u0016!\u00032bi\u000eD7+\u001b>f!\t\u0001T+\u0003\u0002Wc\t\u0019\u0011J\u001c;\t\u000ba;\u0001\u0019A-\u0002\u001dI|w/\u00138eKb\u001cu\u000e\\;n]B\u0011!\fX\u0007\u00027*\u00111JD\u0005\u0003;n\u0013AbQ8mk6tg+Z2u_JDQaR\u0004A\u0002!\u000b\u0001%\\1uKJL\u0017\r\\5{KNKgn\u001a7f%><x+\u001b;i%><\u0018J\u001c3fqR\u0019q(\u00192\t\u000beB\u0001\u0019\u0001\u001e\t\u000b\u001dC\u0001\u0019\u0001%*\u0007\u0001!g-\u0003\u0002f\u0015\t!BI]8q\u001b\u0006\u00148.\u001a3S_^\u001ch)\u001b7uKJL!a\u001a\u0006\u0003)-+W\r]'be.,GMU8xg\u001aKG\u000e^3s\u0001")
public abstract class RowIndexMarkingFilters
implements RowIndexFilter {
    private final RoaringBitmapArray bitmap;

    public abstract byte valueWhenContained();

    public abstract byte valueWhenNotContained();

    private byte isContainedInBitmap(long rowIndex) {
        boolean isContained = this.bitmap.contains(rowIndex);
        if (isContained) {
            return this.valueWhenContained();
        }
        return this.valueWhenNotContained();
    }

    @Override
    public void materializeIntoVector(long start, long end, WritableColumnVector batch) {
        int batchSize = (int)(end - start);
        for (int rowId = 0; rowId < batchSize; ++rowId) {
            byte isContained = this.isContainedInBitmap(start + (long)rowId);
            batch.putByte(rowId, isContained);
        }
    }

    @Override
    public void materializeIntoVectorWithRowIndex(int batchSize, ColumnVector rowIndexColumn, WritableColumnVector batch) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), batchSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)rowNumber -> {
            long rowIndex = rowIndexColumn.getLong(rowNumber);
            byte isContained = this.isContainedInBitmap(rowIndex);
            batch.putByte(rowNumber, isContained);
        });
    }

    @Override
    public void materializeSingleRowWithRowIndex(long rowIndex, WritableColumnVector batch) {
        byte isContained = this.isContainedInBitmap(rowIndex);
        batch.putByte(0, isContained);
    }

    public RowIndexMarkingFilters(RoaringBitmapArray bitmap) {
        this.bitmap = bitmap;
    }
}

