/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.files;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.delta.DefaultRowCommitVersion$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaParquetFileFormat$;
import org.apache.spark.sql.delta.RowId$;
import org.apache.spark.sql.delta.RowIndexFilterType;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.files.SupportsRowIndexFilters;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileStatusWithMetadata;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=f!\u0002\f\u0018\u0003\u0003!\u0003\u0002\u0003\u0010\u0001\u0005\u000b\u0007I\u0011A\u001e\t\u0011\u0001\u0003!\u0011!Q\u0001\nqB\u0001\"\u0011\u0001\u0003\u0006\u0004%\tE\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0007\"Aq\t\u0001BC\u0002\u0013\u0005\u0001\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u00151\u0007A\"\u0001h\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBA3\u0001\u0011E\u0011q\r\u0005\b\u0003g\u0002A\u0011IA;\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!a#\u0001\t\u0003\ni\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\nqA+\u00195pK\u001aKG.Z%oI\u0016D(B\u0001\r\u001a\u0003\u00151\u0017\u000e\\3t\u0015\tQ2$A\u0003eK2$\u0018M\u0003\u0002\u001d;\u0005\u00191/\u001d7\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001K-\u001at\u0007\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003YEj\u0011!\f\u0006\u0003]=\n1\u0002Z1uCN|WO]2fg*\u0011\u0001gG\u0001\nKb,7-\u001e;j_:L!AM\u0017\u0003\u0013\u0019KG.Z%oI\u0016D\bC\u0001\u001b6\u001b\u00059\u0012B\u0001\u001c\u0018\u0005]\u0019V\u000f\u001d9peR\u001c(k\\<J]\u0012,\u0007PR5mi\u0016\u00148\u000f\u0005\u00029s5\t\u0011$\u0003\u0002;3\t\u00112K\\1qg\"|G\u000fR3tGJL\u0007\u000f^8s+\u0005a\u0004CA\u001f?\u001b\u0005Y\u0012BA \u001c\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019\u0019\b/\u0019:lA\u0005AA-\u001a7uC2{w-F\u0001D!\tAD)\u0003\u0002F3\tAA)\u001a7uC2{w-A\u0005eK2$\u0018\rT8hA\u0005!\u0001/\u0019;i+\u0005I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\t17O\u0003\u0002O?\u00051\u0001.\u00193p_BL!\u0001U&\u0003\tA\u000bG\u000f[\u0001\u0006a\u0006$\b\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tQ+fk\u0016\t\u0003i\u0001AQAH\u0004A\u0002qBQ!Q\u0004A\u0002\rCQaR\u0004A\u0002%\u000b\u0011B]8piB\u000bG\u000f[:\u0016\u0003i\u00032aW2J\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`G\u00051AH]8pizJ\u0011\u0001K\u0005\u0003E\u001e\nq\u0001]1dW\u0006<W-\u0003\u0002eK\n\u00191+Z9\u000b\u0005\t<\u0013!D7bi\u000eD\u0017N\\4GS2,7\u000fF\u0002i_j\u00042aW2j!\tQW.D\u0001l\u0015\ta\u0017$A\u0004bGRLwN\\:\n\u00059\\'aB!eI\u001aKG.\u001a\u0005\u0006a&\u0001\r!]\u0001\u0011a\u0006\u0014H/\u001b;j_:4\u0015\u000e\u001c;feN\u00042aW2s!\t\u0019\b0D\u0001u\u0015\t)h/A\u0006fqB\u0014Xm]:j_:\u001c(BA<\u001c\u0003!\u0019\u0017\r^1msN$\u0018BA=u\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006w&\u0001\r!]\u0001\fI\u0006$\u0018MR5mi\u0016\u00148/\u0001\u0010d_:4XM\u001d;QCJ$\u0018\u000e^5p]N$v.\u00138uKJt\u0017\r\u001c*poR\u0019a0!\u0004\u0011\u0007m\u001bw\u0010\u0005\u0004'\u0003\u0003\t)\u0001[\u0005\u0004\u0003\u00079#A\u0002+va2,'\u0007\u0005\u0003\u0002\b\u0005%Q\"\u0001<\n\u0007\u0005-aOA\u0006J]R,'O\\1m%><\bbBA\b\u0015\u0001\u0007\u0011\u0011C\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003B.d\u0003'\u0001bAJA\u0001\u0003+A\u0007\u0003CA\f\u0003?\t)#!\n\u000f\t\u0005e\u00111\u0004\t\u0003;\u001eJ1!!\b(\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011EA\u0012\u0005\ri\u0015\r\u001d\u0006\u0004\u0003;9\u0003\u0003BA\f\u0003OIA!!\u000b\u0002$\t11\u000b\u001e:j]\u001e\f\u0001\u0004\\5tiB\u000b'\u000f^5uS>t7/Q:BI\u00124\u0015\u000e\\3t)\u0019\ty#!\r\u00024A)a%!\u0001\u007fQ\")\u0001o\u0003a\u0001c\")1p\u0003a\u0001c\u0006IA.[:u\r&dWm\u001d\u000b\u0007\u0003s\t\t%a\u0011\u0011\tm\u001b\u00171\b\t\u0004Y\u0005u\u0012bAA [\t\u0011\u0002+\u0019:uSRLwN\u001c#je\u0016\u001cGo\u001c:z\u0011\u0015\u0001H\u00021\u0001r\u0011\u0015YH\u00021\u0001r\u00031a\u0017n\u001d;BI\u00124\u0015\u000e\\3t)\u0019\tI%a\u0013\u0002NA9\u0011qCA\u0010\u0003+A\u0007\"\u00029\u000e\u0001\u0004\t\b\"B>\u000e\u0001\u0004\t\u0018!\t4jY\u0016\u001cF/\u0019;vg^KG\u000f['fi\u0006$\u0017\r^1Ge>l\u0017\t\u001a3GS2,G\u0003BA*\u00033\u00022\u0001LA+\u0013\r\t9&\f\u0002\u0017\r&dWm\u0015;biV\u001cx+\u001b;i\u001b\u0016$\u0018\rZ1uC\"1\u00111\f\bA\u0002%\fq!\u00193e\r&dW-\u0001\rnC.,\u0007+\u0019:uSRLwN\u001c#je\u0016\u001cGo\u001c:jKN$B!!\u000f\u0002b!1\u00111M\bA\u0002y\fa\u0003]1si&$\u0018n\u001c8WC2,Xm\u001d+p\r&dWm]\u0001\u0016O\u0016$\b+\u0019:uSRLwN\u001c,bYV,7OU8x)\u0011\tI'a\u001c\u0011\u0007M\fY'C\u0002\u0002nQ\u0014!cR3oKJL7-\u00138uKJt\u0017\r\u001c*po\"9\u0011\u0011\u000f\tA\u0002\u0005U\u0011a\u00049beRLG/[8o-\u0006dW/Z:\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006,\"!a\u001e\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! \u001c\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t)a\u001f\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0007bEN|G.\u001e;f!\u0006$\b\u000eF\u0002J\u0003\u000fCq!!#\u0013\u0001\u0004\t)#A\u0003dQ&dG-\u0001\u0005u_N#(/\u001b8h)\t\t)#A\u0007ueVt7-\u0019;f%&<\u0007\u000e\u001e\u000b\u0007\u0003K\t\u0019*a&\t\u000f\u0005UE\u00031\u0001\u0002&\u0005)\u0011N\u001c9vi\"9\u0011\u0011\u0014\u000bA\u0002\u0005m\u0015a\u00017f]B\u0019a%!(\n\u0007\u0005}uEA\u0002J]R\f1bZ3u\u0005\u0006\u001cX\rU1uQR!\u0011QUAV!\u00111\u0013qU%\n\u0007\u0005%vE\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003[+\u0002\u0019A%\u0002\u0011\u0019LG.\u001a)bi\"\u0004")
public abstract class TahoeFileIndex
implements FileIndex,
SupportsRowIndexFilters,
SnapshotDescriptor {
    private final SparkSession spark;
    private final DeltaLog deltaLog;
    private final Path path;

    @Override
    public StructType schema() {
        return SnapshotDescriptor.schema$(this);
    }

    @Override
    public Option<Map<String, RowIndexFilterType>> rowIndexFilters() {
        return SupportsRowIndexFilters.rowIndexFilters$(this);
    }

    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$((FileIndex)this);
    }

    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public Path path() {
        return this.path;
    }

    public Seq<Path> rootPaths() {
        Path path = this.path();
        return Nil$.MODULE$.$colon$colon((Object)path);
    }

    public abstract Seq<AddFile> matchingFiles(Seq<Expression> var1, Seq<Expression> var2);

    private Seq<Tuple2<InternalRow, Seq<AddFile>>> convertPartitionsToInternalRow(Seq<Tuple2<Map<String, String>, Seq<AddFile>>> partitions) {
        return (Seq)partitions.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Map partitionValues = (Map)tuple2._1();
                Seq addFiles = (Seq)tuple2._2();
                return new Tuple2((Object)this.getPartitionValuesRow((Map<String, String>)partitionValues), (Object)addFiles);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Tuple2<Seq<Tuple2<InternalRow, Seq<AddFile>>>, Seq<AddFile>> listPartitionsAsAddFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        Seq<AddFile> matchedFiles = this.matchingFiles(partitionFilters, dataFilters);
        Map partitionValuesToFiles = matchedFiles.groupBy((Function1 & Serializable)x$1 -> x$1.partitionValues());
        return new Tuple2(this.convertPartitionsToInternalRow((Seq<Tuple2<Map<String, String>, Seq<AddFile>>>)partitionValuesToFiles.toSeq()), matchedFiles);
    }

    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        Map<Map<String, String>, Seq<AddFile>> partitionValuesToFiles = this.listAddFiles(partitionFilters, dataFilters);
        return this.makePartitionDirectories(this.convertPartitionsToInternalRow((Seq<Tuple2<Map<String, String>, Seq<AddFile>>>)partitionValuesToFiles.toSeq()));
    }

    private Map<Map<String, String>, Seq<AddFile>> listAddFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        return this.matchingFiles(partitionFilters, dataFilters).groupBy((Function1 & Serializable)x$2 -> x$2.partitionValues());
    }

    public FileStatusWithMetadata fileStatusWithMetadataFromAddFile(AddFile addFile) {
        BoxedUnit boxedUnit;
        FileStatus fs = new FileStatus(addFile.size(), false, 0, 1L, addFile.modificationTime(), this.absolutePath(addFile.path()));
        scala.collection.mutable.Map metadata = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        addFile.baseRowId().foreach((Function1 & Serializable)baseRowId -> metadata.put((Object)RowId$.MODULE$.BASE_ROW_ID(), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)baseRowId))));
        addFile.defaultRowCommitVersion().foreach((Function1 & Serializable)defaultRowCommitVersion -> metadata.put((Object)DefaultRowCommitVersion$.MODULE$.METADATA_STRUCT_FIELD_NAME(), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)defaultRowCommitVersion))));
        if (addFile.deletionVector() != null) {
            metadata.put((Object)DeltaParquetFileFormat$.MODULE$.FILE_ROW_INDEX_FILTER_ID_ENCODED(), (Object)addFile.deletionVector().serializeToBase64());
            RowIndexFilterType filterType = (RowIndexFilterType)((Object)((MapOps)this.rowIndexFilters().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).getOrElse((Object)addFile.path(), (Function0 & Serializable)() -> RowIndexFilterType.IF_CONTAINED));
            boxedUnit = metadata.put((Object)DeltaParquetFileFormat$.MODULE$.FILE_ROW_INDEX_FILTER_TYPE(), (Object)filterType);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new FileStatusWithMetadata(fs, metadata.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Seq<PartitionDirectory> makePartitionDirectories(Seq<Tuple2<InternalRow, Seq<AddFile>>> partitionValuesToFiles) {
        String timeZone = this.spark().sessionState().conf().sessionLocalTimeZone();
        return (Seq)partitionValuesToFiles.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                InternalRow partitionValues = (InternalRow)tuple2._1();
                Seq files = (Seq)tuple2._2();
                FileStatusWithMetadata[] fileStatuses = (FileStatusWithMetadata[])((IterableOnceOps)files.map((Function1 & Serializable)f -> this.fileStatusWithMetadataFromAddFile((AddFile)f))).toArray(ClassTag$.MODULE$.apply(FileStatusWithMetadata.class));
                return new PartitionDirectory(partitionValues, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)fileStatuses));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public GenericInternalRow getPartitionValuesRow(Map<String, String> partitionValues) {
        String timeZone = this.spark().sessionState().conf().sessionLocalTimeZone();
        Object[] partitionRowValues = (Object[])((IterableOnceOps)this.partitionSchema().map((Function1 & Serializable)p -> {
            String colName = DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)p);
            Literal partValue = Literal$.MODULE$.apply(partitionValues.get((Object)colName).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            Cast qual$1 = Cast$.MODULE$.apply((Expression)partValue, p.dataType(), Option$.MODULE$.apply((Object)timeZone), false);
            InternalRow x$1 = qual$1.eval$default$1();
            return qual$1.eval(x$1);
        })).toArray(ClassTag$.MODULE$.Any());
        return new GenericInternalRow(partitionRowValues);
    }

    public StructType partitionSchema() {
        return this.metadata().partitionSchema();
    }

    public Path absolutePath(String child) {
        Path p = new Path(new URI(child));
        if (p.isAbsolute()) {
            return p;
        }
        return new Path(this.path(), p);
    }

    public String toString() {
        String truncatedPath = this.truncateRight(this.path().toString(), 100);
        return new StringBuilder(17).append("Delta[version=").append(this.version()).append(", ").append(truncatedPath).append("]").toString();
    }

    private String truncateRight(String input, int len) {
        if (input.length() > len) {
            return new StringBuilder(4).append("... ").append(StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(input), len)).toString();
        }
        return input;
    }

    public Option<Path> getBasePath(Path filePath) {
        return new Some((Object)this.path());
    }

    public TahoeFileIndex(SparkSession spark, DeltaLog deltaLog, Path path) {
        this.spark = spark;
        this.deltaLog = deltaLog;
        this.path = path;
        FileIndex.$init$((FileIndex)this);
        SupportsRowIndexFilters.$init$(this);
        SnapshotDescriptor.$init$(this);
    }
}

