/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import com.fasterxml.jackson.module.scala.ScalaObjectMapper;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.sources.DeltaSourceOffset;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DeltaSourceOffset$
implements Logging,
Serializable {
    public static final DeltaSourceOffset$ MODULE$ = new DeltaSourceOffset$();
    private static final int VERSION_1;
    private static final int VERSION_2;
    private static final int VERSION_3;
    private static final int CURRENT_VERSION;
    private static final long BASE_INDEX_V3;
    private static final long BASE_INDEX_V1;
    private static final long BASE_INDEX;
    private static final long METADATA_CHANGE_INDEX;
    private static final long POST_METADATA_CHANGE_INDEX;
    private static final long END_INDEX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        VERSION_1 = 1;
        VERSION_2 = 2;
        VERSION_3 = 3;
        CURRENT_VERSION = MODULE$.VERSION_3();
        BASE_INDEX_V3 = -100L;
        BASE_INDEX_V1 = -1L;
        BASE_INDEX = MODULE$.BASE_INDEX_V3();
        METADATA_CHANGE_INDEX = -20L;
        POST_METADATA_CHANGE_INDEX = -19L;
        END_INDEX = 9223372036854775707L;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int VERSION_1() {
        return VERSION_1;
    }

    public int VERSION_2() {
        return VERSION_2;
    }

    public int VERSION_3() {
        return VERSION_3;
    }

    public int CURRENT_VERSION() {
        return CURRENT_VERSION;
    }

    public long BASE_INDEX_V3() {
        return BASE_INDEX_V3;
    }

    public long BASE_INDEX_V1() {
        return BASE_INDEX_V1;
    }

    public long BASE_INDEX() {
        return BASE_INDEX;
    }

    public long METADATA_CHANGE_INDEX() {
        return METADATA_CHANGE_INDEX;
    }

    public long POST_METADATA_CHANGE_INDEX() {
        return POST_METADATA_CHANGE_INDEX;
    }

    public long END_INDEX() {
        return END_INDEX;
    }

    public DeltaSourceOffset apply(String reservoirId, long reservoirVersion, long index, boolean isInitialSnapshot) {
        return new DeltaSourceOffset(reservoirId, reservoirVersion, index, isInitialSnapshot);
    }

    public DeltaSourceOffset apply(String reservoirId, Offset offset) {
        Offset offset2 = offset;
        if (offset2 instanceof DeltaSourceOffset) {
            DeltaSourceOffset deltaSourceOffset = (DeltaSourceOffset)offset2;
            return deltaSourceOffset;
        }
        DeltaSourceOffset o = (DeltaSourceOffset)((ScalaObjectMapper)JsonUtils$.MODULE$.mapper()).readValue(offset2.json(), ManifestFactory$.MODULE$.classType(DeltaSourceOffset.class));
        String string = o.reservoirId();
        String string2 = reservoirId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw DeltaErrors$.MODULE$.differentDeltaTableReadByStreamingSource(reservoirId, o.reservoirId());
        }
        return o;
    }

    public void validateOffsets(DeltaSourceOffset previousOffset, DeltaSourceOffset currentOffset) {
        if (!previousOffset.isInitialSnapshot() && currentOffset.isInitialSnapshot()) {
            throw new IllegalStateException(new StringBuilder(85).append("Found invalid offsets: 'isInitialSnapshot' flipped incorrectly. ").append("Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
        if (previousOffset.reservoirVersion() > currentOffset.reservoirVersion()) {
            throw new IllegalStateException(new StringBuilder(75).append("Found invalid offsets: 'reservoirVersion' moved back. ").append("Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
        if (previousOffset.reservoirVersion() == currentOffset.reservoirVersion() && previousOffset.index() > currentOffset.index()) {
            throw new IllegalStateException(new StringBuilder(64).append("Found invalid offsets. 'index' moved back. ").append("Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
    }

    public boolean isMetadataChangeIndex(long index) {
        return index == this.METADATA_CHANGE_INDEX() || index == this.POST_METADATA_CHANGE_INDEX();
    }

    public Option<Tuple4<String, Object, Object, Object>> unapply(DeltaSourceOffset x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.reservoirId(), (Object)BoxesRunTime.boxToLong((long)x$0.reservoirVersion()), (Object)BoxesRunTime.boxToLong((long)x$0.index()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isInitialSnapshot())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeltaSourceOffset$.class);
    }

    private DeltaSourceOffset$() {
    }
}

