/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.stats;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.DeltaUDF$;
import org.apache.spark.sql.delta.stats.DeletedRecordCountsHistogram;
import org.apache.spark.sql.delta.stats.DeletedRecordCountsHistogram$;
import org.apache.spark.sql.delta.stats.DeletedRecordCountsHistogramUtils;
import org.apache.spark.sql.delta.stats.DeletedRecordCountsHistogramUtils$DeletedRecordCountsHistogramAgg$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Searching;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class DeletedRecordCountsHistogramUtils$ {
    public static final DeletedRecordCountsHistogramUtils$ MODULE$ = new DeletedRecordCountsHistogramUtils$();
    private static UserDefinedFunction HistogramAggrToHistogramUDF;
    private static final IndexedSeq<Object> BUCKET_BOUNDARIES;
    private static final int NUMBER_OF_BINS;
    private static volatile boolean bitmap$0;

    static {
        BUCKET_BOUNDARIES = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, Integer.MAX_VALUE, Long.MAX_VALUE}));
        NUMBER_OF_BINS = MODULE$.BUCKET_BOUNDARIES().length() - 1;
    }

    public IndexedSeq<Object> BUCKET_BOUNDARIES() {
        return BUCKET_BOUNDARIES;
    }

    public int NUMBER_OF_BINS() {
        return NUMBER_OF_BINS;
    }

    public long[] getDefaultBins() {
        return (long[])Array$.MODULE$.fill(this.NUMBER_OF_BINS(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
    }

    public DeletedRecordCountsHistogram emptyHistogram() {
        return DeletedRecordCountsHistogram$.MODULE$.apply(this.getDefaultBins());
    }

    public int getHistogramBin(long dvCardinality) {
        Predef$.MODULE$.require(dvCardinality >= 0L);
        if (dvCardinality == Long.MAX_VALUE) {
            return this.NUMBER_OF_BINS() - 1;
        }
        Searching.SearchResult searchResult = this.BUCKET_BOUNDARIES().search((Object)BoxesRunTime.boxToLong((long)dvCardinality), (Ordering)Ordering.Long$.MODULE$);
        if (searchResult instanceof Searching.Found) {
            Searching.Found found = (Searching.Found)searchResult;
            int index = found.foundIndex();
            return index;
        }
        if (searchResult instanceof Searching.InsertionPoint) {
            Searching.InsertionPoint insertionPoint = (Searching.InsertionPoint)searchResult;
            int insertionPoint2 = insertionPoint.insertionPoint();
            return insertionPoint2 - 1;
        }
        throw new MatchError((Object)searchResult);
    }

    private UserDefinedFunction HistogramAggrToHistogramUDF$lzycompute() {
        DeletedRecordCountsHistogramUtils$ deletedRecordCountsHistogramUtils$ = this;
        synchronized (deletedRecordCountsHistogramUtils$) {
            if (!bitmap$0) {
                HistogramAggrToHistogramUDF = DeltaUDF$.MODULE$.deletedRecordCountsHistogramFromArrayLong((Function1<long[], DeletedRecordCountsHistogram>)(Function1 & Serializable)deletedRecordCountsHistogramArray -> new DeletedRecordCountsHistogram((long[])deletedRecordCountsHistogramArray));
                bitmap$0 = true;
            }
        }
        return HistogramAggrToHistogramUDF;
    }

    private UserDefinedFunction HistogramAggrToHistogramUDF() {
        if (!bitmap$0) {
            return this.HistogramAggrToHistogramUDF$lzycompute();
        }
        return HistogramAggrToHistogramUDF;
    }

    public Column histogramAggregate(Column dvCardinalityExpr) {
        Column aggregate = Column$.MODULE$.apply((Expression)new DeletedRecordCountsHistogramUtils.DeletedRecordCountsHistogramAgg(dvCardinalityExpr.expr(), DeletedRecordCountsHistogramUtils$DeletedRecordCountsHistogramAgg$.MODULE$.apply$default$2(), DeletedRecordCountsHistogramUtils$DeletedRecordCountsHistogramAgg$.MODULE$.apply$default$3()).toAggregateExpression());
        return this.HistogramAggrToHistogramUDF().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{aggregate}));
    }

    private DeletedRecordCountsHistogramUtils$() {
    }
}

