/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.stats;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.sql.delta.stats.FileSizeHistogram$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\r\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011!\u0019\u0006A!f\u0001\n\u0003q\u0005\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011B(\t\u000bU\u0003A\u0011\u0001,\t\u000bQ\u0004A\u0011I;\t\u000be\u0004A\u0011\t>\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001\"CA\u000e\u0001\u0005\u0005I\u0011AA\u000f\u0011%\t)\u0003AI\u0001\n\u0003\t9\u0003C\u0005\u0002<\u0001\t\n\u0011\"\u0001\u0002>!I\u0011\u0011\t\u0001\u0012\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003\u0007\u0002\u0011\u0011!C!\u0003\u000bB\u0011\"!\u0014\u0001\u0003\u0003%\t!a\u0014\t\u0013\u0005E\u0003!!A\u0005\u0002\u0005M\u0003\"CA-\u0001\u0005\u0005I\u0011IA.\u0011%\tI\u0007AA\u0001\n\u0003\tY\u0007C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0013qO\u0004\t\u0003s\n\u0003\u0012A\u0012\u0002|\u00199\u0001%\tE\u0001G\u0005u\u0004BB+\u0019\t\u0003\tI\tC\u0004\u0002\fb!\t!!$\t\u000f\u0005M\u0005\u0004\"\u0001\u0002\u0016\"Q\u0011\u0011\u0014\r\t\u0006\u0004%\t!a'\t\u0013\u0005M\u0005$!A\u0005\u0002\u0006%\u0006\"CAY1\u0005\u0005I\u0011QAZ\u0011%\t)\rGA\u0001\n\u0013\t9MA\tGS2,7+\u001b>f\u0011&\u001cHo\\4sC6T!AI\u0012\u0002\u000bM$\u0018\r^:\u000b\u0005\u0011*\u0013!\u00023fYR\f'B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011\u0003\u0002\u00010ka\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0007C\u0001\u00197\u0013\t9\u0014GA\u0004Qe>$Wo\u0019;\u0011\u0005e\neB\u0001\u001e@\u001d\tYd(D\u0001=\u0015\tiT&\u0001\u0004=e>|GOP\u0005\u0002e%\u0011\u0001)M\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00115I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Ac\u0005\u00192o\u001c:uK\u0012\u0014\u0015N\u001c\"pk:$\u0017M]5fgV\ta\tE\u0002:\u000f&K!\u0001S\"\u0003\u0015%sG-\u001a=fIN+\u0017\u000f\u0005\u00021\u0015&\u00111*\r\u0002\u0005\u0019>tw-\u0001\u000bt_J$X\r\u001a\"j]\n{WO\u001c3be&,7\u000fI\u0001\u000bM&dWmQ8v]R\u001cX#A(\u0011\u0007A\u0002\u0016*\u0003\u0002Rc\t)\u0011I\u001d:bs\u0006Ya-\u001b7f\u0007>,h\u000e^:!\u0003)!x\u000e^1m\u0005f$Xm]\u0001\fi>$\u0018\r\u001c\"zi\u0016\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0005/f\u00138\u000f\u0005\u0002Y\u00015\t\u0011\u0005C\u0003E\u000f\u0001\u0007a\t\u000b\u0003Z7&T\u0007C\u0001/h\u001b\u0005i&B\u00010`\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003A\u0006\f\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003E\u000e\fqA[1dWN|gN\u0003\u0002eK\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0002M\u0006\u00191m\\7\n\u0005!l&a\u0004&t_:$Um]3sS\u0006d\u0017N_3\u0002\u0013\r|g\u000e^3oi\u0006\u001b8%A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001\u00027b]\u001eT\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002L[\")Qj\u0002a\u0001\u001f\")1k\u0002a\u0001\u001f\u0006A\u0001.Y:i\u0007>$W\rF\u0001w!\t\u0001t/\u0003\u0002yc\t\u0019\u0011J\u001c;\u0002\r\u0015\fX/\u00197t)\tYh\u0010\u0005\u00021y&\u0011Q0\r\u0002\b\u0005>|G.Z1o\u0011\u0019y\u0018\u00021\u0001\u0002\u0002\u0005!A\u000f[1u!\r\u0001\u00141A\u0005\u0004\u0003\u000b\t$aA!os\u00061\u0011N\\:feR$B!a\u0003\u0002\u0012A\u0019\u0001'!\u0004\n\u0007\u0005=\u0011G\u0001\u0003V]&$\bBBA\n\u0015\u0001\u0007\u0011*\u0001\u0005gS2,7+\u001b>f\u0003\u0019\u0011X-\\8wKR!\u00111BA\r\u0011\u0019\t\u0019b\u0003a\u0001\u0013\u0006!1m\u001c9z)\u001d9\u0016qDA\u0011\u0003GAq\u0001\u0012\u0007\u0011\u0002\u0003\u0007a\tC\u0004N\u0019A\u0005\t\u0019A(\t\u000fMc\u0001\u0013!a\u0001\u001f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0015U\r1\u00151F\u0016\u0003\u0003[\u0001B!a\f\u000285\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$A\u0005v]\u000eDWmY6fI*\u0011a,M\u0005\u0005\u0003s\t\tDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002@)\u001aq*a\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0012\u0011\u00071\fI%C\u0002\u0002L5\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001<\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011AA+\u0011!\t9FEA\u0001\u0002\u00041\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002^A1\u0011qLA3\u0003\u0003i!!!\u0019\u000b\u0007\u0005\r\u0014'\u0001\u0006d_2dWm\u0019;j_:LA!a\u001a\u0002b\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rY\u0018Q\u000e\u0005\n\u0003/\"\u0012\u0011!a\u0001\u0003\u0003\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qIA:\u0011!\t9&FA\u0001\u0002\u00041\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0013!\u0005$jY\u0016\u001c\u0016N_3ISN$xn\u001a:b[B\u0011\u0001\fG\n\u00051=\ny\b\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\r\t)i\\\u0001\u0003S>L1AQAB)\t\tY(A\u0006hKR\u0014\u0015N\\%oI\u0016DH#\u0002<\u0002\u0010\u0006E\u0005BBA\n5\u0001\u0007\u0011\nC\u0003E5\u0001\u0007a)A\u0003baBd\u0017\u0010F\u0002X\u0003/CQ\u0001R\u000eA\u0002\u0019\u000baa]2iK6\fWCAAO!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAARK\u0005)A/\u001f9fg&!\u0011qUAQ\u0005)\u0019FO];diRK\b/\u001a\u000b\b/\u0006-\u0016QVAX\u0011\u0015!U\u00041\u0001G\u0011\u0015iU\u00041\u0001P\u0011\u0015\u0019V\u00041\u0001P\u0003\u001d)h.\u00199qYf$B!!.\u0002BB)\u0001'a.\u0002<&\u0019\u0011\u0011X\u0019\u0003\r=\u0003H/[8o!\u0019\u0001\u0014Q\u0018$P\u001f&\u0019\u0011qX\u0019\u0003\rQ+\b\u000f\\34\u0011!\t\u0019MHA\u0001\u0002\u00049\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u001a\t\u0004Y\u0006-\u0017bAAg[\n1qJ\u00196fGR\u0004")
public class FileSizeHistogram
implements Product,
Serializable {
    private final IndexedSeq<Object> sortedBinBoundaries;
    private final long[] fileCounts;
    private final long[] totalBytes;

    public static Option<Tuple3<IndexedSeq<Object>, long[], long[]>> unapply(FileSizeHistogram x$0) {
        return FileSizeHistogram$.MODULE$.unapply(x$0);
    }

    public static FileSizeHistogram apply(IndexedSeq<Object> sortedBinBoundaries, long[] fileCounts, long[] totalBytes) {
        return FileSizeHistogram$.MODULE$.apply(sortedBinBoundaries, fileCounts, totalBytes);
    }

    public static StructType schema() {
        return FileSizeHistogram$.MODULE$.schema();
    }

    public static FileSizeHistogram apply(IndexedSeq<Object> sortedBinBoundaries) {
        return FileSizeHistogram$.MODULE$.apply(sortedBinBoundaries);
    }

    public static int getBinIndex(long fileSize, IndexedSeq<Object> sortedBinBoundaries) {
        return FileSizeHistogram$.MODULE$.getBinIndex(fileSize, sortedBinBoundaries);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public IndexedSeq<Object> sortedBinBoundaries() {
        return this.sortedBinBoundaries;
    }

    public long[] fileCounts() {
        return this.fileCounts;
    }

    public long[] totalBytes() {
        return this.totalBytes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.totalBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof FileSizeHistogram)) return false;
        FileSizeHistogram fileSizeHistogram = (FileSizeHistogram)object;
        IndexedSeq<Object> thatSB = fileSizeHistogram.sortedBinBoundaries();
        long[] thatFC = fileSizeHistogram.fileCounts();
        long[] thatTB = fileSizeHistogram.totalBytes();
        IndexedSeq<Object> indexedSeq = this.sortedBinBoundaries();
        IndexedSeq<Object> indexedSeq2 = thatSB;
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        if (!Arrays.equals(this.fileCounts(), thatFC)) return false;
        if (!Arrays.equals(this.totalBytes(), thatTB)) return false;
        return true;
    }

    public void insert(long fileSize) {
        int index = FileSizeHistogram$.MODULE$.getBinIndex(fileSize, this.sortedBinBoundaries());
        if (index >= 0) {
            this.fileCounts()[index] = this.fileCounts()[index] + 1L;
            this.totalBytes()[index] = this.totalBytes()[index] + fileSize;
            return;
        }
    }

    public void remove(long fileSize) {
        int index = FileSizeHistogram$.MODULE$.getBinIndex(fileSize, this.sortedBinBoundaries());
        if (index >= 0) {
            this.fileCounts()[index] = this.fileCounts()[index] - 1L;
            this.totalBytes()[index] = this.totalBytes()[index] - fileSize;
            return;
        }
    }

    public FileSizeHistogram copy(IndexedSeq<Object> sortedBinBoundaries, long[] fileCounts, long[] totalBytes) {
        return new FileSizeHistogram(sortedBinBoundaries, fileCounts, totalBytes);
    }

    public IndexedSeq<Object> copy$default$1() {
        return this.sortedBinBoundaries();
    }

    public long[] copy$default$2() {
        return this.fileCounts();
    }

    public long[] copy$default$3() {
        return this.totalBytes();
    }

    public String productPrefix() {
        return "FileSizeHistogram";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sortedBinBoundaries();
            }
            case 1: {
                return this.fileCounts();
            }
            case 2: {
                return this.totalBytes();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FileSizeHistogram;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "sortedBinBoundaries";
            }
            case 1: {
                return "fileCounts";
            }
            case 2: {
                return "totalBytes";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public FileSizeHistogram(@JsonDeserialize(contentAs=Long.class) IndexedSeq<Object> sortedBinBoundaries, long[] fileCounts, long[] totalBytes) {
        this.sortedBinBoundaries = sortedBinBoundaries;
        this.fileCounts = fileCounts;
        this.totalBytes = totalBytes;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(sortedBinBoundaries.nonEmpty());
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)sortedBinBoundaries.head()) == 0L, (Function0 & Serializable)() -> "The first bin should start from 0");
        Predef$.MODULE$.require(sortedBinBoundaries.length() == fileCounts.length, (Function0 & Serializable)() -> "number of binBoundaries should be same as size of fileCounts");
        Predef$.MODULE$.require(sortedBinBoundaries.length() == totalBytes.length, (Function0 & Serializable)() -> "number of binBoundaries should be same as size of totalBytes");
    }
}

