/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitInfo$;
import org.apache.spark.sql.delta.actions.CommitMarker;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.storage.ClosableIterator;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DeltaCommitFileProvider;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.FileNames$DeltaFile$;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DeltaHistoryManager$
implements DeltaLogging {
    public static final DeltaHistoryManager$ MODULE$ = new DeltaHistoryManager$();
    private static DeltaThreadPool threadPool;
    private static final int POTENTIALLY_UNMONOTONIZED_TIMESTAMPS;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        LoggingShims.$init$(MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        POTENTIALLY_UNMONOTONIZED_TIMESTAMPS = 100;
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int $lessinit$greater$default$2() {
        return 1000;
    }

    private DeltaThreadPool threadPool$lzycompute() {
        DeltaHistoryManager$ deltaHistoryManager$ = this;
        synchronized (deltaHistoryManager$) {
            if (!bitmap$0) {
                threadPool = DeltaThreadPool$.MODULE$.apply("delta-history-manager", BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(DeltaSQLConf$.MODULE$.DELTA_HISTORY_MANAGER_THREAD_POOL_SIZE())));
                bitmap$0 = true;
            }
        }
        return threadPool;
    }

    public DeltaThreadPool threadPool() {
        if (!bitmap$0) {
            return this.threadPool$lzycompute();
        }
        return threadPool;
    }

    public Option<CommitInfo> getCommitInfoOpt(LogStore logStore, Path deltaFile, Configuration hadoopConf) {
        Option option;
        try (ClosableIterator<String> logs = logStore.readAsIterator(deltaFile, hadoopConf);){
            option = logs.map((Function1 & Serializable)json -> Action$.MODULE$.fromJson((String)json)).collectFirst((PartialFunction)new Serializable(deltaFile){
                private static final long serialVersionUID = 0L;
                private final Path deltaFile$1;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof CommitInfo) {
                        CommitInfo commitInfo = (CommitInfo)A1;
                        return (B1)commitInfo.copy((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)FileNames$.MODULE$.deltaVersion(this.deltaFile$1))), commitInfo.copy$default$2(), commitInfo.copy$default$3(), commitInfo.copy$default$4(), commitInfo.copy$default$5(), commitInfo.copy$default$6(), commitInfo.copy$default$7(), commitInfo.copy$default$8(), commitInfo.copy$default$9(), commitInfo.copy$default$10(), commitInfo.copy$default$11(), commitInfo.copy$default$12(), commitInfo.copy$default$13(), commitInfo.copy$default$14(), commitInfo.copy$default$15(), commitInfo.copy$default$16(), commitInfo.copy$default$17(), commitInfo.copy$default$18());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    return action instanceof CommitInfo;
                }
                {
                    this.deltaFile$1 = deltaFile$1;
                }
            });
        }
        return option;
    }

    public long getEarliestDeltaFile(DeltaLog deltaLog) {
        return BoxesRunTime.unboxToLong((Object)deltaLog.store().listFrom(FileNames$.MODULE$.listingPrefix(deltaLog.logPath(), 0L), deltaLog.newDeltaHadoopConf()).collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple2<FileStatus, Object>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(A1)).isEmpty()) {
                    long version = ((Tuple2)option.get())._2$mcJ$sp();
                    return (B1)BoxesRunTime.boxToLong((long)version);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                Option<Tuple2<FileStatus, Object>> option;
                FileStatus fileStatus = x1;
                return fileStatus != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(fileStatus)).isEmpty();
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw DeltaErrors$.MODULE$.noHistoryFound(deltaLog.logPath());
        }));
    }

    public Option<DeltaHistoryManager.Commit> org$apache$spark$sql$delta$DeltaHistoryManager$$getCommitWithInCommitTimestamp(long version, FileStatus commitFileStatus, LogStore logStore, Configuration conf) {
        None$ none$;
        try (ClosableIterator<String> logs = logStore.readAsIterator(commitFileStatus, conf);){
            try {
                Option ci = logs.map((Function1 & Serializable)json -> Action$.MODULE$.fromJson((String)json)).collectFirst((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof CommitInfo) {
                            CommitInfo commitInfo = (CommitInfo)A1;
                            return (B1)commitInfo;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Action x1) {
                        Action action = x1;
                        return action instanceof CommitInfo;
                    }
                });
                none$ = new Some((Object)new DeltaHistoryManager.Commit(version, CommitInfo$.MODULE$.getRequiredInCommitTimestamp((Option<CommitInfo>)ci, Long.toString(version))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public Option<DeltaHistoryManager.Commit> getFirstCommitAndICTAfter(long version, long upperBoundExclusive, Path basePath, LogStore logStore, Configuration conf, DeltaCommitFileProvider commitFileProvider) {
        Option<CommitInfo> commitInfoOpt;
        Option<CommitInfo> option;
        Path deltaFile = commitFileProvider.deltaFile(version);
        try {
            option = this.getCommitInfoOpt(logStore, deltaFile, conf);
        }
        catch (FileNotFoundException fileNotFoundException) {
            option = commitInfoOpt = None$.MODULE$;
        }
        if (commitInfoOpt.isDefined()) {
            long timestamp = CommitInfo$.MODULE$.getRequiredInCommitTimestamp(commitInfoOpt, Long.toString(version));
            return new Some((Object)new DeltaHistoryManager.Commit(version, timestamp));
        }
        if (version >= commitFileProvider.minUnbackfilledVersion()) {
            throw new IllegalStateException(new StringBuilder(57).append("Could not find commit ").append(version).append(" which was expected to be at path ").append(deltaFile.toString()).append(".").toString());
        }
        return logStore.listFrom(FileNames$.MODULE$.listingPrefix(basePath, version), conf).takeWhile((Function1 & Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager$.$anonfun$getFirstCommitAndICTAfter$1(upperBoundExclusive, fs))).collectFirst((PartialFunction)new Serializable(logStore, conf){
            private static final long serialVersionUID = 0L;
            private final LogStore logStore$2;
            private final Configuration conf$2;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple2<FileStatus, Object>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(A1)).isEmpty()) {
                    FileStatus f = (FileStatus)((Tuple2)option.get())._1();
                    long v = ((Tuple2)option.get())._2$mcJ$sp();
                    return (B1)DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$getCommitWithInCommitTimestamp(v, f, this.logStore$2, this.conf$2);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                Option<Tuple2<FileStatus, Object>> option;
                FileStatus fileStatus = x1;
                return fileStatus != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(fileStatus)).isEmpty();
            }
            {
                this.logStore$2 = logStore$2;
                this.conf$2 = conf$2;
            }
        }).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<DeltaHistoryManager.Commit> getActiveCommitAtTimeFromICTRange(long searchTimestamp, DeltaHistoryManager.Commit startCommit, long end, Configuration conf, Path basePath, LogStore logStore, long numChunks, SparkSession spark, DeltaCommitFileProvider commitFileProvider) {
        Option option;
        Object object = new Object();
        try {
            Predef$.MODULE$.require(startCommit.version() < end, (Function0 & Serializable)() -> "start must be less than end");
            ObjectRef curStartCommit = ObjectRef.create((Object)startCommit);
            LongRef curEnd = LongRef.create((long)end);
            while (((DeltaHistoryManager.Commit)curStartCommit.elem).version() < curEnd.elem) {
                DeltaHistoryManager.Commit knownTightestLowerBoundCommit;
                long numVersionsInRange = curEnd.elem - ((DeltaHistoryManager.Commit)curStartCommit.elem).version();
                long chunkSize = scala.math.package$.MODULE$.max(numVersionsInRange / numChunks, 1L);
                IndexedSeq chunkStartICTFutures = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(((DeltaHistoryManager.Commit)curStartCommit.elem).version())).until((Object)BoxesRunTime.boxToLong((long)curEnd.elem)).by((Object)BoxesRunTime.boxToLong((long)chunkSize)).map((Function1 & Serializable)chunkStart -> DeltaHistoryManager$.$anonfun$getActiveCommitAtTimeFromICTRange$2(curStartCommit, spark, basePath, logStore, conf, commitFileProvider, chunkSize, curEnd, BoxesRunTime.unboxToLong((Object)chunkStart)));
                DeltaHistoryManager.Commit nextStartCommit = knownTightestLowerBoundCommit = (DeltaHistoryManager.Commit)((IterableOps)((IterableOps)((IterableOps)chunkStartICTFutures.map((Function1 & Serializable)x$5 -> (Option)ThreadUtils$.MODULE$.awaitResult(x$5, (Duration)Duration$.MODULE$.Inf()))).takeWhile((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager$.$anonfun$getActiveCommitAtTimeFromICTRange$6(searchTimestamp$1, x$7)))))).flatten(Predef$.MODULE$.$conforms())).lastOption().getOrElse((Function0 & Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                long nextEnd = DeltaHistoryManager$.getChunkEnd$1(nextStartCommit.version(), chunkSize, curEnd);
                if (nextStartCommit.version() + 2L > nextEnd || knownTightestLowerBoundCommit.timestamp() == searchTimestamp) {
                    return new Some((Object)knownTightestLowerBoundCommit);
                }
                curStartCommit.elem = nextStartCommit;
                curEnd.elem = nextEnd;
            }
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public int POTENTIALLY_UNMONOTONIZED_TIMESTAMPS() {
        return POTENTIALLY_UNMONOTONIZED_TIMESTAMPS;
    }

    public DeltaHistoryManager.Commit[] getCommitsWithNonIctTimestamps(LogStore logStore, Path logPath, long start, Option<Object> end, Configuration hadoopConf) {
        long until = BoxesRunTime.unboxToLong((Object)end.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> Long.MAX_VALUE));
        Iterator commits = logStore.listFrom(FileNames$.MODULE$.listingPrefix(logPath, start), hadoopConf).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple2<FileStatus, Object>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(A1)).isEmpty()) {
                    FileStatus file = (FileStatus)((Tuple2)option.get())._1();
                    long version = ((Tuple2)option.get())._2$mcJ$sp();
                    return (B1)new DeltaHistoryManager.Commit(version, file.getModificationTime());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                Option<Tuple2<FileStatus, Object>> option;
                FileStatus fileStatus = x1;
                return fileStatus != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(fileStatus)).isEmpty();
            }
        }).takeWhile((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager$.$anonfun$getCommitsWithNonIctTimestamps$2(until, x$8)));
        return (DeltaHistoryManager.Commit[])this.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps((CommitMarker[])commits.toArray(ClassTag$.MODULE$.apply(DeltaHistoryManager.Commit.class)));
    }

    public <T extends CommitMarker> T[] org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps(T[] commits) {
        IntRef i = IntRef.create((int)0);
        int length = commits.length;
        while (i.elem < length - 1) {
            long prevTimestamp = commits[i.elem].getTimestamp();
            Predef$.MODULE$.assert(commits[i.elem].getVersion() < commits[i.elem + 1].getVersion(), (Function0 & Serializable)() -> "Unordered commits provided.");
            if (prevTimestamp >= commits[i.elem + 1].getTimestamp()) {
                this.logWarning(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found Delta commit ", " "}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VERSION(), BoxesRunTime.boxToLong((long)commits[i$1.elem].getVersion()))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with a timestamp ", " "}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.TIMESTAMP(), BoxesRunTime.boxToLong((long)prevTimestamp))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"which is greater than the next commit timestamp "}))).log((Seq<MDC>)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "."}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.TIMESTAMP2(), BoxesRunTime.boxToLong((long)commits[i$1.elem + 1].getTimestamp()))})))));
                commits[i.elem + 1] = commits[i.elem + 1].withTimestamp(prevTimestamp + 1L);
            }
            ++i.elem;
        }
        return commits;
    }

    public DeltaHistoryManager.Commit org$apache$spark$sql$delta$DeltaHistoryManager$$parallelSearch0(SparkSession spark, SerializableConfiguration conf, String logPath, long time, long start, long end, long step) {
        DeltaHistoryManager.Commit[] possibleCommits = (DeltaHistoryManager.Commit[])spark.range(start, end, step).mapPartitions((Function1 & Serializable)startVersions -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), conf.value());
            Path basePath = new Path(logPath);
            return startVersions.map((Function1 & Serializable)startVersion -> {
                DeltaHistoryManager.Commit[] commits = MODULE$.getCommitsWithNonIctTimestamps(logStore, basePath, Predef$.MODULE$.Long2long(startVersion), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.min(Predef$.MODULE$.Long2long(startVersion) + step, end))), conf.value());
                return (DeltaHistoryManager.Commit)MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<DeltaHistoryManager.Commit>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)commits), time).getOrElse((Function0 & Serializable)() -> (DeltaHistoryManager.Commit)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])commits)));
            });
        }, package$.MODULE$.historyCommitEncoder()).collect();
        DeltaHistoryManager.Commit[] commitList = (DeltaHistoryManager.Commit[])this.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps(possibleCommits);
        return (DeltaHistoryManager.Commit)this.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<DeltaHistoryManager.Commit>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)commitList), time).getOrElse((Function0 & Serializable)() -> (DeltaHistoryManager.Commit)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])commitList)));
    }

    public Option<DeltaHistoryManager.Commit> org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp(Seq<DeltaHistoryManager.Commit> commits, long time) {
        int i = commits.lastIndexWhere((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager$.$anonfun$lastCommitBeforeTimestamp$1(time, x$9)));
        if (i < 0) {
            return None$.MODULE$;
        }
        return new Some(commits.apply(i));
    }

    public static final /* synthetic */ boolean $anonfun$getFirstCommitAndICTAfter$1(long upperBoundExclusive$1, FileStatus fs) {
        return FileNames$.MODULE$.getFileVersionOpt(fs.getPath()).forall((Function1)(JFunction1.mcZJ.sp & Serializable)x$4 -> x$4 < upperBoundExclusive$1);
    }

    private static final long getChunkEnd$1(long chunkStart, long chunkSize$1, LongRef curEnd$1) {
        return scala.math.package$.MODULE$.min(chunkStart + chunkSize$1, curEnd$1.elem);
    }

    public static final /* synthetic */ Future $anonfun$getActiveCommitAtTimeFromICTRange$2(ObjectRef curStartCommit$1, SparkSession spark$1, Path basePath$1, LogStore logStore$3, Configuration conf$3, DeltaCommitFileProvider commitFileProvider$2, long chunkSize$1, LongRef curEnd$1, long chunkStart) {
        if (chunkStart == ((DeltaHistoryManager.Commit)curStartCommit$1.elem).version()) {
            return CompletableFuture.completedFuture(Option$.MODULE$.apply((Object)((DeltaHistoryManager.Commit)curStartCommit$1.elem)));
        }
        return MODULE$.threadPool().submit(spark$1, (Function0 & Serializable)() -> MODULE$.getFirstCommitAndICTAfter(chunkStart, DeltaHistoryManager$.getChunkEnd$1(chunkStart, chunkSize$1, curEnd$1), basePath$1, logStore$3, conf$3, commitFileProvider$2));
    }

    public static final /* synthetic */ boolean $anonfun$getActiveCommitAtTimeFromICTRange$6(long searchTimestamp$1, DeltaHistoryManager.Commit x$7) {
        return x$7.timestamp() <= searchTimestamp$1;
    }

    public static final /* synthetic */ boolean $anonfun$getCommitsWithNonIctTimestamps$2(long until$1, DeltaHistoryManager.Commit x$8) {
        return x$8.version() < until$1;
    }

    public static final /* synthetic */ boolean $anonfun$lastCommitBeforeTimestamp$1(long time$2, DeltaHistoryManager.Commit x$9) {
        return x$9.timestamp() <= time$2;
    }

    private DeltaHistoryManager$() {
    }
}

