/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class DeltaTimeTravelSpec$
implements Serializable {
    public static final DeltaTimeTravelSpec$ MODULE$ = new DeltaTimeTravelSpec$();
    private static final Regex VERSION_URI_FOR_TIME_TRAVEL = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*@[vV](\\d+)$"));
    private static final String TIMESTAMP_FORMAT = "yyyyMMddHHmmssSSS";
    private static final int TIMESTAMP_FORMAT_LENGTH = MODULE$.TIMESTAMP_FORMAT().length();
    private static final Regex TIMESTAMP_URI_FOR_TIME_TRAVEL = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(10).append(".*@(\\d{").append(MODULE$.TIMESTAMP_FORMAT_LENGTH()).append("})$").toString()));

    private Regex VERSION_URI_FOR_TIME_TRAVEL() {
        return VERSION_URI_FOR_TIME_TRAVEL;
    }

    private String TIMESTAMP_FORMAT() {
        return TIMESTAMP_FORMAT;
    }

    private int TIMESTAMP_FORMAT_LENGTH() {
        return TIMESTAMP_FORMAT_LENGTH;
    }

    private Regex TIMESTAMP_URI_FOR_TIME_TRAVEL() {
        return TIMESTAMP_URI_FOR_TIME_TRAVEL;
    }

    public boolean isApplicable(SQLConf conf, String identifier) {
        return BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.RESOLVE_TIME_TRAVEL_ON_IDENTIFIER())) && this.identifierContainsTimeTravel(identifier);
    }

    private boolean identifierContainsTimeTravel(String identifier) {
        Option option;
        Option option2;
        String string = identifier;
        if (string != null && !(option2 = this.TIMESTAMP_URI_FOR_TIME_TRAVEL().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            return true;
        }
        return string != null && !(option = this.VERSION_URI_FOR_TIME_TRAVEL().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0;
    }

    public Tuple2<DeltaTimeTravelSpec, String> resolvePath(SQLConf conf, String identifier) {
        Option option;
        Option option2;
        String string = identifier;
        if (string != null && !(option2 = this.TIMESTAMP_URI_FOR_TIME_TRAVEL().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String ts = (String)((LinearSeqOps)option2.get()).apply(0);
            Expression timestamp = this.parseTimestamp(ts, conf.sessionLocalTimeZone());
            String realIdentifier = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(identifier), this.TIMESTAMP_FORMAT_LENGTH() + 1);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new DeltaTimeTravelSpec((Option<Expression>)new Some((Object)timestamp), (Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)"atSyntax.path"))), (Object)realIdentifier);
        }
        if (string != null && !(option = this.VERSION_URI_FOR_TIME_TRAVEL().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String v = (String)((LinearSeqOps)option.get()).apply(0);
            String realIdentifier = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(identifier), v.length() + 2);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new DeltaTimeTravelSpec((Option<Expression>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(v)))), (Option<String>)new Some((Object)"atSyntax.path"))), (Object)realIdentifier);
        }
        throw new MatchError((Object)string);
    }

    private Expression parseTimestamp(String ts, String timeZone) {
        PreciseTimestampConversion preciseTimestampConversion;
        FastDateFormat format = FastDateFormat.getInstance((String)this.TIMESTAMP_FORMAT(), (TimeZone)DateTimeUtils$.MODULE$.getTimeZone(timeZone));
        try {
            long sqlTs = DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(format.parse(ts).getTime()));
            preciseTimestampConversion = new PreciseTimestampConversion((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)sqlTs)), (DataType)LongType$.MODULE$, (DataType)TimestampType$.MODULE$);
        }
        catch (ParseException e) {
            throw DeltaErrors$.MODULE$.invalidTimestampFormat(ts, this.TIMESTAMP_FORMAT(), (Option<Throwable>)new Some((Object)e));
        }
        return preciseTimestampConversion;
    }

    public DeltaTimeTravelSpec apply(Option<Expression> timestamp, Option<Object> version, Option<String> creationSource) {
        return new DeltaTimeTravelSpec(timestamp, version, creationSource);
    }

    public Option<Tuple3<Option<Expression>, Option<Object>, Option<String>>> unapply(DeltaTimeTravelSpec x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3(x$0.timestamp(), x$0.version(), x$0.creationSource()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeltaTimeTravelSpec$.class);
    }

    private DeltaTimeTravelSpec$() {
    }
}

