/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class InCommitTimestampUtils$ {
    public static final InCommitTimestampUtils$ MODULE$ = new InCommitTimestampUtils$();

    public boolean didCurrentTransactionEnableICT(Metadata currentTransactionMetadata, Snapshot readSnapshot) {
        boolean isICTCurrentlyEnabled = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMPS_ENABLED().fromMetaData(currentTransactionMetadata));
        boolean wasICTEnabledInReadSnapshot = readSnapshot.version() != -1L && BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMPS_ENABLED().fromMetaData(readSnapshot.metadata()));
        return isICTCurrentlyEnabled && !wasICTEnabledInReadSnapshot;
    }

    public Option<Metadata> getUpdatedMetadataWithICTEnablementInfo(long inCommitTimestamp, Snapshot readSnapshot, Metadata metadata, long commitVersion) {
        return Option$.MODULE$.when(this.didCurrentTransactionEnableICT(metadata, readSnapshot) && commitVersion != 0L, (Function0 & Serializable)() -> {
            Map enablementTrackingProperties = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMP_ENABLEMENT_VERSION().key()), (Object)Long.toString(commitVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMP_ENABLEMENT_TIMESTAMP().key()), (Object)Long.toString(inCommitTimestamp))}));
            Map x$1 = (Map)metadata.configuration().$plus$plus((IterableOnce)enablementTrackingProperties);
            String x$2 = metadata.copy$default$1();
            String x$3 = metadata.copy$default$2();
            String x$4 = metadata.copy$default$3();
            Format x$5 = metadata.copy$default$4();
            String x$6 = metadata.copy$default$5();
            Seq<String> x$7 = metadata.copy$default$6();
            Option<Object> x$8 = metadata.copy$default$8();
            return metadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
        });
    }

    public Option<DeltaHistoryManager.Commit> getValidatedICTEnablementInfo(Metadata metadata) {
        Option<Object> enablementVersionOpt;
        Option<Object> enablementTimestampOpt = DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMP_ENABLEMENT_TIMESTAMP().fromMetaData(metadata);
        Tuple2 tuple2 = new Tuple2(enablementTimestampOpt, enablementVersionOpt = DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMP_ENABLEMENT_VERSION().fromMetaData(metadata));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                long enablementTimestamp = BoxesRunTime.unboxToLong((Object)some.value());
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    long enablementVersion = BoxesRunTime.unboxToLong((Object)some2.value());
                    return new Some((Object)new DeltaHistoryManager.Commit(enablementVersion, enablementTimestamp));
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option3)) {
                return None$.MODULE$;
            }
        }
        throw new IllegalStateException("Both enablement version and timestamp should be present or absent together.");
    }

    private InCommitTimestampUtils$() {
    }
}

