/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeAction;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeInto;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoClause;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoMatchedClause;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoMatchedUpdateClause;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoNotMatchedBySourceClause;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoNotMatchedClause;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoNotMatchedInsertClause;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.delta.BatchedDeltaMergeActionResolver;
import org.apache.spark.sql.delta.DeltaAnalysisException;
import org.apache.spark.sql.delta.DeltaAnalysisException$;
import org.apache.spark.sql.delta.DeltaIllegalArgumentException;
import org.apache.spark.sql.delta.DeltaIllegalArgumentException$;
import org.apache.spark.sql.delta.DeltaMergeActionResolverBase;
import org.apache.spark.sql.delta.DeltaTable$;
import org.apache.spark.sql.delta.IndividualDeltaMergeActionResolver;
import org.apache.spark.sql.delta.TypeWidening$;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.schema.SchemaMergingUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;

public final class ResolveDeltaMergeInto$ {
    public static final ResolveDeltaMergeInto$ MODULE$ = new ResolveDeltaMergeInto$();

    public void throwIfNotResolved(Expression expr, Seq<LogicalPlan> plans, String mergeClauseTypeStr) {
        ((IterableOnceOps)expr.flatMap((Function1 & Serializable)x$1 -> x$1.references()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.resolved()))).foreach((Function1 & Serializable)a -> {
            String cols = new StringBuilder(8).append("columns ").append(((IterableOnceOps)((IterableOps)plans.flatMap((Function1 & Serializable)x$3 -> x$3.output())).map((Function1 & Serializable)x$4 -> x$4.sql())).mkString(", ")).toString();
            String x$1 = "DELTA_MERGE_UNRESOLVED_EXPRESSION";
            String[] x$2 = (String[])((Object[])new String[]{a.sql(), mergeClauseTypeStr, cols});
            Some x$32 = new Some((Object)a.origin());
            Option<Throwable> x$42 = DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3();
            throw new DeltaAnalysisException("DELTA_MERGE_UNRESOLVED_EXPRESSION", x$2, x$42, (Option<Origin>)x$32);
        });
    }

    public Seq<Expression> resolveOrFail(Function2<Seq<Expression>, Seq<LogicalPlan>, Seq<Expression>> resolveExprsFn, Seq<Expression> exprs, Seq<LogicalPlan> plansToResolveExprs, String mergeClauseTypeStr) {
        Seq resolvedExprs = (Seq)resolveExprsFn.apply(exprs, plansToResolveExprs);
        resolvedExprs.foreach((Function1 & Serializable)x$5 -> {
            ResolveDeltaMergeInto$.MODULE$.throwIfNotResolved(x$5, (Seq<LogicalPlan>)plansToResolveExprs, mergeClauseTypeStr);
            return BoxedUnit.UNIT;
        });
        return resolvedExprs;
    }

    public Expression resolveSingleExprOrFail(Function2<Seq<Expression>, Seq<LogicalPlan>, Seq<Expression>> resolveExprsFn, Expression expr, Seq<LogicalPlan> plansToResolveExpr, String mergeClauseTypeStr) {
        return (Expression)this.resolveOrFail(resolveExprsFn, (Seq<Expression>)new .colon.colon((Object)expr, (List)Nil$.MODULE$), plansToResolveExpr, mergeClauseTypeStr).head();
    }

    public DeltaMergeInto resolveReferencesAndSchema(DeltaMergeInto merge, SQLConf conf, Function2<Seq<Expression>, Seq<LogicalPlan>, Seq<Expression>> resolveExprsFn) {
        StructType structType;
        DeltaMergeInto deltaMergeInto = merge;
        if (deltaMergeInto == null) {
            throw new MatchError((Object)deltaMergeInto);
        }
        LogicalPlan target = deltaMergeInto.target();
        LogicalPlan source = deltaMergeInto.source();
        Expression condition = deltaMergeInto.condition();
        Seq<DeltaMergeIntoMatchedClause> matchedClauses = deltaMergeInto.matchedClauses();
        Seq<DeltaMergeIntoNotMatchedClause> notMatchedClauses = deltaMergeInto.notMatchedClauses();
        Seq<DeltaMergeIntoNotMatchedBySourceClause> notMatchedBySourceClauses = deltaMergeInto.notMatchedBySourceClauses();
        boolean withSchemaEvolution = deltaMergeInto.withSchemaEvolution();
        Tuple7 tuple7 = new Tuple7((Object)target, (Object)source, (Object)condition, matchedClauses, notMatchedClauses, notMatchedBySourceClauses, (Object)BoxesRunTime.boxToBoolean((boolean)withSchemaEvolution));
        LogicalPlan target2 = (LogicalPlan)tuple7._1();
        LogicalPlan source2 = (LogicalPlan)tuple7._2();
        Expression condition2 = (Expression)tuple7._3();
        Seq matchedClauses2 = (Seq)tuple7._4();
        Seq notMatchedClauses2 = (Seq)tuple7._5();
        Seq notMatchedBySourceClauses2 = (Seq)tuple7._6();
        boolean withSchemaEvolution2 = BoxesRunTime.unboxToBoolean((Object)tuple7._7());
        boolean canEvolveSchema = withSchemaEvolution2 || BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_SCHEMA_AUTO_MIGRATE()));
        DeltaMergeActionResolverBase mergeActionResolver = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_MERGE_ANALYSIS_BATCH_RESOLUTION())) ? new BatchedDeltaMergeActionResolver(target2, source2, conf, resolveExprsFn) : new IndividualDeltaMergeActionResolver(target2, source2, conf, resolveExprsFn);
        Expression resolvedCond = this.resolveSingleExprOrFail(resolveExprsFn, condition2, (Seq<LogicalPlan>)new .colon.colon((Object)target2, (List)new .colon.colon((Object)source2, (List)Nil$.MODULE$)), "search condition");
        Seq resolvedMatchedClauses = (Seq)matchedClauses2.map((Function1 & Serializable)x$10 -> (DeltaMergeIntoMatchedClause)ResolveDeltaMergeInto$.resolveClause$1(x$10, (Seq)new .colon.colon((Object)target2, (List)new .colon.colon((Object)source2, (List)Nil$.MODULE$)), source2, conf, canEvolveSchema, mergeActionResolver, target2, resolveExprsFn));
        Seq resolvedNotMatchedClauses = (Seq)notMatchedClauses2.map((Function1 & Serializable)x$11 -> (DeltaMergeIntoNotMatchedClause)ResolveDeltaMergeInto$.resolveClause$1(x$11, (Seq)new .colon.colon((Object)source2, (List)Nil$.MODULE$), source2, conf, canEvolveSchema, mergeActionResolver, target2, resolveExprsFn));
        Seq resolvedNotMatchedBySourceClauses = (Seq)notMatchedBySourceClauses2.map((Function1 & Serializable)x$12 -> (DeltaMergeIntoNotMatchedBySourceClause)ResolveDeltaMergeInto$.resolveClause$1(x$12, (Seq)new .colon.colon((Object)target2, (List)Nil$.MODULE$), source2, conf, canEvolveSchema, mergeActionResolver, target2, resolveExprsFn));
        if (canEvolveSchema) {
            Seq actions = (Seq)((IterableOps)resolvedMatchedClauses.$plus$plus((IterableOnce)resolvedNotMatchedClauses)).flatMap((Function1 & Serializable)x$13 -> x$13.actions());
            Seq assignments = (Seq)actions.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof DeltaMergeAction) {
                        DeltaMergeAction deltaMergeAction = (DeltaMergeAction)A1;
                        return (B1)deltaMergeAction.targetColNameParts();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    return expression instanceof DeltaMergeAction;
                }
            });
            boolean containsStarAction = actions.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDeltaMergeInto$.$anonfun$resolveReferencesAndSchema$16(x0$1)));
            StructType migrationSchema = ResolveDeltaMergeInto$.filterSchema$1(source2.schema(), (Seq)scala.package$.MODULE$.Seq().empty(), conf, assignments, containsStarAction);
            boolean allowTypeWidening = target2.exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ResolveDeltaMergeInto$.$anonfun$resolveReferencesAndSchema$21(x0$2)));
            StructType x$1 = target2.schema();
            StructType x$2 = migrationSchema;
            boolean x$3 = true;
            boolean x$4 = allowTypeWidening;
            boolean x$5 = SchemaMergingUtils$.MODULE$.mergeSchemas$default$4();
            boolean x$6 = SchemaMergingUtils$.MODULE$.mergeSchemas$default$6();
            structType = SchemaMergingUtils$.MODULE$.mergeSchemas(x$1, x$2, true, x$5, x$4, x$6);
        } else {
            structType = target2.schema();
        }
        StructType postEvolutionTargetSchema = structType;
        DeltaMergeInto resolvedMerge = new DeltaMergeInto(target2, source2, resolvedCond, (Seq<DeltaMergeIntoMatchedClause>)resolvedMatchedClauses, (Seq<DeltaMergeIntoNotMatchedClause>)resolvedNotMatchedClauses, (Seq<DeltaMergeIntoNotMatchedBySourceClause>)resolvedNotMatchedBySourceClauses, canEvolveSchema, (Option<StructType>)new Some((Object)postEvolutionTargetSchema));
        if (resolvedMerge.missingInput().nonEmpty()) {
            String missingAttributes = resolvedMerge.missingInput().mkString(",");
            String input = resolvedMerge.inputSet().mkString(",");
            String x$7 = "DELTA_MERGE_RESOLVED_ATTRIBUTE_MISSING_FROM_INPUT";
            String[] x$8 = (String[])((Object[])new String[]{missingAttributes, input, resolvedMerge.simpleString(SQLConf$.MODULE$.get().maxToStringFields())});
            Some x$9 = new Some((Object)resolvedMerge.origin());
            Option<Throwable> x$102 = DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3();
            throw new DeltaAnalysisException("DELTA_MERGE_RESOLVED_ATTRIBUTE_MISSING_FROM_INPUT", x$8, x$102, (Option<Origin>)x$9);
        }
        return resolvedMerge;
    }

    private static final Seq getActions$1(StructType currSchema, Seq qualifier, LogicalPlan source$1, SQLConf conf$1) {
        return (Seq)currSchema.flatMap((Function1 & Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                DataType struct = structField.dataType();
                if (struct instanceof StructType) {
                    StructType structType = (StructType)struct;
                    return ResolveDeltaMergeInto$.getActions$1(structType, (Seq)qualifier.$colon$plus((Object)name), source$1, conf$1);
                }
            }
            if (structField != null) {
                String name = structField.name();
                Seq nameParts = (Seq)qualifier.$colon$plus((Object)name);
                NamedExpression sourceExpr = (NamedExpression)source$1.resolve(nameParts, conf$1.resolver()).getOrElse((Function0 & Serializable)() -> {
                    throw new DeltaIllegalArgumentException("DELTA_CANNOT_RESOLVE_SOURCE_COLUMN", (String[])((Object[])new String[]{String.valueOf(new UnresolvedAttribute(nameParts).name())}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
                });
                return new .colon.colon((Object)new DeltaMergeAction((Seq<String>)nameParts, (Expression)sourceExpr, true), (List)Nil$.MODULE$);
            }
            throw new MatchError((Object)structField);
        });
    }

    private static final Seq getActions$default$2$1() {
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$resolveReferencesAndSchema$3(Expression x0$1) {
        Expression expression = x0$1;
        return expression instanceof DeltaMergeAction;
    }

    private static final DeltaMergeIntoClause resolveClause$1(DeltaMergeIntoClause clause, Seq plansToResolveAction, LogicalPlan source$1, SQLConf conf$1, boolean canEvolveSchema$1, DeltaMergeActionResolverBase mergeActionResolver$1, LogicalPlan target$1, Function2 resolveExprsFn$1) {
        String clauseType = clause.clauseType().toUpperCase(Locale.ROOT);
        String mergeClauseTypeStr = new StringBuilder(7).append(clauseType).append(" clause").toString();
        Tuple2 tuple2 = clause.actions().partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDeltaMergeInto$.$anonfun$resolveReferencesAndSchema$3(x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq deltaMergeActions = (Seq)tuple2._1();
        Seq allOtherExpressions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)deltaMergeActions, (Object)allOtherExpressions);
        Seq deltaMergeActions2 = (Seq)tuple22._1();
        Seq allOtherExpressions2 = (Seq)tuple22._2();
        Predef$.MODULE$.assert(deltaMergeActions2.isEmpty() || allOtherExpressions2.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(67).append("Cannot have DeltaMergeActions combined with other expressions in a ").append(mergeClauseTypeStr).toString());
        DeltaMergeIntoClause deltaMergeIntoClause = clause;
        boolean shouldTryUnresolvedTargetExprOnSource = (deltaMergeIntoClause instanceof DeltaMergeIntoMatchedUpdateClause ? true : deltaMergeIntoClause instanceof DeltaMergeIntoNotMatchedClause) ? canEvolveSchema$1 : false;
        Seq<DeltaMergeAction> resolvedDeltaMergeActions = mergeActionResolver$1.resolve(mergeClauseTypeStr, (Seq<LogicalPlan>)plansToResolveAction, shouldTryUnresolvedTargetExprOnSource, (Seq<DeltaMergeAction>)((Seq)deltaMergeActions2.map((Function1 & Serializable)x$8 -> (DeltaMergeAction)x$8)));
        Seq resolvedOtherExpressions = (Seq)allOtherExpressions2.flatMap((Function1 & Serializable)action -> {
            boolean bl = false;
            UnresolvedStar unresolvedStar = null;
            Expression expression = action;
            if (expression instanceof UnresolvedStar) {
                bl = true;
                unresolvedStar = (UnresolvedStar)expression;
                if (!canEvolveSchema$1) {
                    Seq unresolvedExprs = (Seq)target$1.output().map((Function1 & Serializable)attr -> UnresolvedAttribute$.MODULE$.quotedString(new StringBuilder(2).append("`").append(attr.name()).append("`").toString()));
                    Seq<Expression> resolvedExprs = MODULE$.resolveOrFail((Function2<Seq<Expression>, Seq<LogicalPlan>, Seq<Expression>>)resolveExprsFn$1, (Seq<Expression>)unresolvedExprs, (Seq<LogicalPlan>)new .colon.colon((Object)source$1, (List)Nil$.MODULE$), mergeClauseTypeStr);
                    return (IterableOnce)Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(resolvedExprs, target$1.output().map((Function1 & Serializable)x$9 -> x$9.name()))), Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms()), (Function2 & Serializable)(resolvedExpr, targetColName) -> new DeltaMergeAction((Seq<String>)new .colon.colon(targetColName, (List)Nil$.MODULE$), (Expression)resolvedExpr, true), BuildFrom$.MODULE$.buildFromIterableOps());
                }
            }
            if (bl && canEvolveSchema$1) {
                DeltaMergeIntoClause deltaMergeIntoClause = clause;
                if (deltaMergeIntoClause instanceof DeltaMergeIntoNotMatchedInsertClause) {
                    return (IterableOnce)source$1.output().map((Function1 & Serializable)attr -> new DeltaMergeAction((Seq<String>)new .colon.colon((Object)attr.name(), (List)Nil$.MODULE$), (Expression)attr, true));
                }
                if (deltaMergeIntoClause instanceof DeltaMergeIntoMatchedUpdateClause) {
                    return ResolveDeltaMergeInto$.getActions$1(source$1.schema(), (Seq)scala.package$.MODULE$.Seq().empty(), source$1, conf$1);
                }
                throw new MatchError((Object)deltaMergeIntoClause);
            }
            throw package$.MODULE$.AnalysisErrorAt((TreeNode)action).failAnalysis("INTERNAL_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)new StringBuilder(42).append("Unexpected action expression '").append(action).append("' in clause ").append(clause).toString())})));
        });
        Option resolvedCondition = clause.condition().map((Function1 & Serializable)condExpr -> MODULE$.resolveSingleExprOrFail((Function2<Seq<Expression>, Seq<LogicalPlan>, Seq<Expression>>)resolveExprsFn$1, (Expression)condExpr, (Seq<LogicalPlan>)plansToResolveAction, new StringBuilder(10).append(clauseType).append(" condition").toString()));
        return (DeltaMergeIntoClause)((TreeNode)clause).makeCopy(new Object[]{resolvedCondition, resolvedDeltaMergeActions.$plus$plus((IterableOnce)resolvedOtherExpressions)});
    }

    public static final /* synthetic */ boolean $anonfun$resolveReferencesAndSchema$16(Expression x0$1) {
        Expression expression = x0$1;
        return expression instanceof UnresolvedStar;
    }

    public static final /* synthetic */ boolean $anonfun$resolveReferencesAndSchema$18(SQLConf conf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String prefixNamePart = (String)tuple2._1();
            String pathNamePart = (String)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)conf$1.resolver().apply((Object)prefixNamePart, (Object)pathNamePart));
        }
        throw new MatchError((Object)tuple2);
    }

    private static final boolean isPrefix$1(Seq prefix, Seq path, SQLConf conf$1) {
        return prefix.length() <= path.length() && ((IterableOnceOps)prefix.zip((IterableOnce)path)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDeltaMergeInto$.$anonfun$resolveReferencesAndSchema$18(conf$1, x0$1)));
    }

    private static final boolean isEqual$1(Seq path1, Seq path2, SQLConf conf$1) {
        return path1.length() == path2.length() && ResolveDeltaMergeInto$.isPrefix$1(path1, path2, conf$1);
    }

    private static final StructType filterSchema$1(StructType sourceSchema, Seq basePath, SQLConf conf$1, Seq assignments$1, boolean containsStarAction$1) {
        return StructType$.MODULE$.apply((Seq)sourceSchema.flatMap((Function1 & Serializable)field -> {
            Seq fieldPath = (Seq)basePath.$colon$plus((Object)field.name());
            boolean bl = false;
            StructType structType = null;
            DataType dataType = field.dataType();
            if (assignments$1.exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ResolveDeltaMergeInto$.isEqual$1(x$14, fieldPath, conf$1)))) {
                return new Some(field);
            }
            if (dataType instanceof StructType) {
                bl = true;
                structType = (StructType)dataType;
                if (assignments$1.exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ResolveDeltaMergeInto$.isPrefix$1(fieldPath, x$15, conf$1)))) {
                    StructType x$1 = ResolveDeltaMergeInto$.filterSchema$1(structType, fieldPath, conf$1, assignments$1, containsStarAction$1);
                    String x$2 = field.copy$default$1();
                    boolean x$3 = field.copy$default$3();
                    Metadata x$4 = field.copy$default$4();
                    return new Some((Object)field.copy(x$2, (DataType)x$1, x$3, x$4));
                }
            }
            if (bl && containsStarAction$1) {
                StructType x$5 = ResolveDeltaMergeInto$.filterSchema$1(structType, fieldPath, conf$1, assignments$1, containsStarAction$1);
                String x$6 = field.copy$default$1();
                boolean x$7 = field.copy$default$3();
                Metadata x$8 = field.copy$default$4();
                return new Some((Object)field.copy(x$6, (DataType)x$5, x$7, x$8));
            }
            if (containsStarAction$1) {
                return new Some(field);
            }
            return None$.MODULE$;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$resolveReferencesAndSchema$21(LogicalPlan x0$2) {
        LogicalRelation logicalRelation;
        Option<TahoeFileIndex> option;
        LogicalPlan logicalPlan = x0$2;
        if (logicalPlan instanceof LogicalRelation && !(option = DeltaTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan)).isEmpty()) {
            TahoeFileIndex fileIndex = (TahoeFileIndex)option.get();
            return TypeWidening$.MODULE$.isEnabled(fileIndex.protocol(), fileIndex.metadata());
        }
        return false;
    }

    private ResolveDeltaMergeInto$() {
    }
}

