/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.catalog;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.ResolvedTable;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTable$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTableImplicits$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.DeltaUnsupportedTableFeatureException;
import org.apache.spark.sql.delta.InvalidProtocolVersionException;
import org.apache.spark.sql.delta.UnresolvedPathBasedDeltaTable;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;

public final class DeltaTableV2$
implements Serializable {
    public static final DeltaTableV2$ MODULE$ = new DeltaTableV2$();

    public Option<CatalogTable> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<DeltaTimeTravelSpec> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public DeltaTableV2 apply(SparkSession spark, Path tablePath, Map<String, String> options, String cmd) {
        return this.resolve(spark, new UnresolvedPathBasedDeltaTable(tablePath.toString(), options, cmd), cmd);
    }

    public DeltaTableV2 apply(SparkSession spark, TableIdentifier tableId, String cmd) {
        return this.resolve(spark, (LogicalPlan)UnresolvedTableImplicits$.MODULE$.UnresolvedTableShim(UnresolvedTable$.MODULE$).apply((Seq<String>)tableId.nameParts(), cmd), cmd);
    }

    public Option<CatalogTable> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<DeltaTimeTravelSpec> apply$default$5() {
        return None$.MODULE$;
    }

    public Map<String, String> apply$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public DeltaTableV2 resolve(SparkSession spark, LogicalPlan unresolved, String cmd) {
        return this.extractFrom(spark.sessionState().analyzer().ResolveRelations().apply(unresolved), cmd);
    }

    public DeltaTableV2 extractFrom(LogicalPlan plan, String cmd) {
        V1Table v1Table;
        Table t;
        boolean bl = false;
        ResolvedTable resolvedTable = null;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof ResolvedTable) {
            bl = true;
            resolvedTable = (ResolvedTable)logicalPlan;
            Table d = resolvedTable.table();
            if (d instanceof DeltaTableV2) {
                DeltaTableV2 deltaTableV2 = (DeltaTableV2)d;
                return deltaTableV2;
            }
        }
        if (bl && (t = resolvedTable.table()) instanceof V1Table && DeltaTableUtils$.MODULE$.isDeltaTable((v1Table = (V1Table)t).catalogTable())) {
            return new DeltaTableV2(SparkSession$.MODULE$.active(), new Path(v1Table.v1Table().location()), (Option<CatalogTable>)new Some((Object)v1Table.v1Table()), this.apply$default$4(), this.apply$default$5(), this.apply$default$6());
        }
        throw DeltaErrors$.MODULE$.notADeltaTableException(cmd);
    }

    public <T> T withEnrichedUnsupportedTableException(Option<CatalogTable> catalogTable, Option<String> tableName, Function0<T> thunk) {
        Object object;
        LazyRef tableNameToUse$lzy = new LazyRef();
        try {
            object = thunk.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvalidProtocolVersionException) {
                InvalidProtocolVersionException invalidProtocolVersionException = (InvalidProtocolVersionException)throwable2;
                if (DeltaTableV2$.tableNameToUse$1(tableNameToUse$lzy, catalogTable, tableName).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableV2$.$anonfun$withEnrichedUnsupportedTableException$1(invalidProtocolVersionException, x$7)))) {
                    throw invalidProtocolVersionException.copy((String)DeltaTableV2$.tableNameToUse$1(tableNameToUse$lzy, catalogTable, tableName).get(), invalidProtocolVersionException.copy$default$2(), invalidProtocolVersionException.copy$default$3(), invalidProtocolVersionException.copy$default$4(), invalidProtocolVersionException.copy$default$5()).initCause(invalidProtocolVersionException);
                }
            }
            if (throwable2 instanceof DeltaUnsupportedTableFeatureException) {
                DeltaUnsupportedTableFeatureException deltaUnsupportedTableFeatureException = (DeltaUnsupportedTableFeatureException)throwable2;
                if (DeltaTableV2$.tableNameToUse$1(tableNameToUse$lzy, catalogTable, tableName).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableV2$.$anonfun$withEnrichedUnsupportedTableException$2(deltaUnsupportedTableFeatureException, x$8)))) {
                    String x$1 = (String)DeltaTableV2$.tableNameToUse$1(tableNameToUse$lzy, catalogTable, tableName).get();
                    String x$2 = deltaUnsupportedTableFeatureException.copy$default$1();
                    Iterable<String> x$3 = deltaUnsupportedTableFeatureException.copy$default$3();
                    throw deltaUnsupportedTableFeatureException.copy(x$2, x$1, x$3).initCause(deltaUnsupportedTableFeatureException);
                }
            }
            throw throwable;
        }
        return (T)object;
    }

    public <T> Option<String> withEnrichedUnsupportedTableException$default$2() {
        return None$.MODULE$;
    }

    public DeltaTableV2 apply(SparkSession spark, Path path, Option<CatalogTable> catalogTable, Option<String> tableIdentifier, Option<DeltaTimeTravelSpec> timeTravelOpt, Map<String, String> options) {
        return new DeltaTableV2(spark, path, catalogTable, tableIdentifier, timeTravelOpt, options);
    }

    public Option<Tuple6<SparkSession, Path, Option<CatalogTable>, Option<String>, Option<DeltaTimeTravelSpec>, Map<String, String>>> unapply(DeltaTableV2 x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.spark(), (Object)x$0.path(), x$0.catalogTable(), x$0.tableIdentifier(), x$0.timeTravelOpt(), x$0.options()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeltaTableV2$.class);
    }

    private static final /* synthetic */ Option tableNameToUse$lzycompute$1(LazyRef tableNameToUse$lzy$1, Option catalogTable$1, Option tableName$1) {
        Option option;
        LazyRef lazyRef = tableNameToUse$lzy$1;
        synchronized (lazyRef) {
            Option option2;
            if (tableNameToUse$lzy$1.initialized()) {
                option2 = (Option)tableNameToUse$lzy$1.value();
            } else {
                Option option3;
                Option option4 = catalogTable$1;
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    CatalogTable ct = (CatalogTable)some.value();
                    None$ x$1 = None$.MODULE$;
                    String x$2 = ct.identifier().copy$default$1();
                    Option x$3 = ct.identifier().copy$default$2();
                    Some some2 = new Some((Object)ct.identifier().copy(x$2, x$3, (Option)x$1).unquotedString());
                    option3 = some2;
                } else if (None$.MODULE$.equals(option4)) {
                    option3 = tableName$1;
                } else {
                    throw new MatchError((Object)option4);
                }
                option2 = (Option)tableNameToUse$lzy$1.initialize((Object)option3);
            }
            option = option2;
        }
        return option;
    }

    private static final Option tableNameToUse$1(LazyRef tableNameToUse$lzy$1, Option catalogTable$1, Option tableName$1) {
        if (tableNameToUse$lzy$1.initialized()) {
            return (Option)tableNameToUse$lzy$1.value();
        }
        return DeltaTableV2$.tableNameToUse$lzycompute$1(tableNameToUse$lzy$1, catalogTable$1, tableName$1);
    }

    public static final /* synthetic */ boolean $anonfun$withEnrichedUnsupportedTableException$1(InvalidProtocolVersionException x10$1, String x$7) {
        String string = x$7;
        String string2 = x10$1.tableNameOrPath();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$withEnrichedUnsupportedTableException$2(DeltaUnsupportedTableFeatureException x11$1, String x$8) {
        String string = x$8;
        String string2 = x11$1.tableNameOrPath();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private DeltaTableV2$() {
    }
}

