/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.backfill;

import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.commands.backfill.BackfillBatchStats;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import scala.Function0;
import scala.Option;
import scala.StringContext;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005!4qAB\u0004\u0011\u0002\u0007\u0005a\u0003C\u0003$\u0001\u0011\u0005A\u0005C\u0003)\u0001\u0019\u0005\u0011\u0006C\u0003=\u0001\u0019\u0005Q\bC\u0003G\u0001\u0019Eq\tC\u0003T\u0001\u0011\u0005AKA\u0007CC\u000e\\g-\u001b7m\u0005\u0006$8\r\u001b\u0006\u0003\u0011%\t\u0001BY1dW\u001aLG\u000e\u001c\u0006\u0003\u0015-\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003\u00195\tQ\u0001Z3mi\u0006T!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u00192\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011a$I\u0007\u0002?)\u0011\u0001eC\u0001\t[\u0016$XM]5oO&\u0011!e\b\u0002\r\t\u0016dG/\u0019'pO\u001eLgnZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0015\u0002\"\u0001\u0007\u0014\n\u0005\u001dJ\"\u0001B+oSR\fABZ5mKNLeNQ1uG\",\u0012A\u000b\t\u0004WM2dB\u0001\u00172\u001d\ti\u0003'D\u0001/\u0015\tyS#\u0001\u0004=e>|GOP\u0005\u00025%\u0011!'G\u0001\ba\u0006\u001c7.Y4f\u0013\t!TGA\u0002TKFT!AM\r\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eZ\u0011aB1di&|gn]\u0005\u0003wa\u0012q!\u00113e\r&dW-\u0001\rcC\u000e\\g-\u001b7m\u0005\u0006$8\r[*uCR\u001cx\n\u001d+za\u0016,\u0012A\u0010\t\u0003\u007f\rs!\u0001Q!\u0011\u00055J\u0012B\u0001\"\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tK\u0012!\u00069sKB\f'/\u001a$jY\u0016\u001c\u0018I\u001c3D_6l\u0017\u000e\u001e\u000b\u0004K!s\u0005\"B%\u0005\u0001\u0004Q\u0015a\u0001;y]B\u00111\nT\u0007\u0002\u0017%\u0011Qj\u0003\u0002\u0016\u001fB$\u0018.\\5ti&\u001cGK]1og\u0006\u001cG/[8o\u0011\u0015yE\u00011\u0001Q\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\u0004\"\u0001G)\n\u0005IK\"aA%oi\u00069Q\r_3dkR,G#B\u0013V/b3\u0007\"\u0002,\u0006\u0001\u0004Q\u0015aB8sS\u001e$\u0006P\u001c\u0005\u0006\u001f\u0016\u0001\r\u0001\u0015\u0005\u00063\u0016\u0001\rAW\u0001\u0013]Vl7+^2dKN\u001ch-\u001e7CCR\u001c\u0007\u000e\u0005\u0002\\I6\tAL\u0003\u0002^=\u00061\u0011\r^8nS\u000eT!a\u00181\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002bE\u0006!Q\u000f^5m\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!\u001a/\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u00159W\u00011\u0001[\u00039qW/\u001c$bS2,GMQ1uG\"\u0004")
public interface BackfillBatch
extends DeltaLogging {
    public Seq<AddFile> filesInBatch();

    public String backfillBatchStatsOpType();

    public void prepareFilesAndCommit(OptimisticTransaction var1, int var2);

    public static /* synthetic */ void execute$(BackfillBatch $this, OptimisticTransaction origTxn, int batchId, AtomicInteger numSuccessfulBatch, AtomicInteger numFailedBatch) {
        $this.execute(origTxn, batchId, numSuccessfulBatch, numFailedBatch);
    }

    default public void execute(OptimisticTransaction origTxn, int batchId, AtomicInteger numSuccessfulBatch, AtomicInteger numFailedBatch) {
        long startTimeNs = System.nanoTime();
        this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Batch ", " starting, committing "}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.BATCH_ID(), BoxesRunTime.boxToLong((long)batchId))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " candidate files"}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_FILES(), BoxesRunTime.boxToLong((long)this.filesInBatch().size()))})))));
        OptimisticTransaction txn = origTxn.split(this.filesInBatch());
        String txnId = txn.txnId();
        try {
            this.prepareFilesAndCommit(txn, batchId);
            this.recordBackfillBatchStats$1(txnId, true, numSuccessfulBatch, numFailedBatch, startTimeNs, origTxn, batchId);
        }
        catch (Throwable t) {
            this.recordBackfillBatchStats$1(txnId, false, numSuccessfulBatch, numFailedBatch, startTimeNs, origTxn, batchId);
            throw t;
        }
    }

    private void recordBackfillBatchStats$1(String txnId, boolean wasSuccessful, AtomicInteger numSuccessfulBatch$1, AtomicInteger numFailedBatch$1, long startTimeNs$1, OptimisticTransaction origTxn$1, int batchId$1) {
        int n = wasSuccessful ? numSuccessfulBatch$1.incrementAndGet() : numFailedBatch$1.incrementAndGet();
        long totalExecutionTimeInMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs$1);
        BackfillBatchStats batchStats = new BackfillBatchStats(origTxn$1.txnId(), txnId, batchId$1, this.filesInBatch().size(), totalExecutionTimeInMs, wasSuccessful);
        DeltaLog x$1 = origTxn$1.deltaLog();
        String x$2 = this.backfillBatchStatsOpType();
        BackfillBatchStats x$3 = batchStats;
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
    }

    public static void $init$(BackfillBatch $this) {
    }
}

