/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.merge;

import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FileSourceOptions$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoMatchedClause;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoNotMatchedClause;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSource$;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSource$RetryHandling$;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSourceError;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSourceError$;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSourceErrorType$;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSourceReason$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaSparkPlanUtils;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015eaB\u001e=!\u0003\r\ta\u0013\u0005\u0006=\u0002!\ta\u0018\u0005\bG\u0002\u0001\r\u0011\"\u0003e\u0011%\u0011)\t\u0001a\u0001\n\u0013\u00119\tC\u0005\u0003\f\u0002\u0001\r\u0011\"\u0005\u0003\u000e\"I!Q\u0015\u0001A\u0002\u0013E!q\u0015\u0005\n\u0005W\u0003\u0001\u0019!C\t\u0003+C\u0011B!,\u0001\u0001\u0004%\tBa,\t\u000f\tM\u0006\u0001\"\u0005\u00036\u001e9!\u0011 \u0001\t\u0002\tmha\u0002B\u0000\u0001!\u00051\u0011\u0001\u0005\u0007]*!\ta!\u0003\u0006\r\r-!\u0002AB\u0007\u0011%\u0019)B\u0003b\u0001\n\u0003\u00199\u0002\u0003\u0005\u0004\u001a)\u0001\u000b\u0011BB\u0007\u0011%\u0019YB\u0003b\u0001\n\u0003\u00199\u0002\u0003\u0005\u0004\u001e)\u0001\u000b\u0011BB\u0007\u0011%\u0019yB\u0003b\u0001\n\u0003\u00199\u0002\u0003\u0005\u0004\")\u0001\u000b\u0011BB\u0007\u0011\u001d\u0019\u0019\u0003\u0001C\u0005\u0007KAqa!\u0012\u0001\t\u0013\u00199\u0005C\u0004\u0004N\u0001!Iaa\u0014\t\u000f\rU\u0003\u0001\"\u0005\u0004X!91q\r\u0001\u0005\u0012\r%\u0004bBB<\u0001\u0011E1\u0011\u0010\u0005\b\u0007w\u0002A\u0011BB?\u000f\u0015YG\b#\u0001m\r\u0015YD\b#\u0001n\u0011\u0015q7\u0004\"\u0001p\r\u0011\u00018\u0004Q9\t\u0015\u0005\rQD!f\u0001\n\u0003\t)\u0001\u0003\u0006\u0002$u\u0011\t\u0012)A\u0005\u0003\u000fA!\"!\n\u001e\u0005+\u0007I\u0011AA\u0014\u0011)\ty#\bB\tB\u0003%\u0011\u0011\u0006\u0005\u000b\u0003ci\"Q3A\u0005\u0002\u0005M\u0002BCA\";\tE\t\u0015!\u0003\u00026!1a.\bC\u0001\u0003\u000bB\u0011\"!\u0015\u001e\u0003\u0003%\t!a\u0015\t\u0013\u0005mS$%A\u0005\u0002\u0005u\u0003\"CA:;E\u0005I\u0011AA;\u0011%\tI(HI\u0001\n\u0003\tY\bC\u0005\u0002\u0000u\t\t\u0011\"\u0011\u0002\u0002\"I\u00111S\u000f\u0002\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0003;k\u0012\u0011!C\u0001\u0003?C\u0011\"a+\u001e\u0003\u0003%\t%!,\t\u0013\u0005mV$!A\u0005\u0002\u0005u\u0006\"CAa;\u0005\u0005I\u0011IAb\u0011%\t9-HA\u0001\n\u0003\nI\rC\u0005\u0002Lv\t\t\u0011\"\u0011\u0002N\"I\u0011qZ\u000f\u0002\u0002\u0013\u0005\u0013\u0011[\u0004\n\u0003+\\\u0012\u0011!E\u0001\u0003/4\u0001\u0002]\u000e\u0002\u0002#\u0005\u0011\u0011\u001c\u0005\u0007]N\"\t!!=\t\u0013\u0005-7'!A\u0005F\u00055\u0007\"CAzg\u0005\u0005I\u0011QA{\u0011%\tipMA\u0001\n\u0003\u000by\u0010C\u0005\u0003\u000eM\n\t\u0011\"\u0003\u0003\u0010!9!qC\u000e\u0005\u0002\te\u0001b\u0002B\u00177\u0011%!q\u0006\u0002\u001b\u001b\u0016\u0014x-Z%oi>l\u0015\r^3sS\u0006d\u0017N_3T_V\u00148-\u001a\u0006\u0003{y\nQ!\\3sO\u0016T!a\u0010!\u0002\u0011\r|W.\\1oINT!!\u0011\"\u0002\u000b\u0011,G\u000e^1\u000b\u0005\r#\u0015aA:rY*\u0011QIR\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f\"\u000ba!\u00199bG\",'\"A%\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001a%\u000b\u0017\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M3V\"\u0001+\u000b\u0005U\u0003\u0015\u0001C7fi\u0016\u0014\u0018N\\4\n\u0005]#&\u0001\u0004#fYR\fGj\\4hS:<\u0007CA-]\u001b\u0005Q&BA.A\u0003\u0011)H/\u001b7\n\u0005uS&a\u0005#fYR\f7\u000b]1sWBc\u0017M\\+uS2\u001c\u0018A\u0002\u0013j]&$H\u0005F\u0001a!\ti\u0015-\u0003\u0002c\u001d\n!QK\\5u\u0003-iWM]4f'>,(oY3\u0016\u0003\u0015\u00042!\u00144i\u0013\t9gJ\u0001\u0004PaRLwN\u001c\t\u0003Svq!A\u001b\u000e\u000e\u0003q\n!$T3sO\u0016Le\u000e^8NCR,'/[1mSj,7k\\;sG\u0016\u0004\"A[\u000e\u0014\u0005ma\u0015A\u0002\u001fj]&$h\bF\u0001m\u0005-iUM]4f'>,(oY3\u0014\tua%/\u001e\t\u0003\u001bNL!\u0001\u001e(\u0003\u000fA\u0013x\u000eZ;diB\u0011aO \b\u0003ort!\u0001_>\u000e\u0003eT!A\u001f&\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0015BA?O\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tih*\u0001\u0002eMV\u0011\u0011q\u0001\t\u0005\u0003\u0013\tiB\u0004\u0003\u0002\f\u0005ma\u0002BA\u0007\u00033qA!a\u0004\u0002\u00189!\u0011\u0011CA\u000b\u001d\rA\u00181C\u0005\u0002\u0013&\u0011q\tS\u0005\u0003\u000b\u001aK!a\u0011#\n\u0005u\u0014\u0015\u0002BA\u0010\u0003C\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005u\u0014\u0015a\u00013gA\u0005q\u0011n]'bi\u0016\u0014\u0018.\u00197ju\u0016$WCAA\u0015!\ri\u00151F\u0005\u0004\u0003[q%a\u0002\"p_2,\u0017M\\\u0001\u0010SNl\u0015\r^3sS\u0006d\u0017N_3eA\u0005\tR.\u0019;fe&\fG.\u001b>f%\u0016\f7o\u001c8\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003{q1A[A\u001d\u0013\r\tY\u0004P\u0001!\u001b\u0016\u0014x-Z%oi>l\u0015\r^3sS\u0006d\u0017N_3T_V\u00148-\u001a*fCN|g.\u0003\u0003\u0002@\u0005\u0005#\u0001I'fe\u001e,\u0017J\u001c;p\u001b\u0006$XM]5bY&TXmU8ve\u000e,'+Z1t_:T1!a\u000f=\u0003Ii\u0017\r^3sS\u0006d\u0017N_3SK\u0006\u001cxN\u001c\u0011\u0015\u0011\u0005\u001d\u00131JA'\u0003\u001f\u00022!!\u0013\u001e\u001b\u0005Y\u0002bBA\u0002I\u0001\u0007\u0011q\u0001\u0005\b\u0003K!\u0003\u0019AA\u0015\u0011\u001d\t\t\u0004\na\u0001\u0003k\tAaY8qsRA\u0011qIA+\u0003/\nI\u0006C\u0005\u0002\u0004\u0015\u0002\n\u00111\u0001\u0002\b!I\u0011QE\u0013\u0011\u0002\u0003\u0007\u0011\u0011\u0006\u0005\n\u0003c)\u0003\u0013!a\u0001\u0003k\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002`)\"\u0011qAA1W\t\t\u0019\u0007\u0005\u0003\u0002f\u0005=TBAA4\u0015\u0011\tI'a\u001b\u0002\u0013Ut7\r[3dW\u0016$'bAA7\u001d\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0014q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003oRC!!\u000b\u0002b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA?U\u0011\t)$!\u0019\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\u000bAA[1wC&!\u0011\u0011SAD\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0013\t\u0004\u001b\u0006e\u0015bAAN\u001d\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011UAT!\ri\u00151U\u0005\u0004\u0003Ks%aA!os\"I\u0011\u0011V\u0016\u0002\u0002\u0003\u0007\u0011qS\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0006CBAY\u0003o\u000b\t+\u0004\u0002\u00024*\u0019\u0011Q\u0017(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0006M&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u000b\u0002@\"I\u0011\u0011V\u0017\u0002\u0002\u0003\u0007\u0011\u0011U\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0004\u0006\u0015\u0007\"CAU]\u0005\u0005\t\u0019AAL\u0003!A\u0017m\u001d5D_\u0012,GCAAL\u0003!!xn\u0015;sS:<GCAAB\u0003\u0019)\u0017/^1mgR!\u0011\u0011FAj\u0011%\tI+MA\u0001\u0002\u0004\t\t+A\u0006NKJ<WmU8ve\u000e,\u0007cAA%gM)1'a7\u0002hBa\u0011Q\\Ar\u0003\u000f\tI#!\u000e\u0002H5\u0011\u0011q\u001c\u0006\u0004\u0003Ct\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003K\fyNA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!!;\u0002p6\u0011\u00111\u001e\u0006\u0005\u0003[\fY)\u0001\u0002j_&\u0019q0a;\u0015\u0005\u0005]\u0017!B1qa2LH\u0003CA$\u0003o\fI0a?\t\u000f\u0005\ra\u00071\u0001\u0002\b!9\u0011Q\u0005\u001cA\u0002\u0005%\u0002bBA\u0019m\u0001\u0007\u0011QG\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tA!\u0003\u0011\t53'1\u0001\t\n\u001b\n\u0015\u0011qAA\u0015\u0003kI1Aa\u0002O\u0005\u0019!V\u000f\u001d7fg!I!1B\u001c\u0002\u0002\u0003\u0007\u0011qI\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\t!\u0011\t)Ia\u0005\n\t\tU\u0011q\u0011\u0002\u0007\u001f\nTWm\u0019;\u0002[5,'oZ3NCR,'/[1mSj,GmU8ve\u000e,'\u000b\u001a3CY>\u001c7\u000eT8ti\u0016\u0013(o\u001c:SK\u001e,\u0007\u0010\u0006\u0003\u0003\u001c\t%\u0002\u0003\u0002B\u000f\u0005KqAAa\b\u0003\"A\u0011\u0001PT\u0005\u0004\u0005Gq\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0012\n\u001d\"b\u0001B\u0012\u001d\"9!1F\u001dA\u0002\u0005]\u0015!\u0002:eI&#\u0017AG4fiJ+g-\u001a:f]\u000e,GmU8ve\u000e,7i\u001c7v[:\u001cHC\u0003B\u0019\u0005\u001b\u0012\tGa\u001b\u0003zA1!1\u0007B\u001d\u0005{i!A!\u000e\u000b\t\t]\u00121W\u0001\nS6lW\u000f^1cY\u0016LAAa\u000f\u00036\t\u00191+Z9\u0011\t\t}\"\u0011J\u0007\u0003\u0005\u0003RAAa\u0011\u0003F\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\u00119EQ\u0001\tG\u0006$\u0018\r\\=ti&!!1\nB!\u0005%\tE\u000f\u001e:jEV$X\rC\u0004\u0003Pi\u0002\rA!\u0015\u0002\rM|WO]2f!\u0011\u0011\u0019F!\u0018\u000e\u0005\tU#\u0002\u0002B,\u00053\nq\u0001\\8hS\u000e\fGN\u0003\u0003\u0003\\\t\u0015\u0013!\u00029mC:\u001c\u0018\u0002\u0002B0\u0005+\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\"9!1\r\u001eA\u0002\t\u0015\u0014!C2p]\u0012LG/[8o!\u0011\u0011yDa\u001a\n\t\t%$\u0011\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007b\u0002B7u\u0001\u0007!qN\u0001\u000f[\u0006$8\r[3e\u00072\fWo]3t!\u00151(\u0011\u000fB:\u0013\u0011\u0011Y$!\u0001\u0011\t\tM#QO\u0005\u0005\u0005o\u0012)FA\u000eEK2$\u0018-T3sO\u0016Le\u000e^8NCR\u001c\u0007.\u001a3DY\u0006,8/\u001a\u0005\b\u0005wR\u0004\u0019\u0001B?\u0003Eqw\u000e^'bi\u000eDW\rZ\"mCV\u001cXm\u001d\t\u0006m\nE$q\u0010\t\u0005\u0005'\u0012\t)\u0003\u0003\u0003\u0004\nU#A\b#fYR\fW*\u001a:hK&sGo\u001c(pi6\u000bGo\u00195fI\u000ec\u0017-^:f\u0003=iWM]4f'>,(oY3`I\u0015\fHc\u00011\u0003\n\"A\u0011\u0011V\u0002\u0002\u0002\u0003\u0007Q-A\u000bnCR,'/[1mSj,GmU8ve\u000e,'\u000b\u0012#\u0016\u0005\t=\u0005\u0003B'g\u0005#\u0003bAa%\u0003\u001a\nuUB\u0001BK\u0015\r\u00119\nR\u0001\u0004e\u0012$\u0017\u0002\u0002BN\u0005+\u00131A\u0015#E!\u0011\u0011yJ!)\u000e\u0005\t\u0015\u0013\u0002\u0002BR\u0005\u000b\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006IR.\u0019;fe&\fG.\u001b>fIN{WO]2f%\u0012#u\fJ3r)\r\u0001'\u0011\u0016\u0005\n\u0003S+\u0011\u0011!a\u0001\u0005\u001f\u000bq!\u0019;uK6\u0004H/A\u0006biR,W\u000e\u001d;`I\u0015\fHc\u00011\u00032\"I\u0011\u0011V\u0004\u0002\u0002\u0003\u0007\u0011qS\u0001%eVtw+\u001b;i\u001b\u0006$XM]5bY&TX\rZ*pkJ\u001cW\rT8tiJ+GO]5fgRQ!q\u0017Ba\u0005\u0013\u0014)Na<\u0011\u000bY\u0014\tH!/\u0011\t\tm&QX\u0007\u0002\u0005&\u0019!q\u0018\"\u0003\u0007I{w\u000f\u0003\u0004F\u0011\u0001\u0007!1\u0019\t\u0005\u0005w\u0013)-C\u0002\u0003H\n\u0013Ab\u00159be.\u001cVm]:j_:DqAa3\t\u0001\u0004\u0011i-\u0001\u0005eK2$\u0018\rT8h!\u0011\u0011yM!5\u000e\u0003\u0001K1Aa5A\u0005!!U\r\u001c;b\u0019><\u0007b\u0002Bl\u0011\u0001\u0007!\u0011\\\u0001\b[\u0016$(/[2t!!\u0011iBa7\u0003\u001c\t}\u0017\u0002\u0002Bo\u0005O\u00111!T1q!\u0011\u0011\tOa;\u000e\u0005\t\r(\u0002\u0002Bs\u0005O\fa!\\3ue&\u001c'b\u0001Bu\u0005\u0006IQ\r_3dkRLwN\\\u0005\u0005\u0005[\u0014\u0019OA\u0005T#2kU\r\u001e:jG\"9!\u0011\u001f\u0005A\u0002\tM\u0018\u0001\u0004:v]6+'oZ3Gk:\u001c\u0007cB'\u0003v\n\r'qW\u0005\u0004\u0005ot%!\u0003$v]\u000e$\u0018n\u001c82\u00035\u0011V\r\u001e:z\u0011\u0006tG\r\\5oOB\u0019!Q \u0006\u000e\u0003\u0001\u0011QBU3uefD\u0015M\u001c3mS:<7c\u0001\u0006\u0004\u0004A\u0019Qj!\u0002\n\u0007\r\u001daJA\u0006F]VlWM]1uS>tGC\u0001B~\u0005\u0019\u0011Vm];miB!1qBB\t\u001b\u0005Q\u0011\u0002BB\n\u0007\u000b\u0011QAV1mk\u0016\fQAU3uef,\"a!\u0004\u0002\rI+GO]=!\u0003A\u0011V\r\u001e5s_^,\u0005pY3qi&|g.A\tSKRD'o\\<Fq\u000e,\u0007\u000f^5p]\u0002\n\u0001#\u0012=iCV\u001cH/\u001a3SKR\u0014\u0018.Z:\u0002#\u0015C\b.Y;ti\u0016$'+\u001a;sS\u0016\u001c\b%\u0001\u000fiC:$G.Z#yG\u0016\u0004H/[8o\tV\u0014\u0018N\\4BiR,W\u000e\u001d;\u0015\u0011\r\u001d21FB\u001b\u0007s\u00012a!\u000b\r\u001d\r\u0011i0\u0003\u0005\b\u0007[\u0019\u0002\u0019AB\u0018\u0003\t)\u0007\u0010E\u0002w\u0007cIAaa\r\u0002\u0002\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0007o\u0019\u0002\u0019AA\u0015\u00035I7\u000fT1ti\u0006#H/Z7qi\"9!1Z\nA\u0002\t5\u0007fA\n\u0004>A!1qHB!\u001b\t\tY'\u0003\u0003\u0004D\u0005-$a\u0002;bS2\u0014XmY\u0001-a2\fgnQ8oi\u0006Lgn]%h]>\u0014X-\u00168sK\u0006$\u0017M\u00197f\r&dWm\u001d*fC\u0012|\u0005\u000f^5p]N$B!!\u000b\u0004J!911\n\u000bA\u0002\tE\u0013\u0001\u00029mC:\f!%[4o_J,WK\u001c:fC\u0012\f'\r\\3GS2,7oQ8oM&<7/\u0011:f'\u0016$HCBA\u0015\u0007#\u001a\u0019\u0006C\u0004\u0004LU\u0001\rA!\u0015\t\r\u0015+\u0002\u0019\u0001Bb\u0003]\u0019\bn\\;mI6\u000bG/\u001a:jC2L'0Z*pkJ\u001cW\r\u0006\u0005\u0004Z\r}3\u0011MB2!\u001di51LA\u0015\u0003kI1a!\u0018O\u0005\u0019!V\u000f\u001d7fe!1QI\u0006a\u0001\u0005\u0007DqAa\u0014\u0017\u0001\u0004\u0011\t\u0006C\u0004\u0004fY\u0001\r!!\u000b\u0002\u0019%\u001c\u0018J\\:feR|e\u000e\\=\u0002%A\u0014X\r]1sK6+'oZ3T_V\u00148-\u001a\u000b\u000eA\u000e-4QNB8\u0007c\u001a\u0019h!\u001e\t\r\u0015;\u0002\u0019\u0001Bb\u0011\u001d\u0011ye\u0006a\u0001\u0005#BqAa\u0019\u0018\u0001\u0004\u0011)\u0007C\u0004\u0003n]\u0001\rAa\u001c\t\u000f\tmt\u00031\u0001\u0003~!91QM\fA\u0002\u0005%\u0012AD4fi6+'oZ3T_V\u00148-Z\u000b\u0002Q\u0006q\u0011\r\u001a3IS:$8\u000fV8QY\u0006tGC\u0002B)\u0007\u007f\u001a\u0019\tC\u0004\u0004\u0002f\u0001\rA!\u0015\u0002\u0015M|WO]2f!2\fg\u000eC\u0004\u0004Le\u0001\rA!\u0015")
public interface MergeIntoMaterializeSource
extends DeltaLogging,
DeltaSparkPlanUtils {
    public static String mergeMaterializedSourceRddBlockLostErrorRegex(int rddId) {
        return MergeIntoMaterializeSource$.MODULE$.mergeMaterializedSourceRddBlockLostErrorRegex(rddId);
    }

    public MergeIntoMaterializeSource$RetryHandling$ RetryHandling();

    public Option<MergeSource> org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource();

    public void org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq(Option<MergeSource> var1);

    public Option<RDD<InternalRow>> materializedSourceRDD();

    public void materializedSourceRDD_$eq(Option<RDD<InternalRow>> var1);

    public int attempt();

    public void attempt_$eq(int var1);

    public static /* synthetic */ Seq runWithMaterializedSourceLostRetries$(MergeIntoMaterializeSource $this, SparkSession spark, DeltaLog deltaLog, Map metrics, Function1 runMergeFunc) {
        return $this.runWithMaterializedSourceLostRetries(spark, deltaLog, (Map<String, SQLMetric>)metrics, (Function1<SparkSession, Seq<Row>>)runMergeFunc);
    }

    default public Seq<Row> runWithMaterializedSourceLostRetries(SparkSession spark, DeltaLog deltaLog, Map<String, SQLMetric> metrics, Function1<SparkSession, Seq<Row>> runMergeFunc) {
        boolean doRetry = false;
        Seq runResult = null;
        this.attempt_$eq(1);
        do {
            doRetry = false;
            metrics.values().foreach((Function1 & Serializable)x$1 -> {
                x$1.reset();
                return BoxedUnit.UNIT;
            });
            try {
                try {
                    runResult = (Seq)runMergeFunc.apply((Object)spark);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable2)) {
                        boolean isLastAttempt = this.attempt() == BoxesRunTime.unboxToInt((Object)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_MAX_ATTEMPTS()));
                        Enumeration.Value value = this.handleExceptionDuringAttempt(throwable2, isLastAttempt, deltaLog);
                        Enumeration.Value value2 = this.RetryHandling().Retry();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) {
                            Enumeration.Value value4 = this.RetryHandling().ExhaustedRetries();
                            Enumeration.Value value5 = value;
                            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                                this.logError(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exhausted retries after ", ""}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_ATTEMPT(), BoxesRunTime.boxToInteger((int)this.attempt()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" attempts in MERGE with materialized source. Logging latest exception."}))).log((Seq<MDC>)Nil$.MODULE$))), throwable2);
                                throw DeltaErrors$.MODULE$.sourceMaterializationFailedRepeatedlyInMerge();
                            }
                            Enumeration.Value value6 = this.RetryHandling().RethrowException();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                this.logError(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fatal error in MERGE with materialized source in "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"attempt ", ""}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_ATTEMPT(), BoxesRunTime.boxToInteger((int)this.attempt()))})))), throwable2);
                                throw throwable2;
                            }
                            throw new MatchError((Object)value);
                        }
                        this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying MERGE with materialized source. Attempt "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_ATTEMPT(), BoxesRunTime.boxToInteger((int)this.attempt()))})))));
                        doRetry = true;
                        this.attempt_$eq(this.attempt() + 1);
                        continue;
                    }
                    throw throwable;
                }
            }
            finally {
                this.materializedSourceRDD().foreach((Function1 & Serializable)rdd -> rdd.unpersist(rdd.unpersist$default$1()));
                this.materializedSourceRDD_$eq((Option<RDD<InternalRow>>)None$.MODULE$);
                this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq((Option<MergeSource>)None$.MODULE$);
            }
        } while (doRetry);
        return runResult;
    }

    private Enumeration.Value handleExceptionDuringAttempt(Throwable ex, boolean isLastAttempt, DeltaLog deltaLog) {
        while (true) {
            Throwable ex2;
            Option option;
            boolean bl = false;
            SparkException sparkException = null;
            Throwable throwable = ex;
            if (throwable instanceof SparkException) {
                bl = true;
                sparkException = (SparkException)throwable;
                if (this.materializedSourceRDD().nonEmpty() && sparkException.getMessage().matches(MergeIntoMaterializeSource$.MODULE$.mergeMaterializedSourceRddBlockLostErrorRegex(((RDD)this.materializedSourceRDD().get()).id()))) {
                    this.log().warn(new StringBuilder(96).append("Materialized Merge source RDD block lost. Merge needs to be restarted. ").append("This was attempt number ").append(this.attempt()).append(".").toString());
                    if (!isLastAttempt) {
                        return this.RetryHandling().Retry();
                    }
                    DeltaLog x$1 = deltaLog;
                    String x$2 = MergeIntoMaterializeSourceError$.MODULE$.OP_TYPE();
                    MergeIntoMaterializeSourceError x$3 = new MergeIntoMaterializeSourceError(MergeIntoMaterializeSourceErrorType$.MODULE$.RDD_BLOCK_LOST().toString(), this.attempt(), ((RDD)this.materializedSourceRDD().get()).getStorageLevel().toString());
                    Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                    Option<Path> x$5 = this.recordDeltaEvent$default$5();
                    this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
                    return this.RetryHandling().ExhaustedRetries();
                }
            }
            if (bl && this.materializedSourceRDD().nonEmpty() && sparkException.getMessage().contains("java.io.IOException: No space left on device")) {
                DeltaLog x$6 = deltaLog;
                String x$7 = MergeIntoMaterializeSourceError$.MODULE$.OP_TYPE();
                MergeIntoMaterializeSourceError x$8 = new MergeIntoMaterializeSourceError(MergeIntoMaterializeSourceErrorType$.MODULE$.OUT_OF_DISK().toString(), this.attempt(), ((RDD)this.materializedSourceRDD().get()).getStorageLevel().toString());
                Map<TagDefinition, String> x$9 = this.recordDeltaEvent$default$3();
                Option<Path> x$10 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(x$6, x$7, x$9, x$8, x$10);
                return this.RetryHandling().RethrowException();
            }
            if (throwable == null || (option = NonFatal$.MODULE$.unapply(throwable)).isEmpty() || (ex2 = (Throwable)option.get()).getCause() == null) break;
            ex = ex2.getCause();
        }
        return this.RetryHandling().RethrowException();
    }

    private boolean planContainsIgnoreUnreadableFilesReadOptions(LogicalPlan plan) {
        Option res = plan.collectFirst((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeIntoMaterializeSource $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                LogicalRelation logicalRelation;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && MergeIntoMaterializeSource.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$relationContainsOptions$1((logicalRelation = (LogicalRelation)A1).relation())) {
                    return (B1)logicalRelation;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalRelation && MergeIntoMaterializeSource.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$relationContainsOptions$1((logicalRelation = (LogicalRelation)logicalPlan).relation());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return res.nonEmpty();
    }

    private boolean ignoreUnreadableFilesConfigsAreSet(LogicalPlan plan, SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.conf().get(SQLConf$.MODULE$.IGNORE_MISSING_FILES())) || BoxesRunTime.unboxToBoolean((Object)spark.conf().get(SQLConf$.MODULE$.IGNORE_CORRUPT_FILES())) || this.planContainsIgnoreUnreadableFilesReadOptions(plan);
    }

    public static /* synthetic */ Tuple2 shouldMaterializeSource$(MergeIntoMaterializeSource $this, SparkSession spark, LogicalPlan source, boolean isInsertOnly) {
        return $this.shouldMaterializeSource(spark, source, isInsertOnly);
    }

    default public Tuple2<Object, Enumeration.Value> shouldMaterializeSource(SparkSession spark, LogicalPlan source, boolean isInsertOnly) {
        String materializeType = (String)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE());
        boolean forceMaterializationWithUnreadableFiles = BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_FORCE_SOURCE_MATERIALIZATION_WITH_UNREADABLE_FILES()));
        DeltaSparkPlanUtils.CheckDeterministicOptions checkDeterministicOptions = new DeltaSparkPlanUtils.CheckDeterministicOptions(true);
        String string = materializeType;
        switch (string == null ? 0 : string.hashCode()) {
            case 96673: {
                if (!"all".equals(string)) break;
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.MATERIALIZE_ALL());
            }
            case 3005871: {
                if (!"auto".equals(string)) break;
                if (isInsertOnly && BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_INSERT_ONLY_ENABLED()))) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NOT_MATERIALIZED_AUTO_INSERT_ONLY());
                }
                if (!this.planContainsOnlyDeltaScans(source)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NON_DETERMINISTIC_SOURCE_NON_DELTA());
                }
                if (!this.planIsDeterministic(source, checkDeterministicOptions)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NON_DETERMINISTIC_SOURCE_OPERATORS());
                }
                if (forceMaterializationWithUnreadableFiles && this.ignoreUnreadableFilesConfigsAreSet(source, spark)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.IGNORE_UNREADABLE_FILES_CONFIGS_ARE_SET());
                }
                if (this.planContainsUdf(source)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NON_DETERMINISTIC_SOURCE_WITH_DETERMINISTIC_UDF());
                }
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NOT_MATERIALIZED_AUTO());
            }
            case 3387192: {
                if (!"none".equals(string)) break;
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NOT_MATERIALIZED_NONE());
            }
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.INVALID_CONFIG());
    }

    public static /* synthetic */ void prepareMergeSource$(MergeIntoMaterializeSource $this, SparkSession spark, LogicalPlan source, Expression condition, Seq matchedClauses, Seq notMatchedClauses, boolean isInsertOnly) {
        $this.prepareMergeSource(spark, source, condition, (Seq<DeltaMergeIntoMatchedClause>)matchedClauses, (Seq<DeltaMergeIntoNotMatchedClause>)notMatchedClauses, isInsertOnly);
    }

    default public void prepareMergeSource(SparkSession spark, LogicalPlan source, Expression condition, Seq<DeltaMergeIntoMatchedClause> matchedClauses, Seq<DeltaMergeIntoNotMatchedClause> notMatchedClauses, boolean isInsertOnly) {
        Tuple2<Object, Enumeration.Value> tuple2 = this.shouldMaterializeSource(spark, source, isInsertOnly);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean materialize = tuple2._1$mcZ$sp();
        Enumeration.Value materializeReason = (Enumeration.Value)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)materialize), (Object)materializeReason);
        boolean materialize2 = tuple22._1$mcZ$sp();
        Enumeration.Value materializeReason2 = (Enumeration.Value)tuple22._2();
        if (!materialize2) {
            this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq((Option<MergeSource>)new Some((Object)new MergeSource((Dataset<Row>)Dataset$.MODULE$.ofRows(spark, source), false, materializeReason2)));
            return;
        }
        Seq<Attribute> referencedSourceColumns = MergeIntoMaterializeSource$.MODULE$.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$getReferencedSourceColumns(source, condition, matchedClauses, notMatchedClauses);
        Project sourceWithSelectedColumns = new Project(referencedSourceColumns, source);
        Dataset baseSourcePlanDF = Dataset$.MODULE$.ofRows(spark, (LogicalPlan)sourceWithSelectedColumns);
        Dataset checkpointedSourcePlanDF = baseSourcePlanDF.localCheckpoint(false);
        LogicalPlan checkpointedPlan = checkpointedSourcePlanDF.queryExecution().analyzed();
        RDD rdd = ((LogicalRDD)checkpointedPlan).rdd();
        this.materializedSourceRDD_$eq((Option<RDD<InternalRow>>)new Some((Object)rdd));
        rdd.setName("mergeMaterializedSource");
        checkpointedPlan = this.addHintsToPlan(source, checkpointedPlan);
        this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq((Option<MergeSource>)new Some((Object)new MergeSource((Dataset<Row>)Dataset$.MODULE$.ofRows(spark, checkpointedPlan), true, materializeReason2)));
        StorageLevel storageLevel = StorageLevel$.MODULE$.fromString(this.attempt() == 1 ? (String)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_RDD_STORAGE_LEVEL()) : (this.attempt() == 2 ? (String)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_RDD_STORAGE_LEVEL_FIRST_RETRY()) : (String)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_RDD_STORAGE_LEVEL_RETRY())));
        rdd.persist(storageLevel);
        if (BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_EAGER()))) {
            rdd.mapPartitions((Function1 & Serializable)x$3 -> package$.MODULE$.Iterator().empty(), rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)).foreach((Function1 & Serializable)x$4 -> {
                MergeIntoMaterializeSource.$anonfun$prepareMergeSource$2(x$4);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.assert(rdd.isCheckpointed());
        }
        this.logDebug((Function0 & Serializable)() -> new StringBuilder(41).append("Materializing MERGE with pruned columns ").append(referencedSourceColumns).append(".").toString());
        this.logDebug((Function0 & Serializable)() -> new StringBuilder(32).append("Materialized MERGE source plan:\n").append(this.getMergeSource().df().queryExecution()).toString());
    }

    public static /* synthetic */ MergeSource getMergeSource$(MergeIntoMaterializeSource $this) {
        return $this.getMergeSource();
    }

    default public MergeSource getMergeSource() {
        Option<MergeSource> option = this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource();
        if (option instanceof Some) {
            Some some = (Some)option;
            MergeSource source = (MergeSource)some.value();
            return source;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("mergeSource was not initialized! Call prepareMergeSource before.");
        }
        throw new MatchError(option);
    }

    private LogicalPlan addHintsToPlan(LogicalPlan sourcePlan, LogicalPlan plan) {
        Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(sourcePlan)._2();
        if (hints.nonEmpty()) {
            LogicalPlan planWithHints = (LogicalPlan)hints.foldRight((Object)plan, (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    HintInfo hint = (HintInfo)tuple2._1();
                    LogicalPlan p = (LogicalPlan)tuple2._2();
                    return new ResolvedHint(p, hint);
                }
                throw new MatchError((Object)tuple2);
            });
            return planWithHints;
        }
        return plan;
    }

    public static boolean org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$relationContainsOptions$1(BaseRelation relation) {
        BaseRelation baseRelation = relation;
        if (baseRelation instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
            return hadoopFsRelation.options().get((Object)FileSourceOptions$.MODULE$.IGNORE_CORRUPT_FILES()).contains((Object)"true") || hadoopFsRelation.options().get((Object)FileSourceOptions$.MODULE$.IGNORE_MISSING_FILES()).contains((Object)"true");
        }
        return false;
    }

    public static /* synthetic */ void $anonfun$prepareMergeSource$2(InternalRow x$4) {
    }

    public static void $init$(MergeIntoMaterializeSource $this) {
        $this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq((Option<MergeSource>)None$.MODULE$);
        $this.materializedSourceRDD_$eq((Option<RDD<InternalRow>>)None$.MODULE$);
        $this.attempt_$eq(0);
    }

    public static class MergeSource
    implements Product,
    Serializable {
        private final Dataset<Row> df;
        private final boolean isMaterialized;
        private final Enumeration.Value materializeReason;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Dataset<Row> df() {
            return this.df;
        }

        public boolean isMaterialized() {
            return this.isMaterialized;
        }

        public Enumeration.Value materializeReason() {
            return this.materializeReason;
        }

        public MergeSource copy(Dataset<Row> df, boolean isMaterialized, Enumeration.Value materializeReason) {
            return new MergeSource(df, isMaterialized, materializeReason);
        }

        public Dataset<Row> copy$default$1() {
            return this.df();
        }

        public boolean copy$default$2() {
            return this.isMaterialized();
        }

        public Enumeration.Value copy$default$3() {
            return this.materializeReason();
        }

        public String productPrefix() {
            return "MergeSource";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.df();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isMaterialized());
                }
                case 2: {
                    return this.materializeReason();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MergeSource;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "df";
                }
                case 1: {
                    return "isMaterialized";
                }
                case 2: {
                    return "materializeReason";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.df()));
            n = Statics.mix((int)n, (int)(this.isMaterialized() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.materializeReason()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MergeSource)) return false;
            boolean bl = true;
            if (!bl) return false;
            MergeSource mergeSource = (MergeSource)x$1;
            if (this.isMaterialized() != mergeSource.isMaterialized()) return false;
            Dataset<Row> dataset = this.df();
            Dataset<Row> dataset2 = mergeSource.df();
            if (dataset == null) {
                if (dataset2 != null) {
                    return false;
                }
            } else if (!dataset.equals(dataset2)) return false;
            Enumeration.Value value = this.materializeReason();
            Enumeration.Value value2 = mergeSource.materializeReason();
            if (value == null) {
                if (value2 != null) {
                    return false;
                }
            } else if (!value.equals(value2)) return false;
            if (!mergeSource.canEqual(this)) return false;
            return true;
        }

        public MergeSource(Dataset<Row> df, boolean isMaterialized, Enumeration.Value materializeReason) {
            this.df = df;
            this.isMaterialized = isMaterialized;
            this.materializeReason = materializeReason;
            Product.$init$((Product)this);
            Predef$.MODULE$.assert(!isMaterialized || MergeIntoMaterializeSourceReason$.MODULE$.MATERIALIZED_REASONS().contains((Object)materializeReason));
        }
    }
}

