/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOptions$;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSource$;
import org.apache.spark.sql.delta.sources.DeltaSourceMetadataEvolutionSupport$;
import org.apache.spark.sql.delta.sources.DeltaSourceMetadataTrackingLog;
import org.apache.spark.sql.delta.sources.PersistedMetadata;
import org.apache.spark.sql.delta.storage.ClosableIterator$;
import org.apache.spark.sql.delta.storage.ClosableIterator$ClosableWrapper$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class DeltaSourceMetadataTrackingLog$
implements Logging {
    public static final DeltaSourceMetadataTrackingLog$ MODULE$ = new DeltaSourceMetadataTrackingLog$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    private boolean $lessinit$greater$default$5() {
        return true;
    }

    public String fullMetadataTrackingLocation(String rootSchemaTrackingLocation, String tableId, Option<String> sourceTrackingId) {
        String subdir = new StringBuilder(12).append("_schema_log_").append(tableId).append(sourceTrackingId.map((Function1 & Serializable)n -> new StringBuilder(1).append("_").append((String)n).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
        return new Path(rootSchemaTrackingLocation, subdir).toString();
    }

    public Option<String> fullMetadataTrackingLocation$default$3() {
        return None$.MODULE$;
    }

    public DeltaSourceMetadataTrackingLog create(SparkSession sparkSession, String rootMetadataLocation, SnapshotDescriptor sourceSnapshot, Option<String> sourceTrackingId, Option<String> sourceMetadataPathOpt, boolean mergeConsecutiveSchemaChanges, boolean initMetadataLogEagerly) {
        DeltaSourceMetadataTrackingLog log;
        block4: {
            Tuple3 tuple3;
            String metadataTrackingLocation = this.fullMetadataTrackingLocation(rootMetadataLocation, sourceSnapshot.deltaLog().tableId(), sourceTrackingId);
            log = new DeltaSourceMetadataTrackingLog(sparkSession, metadataTrackingLocation, sourceSnapshot, sourceMetadataPathOpt, initMetadataLogEagerly);
            log.getCurrentTrackedMetadata().foreach((Function1 & Serializable)schema -> {
                DeltaSourceMetadataTrackingLog$.$anonfun$create$1(sourceSnapshot, sparkSession, sourceMetadataPathOpt, schema);
                return BoxedUnit.UNIT;
            });
            if (mergeConsecutiveSchemaChanges && log.getCurrentTrackedMetadata().isDefined()) {
                this.getMergedConsecutiveMetadataChanges(sparkSession, sourceSnapshot.deltaLog(), (PersistedMetadata)log.getCurrentTrackedMetadata().get()).foreach((Function1 & Serializable)mergedSchema -> log.writeNewMetadata((PersistedMetadata)mergedSchema, true));
            }
            if ((tuple3 = new Tuple3(log.getPreviousTrackedMetadata(), log.getCurrentTrackedMetadata(), sourceMetadataPathOpt)) == null) break block4;
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                PersistedMetadata prev = (PersistedMetadata)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    PersistedMetadata curr = (PersistedMetadata)some2.value();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        String metadataPath = (String)some3.value();
                        DeltaSourceMetadataEvolutionSupport$.MODULE$.validateIfSchemaChangeCanBeUnblockedWithSQLConf(sparkSession, metadataPath, curr, prev);
                    }
                }
            }
        }
        return log;
    }

    public Option<String> create$default$4() {
        return None$.MODULE$;
    }

    public Option<String> create$default$5() {
        return None$.MODULE$;
    }

    public boolean create$default$6() {
        return false;
    }

    public boolean create$default$7() {
        return true;
    }

    private Option<PersistedMetadata> getMergedConsecutiveMetadataChanges(SparkSession spark, DeltaLog deltaLog, PersistedMetadata currentMetadata) {
        long currentMetadataVersion = currentMetadata.deltaCommitVersion();
        Iterator untilMetadataChange = deltaLog.getChangeLogFiles(currentMetadataVersion, deltaLog.getChangeLogFiles$default$2()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long version = tuple2._1$mcJ$sp();
                FileStatus fileStatus = (FileStatus)tuple2._2();
                ObjectRef metadataAction = ObjectRef.create((Object)None$.MODULE$);
                ObjectRef protocolAction = ObjectRef.create((Object)None$.MODULE$);
                BooleanRef hasFileAction = BooleanRef.create((boolean)false);
                DeltaSource$.MODULE$.createRewindableActionIterator(spark, deltaLog, fileStatus).processAndClose((Function1 & Serializable)actionsIter -> {
                    actionsIter.foreach((Function1 & Serializable)x0$2 -> {
                        DeltaSourceMetadataTrackingLog$.$anonfun$getMergedConsecutiveMetadataChanges$3(metadataAction$1, protocolAction$1, hasFileAction$1, x0$2);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return new Tuple4((Object)BoxesRunTime.boxToBoolean((!hasFileAction.elem && (((Option)metadataAction.elem).isDefined() || ((Option)protocolAction.elem).isDefined()) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToLong((long)version), (Object)((Option)metadataAction.elem), (Object)((Option)protocolAction.elem));
            }
            throw new MatchError((Object)tuple2);
        }).takeWhile((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeltaSourceMetadataTrackingLog$.$anonfun$getMergedConsecutiveMetadataChanges$4(x$5)));
        return DeltaSource$.MODULE$.iteratorLast(ClosableIterator$ClosableWrapper$.MODULE$.toClosable$extension(ClosableIterator$.MODULE$.ClosableWrapper(untilMetadataChange))).flatMap((Function1 & Serializable)x0$3 -> {
            Tuple4 tuple4 = x0$3;
            if (tuple4 != null) {
                long version = BoxesRunTime.unboxToLong((Object)tuple4._2());
                Option metadataOpt = (Option)tuple4._3();
                Option protocolOpt = (Option)tuple4._4();
                if (version == currentMetadataVersion) {
                    return None$.MODULE$;
                }
                MODULE$.log().info(new StringBuilder(82).append("Looked ahead from version ").append(currentMetadataVersion).append(" and ").append("will use metadata at version ").append(version).append(" to read Delta stream.").toString());
                long x$1 = version;
                String x$2 = (String)metadataOpt.map((Function1 & Serializable)x$6 -> x$6.schema().json()).getOrElse((Function0 & Serializable)() -> currentMetadata.dataSchemaJson());
                String x$3 = (String)metadataOpt.map((Function1 & Serializable)x$7 -> x$7.partitionSchema().json()).getOrElse((Function0 & Serializable)() -> currentMetadata.partitionSchemaJson());
                Option x$4 = metadataOpt.map((Function1 & Serializable)x$8 -> x$8.configuration()).orElse((Function0 & Serializable)() -> currentMetadata.tableConfigurations());
                Option x$5 = protocolOpt.map((Function1 & Serializable)x$9 -> x$9.json()).orElse((Function0 & Serializable)() -> currentMetadata.protocolJson());
                String x$62 = currentMetadata.copy$default$1();
                String x$72 = currentMetadata.copy$default$5();
                Option<Object> x$82 = currentMetadata.copy$default$8();
                return new Some((Object)currentMetadata.copy(x$62, x$1, x$2, x$3, x$72, (Option<Map<String, String>>)x$4, (Option<String>)x$5, x$82));
            }
            throw new MatchError((Object)tuple4);
        });
    }

    public static final /* synthetic */ void $anonfun$create$2(PersistedMetadata schema$1, String metadataPath) {
        String string = metadataPath;
        String string2 = schema$1.sourceMetadataPath();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> new StringBuilder(270).append("The Delta source metadata path used for execution '").append(metadataPath).append("' is different ").append("from the one persisted for previous processing '").append(schema$1.sourceMetadataPath()).append("'. ").append("Please check if the schema location has been reused across different streaming ").append("sources. Pick a new `").append(DeltaOptions$.MODULE$.SCHEMA_TRACKING_LOCATION()).append("` or use ").append("`").append(DeltaOptions$.MODULE$.STREAMING_SOURCE_TRACKING_ID()).append("` to ").append("distinguish between streaming sources.").toString());
    }

    public static final /* synthetic */ void $anonfun$create$1(SnapshotDescriptor sourceSnapshot$1, SparkSession sparkSession$1, Option sourceMetadataPathOpt$1, PersistedMetadata schema) {
        schema.validateAgainstSnapshot(sourceSnapshot$1);
        if (BoxesRunTime.unboxToBoolean((Object)sparkSession$1.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_STREAMING_SCHEMA_TRACKING_METADATA_PATH_CHECK_ENABLED()))) {
            sourceMetadataPathOpt$1.foreach((Function1 & Serializable)metadataPath -> {
                DeltaSourceMetadataTrackingLog$.$anonfun$create$2(schema, metadataPath);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$getMergedConsecutiveMetadataChanges$3(ObjectRef metadataAction$1, ObjectRef protocolAction$1, BooleanRef hasFileAction$1, Action x0$2) {
        Action action = x0$2;
        if (action instanceof Metadata) {
            Metadata metadata = (Metadata)action;
            metadataAction$1.elem = new Some((Object)metadata);
            return;
        }
        if (action instanceof Protocol) {
            Protocol protocol = (Protocol)action;
            protocolAction$1.elem = new Some((Object)protocol);
            return;
        }
        if (action instanceof FileAction) {
            hasFileAction$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getMergedConsecutiveMetadataChanges$4(Tuple4 x$5) {
        return BoxesRunTime.unboxToBoolean((Object)x$5._1());
    }

    private DeltaSourceMetadataTrackingLog$() {
    }
}

