/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import io.delta.storage.AzureLogStore;
import io.delta.storage.GCSLogStore;
import io.delta.storage.HDFSLogStore;
import io.delta.storage.S3SingleDriverLogStore;
import org.apache.spark.sql.delta.DeltaErrors$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;

public final class DelegatingLogStore$ {
    public static final DelegatingLogStore$ MODULE$ = new DelegatingLogStore$();
    private static final String defaultS3LogStoreClassName;
    private static final String defaultAzureLogStoreClassName;
    private static final String defaultHDFSLogStoreClassName;
    private static final String defaultGCSLogStoreClassName;
    private static final Set<String> s3Schemes;
    private static final Set<String> azureSchemes;
    private static final Set<String> gsSchemes;

    static {
        try {
        }
        catch (NoClassDefFoundError e) {
            throw DeltaErrors$.MODULE$.missingDeltaStorageJar(e);
        }
        defaultS3LogStoreClassName = S3SingleDriverLogStore.class.getName();
        defaultAzureLogStoreClassName = AzureLogStore.class.getName();
        defaultHDFSLogStoreClassName = HDFSLogStore.class.getName();
        defaultGCSLogStoreClassName = GCSLogStore.class.getName();
        s3Schemes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"s3", "s3a", "s3n"}));
        azureSchemes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abfs", "abfss", "adl", "wasb", "wasbs"}));
        gsSchemes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"gs"}));
    }

    public String defaultS3LogStoreClassName() {
        return defaultS3LogStoreClassName;
    }

    public String defaultAzureLogStoreClassName() {
        return defaultAzureLogStoreClassName;
    }

    public String defaultHDFSLogStoreClassName() {
        return defaultHDFSLogStoreClassName;
    }

    public String defaultGCSLogStoreClassName() {
        return defaultGCSLogStoreClassName;
    }

    public Set<String> s3Schemes() {
        return s3Schemes;
    }

    public Set<String> azureSchemes() {
        return azureSchemes;
    }

    public Set<String> gsSchemes() {
        return gsSchemes;
    }

    public Option<String> getDefaultLogStoreClassName(String scheme) {
        if (this.s3Schemes().contains((Object)scheme)) {
            return new Some((Object)this.defaultS3LogStoreClassName());
        }
        if (this.azureSchemes().apply((Object)scheme)) {
            return new Some((Object)this.defaultAzureLogStoreClassName());
        }
        if (this.gsSchemes().apply((Object)scheme)) {
            return new Some((Object)this.defaultGCSLogStoreClassName());
        }
        return None$.MODULE$;
    }

    private DelegatingLogStore$() {
    }
}

