/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.spark.sql.delta.util.DateFormatter;
import org.apache.spark.sql.delta.util.DateTimeFormatterHelper;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00114AAC\u0006\u00011!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011\u0015Q\u0004\u0001\"\u0001<\u0011!y\u0004\u0001#b\u0001\n\u0013\u0001\u0005bB'\u0001\u0005\u0004%IA\u0014\u0005\u0007'\u0002\u0001\u000b\u0011B(\t\u000bQ\u0003A\u0011B+\t\u000bm\u0003A\u0011\t/\t\u000b\u0011\u0003A\u0011I1\u0003)%\u001bx\u000e\u000f\u001c1c\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u0015\taQ\"\u0001\u0003vi&d'B\u0001\b\u0010\u0003\u0015!W\r\u001c;b\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011dH\u0012\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0013%D\u0001\f\u0013\t\u00113BA\u0007ECR,gi\u001c:nCR$XM\u001d\t\u0003A\u0011J!!J\u0006\u0003/\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000fS3ma\u0016\u0014\u0018a\u00029biR,'O\u001c\t\u0003Q=r!!K\u0017\u0011\u0005)ZR\"A\u0016\u000b\u00051:\u0012A\u0002\u001fs_>$h(\u0003\u0002/7\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq3$\u0001\u0004m_\u000e\fG.\u001a\t\u0003iaj\u0011!\u000e\u0006\u0003\u0019YR\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:k\t1Aj\\2bY\u0016\fa\u0001P5oSRtDc\u0001\u001f>}A\u0011\u0001\u0005\u0001\u0005\u0006M\r\u0001\ra\n\u0005\u0006e\r\u0001\raM\u0001\nM>\u0014X.\u0019;uKJ,\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000baAZ8s[\u0006$(B\u0001$7\u0003\u0011!\u0018.\\3\n\u0005!\u001b%!\u0005#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\"\u0012AA\u0013\t\u00035-K!\u0001T\u000e\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018aA+U\u0007V\tq\n\u0005\u0002Q#6\tQ)\u0003\u0002S\u000b\n1!l\u001c8f\u0013\u0012\fA!\u0016+DA\u0005IAo\\%ogR\fg\u000e\u001e\u000b\u0003-f\u0003\"\u0001U,\n\u0005a+%aB%ogR\fg\u000e\u001e\u0005\u00065\u001e\u0001\raJ\u0001\u0002g\u0006)\u0001/\u0019:tKR\u0011Q\f\u0019\t\u00035yK!aX\u000e\u0003\u0007%sG\u000fC\u0003[\u0011\u0001\u0007q\u0005\u0006\u0002(E\")1-\u0003a\u0001;\u0006!A-Y=t\u0001")
public class Iso8601DateFormatter
implements DateFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private final String pattern;
    private final Locale locale;
    private final ZoneId UTC;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Instant toInstantWithZoneId(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toInstantWithZoneId$(this, temporalAccessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale) {
        return DateTimeFormatterHelper.getOrCreateFormatter$(this, pattern, locale);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601DateFormatter iso8601DateFormatter = this;
        synchronized (iso8601DateFormatter) {
            if (!this.bitmap$trans$0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale);
                this.bitmap$trans$0 = true;
            }
        }
        return this.formatter;
    }

    private DateTimeFormatter formatter() {
        if (!this.bitmap$trans$0) {
            return this.formatter$lzycompute();
        }
        return this.formatter;
    }

    private ZoneId UTC() {
        return this.UTC;
    }

    private Instant toInstant(String s) {
        TemporalAccessor temporalAccessor = this.formatter().parse(s);
        return this.toInstantWithZoneId(temporalAccessor, this.UTC());
    }

    @Override
    public int parse(String s) {
        return DateTimeUtils$.MODULE$.instantToDays(this.toInstant(s));
    }

    @Override
    public String format(int days) {
        Instant instant = Instant.ofEpochSecond((long)days * DateTimeUtils$.MODULE$.SECONDS_PER_DAY());
        return this.formatter().withZone(this.UTC()).format(instant);
    }

    public Iso8601DateFormatter(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale;
        DateTimeFormatterHelper.$init$(this);
        this.UTC = ZoneId.of("UTC");
    }
}

