/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.delta.CheckpointInstance;
import org.apache.spark.sql.delta.CheckpointInstance$;
import org.apache.spark.sql.delta.CheckpointInstance$Format$V2$;
import org.apache.spark.sql.delta.CheckpointProtectionTableFeature$;
import org.apache.spark.sql.delta.CheckpointProvider$;
import org.apache.spark.sql.delta.Checkpoints;
import org.apache.spark.sql.delta.Checkpoints$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLogFileIndex;
import org.apache.spark.sql.delta.DeltaLogFileIndex$;
import org.apache.spark.sql.delta.DeltaUDF$;
import org.apache.spark.sql.delta.LastCheckpointInfo;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotManagement;
import org.apache.spark.sql.delta.TruncationGranularity$;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.FileNames$CheckpointFile$;
import org.apache.spark.sql.delta.util.FileNames$ChecksumFile$;
import org.apache.spark.sql.delta.util.FileNames$DeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$UnbackfilledDeltaFile$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.NumericRange$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t-e!C\u001b7!\u0003\r\t!QAQ\u0011\u0015q\u0005\u0001\"\u0001P\u000b\u0011\u0019\u0006\u0001\u0003+\t\u000b\r\u0004A\u0011\u00033\t\u000b-\u0004A\u0011\u00017\t\u000ba\u0004A\u0011A=\t\u000bm\u0004A\u0011\t?\t\u0011\u0005\u001d\u0001\u0001\"\u00017\u0003\u0013A!\"a\u0011\u0001#\u0003%\tANA#\u0011)\tY\u0006AI\u0001\n\u00031\u0014Q\f\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!!'\u0001\t#\tY\nC\u0004\u0002,\u0002!I!!,\t\u0011\u0005U\u0006\u0001\"\u00057\u0003oC\u0001\"!.\u0001\t#1\u0014q\u0019\u0005\t\u0003\u001b\u0004A\u0011\u0001\u001c\u0002P\"A\u0011\u0011\u001e\u0001\u0005\u0002Y\nY\u000f\u0003\u0005\u0002p\u0002!\tBNAy\u0011\u001d\u0011Y\u0002\u0001C\t\u0005;AqA!\u001e\u0001\t\u0013\u00119H\u0002\u0004\u0003*\u0001A!1\u0006\u0005\b\u0003\u007f,B\u0011\u0001B\u0017\u0011%\u0011y#\u0006a\u0001\n\u0003\u0011)\u0001C\u0005\u00032U\u0001\r\u0011\"\u0001\u00034!9!qG\u000b!B\u0013\u0001\u0007\"\u0003B\u001d+\u0001\u0007I\u0011\u0001B\u0003\u0011%\u0011Y$\u0006a\u0001\n\u0003\u0011i\u0004C\u0004\u0003BU\u0001\u000b\u0015\u00021\t\u0013\t\rS\u00031A\u0005\u0002\t\u0015\u0001\"\u0003B#+\u0001\u0007I\u0011\u0001B$\u0011\u001d\u0011Y%\u0006Q!\n\u0001D\u0011B!\u0014\u0016\u0001\u0004%\tA!\u0002\t\u0013\t=S\u00031A\u0005\u0002\tE\u0003b\u0002B++\u0001\u0006K\u0001\u0019\u0005\n\u0005/*\u0002\u0019!C\u0001\u0005\u000bA\u0011B!\u0017\u0016\u0001\u0004%\tAa\u0017\t\u000f\t}S\u0003)Q\u0005A\"I!\u0011M\u000bA\u0002\u0013\u0005!Q\u0001\u0005\n\u0005G*\u0002\u0019!C\u0001\u0005KBqA!\u001b\u0016A\u0003&\u0001\rC\u0005\u0003lU\u0001\r\u0011\"\u0001\u0003\u0006!I!QN\u000bA\u0002\u0013\u0005!q\u000e\u0005\b\u0005g*\u0002\u0015)\u0003a\r\u001d\tY\u0010\u0001\u00057\u0003{Dq!a@-\t\u0003\u0011\t\u0001C\u0005\u0003\u00041\u0002\r\u0011\"\u0001\u0003\u0006!I!q\u0001\u0017A\u0002\u0013\u0005!\u0011\u0002\u0005\b\u0005\u001fa\u0003\u0015)\u0003a\u0011%\u0011\t\u0002\fa\u0001\n\u0003\u0011)\u0001C\u0005\u0003\u00141\u0002\r\u0011\"\u0001\u0003\u0016!9!\u0011\u0004\u0017!B\u0013\u0001\u0007b\u0002BD\u0001\u0011\u0005!\u0011\u0012\u0002\u0010\u001b\u0016$\u0018\rZ1uC\u000ecW-\u00198va*\u0011q\u0007O\u0001\u0006I\u0016dG/\u0019\u0006\u0003si\n1a]9m\u0015\tYD(A\u0003ta\u0006\u00148N\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<7\u0001A\n\u0004\u0001\tC\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB!osJ+g\r\u0005\u0002J\u00196\t!J\u0003\u0002Lm\u0005AQ.\u001a;fe&tw-\u0003\u0002N\u0015\naA)\u001a7uC2{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012\u0001\u0015\t\u0003\u0007FK!A\u0015#\u0003\tUs\u0017\u000e\u001e\u0002\r-\u0016\u00148/[8o%\u0006tw-\u001a\t\u0004+v\u0003gB\u0001,\\\u001b\u00059&B\u0001-Z\u0003%IW.\\;uC\ndWM\u0003\u0002[\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005q;\u0016\u0001\u0004(v[\u0016\u0014\u0018n\u0019*b]\u001e,\u0017B\u00010`\u0005%Ien\u00197vg&4XM\u0003\u0002]/B\u00111)Y\u0005\u0003E\u0012\u0013A\u0001T8oO\u0006aa/\u001a:tS>t'+\u00198hKR\u0019QmZ5\u0011\u0005\u0019\u0014Q\"\u0001\u0001\t\u000b!\u001c\u0001\u0019\u00011\u0002\u000bM$\u0018M\u001d;\t\u000b)\u001c\u0001\u0019\u00011\u0002\u0007\u0015tG-A\ff]\u0006\u0014G.Z#ya&\u0014X\r\u001a'pO\u000ecW-\u00198vaR\u0011Q\u000e\u001d\t\u0003\u0007:L!a\u001c#\u0003\u000f\t{w\u000e\\3b]\")\u0011\u000f\u0002a\u0001e\u0006AQ.\u001a;bI\u0006$\u0018\r\u0005\u0002tm6\tAO\u0003\u0002vm\u00059\u0011m\u0019;j_:\u001c\u0018BA<u\u0005!iU\r^1eCR\f\u0017\u0001\u00063fYR\f'+\u001a;f]RLwN\\'jY2L7\u000f\u0006\u0002au\")\u0011/\u0002a\u0001e\u0006aAm\u001c'pO\u000ecW-\u00198vaR\u0011\u0001+ \u0005\u0006}\u001a\u0001\ra`\u0001\u0012g:\f\u0007o\u001d5piR{7\t\\3b]V\u0004\b\u0003BA\u0001\u0003\u0007i\u0011AN\u0005\u0004\u0003\u000b1$\u0001C*oCB\u001c\bn\u001c;\u0002%\rdW-\u00198Va\u0016C\b/\u001b:fI2{wm\u001d\u000b\b!\u0006-\u0011QBA\f\u0011\u0015qx\u00011\u0001\u0000\u0011%\tya\u0002I\u0001\u0002\u0004\t\t\"A\feK2$\u0018MU3uK:$\u0018n\u001c8NS2d\u0017n](qiB!1)a\u0005a\u0013\r\t)\u0002\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005eq\u0001%AA\u0002\u0005m\u0011aG2vi>4g\r\u0016:v]\u000e\fG/[8o\u000fJ\fg.\u001e7be&$\u0018\u0010\u0005\u0003\u0002\u001e\u0005ub\u0002BA\u0010\u0003sqA!!\t\u000289!\u00111EA\u001b\u001d\u0011\t)#a\r\u000f\t\u0005\u001d\u0012\u0011\u0007\b\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006!\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0014BA\u001f?\u0013\tYD(\u0003\u0002:u%\u0011q\u0007O\u0005\u0004\u0003w1\u0014!\u0006+sk:\u001c\u0017\r^5p]\u001e\u0013\u0018M\\;mCJLG/_\u0005\u0005\u0003\u007f\t\tEA\u000bUeVt7-\u0019;j_:<%/\u00198vY\u0006\u0014\u0018\u000e^=\u000b\u0007\u0005mb'\u0001\u000fdY\u0016\fg.\u00169FqBL'/\u001a3M_\u001e\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d#\u0006BA\t\u0003\u0013Z#!a\u0013\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+\"\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011LA(\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001dG2,\u0017M\\+q\u000bb\u0004\u0018N]3e\u0019><7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyF\u000b\u0003\u0002\u001c\u0005%\u0013aJ4fi\u0012+G\u000e^1GS2,7\t[3dWN,Xn\u0014:DQ\u0016\u001c7\u000e]8j]R4VM]:j_:$2\u0001YA3\u0011\u001d\t9G\u0003a\u0001\u0003S\n\u0001BZ5mKB\u000bG\u000f\u001b\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003\t17OC\u0002\u0002tq\na\u0001[1e_>\u0004\u0018\u0002BA<\u0003[\u0012A\u0001U1uQ\u0006!B.[:u\u000bb\u0004\u0018N]3e\t\u0016dG/\u0019'pON$B!! \u0002\u0016B1\u0011qPAE\u0003\u001fsA!!!\u0002\u0006:!\u0011\u0011FAB\u0013\u0005)\u0015bAAD\t\u00069\u0001/Y2lC\u001e,\u0017\u0002BAF\u0003\u001b\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003\u000f#\u0005\u0003BA6\u0003#KA!a%\u0002n\tQa)\u001b7f'R\fG/^:\t\r\u0005]5\u00021\u0001a\u000391\u0017\u000e\\3DkR|eM\u001a+j[\u0016\f\u0011e\u00195fG.\u0004x.\u001b8u\u000bbL7\u000f^:Bi\u000ecW-\u00198va\n{WO\u001c3bef$R!\\AO\u0003OCq!a(\r\u0001\u0004\t\t+\u0001\u0005eK2$\u0018\rT8h!\u0011\t\t!a)\n\u0007\u0005\u0015fG\u0001\u0005EK2$\u0018\rT8h\u0011\u0019\tI\u000b\u0004a\u0001A\u00069a/\u001a:tS>t\u0017AF7fi\u0006$\u0017\r^1DY\u0016\fg.\u001e9BY2|w/\u001a3\u0015\u000b5\fy+a-\t\r\u0005EV\u00021\u0001\u0000\u0003!\u0019h.\u00199tQ>$\bBBAL\u001b\u0001\u0007\u0001-A\u000bbY2\u0004&o\u001c;pG>d7oU;qa>\u0014H/\u001a3\u0015\u00135\fI,a/\u0002@\u0006\r\u0007bBAP\u001d\u0001\u0007\u0011\u0011\u0015\u0005\b\u0003{s\u0001\u0019AA?\u0003M\u0019\u0007.Z2lgVl7\u000fV8WC2LG-\u0019;f\u0011\u0019\t\tM\u0004a\u0001A\u0006yb/\u001a:tS>tG\u000b[1u%\u0016\fX/\u001b:fg^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\t\r\u0005\u0015g\u00021\u0001a\u0003e)\u0007\u0010]3di\u0016$7\t[3dWN,XNR5mK\u000e{WO\u001c;\u0015\u000b5\fI-a3\t\u000f\u0005}u\u00021\u0001\u0002\"\")1m\u0004a\u0001K\u0006aAO];oG\u0006$X\rR1uKR1\u0011\u0011[Aq\u0003K\u0004B!a5\u0002^6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.\u0001\u0003vi&d'BAAn\u0003\u0011Q\u0017M^1\n\t\u0005}\u0017Q\u001b\u0002\t\u0007\u0006dWM\u001c3be\"1\u00111\u001d\tA\u0002\u0001\f!\u0002^5nK6KG\u000e\\5t\u0011\u001d\t9\u000f\u0005a\u0001\u00037\tA!\u001e8ji\u0006YAO];oG\u0006$X\rR1z)\u0011\t\t.!<\t\r\u0005\r\u0018\u00031\u0001a\u0003-\u001a'/Z1uKNKgn\u001a7f!\u0006\u0014Ho\u00115fG.\u0004x.\u001b8u\r>\u0014()Y2lo\u0006\u0014HmQ8na\u0006$H#\u0002)\u0002t\u0006U\b\"\u0002@\u0013\u0001\u0004y\bbBA|%\u0001\u0007\u0011\u0011`\u0001\b[\u0016$(/[2t!\t1GFA\rWe\r{W\u000e]1u\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001c8C\u0001\u0017C\u0003\u0019a\u0014N\\5u}Q\u0011\u0011\u0011`\u0001#mJ\u001a\u0005.Z2la>Lg\u000e^\"p[B\fG\u000fT8hS\u000e$\u0016.\\3UC.,g.T:\u0016\u0003\u0001\faE\u001e\u001aDQ\u0016\u001c7\u000e]8j]R\u001cu.\u001c9bi2{w-[2US6,G+Y6f]6\u001bx\fJ3r)\r\u0001&1\u0002\u0005\t\u0005\u001by\u0013\u0011!a\u0001A\u0006\u0019\u0001\u0010J\u0019\u0002GY\u00144\t[3dWB|\u0017N\u001c;D_6\u0004\u0018\r\u001e'pO&\u001cG+[7f)\u0006\\WM\\'tA\u0005\t2\r[3dWB|\u0017N\u001c;WKJ\u001c\u0018n\u001c8\u0002+\rDWmY6q_&tGOV3sg&|gn\u0018\u0013fcR\u0019\u0001Ka\u0006\t\u0011\t5!'!AA\u0002\u0001\f!c\u00195fG.\u0004x.\u001b8u-\u0016\u00148/[8oA\u0005I\u0013\u000eZ3oi&4\u00170\u00118e\t\u0016dW\r^3V]J,g-\u001a:f]\u000e,GmU5eK\u000e\f'OR5mKN$r\u0001\u0015B\u0010\u0005C\u0011)\u0003C\u0003\u007f'\u0001\u0007q\u0010\u0003\u0004\u0003$M\u0001\r\u0001Y\u0001\u0014G\",7m\u001b9pS:$(+\u001a;f]RLwN\u001c\u0005\b\u0003o\u001c\u0002\u0019\u0001B\u0014!\t1WC\u0001\fTS\u0012,7-\u0019:EK2,G/[8o\u001b\u0016$(/[2t'\t)\"\t\u0006\u0002\u0003(\u00051b.^7TS\u0012,7-\u0019:GS2,7\u000fR3mKR,G-\u0001\u000eok6\u001c\u0016\u000eZ3dCJ4\u0015\u000e\\3t\t\u0016dW\r^3e?\u0012*\u0017\u000fF\u0002Q\u0005kA\u0001B!\u0004\u0019\u0003\u0003\u0005\r\u0001Y\u0001\u0018]Vl7+\u001b3fG\u0006\u0014h)\u001b7fg\u0012+G.\u001a;fI\u0002\nqD\\;n\u0003\u000e$\u0018N^3QCJ\fX/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3t\u0003\rrW/\\!di&4X\rU1scV,Go\u00115fG.\u0004x.\u001b8u\r&dWm]0%KF$2\u0001\u0015B \u0011!\u0011iaGA\u0001\u0002\u0004\u0001\u0017\u0001\t8v[\u0006\u001bG/\u001b<f!\u0006\u0014\u0018/^3u\u0007\",7m\u001b9pS:$h)\u001b7fg\u0002\nAD\\;n\u0003\u000e$\u0018N^3Kg>t7\t[3dWB|\u0017N\u001c;GS2,7/\u0001\u0011ok6\f5\r^5wK*\u001bxN\\\"iK\u000e\\\u0007o\\5oi\u001aKG.Z:`I\u0015\fHc\u0001)\u0003J!A!Q\u0002\u0010\u0002\u0002\u0003\u0007\u0001-A\u000fok6\f5\r^5wK*\u001bxN\\\"iK\u000e\\\u0007o\\5oi\u001aKG.Z:!\u0003\r\n7\r^5wK\u000eCWmY6q_&tGo\u001d'jgRLgn\u001a+j[\u0016$\u0016m[3o\u001bN\fq%Y2uSZ,7\t[3dWB|\u0017N\u001c;t\u0019&\u001cH/\u001b8h)&lW\rV1lK:l5o\u0018\u0013fcR\u0019\u0001Ka\u0015\t\u0011\t5\u0011%!AA\u0002\u0001\fA%Y2uSZ,7\t[3dWB|\u0017N\u001c;t\u0019&\u001cH/\u001b8h)&lW\rV1lK:l5\u000fI\u0001%S\u0012,g\u000e^5gs\u0006sG\rR3mKR,7+\u001b3fG\u0006\u00148\u000fV5nKR\u000b7.\u001a8Ng\u0006A\u0013\u000eZ3oi&4\u00170\u00118e\t\u0016dW\r^3TS\u0012,7-\u0019:t)&lW\rV1lK:l5o\u0018\u0013fcR\u0019\u0001K!\u0018\t\u0011\t5A%!AA\u0002\u0001\fQ%\u001b3f]RLg-_!oI\u0012+G.\u001a;f'&$WmY1sgRKW.\u001a+bW\u0016tWj\u001d\u0011\u0002C%$WM\u001c;jMf\f5\r^5wKNKG-Z2beN$\u0016.\\3UC.,g.T:\u0002K%$WM\u001c;jMf\f5\r^5wKNKG-Z2beN$\u0016.\\3UC.,g.T:`I\u0015\fHc\u0001)\u0003h!A!QB\u0014\u0002\u0002\u0003\u0007\u0001-\u0001\u0012jI\u0016tG/\u001b4z\u0003\u000e$\u0018N^3TS\u0012,7-\u0019:t)&lW\rV1lK:l5\u000fI\u0001$_Z,'/\u00197m'&$WmY1s!J|7-Z:tS:<G+[7f)\u0006\\WM\\'t\u0003\u001dzg/\u001a:bY2\u001c\u0016\u000eZ3dCJ\u0004&o\\2fgNLgn\u001a+j[\u0016$\u0016m[3o\u001bN|F%Z9\u0015\u0007A\u0013\t\b\u0003\u0005\u0003\u000e)\n\t\u00111\u0001a\u0003\u0011zg/\u001a:bY2\u001c\u0016\u000eZ3dCJ\u0004&o\\2fgNLgn\u001a+j[\u0016$\u0016m[3o\u001bN\u0004\u0013A\u00043fY\u0016$X-T;mi&\u0004H.\u001a\u000b\u0006A\ne$\u0011\u0011\u0005\b\u0003_\"\u0002\u0019\u0001B>!\u0011\tYG! \n\t\t}\u0014Q\u000e\u0002\u000b\r&dWmU=ti\u0016l\u0007b\u0002BB)\u0001\u0007!QQ\u0001\u0006a\u0006$\bn\u001d\t\u0007\u0003\u007f\nI)!\u001b\u0002=\u0019Lg\u000eZ#be2LWm\u001d;SK2L\u0017M\u00197f\u0007\",7m\u001b9pS:$XCAA\t\u0001")
public interface MetadataCleanup
extends DeltaLogging {
    public static /* synthetic */ NumericRange.Inclusive versionRange$(MetadataCleanup $this, long start, long end) {
        return $this.versionRange(start, end);
    }

    default public NumericRange.Inclusive<Object> versionRange(long start, long end) {
        return NumericRange$.MODULE$.inclusive((Object)BoxesRunTime.boxToLong((long)start), (Object)BoxesRunTime.boxToLong((long)end), (Object)BoxesRunTime.boxToLong((long)1L), (Integral)Numeric.LongIsIntegral$.MODULE$);
    }

    public static /* synthetic */ boolean enableExpiredLogCleanup$(MetadataCleanup $this, Metadata metadata) {
        return $this.enableExpiredLogCleanup(metadata);
    }

    default public boolean enableExpiredLogCleanup(Metadata metadata) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_EXPIRED_LOG_CLEANUP().fromMetaData(metadata));
    }

    public static /* synthetic */ long deltaRetentionMillis$(MetadataCleanup $this, Metadata metadata) {
        return $this.deltaRetentionMillis(metadata);
    }

    default public long deltaRetentionMillis(Metadata metadata) {
        CalendarInterval interval = DeltaConfigs$.MODULE$.LOG_RETENTION().fromMetaData(metadata);
        return DeltaConfigs$.MODULE$.getMilliSeconds(interval);
    }

    public static /* synthetic */ void doLogCleanup$(MetadataCleanup $this, Snapshot snapshotToCleanup) {
        $this.doLogCleanup(snapshotToCleanup);
    }

    default public void doLogCleanup(Snapshot snapshotToCleanup) {
        if (this.enableExpiredLogCleanup(((SnapshotManagement)((Object)this)).snapshot().metadata())) {
            this.cleanUpExpiredLogs(snapshotToCleanup, this.cleanUpExpiredLogs$default$2(), this.cleanUpExpiredLogs$default$3());
            return;
        }
    }

    public static /* synthetic */ void cleanUpExpiredLogs$(MetadataCleanup $this, Snapshot snapshotToCleanup, Option deltaRetentionMillisOpt, Enumeration.Value cutoffTruncationGranularity) {
        $this.cleanUpExpiredLogs(snapshotToCleanup, (Option<Object>)deltaRetentionMillisOpt, cutoffTruncationGranularity);
    }

    default public void cleanUpExpiredLogs(Snapshot snapshotToCleanup, Option<Object> deltaRetentionMillisOpt, Enumeration.Value cutoffTruncationGranularity) {
        Object object = new Object();
        try {
            this.recordDeltaOperation((DeltaLog)this, "delta.log.cleanup", this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable)() -> {
                long retentionMillis = BoxesRunTime.unboxToLong((Object)deltaRetentionMillisOpt.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.deltaRetentionMillis(((SnapshotManagement)((Object)this)).snapshot().metadata())));
                Date fileCutOffTime = this.truncateDate(((DeltaLog)this).clock().getTimeMillis() - retentionMillis, cutoffTruncationGranularity).getTime();
                String formattedDate = fileCutOffTime.toGMTString();
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting the deletion of log files older than "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.DATE(), (Object)formattedDate)})))));
                if (!this.metadataCleanupAllowed(snapshotToCleanup, fileCutOffTime.getTime())) {
                    this.logInfo((Function0 & Serializable)() -> "Metadata cleanup was skipped due to not satisfying the requirements of CheckpointProtectionTableFeature.");
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                FileSystem fs = ((DeltaLog)this).logPath().getFileSystem(((DeltaLog)this).newDeltaHadoopConf());
                IntRef numDeleted = IntRef.create((int)0);
                Iterator<FileStatus> expiredDeltaLogs = this.listExpiredDeltaLogs(fileCutOffTime.getTime());
                if (expiredDeltaLogs.hasNext()) {
                    V2CompatCheckpointMetrics v2CompatCheckpointMetrics = new V2CompatCheckpointMetrics((DeltaLog)this);
                    this.createSinglePartCheckpointForBackwardCompat(snapshotToCleanup, v2CompatCheckpointMetrics);
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Compatibility checkpoint creation metrics: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.METRICS(), (Object)v2CompatCheckpointMetrics)})))));
                }
                BooleanRef wasCheckpointDeleted = BooleanRef.create((boolean)false);
                LongRef maxBackfilledVersionDeleted = LongRef.create((long)-1L);
                expiredDeltaLogs.map((Function1 & Serializable)x$1 -> x$1.getPath()).foreach((Function1 & Serializable)path -> {
                    MetadataCleanup.$anonfun$cleanUpExpiredLogs$7(fs, numDeleted, wasCheckpointDeleted, maxBackfilledVersionDeleted, path);
                    return BoxedUnit.UNIT;
                });
                Path commitDirPath = FileNames$.MODULE$.commitDirPath(((DeltaLog)this).logPath());
                Iterator expiredUnbackfilledDeltaLogs = fs.exists(commitDirPath) ? ((DeltaLog)this).store().listFrom(FileNames$.MODULE$.listingPrefix(commitDirPath, 0L), ((DeltaLog)this).newDeltaHadoopConf()).takeWhile((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$cleanUpExpiredLogs$8(maxBackfilledVersionDeleted, x0$1))) : scala.package$.MODULE$.Iterator().empty();
                int numDeletedUnbackfilled = expiredUnbackfilledDeltaLogs.count((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)fs.delete(log.getPath(), false)));
                if (wasCheckpointDeleted.elem) {
                    SidecarDeletionMetrics sidecarDeletionMetrics = new SidecarDeletionMetrics((DeltaLog)this);
                    this.identifyAndDeleteUnreferencedSidecarFiles(snapshotToCleanup, fileCutOffTime.getTime(), sidecarDeletionMetrics);
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Sidecar deletion metrics: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.METRICS(), (Object)sidecarDeletionMetrics)}))));
                }
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " log files and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.NUM_FILES(), (Object)BoxesRunTime.boxToLong((long)numDeleted$1.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " unbackfilled commit "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.NUM_FILES2(), (Object)BoxesRunTime.boxToLong((long)numDeletedUnbackfilled))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"files older than ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.DATE(), (Object)formattedDate)})))));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public static /* synthetic */ Option cleanUpExpiredLogs$default$2$(MetadataCleanup $this) {
        return $this.cleanUpExpiredLogs$default$2();
    }

    default public Option<Object> cleanUpExpiredLogs$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Enumeration.Value cleanUpExpiredLogs$default$3$(MetadataCleanup $this) {
        return $this.cleanUpExpiredLogs$default$3();
    }

    default public Enumeration.Value cleanUpExpiredLogs$default$3() {
        return TruncationGranularity$.MODULE$.DAY();
    }

    public static /* synthetic */ long getDeltaFileChecksumOrCheckpointVersion$(MetadataCleanup $this, Path filePath) {
        return $this.getDeltaFileChecksumOrCheckpointVersion(filePath);
    }

    default public long getDeltaFileChecksumOrCheckpointVersion(Path filePath) {
        Predef$.MODULE$.require(FileNames$.MODULE$.isCheckpointFile(filePath) || FileNames$.MODULE$.isDeltaFile(filePath) || FileNames$.MODULE$.isChecksumFile(filePath));
        return FileNames$.MODULE$.getFileVersion(filePath);
    }

    private Iterator<FileStatus> listExpiredDeltaLogs(long fileCutOffTime) {
        Option<LastCheckpointInfo> latestCheckpoint = ((Checkpoints)((Object)this)).readLastCheckpointFile();
        if (latestCheckpoint.isEmpty()) {
            return scala.package$.MODULE$.Iterator().empty();
        }
        long threshold = ((LastCheckpointInfo)latestCheckpoint.get()).version() - 1L;
        Iterator files = ((DeltaLog)this).store().listFrom(FileNames$.MODULE$.listingPrefix(((DeltaLog)this).logPath(), 0L), ((DeltaLog)this).newDeltaHadoopConf()).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$listExpiredDeltaLogs$1(f)));
        return new DeltaHistoryManager.BufferingLogDeletionIterator((Iterator<FileStatus>)files, fileCutOffTime, threshold, (Function1<Path, Object>)(Function1 & Serializable)filePath -> BoxesRunTime.boxToLong((long)this.getDeltaFileChecksumOrCheckpointVersion(filePath)));
    }

    public static /* synthetic */ boolean checkpointExistsAtCleanupBoundary$(MetadataCleanup $this, DeltaLog deltaLog, long version) {
        return $this.checkpointExistsAtCleanupBoundary(deltaLog, version);
    }

    default public boolean checkpointExistsAtCleanupBoundary(DeltaLog deltaLog, long version) {
        if (BoxesRunTime.unboxToBoolean((Object)((DeltaLog)this).spark().conf().get(DeltaSQLConf$.MODULE$.ALLOW_METADATA_CLEANUP_CHECKPOINT_EXISTENCE_CHECK_DISABLED()))) {
            return false;
        }
        Some upperBoundVersion = new Some((Object)CheckpointInstance$.MODULE$.apply(version + 1L));
        return deltaLog.findLastCompleteCheckpointBefore((Option<CheckpointInstance>)upperBoundVersion).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$checkpointExistsAtCleanupBoundary$1(version, x$2)));
    }

    private boolean metadataCleanupAllowed(Snapshot snapshot, long fileCutOffTime) {
        long checkpointProtectionVersion = CheckpointProtectionTableFeature$.MODULE$.getCheckpointProtectionVersion(snapshot);
        if (checkpointProtectionVersion <= 0L) {
            return true;
        }
        Iterator<FileStatus> expiredDeltaLogs = this.listExpiredDeltaLogs(fileCutOffTime);
        if (expiredDeltaLogs.isEmpty()) {
            return true;
        }
        DeltaLog deltaLog = snapshot.deltaLog();
        NumericRange.Inclusive toCleanVersionRange = (NumericRange.Inclusive)expiredDeltaLogs.filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FileNames$.MODULE$.isDeltaFile(file))).collect((PartialFunction)new Serializable((DeltaLog)this){
            private static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple2<FileStatus, Object>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(A1)).isEmpty()) {
                    long version = ((Tuple2)option.get())._2$mcJ$sp();
                    return (B1)BoxesRunTime.boxToLong((long)version);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                Option<Tuple2<FileStatus, Object>> option;
                FileStatus fileStatus = x1;
                return fileStatus != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(fileStatus)).isEmpty();
            }
        }).takeWhile((Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 <= checkpointProtectionVersion - 1L).foldLeft(this.versionRange(Long.MAX_VALUE, 0L), (Function2 & Serializable)(currentRange, versionToCover) -> this.expandVersionRange$1(currentRange, BoxesRunTime.unboxToLong((Object)versionToCover)));
        if (BoxesRunTime.unboxToLong((Object)toCleanVersionRange.end()) >= checkpointProtectionVersion - 1L) {
            return true;
        }
        if (this.checkpointExistsAtCleanupBoundary(deltaLog, BoxesRunTime.unboxToLong((Object)toCleanVersionRange.end()) + 1L)) {
            return true;
        }
        return this.allProtocolsSupported(deltaLog, this.versionRange(BoxesRunTime.unboxToLong((Object)toCleanVersionRange.start()), BoxesRunTime.unboxToLong((Object)toCleanVersionRange.end()) + 1L));
    }

    public static /* synthetic */ boolean allProtocolsSupported$(MetadataCleanup $this, DeltaLog deltaLog, Iterator checksumsToValidate, long versionThatRequiresWriteSupport, long expectedChecksumFileCount) {
        return $this.allProtocolsSupported(deltaLog, (Iterator<FileStatus>)checksumsToValidate, versionThatRequiresWriteSupport, expectedChecksumFileCount);
    }

    default public boolean allProtocolsSupported(DeltaLog deltaLog, Iterator<FileStatus> checksumsToValidate, long versionThatRequiresWriteSupport, long expectedChecksumFileCount) {
        boolean bl;
        Object object = new Object();
        try {
            if (!BoxesRunTime.unboxToBoolean((Object)((DeltaLog)this).spark().conf().get(DeltaSQLConf$.MODULE$.ALLOW_METADATA_CLEANUP_WHEN_ALL_PROTOCOLS_SUPPORTED()))) {
                return false;
            }
            StructType schemaToUse = Action$.MODULE$.logSchema().apply((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"protocol"})));
            Column supportedForRead = DeltaUDF$.MODULE$.booleanFromProtocol((Function1<Protocol, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.supportedForRead())).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("protocol")}));
            Column supportedForWrite = DeltaUDF$.MODULE$.booleanFromProtocol((Function1<Protocol, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.supportedForWrite())).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("protocol")}));
            Column supportedForReadAndWrite = supportedForRead.$amp$amp((Object)supportedForWrite);
            Column supported = functions$.MODULE$.when(functions$.MODULE$.col("version").$eq$eq$eq((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)versionThatRequiresWriteSupport))), (Object)supportedForReadAndWrite).otherwise((Object)supportedForRead);
            Option<DeltaLogFileIndex> fileIndexOpt = DeltaLogFileIndex$.MODULE$.apply((FileFormat)DeltaLogFileIndex$.MODULE$.CHECKSUM_FILE_FORMAT(), (Seq<FileStatus>)checksumsToValidate.toSeq());
            Option fileIndexSupportedOpt = fileIndexOpt.map((Function1 & Serializable)index -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$allProtocolsSupported$3(expectedChecksumFileCount, object, deltaLog, schemaToUse, supported, index)));
            bl = BoxesRunTime.unboxToBoolean((Object)fileIndexSupportedOpt.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static /* synthetic */ boolean allProtocolsSupported$(MetadataCleanup $this, DeltaLog deltaLog, NumericRange.Inclusive versionRange) {
        return $this.allProtocolsSupported(deltaLog, (NumericRange.Inclusive<Object>)versionRange);
    }

    default public boolean allProtocolsSupported(DeltaLog deltaLog, NumericRange.Inclusive<Object> versionRange) {
        Iterator checksumsToValidate = deltaLog.listFrom(BoxesRunTime.unboxToLong((Object)versionRange.start())).collect((PartialFunction)new Serializable((DeltaLog)this){
            private static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple2<FileStatus, Object>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = FileNames$ChecksumFile$.MODULE$.unapply(A1)).isEmpty()) {
                    FileStatus fileStatus = (FileStatus)((Tuple2)option.get())._1();
                    long version = ((Tuple2)option.get())._2$mcJ$sp();
                    return (B1)new Tuple2((Object)fileStatus, (Object)BoxesRunTime.boxToLong((long)version));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                Option<Tuple2<FileStatus, Object>> option;
                FileStatus fileStatus = x1;
                return fileStatus != null && !(option = FileNames$ChecksumFile$.MODULE$.unapply(fileStatus)).isEmpty();
            }
        }).takeWhile((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$allProtocolsSupported$5(versionRange, x0$1))).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                FileStatus fileStatus = (FileStatus)tuple2._1();
                return fileStatus;
            }
            throw new MatchError((Object)tuple2);
        });
        return this.allProtocolsSupported(deltaLog, (Iterator<FileStatus>)checksumsToValidate, BoxesRunTime.unboxToLong((Object)versionRange.end()), BoxesRunTime.unboxToLong((Object)versionRange.end()) - BoxesRunTime.unboxToLong((Object)versionRange.start()) + 1L);
    }

    public static /* synthetic */ Calendar truncateDate$(MetadataCleanup $this, long timeMillis, Enumeration.Value unit) {
        return $this.truncateDate(timeMillis, unit);
    }

    default public Calendar truncateDate(long timeMillis, Enumeration.Value unit) {
        int n;
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.setTimeInMillis(timeMillis);
        Enumeration.Value value = unit;
        Enumeration.Value value2 = TruncationGranularity$.MODULE$.DAY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = 5;
        } else {
            Enumeration.Value value4 = TruncationGranularity$.MODULE$.HOUR();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                n = 11;
            } else {
                Enumeration.Value value6 = TruncationGranularity$.MODULE$.MINUTE();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    n = 12;
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        int calendarUnit = n;
        return DateUtils.truncate((Calendar)date, (int)calendarUnit);
    }

    public static /* synthetic */ Calendar truncateDay$(MetadataCleanup $this, long timeMillis) {
        return $this.truncateDay(timeMillis);
    }

    default public Calendar truncateDay(long timeMillis) {
        return this.truncateDate(timeMillis, TruncationGranularity$.MODULE$.DAY());
    }

    public static /* synthetic */ void createSinglePartCheckpointForBackwardCompat$(MetadataCleanup $this, Snapshot snapshotToCleanup, V2CompatCheckpointMetrics metrics) {
        $this.createSinglePartCheckpointForBackwardCompat(snapshotToCleanup, metrics);
    }

    default public void createSinglePartCheckpointForBackwardCompat(Snapshot snapshotToCleanup, V2CompatCheckpointMetrics metrics) {
        if (!CheckpointProvider$.MODULE$.isV2CheckpointEnabled(snapshotToCleanup)) {
            return;
        }
        if (snapshotToCleanup.checkpointProvider().isEmpty()) {
            return;
        }
        long startTimeMs = System.currentTimeMillis();
        Configuration hadoopConf = ((DeltaLog)this).newDeltaHadoopConf();
        CheckpointInstance checkpointInstance = CheckpointInstance$.MODULE$.apply(((FileStatus)snapshotToCleanup.checkpointProvider().topLevelFiles().head()).getPath());
        CheckpointInstance.Format format = checkpointInstance.format();
        CheckpointInstance$Format$V2$ checkpointInstance$Format$V2$ = CheckpointInstance$Format$V2$.MODULE$;
        if (format == null ? checkpointInstance$Format$V2$ != null : !format.equals(checkpointInstance$Format$V2$)) {
            return;
        }
        long checkpointVersion = snapshotToCleanup.checkpointProvider().version();
        CheckpointInstance[] checkpoints = (CheckpointInstance[])((SnapshotManagement)((Object)this)).listFrom(checkpointVersion).takeWhile((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$createSinglePartCheckpointForBackwardCompat$1(checkpointVersion, file))).collect((PartialFunction)new Serializable((DeltaLog)this){
            private static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (FileNames$.MODULE$.isCheckpointFile(A1)) {
                    return (B1)CheckpointInstance$.MODULE$.apply(A1.getPath());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                FileStatus fileStatus = x1;
                return FileNames$.MODULE$.isCheckpointFile(fileStatus);
            }
        }).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$createSinglePartCheckpointForBackwardCompat$3(x$7))).toArray(ClassTag$.MODULE$.apply(CheckpointInstance.class));
        Option<CheckpointInstance> availableNonV2Checkpoints = ((Checkpoints)((Object)this)).getLatestCompleteCheckpointFromList(checkpoints, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)checkpointVersion)));
        if (availableNonV2Checkpoints.nonEmpty()) {
            metrics.v2CheckpointCompatLogicTimeTakenMs_$eq(System.currentTimeMillis() - startTimeMs);
            return;
        }
        Dataset<Row> shallowCopyDf = ((DeltaLog)this).loadIndex((DeltaLogFileIndex)snapshotToCleanup.checkpointProvider().topLevelFileIndex().get(), Action$.MODULE$.logSchema());
        Path finalPath = FileNames$.MODULE$.checkpointFileSingular(snapshotToCleanup.deltaLog().logPath(), checkpointVersion);
        Checkpoints$.MODULE$.createCheckpointV2ParquetFile(((DeltaLog)this).spark(), shallowCopyDf, finalPath, hadoopConf, false);
        metrics.v2CheckpointCompatLogicTimeTakenMs_$eq(System.currentTimeMillis() - startTimeMs);
        metrics.checkpointVersion_$eq(checkpointVersion);
    }

    public static /* synthetic */ void identifyAndDeleteUnreferencedSidecarFiles$(MetadataCleanup $this, Snapshot snapshotToCleanup, long checkpointRetention, SidecarDeletionMetrics metrics) {
        $this.identifyAndDeleteUnreferencedSidecarFiles(snapshotToCleanup, checkpointRetention, metrics);
    }

    default public void identifyAndDeleteUnreferencedSidecarFiles(Snapshot snapshotToCleanup, long checkpointRetention, SidecarDeletionMetrics metrics) {
        Object object = new Object();
        try {
            long startTimeMs = System.currentTimeMillis();
            if (!CheckpointProvider$.MODULE$.isV2CheckpointEnabled(snapshotToCleanup)) {
                return;
            }
            Configuration hadoopConf = ((DeltaLog)this).newDeltaHadoopConf();
            FileSystem fs = ((DeltaLog)this).sidecarDirPath().getFileSystem(hadoopConf);
            if (!fs.exists(((DeltaLog)this).sidecarDirPath())) {
                return;
            }
            Tuple2 tuple2 = ((DeltaLog)this).store().listFrom(FileNames$.MODULE$.listingPrefix(((DeltaLog)this).logPath(), 0L), hadoopConf).collect((PartialFunction)new Serializable((DeltaLog)this){
                private static final long serialVersionUID = 0L;

                public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option<Tuple2<FileStatus, Object>> option;
                    A1 A1 = x1;
                    if (A1 != null && !(option = FileNames$CheckpointFile$.MODULE$.unapply(A1)).isEmpty()) {
                        FileStatus status = (FileStatus)((Tuple2)option.get())._1();
                        return (B1)new Tuple2((Object)status, (Object)CheckpointInstance$.MODULE$.apply(status.getPath()));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(FileStatus x1) {
                    Option<Tuple2<FileStatus, Object>> option;
                    FileStatus fileStatus = x1;
                    return fileStatus != null && !(option = FileNames$CheckpointFile$.MODULE$.unapply(fileStatus)).isEmpty();
                }
            }).collect((PartialFunction)new Serializable((DeltaLog)this){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<FileStatus, CheckpointInstance>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 != null) {
                        FileStatus fileStatus = (FileStatus)A1._1();
                        CheckpointInstance ci = (CheckpointInstance)A1._2();
                        if (ci.format().usesSidecars()) {
                            return (B1)fileStatus;
                        }
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Tuple2<FileStatus, CheckpointInstance> x2) {
                    CheckpointInstance ci;
                    Tuple2<FileStatus, CheckpointInstance> tuple2 = x2;
                    return tuple2 != null && (ci = (CheckpointInstance)tuple2._2()).format().usesSidecars();
                }
            }).toSeq().partition((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$identifyAndDeleteUnreferencedSidecarFiles$1(x$8)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq parquetCheckpointFiles = (Seq)tuple2._1();
            Seq otherFiles = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)parquetCheckpointFiles, (Object)otherFiles);
            Seq parquetCheckpointFiles2 = (Seq)tuple22._1();
            Seq otherFiles2 = (Seq)tuple22._2();
            Tuple2 tuple23 = otherFiles2.partition((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$identifyAndDeleteUnreferencedSidecarFiles$2(x$10)));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Seq jsonCheckpointFiles = (Seq)tuple23._1();
            Seq unknownFormatCheckpointFiles = (Seq)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)jsonCheckpointFiles, (Object)unknownFormatCheckpointFiles);
            Seq jsonCheckpointFiles2 = (Seq)tuple24._1();
            Seq unknownFormatCheckpointFiles2 = (Seq)tuple24._2();
            if (unknownFormatCheckpointFiles2.nonEmpty()) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found checkpoint files other than parquet and json: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.PATHS(), (Object)((IterableOnceOps)unknownFormatCheckpointFiles2.map((Function1 & Serializable)x$12 -> x$12.getPath().toString())).mkString(","))})))));
            }
            metrics.numActiveParquetCheckpointFiles_$eq(parquetCheckpointFiles2.size());
            metrics.numActiveJsonCheckpointFiles_$eq(jsonCheckpointFiles2.size());
            Option<DeltaLogFileIndex> parquetCheckpointsFileIndex = DeltaLogFileIndex$.MODULE$.apply((FileFormat)DeltaLogFileIndex$.MODULE$.CHECKPOINT_FILE_FORMAT_PARQUET(), (Seq<FileStatus>)parquetCheckpointFiles2);
            Option<DeltaLogFileIndex> jsonCheckpointsFileIndex = DeltaLogFileIndex$.MODULE$.apply((FileFormat)DeltaLogFileIndex$.MODULE$.CHECKPOINT_FILE_FORMAT_JSON(), (Seq<FileStatus>)jsonCheckpointFiles2);
            long identifyActiveSidecarsStartTimeMs = System.currentTimeMillis();
            metrics.activeCheckpointsListingTimeTakenMs_$eq(identifyActiveSidecarsStartTimeMs - startTimeMs);
            Dataset df = (Dataset)((IterableOnceOps)((IterableOps)Option$.MODULE$.option2Iterable(parquetCheckpointsFileIndex).$plus$plus(jsonCheckpointsFileIndex)).map((Function1 & Serializable)x$13 -> ((DeltaLog)this).loadIndex((DeltaLogFileIndex)x$13, Action$.MODULE$.logSchema().apply((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sidecar"})))))).reduceOption((Function2 & Serializable)(x$14, x$15) -> x$14.union(x$15)).getOrElse((Function0 & Serializable)() -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            Set activeSidecarFiles = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.select("sidecar.path", (Seq)Nil$.MODULE$).where("path is not null").as(package$.MODULE$.stringEncoder()).collect()), (Function1 & Serializable)p -> new Path(p).getName(), ClassTag$.MODULE$.apply(String.class))).toSet();
            long identifyAndDeleteSidecarsStartTimeMs = System.currentTimeMillis();
            metrics.identifyActiveSidecarsTimeTakenMs_$eq(identifyAndDeleteSidecarsStartTimeMs - identifyActiveSidecarsStartTimeMs);
            long retentionTimestamp = checkpointRetention;
            Iterator<FileStatus> sidecarFilesIterator = new Iterator<FileStatus>((DeltaLog)this, fs){
                private final RemoteIterator<FileStatus> remoteIterator;

                public final boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public final Iterator<FileStatus> iterator() {
                    return Iterator.iterator$((Iterator)this);
                }

                public Option<FileStatus> nextOption() {
                    return Iterator.nextOption$((Iterator)this);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public BufferedIterator<FileStatus> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator<B> padTo(int len, B elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> partition(Function1<FileStatus, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public <B$> Iterator<B$> scanLeft(B$ z, Function2<B$, FileStatus, B$> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B$> Iterator<B$> scanRight(B$ z, Function2<FileStatus, B$, B$> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public int indexWhere(Function1<FileStatus, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public int indexWhere$default$2() {
                    return Iterator.indexWhere$default$2$((Iterator)this);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public final int length() {
                    return Iterator.length$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public Iterator<FileStatus> filter(Function1<FileStatus, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public Iterator<FileStatus> filterNot(Function1<FileStatus, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public Iterator<FileStatus> filterImpl(Function1<FileStatus, Object> p, boolean isFlipped) {
                    return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
                }

                public Iterator<FileStatus> withFilter(Function1<FileStatus, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B$> Iterator<B$> collect(PartialFunction<FileStatus, B$> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public Iterator<FileStatus> distinct() {
                    return Iterator.distinct$((Iterator)this);
                }

                public <B$> Iterator<FileStatus> distinctBy(Function1<FileStatus, B$> f) {
                    return Iterator.distinctBy$((Iterator)this, f);
                }

                public <B$> Iterator<B$> map(Function1<FileStatus, B$> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B$> Iterator<B$> flatMap(Function1<FileStatus, IterableOnce<B$>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public <B$> Iterator<B$> flatten(Function1<FileStatus, IterableOnce<B$>> ev) {
                    return Iterator.flatten$((Iterator)this, ev);
                }

                public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                    return Iterator.concat$((Iterator)this, xs);
                }

                public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                    return Iterator.$plus$plus$((Iterator)this, xs);
                }

                public Iterator<FileStatus> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<FileStatus> takeWhile(Function1<FileStatus, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Iterator<FileStatus> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<FileStatus> dropWhile(Function1<FileStatus, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> span(Function1<FileStatus, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<FileStatus> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<FileStatus> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B$> Iterator<Tuple2<FileStatus, B$>> zip(IterableOnce<B$> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public Iterator<Tuple2<FileStatus, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B> boolean sameElements(IterableOnce<B> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <U> Iterator<FileStatus> tapEach(Function1<FileStatus, U> f) {
                    return Iterator.tapEach$((Iterator)this, f);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public Iterator<FileStatus> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> splitAt(int n) {
                    return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
                }

                public boolean isTraversableAgain() {
                    return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
                }

                public <U> void foreach(Function1<FileStatus, U> f) {
                    IterableOnceOps.foreach$((IterableOnceOps)this, f);
                }

                public boolean forall(Function1<FileStatus, Object> p) {
                    return IterableOnceOps.forall$((IterableOnceOps)this, p);
                }

                public boolean exists(Function1<FileStatus, Object> p) {
                    return IterableOnceOps.exists$((IterableOnceOps)this, p);
                }

                public int count(Function1<FileStatus, Object> p) {
                    return IterableOnceOps.count$((IterableOnceOps)this, p);
                }

                public Option<FileStatus> find(Function1<FileStatus, Object> p) {
                    return IterableOnceOps.find$((IterableOnceOps)this, p);
                }

                public <B$> B$ foldLeft(B$ z, Function2<B$, FileStatus, B$> op) {
                    return (B$)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                }

                public <B$> B$ foldRight(B$ z, Function2<FileStatus, B$, B$> op) {
                    return (B$)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                }

                public final <B$> B$ $div$colon(B$ z, Function2<B$, FileStatus, B$> op) {
                    return (B$)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                }

                public final <B$> B$ $colon$bslash(B$ z, Function2<FileStatus, B$, B$> op) {
                    return (B$)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                }

                public <B> B reduce(Function2<B, B, B> op) {
                    return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                    return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                }

                public <B> B reduceLeft(Function2<B, FileStatus, B> op) {
                    return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                }

                public <B> B reduceRight(Function2<FileStatus, B, B> op) {
                    return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, FileStatus, B> op) {
                    return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<FileStatus, B, B> op) {
                    return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                }

                public boolean nonEmpty() {
                    return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                }

                public int size() {
                    return IterableOnceOps.size$((IterableOnceOps)this);
                }

                public final <B> void copyToBuffer(Buffer<B> dest) {
                    IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                }

                public <B> int copyToArray(Object xs) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                }

                public <B> int copyToArray(Object xs, int start) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                }

                public <B> int copyToArray(Object xs, int start, int len) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                }

                public Object min(Ordering ord) {
                    return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<FileStatus> minOption(Ordering<B> ord) {
                    return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                }

                public Object max(Ordering ord) {
                    return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<FileStatus> maxOption(Ordering<B> ord) {
                    return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                }

                public Object maxBy(Function1 f, Ordering ord) {
                    return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
                }

                public <B$> Option<FileStatus> maxByOption(Function1<FileStatus, B$> f, Ordering<B$> ord) {
                    return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
                }

                public Object minBy(Function1 f, Ordering ord) {
                    return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
                }

                public <B$> Option<FileStatus> minByOption(Function1<FileStatus, B$> f, Ordering<B$> ord) {
                    return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
                }

                public <B$> Option<B$> collectFirst(PartialFunction<FileStatus, B$> pf) {
                    return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                }

                public <B$> B$ aggregate(Function0<B$> z, Function2<B$, FileStatus, B$> seqop, Function2<B$, B$, B$> combop) {
                    return (B$)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                }

                public <B$> boolean corresponds(IterableOnce<B$> that, Function2<FileStatus, B$, Object> p) {
                    return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                }

                public final String mkString(String start, String sep, String end) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                }

                public final String mkString(String sep) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                }

                public final String mkString() {
                    return IterableOnceOps.mkString$((IterableOnceOps)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public final StringBuilder addString(StringBuilder b, String sep) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                }

                public final StringBuilder addString(StringBuilder b) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                }

                public <C1> C1 to(Factory<FileStatus, C1> factory) {
                    return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                }

                public final Iterator<FileStatus> toIterator() {
                    return IterableOnceOps.toIterator$((IterableOnceOps)this);
                }

                public List<FileStatus> toList() {
                    return IterableOnceOps.toList$((IterableOnceOps)this);
                }

                public Vector<FileStatus> toVector() {
                    return IterableOnceOps.toVector$((IterableOnceOps)this);
                }

                public <K, V> Map<K, V> toMap(.less.colon.less<FileStatus, Tuple2<K, V>> ev) {
                    return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                }

                public <B> Set<B> toSet() {
                    return IterableOnceOps.toSet$((IterableOnceOps)this);
                }

                public Seq<FileStatus> toSeq() {
                    return IterableOnceOps.toSeq$((IterableOnceOps)this);
                }

                public IndexedSeq<FileStatus> toIndexedSeq() {
                    return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                }

                public final Stream<FileStatus> toStream() {
                    return IterableOnceOps.toStream$((IterableOnceOps)this);
                }

                public final <B> Buffer<B> toBuffer() {
                    return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                }

                public <B> Object toArray(ClassTag<B> evidence$2) {
                    return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                }

                public Iterable<FileStatus> reversed() {
                    return IterableOnceOps.reversed$((IterableOnceOps)this);
                }

                public <S extends Stepper<?>> S stepper(StepperShape<FileStatus, S> shape) {
                    return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                }

                public int knownSize() {
                    return IterableOnce.knownSize$((IterableOnce)this);
                }

                public RemoteIterator<FileStatus> remoteIterator() {
                    return this.remoteIterator;
                }

                public boolean hasNext() {
                    return this.remoteIterator().hasNext();
                }

                public FileStatus next() {
                    return (FileStatus)this.remoteIterator().next();
                }
                {
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                    this.remoteIterator = fs$2.listStatusIterator($outer.sidecarDirPath());
                }
            };
            Iterator sidecarFilesToDelete = sidecarFilesIterator.collect((PartialFunction)new Serializable((DeltaLog)this, retentionTimestamp){
                private static final long serialVersionUID = 0L;
                private final long retentionTimestamp$1;

                public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1.getModificationTime() < this.retentionTimestamp$1) {
                        return (B1)A1.getPath();
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(FileStatus x3) {
                    FileStatus fileStatus = x3;
                    return fileStatus.getModificationTime() < this.retentionTimestamp$1;
                }
                {
                    this.retentionTimestamp$1 = retentionTimestamp$1;
                }
            }).filterNot((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)activeSidecarFiles.contains((Object)path.getName())));
            long sidecarDeletionStartTimeMs = System.currentTimeMillis();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting the deletion of unreferenced sidecar files"}))).log((Seq)Nil$.MODULE$)));
            long count = this.deleteMultiple(fs, (Iterator<Path>)sidecarFilesToDelete);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " sidecar files"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.COUNT(), (Object)BoxesRunTime.boxToLong((long)count))}))));
            metrics.numSidecarFilesDeleted_$eq(count);
            long endTimeMs = System.currentTimeMillis();
            metrics.identifyAndDeleteSidecarsTimeTakenMs_$eq(sidecarDeletionStartTimeMs - identifyAndDeleteSidecarsStartTimeMs);
            metrics.overallSidecarProcessingTimeTakenMs_$eq(endTimeMs - startTimeMs);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private long deleteMultiple(FileSystem fs, Iterator<Path> paths) {
        return BoxesRunTime.unboxToLong((Object)paths.map((Function1 & Serializable)path -> BoxesRunTime.boxToLong((long)MetadataCleanup.$anonfun$deleteMultiple$1(fs, path))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static /* synthetic */ Option findEarliestReliableCheckpoint$(MetadataCleanup $this) {
        return $this.findEarliestReliableCheckpoint();
    }

    default public Option<Object> findEarliestReliableCheckpoint() {
        Configuration hadoopConf = ((DeltaLog)this).newDeltaHadoopConf();
        ObjectRef earliestCheckpointVersionOpt = ObjectRef.create((Object)None$.MODULE$);
        ArrayBuffer currentCheckpointFiles = ArrayBuffer$.MODULE$.empty();
        LongRef prevCommitVersion = LongRef.create((long)0L);
        ((DeltaLog)this).store().listFrom(FileNames$.MODULE$.listingPrefix(((DeltaLog)this).logPath(), 0L), hadoopConf).map((Function1 & Serializable)x$18 -> x$18.getPath()).foreach((Function1 & Serializable)x0$1 -> {
            Option<Tuple2<Path, Object>> option;
            Option<Tuple2<Path, Object>> option2;
            Path path = x0$1;
            if (path != null && !(option2 = FileNames$CheckpointFile$.MODULE$.unapply(path)).isEmpty()) {
                Path f = (Path)((Tuple2)option2.get())._1();
                long checkpointVersion = ((Tuple2)option2.get())._2$mcJ$sp();
                if (((Option)earliestCheckpointVersionOpt$1.elem).isEmpty()) {
                    if (!MetadataCleanup.currentCheckpointVersionOpt$1(currentCheckpointFiles).contains((Object)BoxesRunTime.boxToLong((long)checkpointVersion))) {
                        currentCheckpointFiles.clear();
                    }
                    return currentCheckpointFiles.$plus$eq((Object)f);
                }
            }
            if (path != null && !(option = FileNames$DeltaFile$.MODULE$.unapply(path)).isEmpty()) {
                long deltaVersion = ((Tuple2)option.get())._2$mcJ$sp();
                if (((Option)earliestCheckpointVersionOpt$1.elem).isEmpty() && this.isCurrentCheckpointComplete$1(currentCheckpointFiles) && MetadataCleanup.currentCheckpointVersionOpt$1(currentCheckpointFiles).contains((Object)BoxesRunTime.boxToLong((long)deltaVersion))) {
                    earliestCheckpointVersionOpt$1.elem = MetadataCleanup.currentCheckpointVersionOpt$1(currentCheckpointFiles);
                    prevCommitVersion$1.elem = deltaVersion;
                }
                currentCheckpointFiles.clear();
                if (deltaVersion > prevCommitVersion$1.elem + 1L) {
                    earliestCheckpointVersionOpt$1.elem = None$.MODULE$;
                }
                prevCommitVersion$1.elem = deltaVersion;
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        return (Option)earliestCheckpointVersionOpt.elem;
    }

    public static /* synthetic */ void $anonfun$cleanUpExpiredLogs$7(FileSystem fs$1, IntRef numDeleted$1, BooleanRef wasCheckpointDeleted$1, LongRef maxBackfilledVersionDeleted$1, Path path) {
        if (fs$1.delete(path, false)) {
            ++numDeleted$1.elem;
            if (FileNames$.MODULE$.isCheckpointFile(path)) {
                wasCheckpointDeleted$1.elem = true;
            }
            if (FileNames$.MODULE$.isDeltaFile(path)) {
                maxBackfilledVersionDeleted$1.elem = Math.max(maxBackfilledVersionDeleted$1.elem, FileNames$.MODULE$.deltaVersion(path));
                return;
            }
            return;
        }
    }

    public static /* synthetic */ boolean $anonfun$cleanUpExpiredLogs$8(LongRef maxBackfilledVersionDeleted$1, FileStatus x0$1) {
        Option<Tuple3<FileStatus, Object, String>> option;
        FileStatus fileStatus = x0$1;
        if (fileStatus != null && !(option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(fileStatus)).isEmpty()) {
            long fileVersion = BoxesRunTime.unboxToLong((Object)((Tuple3)option.get())._2());
            return fileVersion <= maxBackfilledVersionDeleted$1.elem;
        }
        throw new MatchError((Object)fileStatus);
    }

    public static /* synthetic */ boolean $anonfun$listExpiredDeltaLogs$1(FileStatus f) {
        return FileNames$.MODULE$.isCheckpointFile(f) || FileNames$.MODULE$.isDeltaFile(f) || FileNames$.MODULE$.isChecksumFile(f);
    }

    public static /* synthetic */ boolean $anonfun$checkpointExistsAtCleanupBoundary$1(long version$1, CheckpointInstance x$2) {
        return x$2.version() == version$1;
    }

    private NumericRange.Inclusive expandVersionRange$1(NumericRange.Inclusive currentRange, long versionToCover) {
        return this.versionRange(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)currentRange.start())), versionToCover), RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)currentRange.end())), versionToCover));
    }

    public static /* synthetic */ boolean $anonfun$allProtocolsSupported$3(long expectedChecksumFileCount$1, Object nonLocalReturnKey2$1, DeltaLog deltaLog$1, StructType schemaToUse$1, Column supported$1, DeltaLogFileIndex index) {
        if ((long)index.inputFiles().length != expectedChecksumFileCount$1) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, false);
        }
        return ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])deltaLog$1.loadIndex(index, schemaToUse$1).filter(functions$.MODULE$.isnull(functions$.MODULE$.col("protocol")).$bar$bar((Object)functions$.MODULE$.not(supported$1))).take(1)));
    }

    public static /* synthetic */ boolean $anonfun$allProtocolsSupported$5(NumericRange.Inclusive versionRange$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long version = tuple2._2$mcJ$sp();
            return version <= BoxesRunTime.unboxToLong((Object)versionRange$1.end());
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$createSinglePartCheckpointForBackwardCompat$1(long checkpointVersion$1, FileStatus file) {
        return FileNames$.MODULE$.getFileVersionOpt(file.getPath()).exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$6 -> x$6 <= checkpointVersion$1);
    }

    public static /* synthetic */ boolean $anonfun$createSinglePartCheckpointForBackwardCompat$3(CheckpointInstance x$7) {
        CheckpointInstance.Format format = x$7.format();
        CheckpointInstance$Format$V2$ checkpointInstance$Format$V2$ = CheckpointInstance$Format$V2$.MODULE$;
        return format == null ? checkpointInstance$Format$V2$ != null : !format.equals(checkpointInstance$Format$V2$);
    }

    public static /* synthetic */ boolean $anonfun$identifyAndDeleteUnreferencedSidecarFiles$1(FileStatus x$8) {
        return x$8.getPath().getName().endsWith("parquet");
    }

    public static /* synthetic */ boolean $anonfun$identifyAndDeleteUnreferencedSidecarFiles$2(FileStatus x$10) {
        return x$10.getPath().getName().endsWith("json");
    }

    public static /* synthetic */ long $anonfun$deleteMultiple$1(FileSystem fs$3, Path path) {
        if (fs$3.delete(path, false)) {
            return 1L;
        }
        return 0L;
    }

    private static Option currentCheckpointVersionOpt$1(ArrayBuffer currentCheckpointFiles$1) {
        return currentCheckpointFiles$1.headOption().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)FileNames$.MODULE$.checkpointVersion(x$16)));
    }

    private boolean isCurrentCheckpointComplete$1(ArrayBuffer currentCheckpointFiles$1) {
        CheckpointInstance[] instances = (CheckpointInstance[])((IterableOnceOps)currentCheckpointFiles$1.map((Function1 & Serializable)x$17 -> CheckpointInstance$.MODULE$.apply((Path)x$17))).toArray(ClassTag$.MODULE$.apply(CheckpointInstance.class));
        return ((Checkpoints)((Object)this)).getLatestCompleteCheckpointFromList(instances, ((Checkpoints)((Object)this)).getLatestCompleteCheckpointFromList$default$2()).isDefined();
    }

    public static void $init$(MetadataCleanup $this) {
    }

    public static class SidecarDeletionMetrics {
        private long numSidecarFilesDeleted;
        private long numActiveParquetCheckpointFiles;
        private long numActiveJsonCheckpointFiles;
        private long activeCheckpointsListingTimeTakenMs;
        private long identifyAndDeleteSidecarsTimeTakenMs;
        private long identifyActiveSidecarsTimeTakenMs;
        private long overallSidecarProcessingTimeTakenMs;
        public final /* synthetic */ DeltaLog $outer;

        public long numSidecarFilesDeleted() {
            return this.numSidecarFilesDeleted;
        }

        public void numSidecarFilesDeleted_$eq(long x$1) {
            this.numSidecarFilesDeleted = x$1;
        }

        public long numActiveParquetCheckpointFiles() {
            return this.numActiveParquetCheckpointFiles;
        }

        public void numActiveParquetCheckpointFiles_$eq(long x$1) {
            this.numActiveParquetCheckpointFiles = x$1;
        }

        public long numActiveJsonCheckpointFiles() {
            return this.numActiveJsonCheckpointFiles;
        }

        public void numActiveJsonCheckpointFiles_$eq(long x$1) {
            this.numActiveJsonCheckpointFiles = x$1;
        }

        public long activeCheckpointsListingTimeTakenMs() {
            return this.activeCheckpointsListingTimeTakenMs;
        }

        public void activeCheckpointsListingTimeTakenMs_$eq(long x$1) {
            this.activeCheckpointsListingTimeTakenMs = x$1;
        }

        public long identifyAndDeleteSidecarsTimeTakenMs() {
            return this.identifyAndDeleteSidecarsTimeTakenMs;
        }

        public void identifyAndDeleteSidecarsTimeTakenMs_$eq(long x$1) {
            this.identifyAndDeleteSidecarsTimeTakenMs = x$1;
        }

        public long identifyActiveSidecarsTimeTakenMs() {
            return this.identifyActiveSidecarsTimeTakenMs;
        }

        public void identifyActiveSidecarsTimeTakenMs_$eq(long x$1) {
            this.identifyActiveSidecarsTimeTakenMs = x$1;
        }

        public long overallSidecarProcessingTimeTakenMs() {
            return this.overallSidecarProcessingTimeTakenMs;
        }

        public void overallSidecarProcessingTimeTakenMs_$eq(long x$1) {
            this.overallSidecarProcessingTimeTakenMs = x$1;
        }

        public /* synthetic */ DeltaLog org$apache$spark$sql$delta$MetadataCleanup$SidecarDeletionMetrics$$$outer() {
            return this.$outer;
        }

        public SidecarDeletionMetrics(DeltaLog $outer) {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.numSidecarFilesDeleted = -1L;
            this.numActiveParquetCheckpointFiles = -1L;
            this.numActiveJsonCheckpointFiles = -1L;
            this.activeCheckpointsListingTimeTakenMs = -1L;
            this.identifyAndDeleteSidecarsTimeTakenMs = -1L;
            this.identifyActiveSidecarsTimeTakenMs = -1L;
            this.overallSidecarProcessingTimeTakenMs = -1L;
        }
    }

    public static class V2CompatCheckpointMetrics {
        private long v2CheckpointCompatLogicTimeTakenMs;
        private long checkpointVersion;
        public final /* synthetic */ DeltaLog $outer;

        public long v2CheckpointCompatLogicTimeTakenMs() {
            return this.v2CheckpointCompatLogicTimeTakenMs;
        }

        public void v2CheckpointCompatLogicTimeTakenMs_$eq(long x$1) {
            this.v2CheckpointCompatLogicTimeTakenMs = x$1;
        }

        public long checkpointVersion() {
            return this.checkpointVersion;
        }

        public void checkpointVersion_$eq(long x$1) {
            this.checkpointVersion = x$1;
        }

        public /* synthetic */ DeltaLog org$apache$spark$sql$delta$MetadataCleanup$V2CompatCheckpointMetrics$$$outer() {
            return this.$outer;
        }

        public V2CompatCheckpointMetrics(DeltaLog $outer) {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.v2CheckpointCompatLogicTimeTakenMs = -1L;
            this.checkpointVersion = -1L;
        }
    }
}

