/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations$ManualUpdate$;
import org.apache.spark.sql.delta.RecordChecksum$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.VersionChecksum;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.InMemoryLogReplay;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.stats.DeletedRecordCountsHistogram;
import org.apache.spark.sql.delta.stats.DeletedRecordCountsHistogram$;
import org.apache.spark.sql.delta.stats.FileSizeHistogram;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.delta.util.Utils$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dgaB\n\u0015!\u0003\r\ta\b\u0005\u0006Y\u0001!\t!\f\u0005\bc\u0001\u0011\rQ\"\u00013\u0011\u0015I\u0002A\"\u00058\u0011!a\u0004\u0001#b\u0001\n\u0013i\u0004\"\u0002$\u0001\t\u00139\u0005\"\u0002)\u0001\t#\t\u0006\"\u00021\u0001\t\u0003\t\u0007\u0002CA\u0018\u0001\u0011\u0005A#!\r\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBAE\u0001\u0011%\u00111R\u0004\b\u0003G#\u0002\u0012AAS\r\u0019\u0019B\u0003#\u0001\u0002(\"9\u0011\u0011V\u0007\u0005\u0002\u0005-\u0006BCAW\u001b\t\u0007I\u0011\u0001\u000b\u00020\"A\u0011\u0011Y\u0007!\u0002\u0013\t\t\f\u0003\u0006\u0002D6\u0011\r\u0011\"\u0001\u0015\u0003_C\u0001\"!2\u000eA\u0003%\u0011\u0011\u0017\u0002\u000f%\u0016\u001cwN\u001d3DQ\u0016\u001c7n];n\u0015\t)b#A\u0003eK2$\u0018M\u0003\u0002\u00181\u0005\u00191/\u001d7\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014+\u001b\u0005A#BA\u0015\u0015\u0003!iW\r^3sS:<\u0017BA\u0016)\u00051!U\r\u001c;b\u0019><w-\u001b8h\u0003\u0019!\u0013N\\5uIQ\ta\u0006\u0005\u0002\"_%\u0011\u0001G\t\u0002\u0005+:LG/\u0001\u0005eK2$\u0018\rT8h+\u0005\u0019\u0004C\u0001\u001b6\u001b\u0005!\u0012B\u0001\u001c\u0015\u0005!!U\r\u001c;b\u0019><W#\u0001\u001d\u0011\u0005eRT\"\u0001\f\n\u0005m2\"\u0001D*qCJ\\7+Z:tS>t\u0017AB<sSR,'/F\u0001?!\tyD)D\u0001A\u0015\t\t%)A\u0005tiJ,\u0017-\\5oO*\u00111IF\u0001\nKb,7-\u001e;j_:L!!\u0012!\u0003+\rCWmY6q_&tGOR5mK6\u000bg.Y4fe\u0006Yq-\u001a;DQ\u0016\u001c7n];n)\tA5\n\u0005\u00025\u0013&\u0011!\n\u0006\u0002\u0010-\u0016\u00148/[8o\u0007\",7m[:v[\")A*\u0002a\u0001\u001b\u0006A1O\\1qg\"|G\u000f\u0005\u00025\u001d&\u0011q\n\u0006\u0002\t':\f\u0007o\u001d5pi\u0006\trO]5uK\u000eCWmY6tk64\u0015\u000e\\3\u0015\u00079\u0012v\fC\u0003T\r\u0001\u0007A+A\u0003uq:LE\r\u0005\u0002V9:\u0011aK\u0017\t\u0003/\nj\u0011\u0001\u0017\u0006\u00033z\ta\u0001\u0010:p_Rt\u0014BA.#\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m\u0013\u0003\"\u0002'\u0007\u0001\u0004i\u0015aG5oGJ,W.\u001a8uC2d\u0017\u0010R3sSZ,7\t[3dWN,X\u000e\u0006\tcW2l'\u000f`A\u0005\u0003+\tI\"a\b\u0002&A!1\r\u001b+I\u001d\t!gM\u0004\u0002XK&\t1%\u0003\u0002hE\u00059\u0001/Y2lC\u001e,\u0017BA5k\u0005\u0019)\u0015\u000e\u001e5fe*\u0011qM\t\u0005\u00063\u001d\u0001\r\u0001\u000f\u0005\u0006c\u001d\u0001\ra\r\u0005\u0006]\u001e\u0001\ra\\\u0001\u0011m\u0016\u00148/[8o)>\u001cu.\u001c9vi\u0016\u0004\"!\t9\n\u0005E\u0014#\u0001\u0002'p]\u001eDQa]\u0004A\u0002Q\fq!Y2uS>t7\u000fE\u0002dk^L!A\u001e6\u0003\u0007M+\u0017\u000f\u0005\u0002yu6\t\u0011P\u0003\u0002t)%\u001110\u001f\u0002\u0007\u0003\u000e$\u0018n\u001c8\t\u000bu<\u0001\u0019\u0001@\u0002\u00175,G/\u00193bi\u0006|\u0005\u000f\u001e\t\u0005C}\f\u0019!C\u0002\u0002\u0002\t\u0012aa\u00149uS>t\u0007c\u0001=\u0002\u0006%\u0019\u0011qA=\u0003\u00115+G/\u00193bi\u0006Dq!a\u0003\b\u0001\u0004\ti!A\u0006qe>$xnY8m\u001fB$\b\u0003B\u0011\u0000\u0003\u001f\u00012\u0001_A\t\u0013\r\t\u0019\"\u001f\u0002\t!J|Go\\2pY\"1\u0011qC\u0004A\u0002Q\u000bQb\u001c9fe\u0006$\u0018n\u001c8OC6,\u0007bBA\u000e\u000f\u0001\u0007\u0011QD\u0001\tibt\u0017\nZ(qiB\u0019\u0011e +\t\u000f\u0005\u0005r\u00011\u0001\u0002$\u0005!\u0002O]3wS>,8OV3sg&|gn\u0015;bi\u0016\u0004Ba\u00195N\u0011\"9\u0011qE\u0004A\u0002\u0005%\u0012\u0001F5oG2,H-Z!eI\u001aKG.Z:J]\u000e\u00138\rE\u0002\"\u0003WI1!!\f#\u0005\u001d\u0011un\u001c7fC:\f!cY8naV$XMT3x\u0007\",7m[:v[R9\"-a\r\u00028\u0005e\u00121HA \u0003\u000b\n9%a\u0013\u0002P\u0005M\u0013q\u000b\u0005\u0007\u0003kA\u0001\u0019A8\u0002\u001d\u0005$H/Z7qiZ+'o]5p]\"1\u0011q\u0003\u0005A\u0002QCq!a\u0007\t\u0001\u0004\ti\u0002\u0003\u0004\u0002>!\u0001\r\u0001S\u0001\u0013_2$g+\u001a:tS>t7\t[3dWN,X\u000eC\u0004\u0002B!\u0001\r!a\u0011\u0002\u0017=dGm\u00158baNDw\u000e\u001e\t\u0004C}l\u0005\"B:\t\u0001\u0004!\bbBA%\u0011\u0001\u0007\u0011\u0011F\u0001\u000fS\u001etwN]3BI\u00124\u0015\u000e\\3t\u0011\u001d\ti\u0005\u0003a\u0001\u0003S\t\u0011#[4o_J,'+Z7pm\u00164\u0015\u000e\\3t\u0011\u001d\t\t\u0006\u0003a\u0001\u0003S\tA#\u001b8dYV$W-\u00117m\r&dWm]%o\u0007J\u001b\u0005bBA+\u0011\u0001\u0007\u0011\u0011F\u0001\u001da\u0016\u00148/[:uK:$HIV:P]R\u000b'\r\\3SK\u0006$\u0017M\u00197f\u0011\u001d\tI\u0006\u0003a\u0001\u0003S\tA\u0004]3sg&\u001cH/\u001a8u\tZ\u001bxJ\u001c+bE2,wK]5uC\ndW-A\u0012j]\u000e\u0014X-\\3oi\u0006dG._\"p[B,H/Z*fiR\u0013\u0018M\\:bGRLwN\\:\u0015\u0015\u0005}\u0013\u0011NA6\u0003[\ny\u0007\u0005\u0003\"\u007f\u0006\u0005\u0004\u0003B2v\u0003G\u00022\u0001_A3\u0013\r\t9'\u001f\u0002\u000f'\u0016$HK]1og\u0006\u001cG/[8o\u0011\u001d\t\t%\u0003a\u0001\u0003\u0007Ba!!\u0010\n\u0001\u0004A\u0005BBA\u001b\u0013\u0001\u0007q\u000e\u0003\u0004\u0002r%\u0001\r\u0001^\u0001\u0010C\u000e$\u0018n\u001c8t)>\u001cu.\\7ji\u0006\u0019\u0013N\\2sK6,g\u000e^1mYf\u001cu.\u001c9vi\u0016$u.\\1j]6+G/\u00193bi\u0006\u001cHCCA<\u0003\u0003\u000b\u0019)!\"\u0002\bB!\u0011e`A=!\u0011\u0019W/a\u001f\u0011\u0007a\fi(C\u0002\u0002\u0000e\u0014a\u0002R8nC&tW*\u001a;bI\u0006$\u0018\rC\u0004\u0002B)\u0001\r!a\u0011\t\r\u0005u\"\u00021\u0001I\u0011\u0019\t)D\u0003a\u0001_\"1\u0011\u0011\u000f\u0006A\u0002Q\fA$\u001b8de\u0016lWM\u001c;bY2L8i\\7qkR,\u0017\t\u001a3GS2,7\u000f\u0006\u0007\u0002\u000e\u0006]\u0015\u0011TAN\u0003;\u000b\t\u000b\u0005\u0003\"\u007f\u0006=\u0005\u0003B2v\u0003#\u00032\u0001_AJ\u0013\r\t)*\u001f\u0002\b\u0003\u0012$g)\u001b7f\u0011\u001d\t\te\u0003a\u0001\u0003\u0007Ba!!\u0010\f\u0001\u0004A\u0005BBA\u001b\u0017\u0001\u0007q\u000e\u0003\u0004\u0002 .\u0001\ra\\\u0001\u0014]Vlg)\u001b7fg\u00063G/\u001a:D_6l\u0017\u000e\u001e\u0005\u0007\u0003cZ\u0001\u0019\u0001;\u0002\u001dI+7m\u001c:e\u0007\",7m[:v[B\u0011A'D\n\u0003\u001b\u0001\na\u0001P5oSRtDCAAS\u0003Mz\u0007/\u001a:bi&|gNT1nKN<\u0006.\u001a:f\u0003\u0012$g)\u001b7fg&;gn\u001c:fI\u001a{'/\u00138de\u0016lWM\u001c;bY\u000e\u00138-\u0006\u0002\u00022B)\u00111WA_)6\u0011\u0011Q\u0017\u0006\u0005\u0003o\u000bI,A\u0005j[6,H/\u00192mK*\u0019\u00111\u0018\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002@\u0006U&aA*fi\u0006!t\u000e]3sCRLwN\u001c(b[\u0016\u001cx\u000b[3sK\u0006#GMR5mKNLuM\\8sK\u00124uN]%oGJ,W.\u001a8uC2\u001c%o\u0019\u0011\u0002m=\u0004XM]1uS>tg*Y7fg^CWM]3SK6|g/\u001a$jY\u0016\u001c\u0018j\u001a8pe\u0016$gi\u001c:J]\u000e\u0014X-\\3oi\u0006d7I]2\u0002o=\u0004XM]1uS>tg*Y7fg^CWM]3SK6|g/\u001a$jY\u0016\u001c\u0018j\u001a8pe\u0016$gi\u001c:J]\u000e\u0014X-\\3oi\u0006d7I]2!\u0001")
public interface RecordChecksum
extends DeltaLogging {
    public DeltaLog deltaLog();

    public SparkSession spark();

    public static /* synthetic */ CheckpointFileManager org$apache$spark$sql$delta$RecordChecksum$$writer$(RecordChecksum $this) {
        return $this.org$apache$spark$sql$delta$RecordChecksum$$writer();
    }

    default public CheckpointFileManager org$apache$spark$sql$delta$RecordChecksum$$writer() {
        return CheckpointFileManager$.MODULE$.create(this.deltaLog().logPath(), this.deltaLog().newDeltaHadoopConf());
    }

    private VersionChecksum getChecksum(Snapshot snapshot) {
        return snapshot.computeChecksum();
    }

    public static /* synthetic */ void writeChecksumFile$(RecordChecksum $this, String txnId, Snapshot snapshot) {
        $this.writeChecksumFile(txnId, snapshot);
    }

    default public void writeChecksumFile(String txnId, Snapshot snapshot) {
        Map eventData;
        block7: {
            if (!BoxesRunTime.unboxToBoolean((Object)this.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_WRITE_CHECKSUM_ENABLED()))) {
                return;
            }
            long version = snapshot.version();
            VersionChecksum checksumWithoutTxnId = this.getChecksum(snapshot);
            VersionChecksum checksum = checksumWithoutTxnId.copy((Option<String>)new Some((Object)txnId), checksumWithoutTxnId.copy$default$2(), checksumWithoutTxnId.copy$default$3(), checksumWithoutTxnId.copy$default$4(), checksumWithoutTxnId.copy$default$5(), checksumWithoutTxnId.copy$default$6(), checksumWithoutTxnId.copy$default$7(), checksumWithoutTxnId.copy$default$8(), checksumWithoutTxnId.copy$default$9(), checksumWithoutTxnId.copy$default$10(), checksumWithoutTxnId.copy$default$11(), checksumWithoutTxnId.copy$default$12(), checksumWithoutTxnId.copy$default$13(), checksumWithoutTxnId.copy$default$14(), checksumWithoutTxnId.copy$default$15());
            eventData = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationSucceeded"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
            eventData.update((Object)"numAddFileActions", checksum.allFiles().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
            eventData.update((Object)"numSetTransactionActions", checksum.setTransactions().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
            long startTimeMs = System.currentTimeMillis();
            try {
                String toWrite = new StringBuilder(1).append(JsonUtils$.MODULE$.toJson(checksum, ManifestFactory$.MODULE$.classType(VersionChecksum.class))).append("\n").toString();
                eventData.update((Object)"jsonSerializationTimeTakenMs", (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTimeMs)));
                eventData.update((Object)"checksumLength", (Object)BoxesRunTime.boxToInteger((int)toWrite.length()));
                CheckpointFileManager.CancellableFSDataOutputStream stream = this.org$apache$spark$sql$delta$RecordChecksum$$writer().createAtomic(FileNames$.MODULE$.checksumFile(this.deltaLog().logPath(), version), false);
                try {
                    stream.write(toWrite.getBytes(StandardCharsets.UTF_8));
                    stream.close();
                    eventData.update((Object)"overallTimeTakenMs", (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTimeMs)));
                    eventData.update((Object)"operationSucceeded", (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable2)) {
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write the checksum for version: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToLong((long)version))})))), throwable2);
                        stream.cancel();
                        break block7;
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                if (NonFatal$.MODULE$.apply(throwable3)) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write the checksum for version: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToLong((long)version))})))), throwable3);
                }
                throw throwable;
            }
        }
        DeltaLog x$12 = this.deltaLog();
        String x$22 = "delta.checksum.write";
        Map x$3 = eventData;
        scala.collection.immutable.Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$12, "delta.checksum.write", x$4, x$3, x$5);
    }

    public static /* synthetic */ Either incrementallyDeriveChecksum$(RecordChecksum $this, SparkSession spark, DeltaLog deltaLog, long versionToCompute, Seq actions, Option metadataOpt, Option protocolOpt, String operationName, Option txnIdOpt, Either previousVersionState, boolean includeAddFilesInCrc) {
        return $this.incrementallyDeriveChecksum(spark, deltaLog, versionToCompute, (Seq<Action>)actions, (Option<Metadata>)metadataOpt, (Option<Protocol>)protocolOpt, operationName, (Option<String>)txnIdOpt, (Either<Snapshot, VersionChecksum>)previousVersionState, includeAddFilesInCrc);
    }

    default public Either<String, VersionChecksum> incrementallyDeriveChecksum(SparkSession spark, DeltaLog deltaLog, long versionToCompute, Seq<Action> actions, Option<Metadata> metadataOpt, Option<Protocol> protocolOpt, String operationName, Option<String> txnIdOpt, Either<Snapshot, VersionChecksum> previousVersionState, boolean includeAddFilesInCrc) {
        Either<String, VersionChecksum> either;
        Object object = new Object();
        try {
            Tuple2 tuple2;
            Left left;
            Snapshot snapshot2;
            Tuple2 tuple22;
            if (!deltaLog.incrementalCommitEnabled()) {
                return new Left((Object)"INCREMENTAL_COMMITS_DISABLED");
            }
            String string = operationName;
            String string2 = DeltaOperations$ManualUpdate$.MODULE$.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Left((Object)"INVALID_OPERATION_MANUAL_UPDATE");
            }
            long expectedVersion = versionToCompute - 1L;
            Either<Snapshot, VersionChecksum> either2 = previousVersionState;
            if (either2 instanceof Right) {
                Right right = (Right)either2;
                VersionChecksum checksum = (VersionChecksum)right.value();
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)checksum), (Object)None$.MODULE$);
            } else if (either2 instanceof Left && (snapshot2 = (Snapshot)(left = (Left)either2).value()).version() == expectedVersion) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Incremental commit: starting with snapshot version "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToLong((long)expectedVersion))})))));
                VersionChecksum qual$1 = this.getChecksum(snapshot2);
                long x$1 = 1L;
                long x$2 = 1L;
                Option<String> x$32 = qual$1.copy$default$1();
                long x$42 = qual$1.copy$default$2();
                long x$5 = qual$1.copy$default$3();
                Option<Object> x$6 = qual$1.copy$default$4();
                Option<Object> x$7 = qual$1.copy$default$5();
                Option<Object> x$8 = qual$1.copy$default$8();
                Option<Seq<SetTransaction>> x$9 = qual$1.copy$default$9();
                Option<Seq<DomainMetadata>> x$10 = qual$1.copy$default$10();
                Metadata x$11 = qual$1.copy$default$11();
                Protocol x$12 = qual$1.copy$default$12();
                Option<FileSizeHistogram> x$13 = qual$1.copy$default$13();
                Option<DeletedRecordCountsHistogram> x$14 = qual$1.copy$default$14();
                Option<Seq<AddFile>> x$15 = qual$1.copy$default$15();
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)qual$1.copy(x$32, x$42, x$5, x$6, x$7, 1L, 1L, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15)), (Object)new Some((Object)snapshot2));
            } else {
                previousVersionState.swap().foreach((Function1 & Serializable)snapshot -> {
                    RecordChecksum.$anonfun$incrementallyDeriveChecksum$2(this, deltaLog, versionToCompute, snapshot);
                    return BoxedUnit.UNIT;
                });
                Option<VersionChecksum> oldCrcOpt = deltaLog.readChecksum(expectedVersion, deltaLog.readChecksum$default$2());
                if (oldCrcOpt.isEmpty()) {
                    return new Left((Object)"MISSING_OLD_CRC");
                }
                Option oldCrcFiltered = oldCrcOpt.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyDeriveChecksum$3(x$3))).filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyDeriveChecksum$4(x$4)));
                VersionChecksum oldCrc = (VersionChecksum)oldCrcFiltered.getOrElse((Function0 & Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)new Left((Object)"OLD_CRC_INCOMPLETE"));
                });
                tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)oldCrc), (Object)None$.MODULE$);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            VersionChecksum oldVersionChecksum = (VersionChecksum)tuple2._1();
            Option oldSnapshot = (Option)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)oldVersionChecksum, (Object)oldSnapshot);
            VersionChecksum oldVersionChecksum2 = (VersionChecksum)tuple23._1();
            Option oldSnapshot2 = (Option)tuple23._2();
            boolean ignoreAddFilesInOperation = RecordChecksum$.MODULE$.operationNamesWhereAddFilesIgnoredForIncrementalCrc().contains((Object)operationName);
            boolean ignoreRemoveFilesInOperation = RecordChecksum$.MODULE$.operationNamesWhereRemoveFilesIgnoredForIncrementalCrc().contains((Object)operationName);
            Protocol protocol = (Protocol)protocolOpt.orElse((Function0 & Serializable)() -> actions.collectFirst((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Protocol) {
                        Protocol protocol = (Protocol)A1;
                        return (B1)protocol;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    return action instanceof Protocol;
                }
            })).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)oldVersionChecksum2.protocol())).getOrElse((Function0 & Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)new Left((Object)"PROTOCOL_MISSING"));
            });
            Metadata metadata = (Metadata)metadataOpt.orElse((Function0 & Serializable)() -> actions.collectFirst((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof Metadata) {
                        Metadata metadata = (Metadata)A1;
                        return (B1)metadata;
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Action x2) {
                    Action action = x2;
                    return action instanceof Metadata;
                }
            })).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)oldVersionChecksum2.metadata())).getOrElse((Function0 & Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)new Left((Object)"METADATA_MISSING"));
            });
            boolean persistentDVsOnTableReadable = DeletionVectorUtils$.MODULE$.deletionVectorsReadable(protocol, metadata);
            boolean persistentDVsOnTableWritable = DeletionVectorUtils$.MODULE$.deletionVectorsWritable(protocol, metadata);
            either = this.computeNewChecksum(versionToCompute, operationName, txnIdOpt, oldVersionChecksum2, (Option<Snapshot>)oldSnapshot2, actions, ignoreAddFilesInOperation, ignoreRemoveFilesInOperation, includeAddFilesInCrc, persistentDVsOnTableReadable, persistentDVsOnTableWritable);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either<String, VersionChecksum>)ex.value();
            }
            throw ex;
        }
        return either;
    }

    public static /* synthetic */ Either computeNewChecksum$(RecordChecksum $this, long attemptVersion, String operationName, Option txnIdOpt, VersionChecksum oldVersionChecksum, Option oldSnapshot, Seq actions, boolean ignoreAddFiles, boolean ignoreRemoveFiles, boolean includeAllFilesInCRC, boolean persistentDVsOnTableReadable, boolean persistentDVsOnTableWritable) {
        return $this.computeNewChecksum(attemptVersion, operationName, (Option<String>)txnIdOpt, oldVersionChecksum, (Option<Snapshot>)oldSnapshot, (Seq<Action>)actions, ignoreAddFiles, ignoreRemoveFiles, includeAllFilesInCRC, persistentDVsOnTableReadable, persistentDVsOnTableWritable);
    }

    default public Either<String, VersionChecksum> computeNewChecksum(long attemptVersion, String operationName, Option<String> txnIdOpt, VersionChecksum oldVersionChecksum, Option<Snapshot> oldSnapshot, Seq<Action> actions, boolean ignoreAddFiles, boolean ignoreRemoveFiles, boolean includeAllFilesInCRC, boolean persistentDVsOnTableReadable, boolean persistentDVsOnTableWritable) {
        Either either;
        Object object = new Object();
        try {
            oldSnapshot.foreach((Function1 & Serializable)s -> {
                Predef$.MODULE$.require(s.version() == attemptVersion - 1L);
                return BoxedUnit.UNIT;
            });
            LongRef tableSizeBytes = LongRef.create((long)oldVersionChecksum.tableSizeBytes());
            LongRef numFiles = LongRef.create((long)oldVersionChecksum.numFiles());
            ObjectRef protocol = ObjectRef.create((Object)oldVersionChecksum.protocol());
            ObjectRef metadata = ObjectRef.create((Object)oldVersionChecksum.metadata());
            SQLConf conf = this.spark().sessionState().conf();
            boolean isFirstVersion = oldSnapshot.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$computeNewChecksum$2(x$6)));
            boolean checksumDVMetricsEnabled = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_CHECKSUM_DV_METRICS_ENABLED()));
            boolean deletedRecordCountsHistogramEnabled = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_DELETED_RECORD_COUNTS_HISTOGRAM_ENABLED()));
            boolean computeDVMetricsWhenDVsNotWritable = persistentDVsOnTableReadable && oldVersionChecksum.numDeletionVectorsOpt().isDefined() && !isFirstVersion;
            boolean computeDVMetrics = checksumDVMetricsEnabled && (persistentDVsOnTableWritable || computeDVMetricsWhenDVsNotWritable);
            ObjectRef numDeletedRecordsOpt = ObjectRef.create((Object)(computeDVMetrics ? oldVersionChecksum.numDeletedRecordsOpt().orElse((Function0 & Serializable)() -> oldSnapshot.flatMap((Function1 & Serializable)x$7 -> x$7.numDeletedRecordsOpt())) : None$.MODULE$));
            ObjectRef numDeletionVectorsOpt = ObjectRef.create((Object)(computeDVMetrics ? oldVersionChecksum.numDeletionVectorsOpt().orElse((Function0 & Serializable)() -> oldSnapshot.flatMap((Function1 & Serializable)x$8 -> x$8.numDeletionVectorsOpt())) : None$.MODULE$));
            None$ deletedRecordCountsHistogramOpt = computeDVMetrics && deletedRecordCountsHistogramEnabled ? oldVersionChecksum.deletedRecordCountsHistogramOpt().orElse((Function0 & Serializable)() -> oldSnapshot.flatMap((Function1 & Serializable)x$9 -> x$9.deletedRecordCountsHistogramOpt())).map((Function1 & Serializable)h -> DeletedRecordCountsHistogram$.MODULE$.apply((long[])h.deletedRecordCounts().clone())) : None$.MODULE$;
            ObjectRef inCommitTimestamp = ObjectRef.create((Object)None$.MODULE$);
            actions.foreach(arg_0 -> RecordChecksum.$anonfun$computeNewChecksum$10$adapted(this, ignoreAddFiles, tableSizeBytes, numFiles, numDeletedRecordsOpt, numDeletionVectorsOpt, (Option)deletedRecordCountsHistogramOpt, ignoreRemoveFiles, object, protocol, metadata, inCommitTimestamp, arg_0));
            Option<Seq<SetTransaction>> setTransactions = this.incrementallyComputeSetTransactions(oldSnapshot, oldVersionChecksum, attemptVersion, actions);
            Option<Seq<DomainMetadata>> domainMetadata = this.incrementallyComputeDomainMetadatas(oldSnapshot, oldVersionChecksum, attemptVersion, actions);
            Option computeAddFiles = includeAllFilesInCRC ? this.incrementallyComputeAddFiles(oldSnapshot, oldVersionChecksum, attemptVersion, numFiles.elem, actions) : (numFiles.elem == 0L ? Option$.MODULE$.apply((Object)Nil$.MODULE$) : None$.MODULE$);
            Option allFiles = computeAddFiles.filter((Function1 & Serializable)files -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$computeNewChecksum$21(this, numFiles, tableSizeBytes, oldVersionChecksum, oldSnapshot, actions, attemptVersion, operationName, files)));
            Option<String> x$11 = txnIdOpt;
            long x$12 = tableSizeBytes.elem;
            long x$13 = numFiles.elem;
            Option x$14 = (Option)numDeletedRecordsOpt.elem;
            Option x$15 = (Option)numDeletionVectorsOpt.elem;
            long x$16 = 1L;
            long x$17 = 1L;
            Option x$18 = (Option)inCommitTimestamp.elem;
            Metadata x$19 = (Metadata)metadata.elem;
            Protocol x$20 = (Protocol)protocol.elem;
            Option<Seq<SetTransaction>> x$21 = setTransactions;
            Option<Seq<DomainMetadata>> x$22 = domainMetadata;
            Option x$23 = allFiles;
            None$ x$24 = deletedRecordCountsHistogramOpt;
            None$ x$25 = None$.MODULE$;
            Right right = new Right((Object)new VersionChecksum(x$11, x$12, x$13, (Option<Object>)x$14, (Option<Object>)x$15, 1L, 1L, (Option<Object>)x$18, x$21, x$22, x$19, x$20, (Option<FileSizeHistogram>)x$25, (Option<DeletedRecordCountsHistogram>)x$24, (Option<Seq<AddFile>>)x$23));
            either = right;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either)ex.value();
            }
            throw ex;
        }
        return either;
    }

    private Option<Seq<SetTransaction>> incrementallyComputeSetTransactions(Option<Snapshot> oldSnapshot, VersionChecksum oldVersionChecksum, long attemptVersion, Seq<Action> actionsToCommit) {
        Option option;
        Object object = new Object();
        try {
            if (!BoxesRunTime.unboxToBoolean((Object)this.spark().conf().get(DeltaSQLConf$.MODULE$.DELTA_WRITE_SET_TRANSACTIONS_IN_CRC()))) {
                return None$.MODULE$;
            }
            Option newMetadataToCommit = actionsToCommit.collectFirst((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Metadata) {
                        Metadata metadata = (Metadata)A1;
                        return (B1)metadata;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    return action instanceof Metadata;
                }
            });
            boolean setTransactionRetentionTimestampConfigured = ((IterableOnceOps)((IterableOps)Option$.MODULE$.option2Iterable(oldSnapshot.map((Function1 & Serializable)x$24 -> x$24.metadata())).$plus$plus((IterableOnce)Option$.MODULE$.apply((Object)oldVersionChecksum.metadata()))).$plus$plus((IterableOnce)newMetadataToCommit)).exists((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeSetTransactions$2(x$25)));
            if (setTransactionRetentionTimestampConfigured) {
                return None$.MODULE$;
            }
            Seq oldSetTransactions = (Seq)oldVersionChecksum.setTransactions().getOrElse((Function0 & Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            Seq setTransactionsToCommit = (Seq)actionsToCommit.filter((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeSetTransactions$4(x$26)));
            long threshold = BoxesRunTime.unboxToLong((Object)this.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_MAX_SET_TRANSACTIONS_IN_CRC()));
            if ((long)Math.max(setTransactionsToCommit.size(), oldSetTransactions.size()) > threshold) {
                return None$.MODULE$;
            }
            InMemoryLogReplay logReplay = new InMemoryLogReplay(0L, (Option<Object>)None$.MODULE$);
            logReplay.append(attemptVersion - 1L, (Iterator<Action>)oldSetTransactions.toIterator());
            logReplay.append(attemptVersion, (Iterator<Action>)setTransactionsToCommit.toIterator());
            option = new Some((Object)logReplay.getTransactions().toSeq()).filter((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeSetTransactions$5(threshold, x$27)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Option<Seq<DomainMetadata>> incrementallyComputeDomainMetadatas(Option<Snapshot> oldSnapshot, VersionChecksum oldVersionChecksum, long attemptVersion, Seq<Action> actionsToCommit) {
        Option option;
        Object object = new Object();
        try {
            Seq oldDomainMetadatas = (Seq)oldVersionChecksum.domainMetadata().getOrElse((Function0 & Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            Seq newDomainMetadatas = (Seq)actionsToCommit.filter((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeDomainMetadatas$2(x$28)));
            InMemoryLogReplay logReplay = new InMemoryLogReplay(0L, (Option<Object>)None$.MODULE$);
            long threshold = BoxesRunTime.unboxToLong((Object)this.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_MAX_DOMAIN_METADATAS_IN_CRC()));
            logReplay.append(attemptVersion - 1L, (Iterator<Action>)oldDomainMetadatas.iterator());
            logReplay.append(attemptVersion, (Iterator<Action>)newDomainMetadatas.iterator());
            option = new Some((Object)logReplay.getDomainMetadatas().toSeq()).filter((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeDomainMetadatas$3(threshold, x$29)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Option<Seq<AddFile>> incrementallyComputeAddFiles(Option<Snapshot> oldSnapshot, VersionChecksum oldVersionChecksum, long attemptVersion, long numFilesAfterCommit, Seq<Action> actionsToCommit) {
        Option option;
        Object object = new Object();
        try {
            int incrementalAllFilesThreshold = BoxesRunTime.unboxToInt((Object)this.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_ALL_FILES_IN_CRC_THRESHOLD_FILES()));
            long numFilesBeforeCommit = oldVersionChecksum.numFiles();
            if (Math.max(numFilesAfterCommit, numFilesBeforeCommit) > (long)incrementalAllFilesThreshold) {
                return None$.MODULE$;
            }
            Seq oldAllFiles = (Seq)oldVersionChecksum.allFiles().orElse((Function0 & Serializable)() -> (Option)this.recordFrameProfile("Delta", "VersionChecksum.incrementallyComputeAddFiles", (Function0 & Serializable)() -> oldSnapshot.map((Function1 & Serializable)x$30 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])x$30.allFiles().collect()))))).getOrElse((Function0 & Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            DeltaLog.CanonicalPathFunction canonicalPath = new DeltaLog.CanonicalPathFunction((Function0<Configuration>)(Function0 & Serializable)() -> this.deltaLog().newDeltaHadoopConf());
            InMemoryLogReplay logReplay = new InMemoryLogReplay(0L, (Option<Object>)None$.MODULE$);
            logReplay.append(attemptVersion - 1L, (Iterator<Action>)((IterableOnceOps)oldAllFiles.map((Function1 & Serializable)action -> RecordChecksum.normalizePath$1(action, canonicalPath))).toIterator());
            logReplay.append(attemptVersion, (Iterator<Action>)((IterableOnceOps)actionsToCommit.map((Function1 & Serializable)action -> RecordChecksum.normalizePath$1(action, canonicalPath))).toIterator());
            option = new Some(logReplay.allFiles());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static /* synthetic */ void $anonfun$incrementallyDeriveChecksum$2(RecordChecksum $this, DeltaLog deltaLog$1, long versionToCompute$1, Snapshot snapshot) {
        DeltaLog x$16 = deltaLog$1;
        String x$17 = "delta.commit.snapshotAgedOut";
        scala.collection.immutable.Map x$18 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snapshotVersion"), (Object)BoxesRunTime.boxToLong((long)snapshot.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"commitAttemptVersion"), (Object)BoxesRunTime.boxToLong((long)versionToCompute$1))}));
        scala.collection.immutable.Map<TagDefinition, String> x$19 = $this.recordDeltaEvent$default$3();
        Option<Path> x$20 = $this.recordDeltaEvent$default$5();
        $this.recordDeltaEvent(x$16, "delta.commit.snapshotAgedOut", x$19, x$18, x$20);
    }

    public static /* synthetic */ boolean $anonfun$incrementallyDeriveChecksum$3(VersionChecksum x$3) {
        return x$3.metadata() == null;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyDeriveChecksum$4(VersionChecksum x$4) {
        return x$4.protocol() == null;
    }

    public static /* synthetic */ boolean $anonfun$computeNewChecksum$2(Snapshot x$6) {
        return x$6.version() == -1L;
    }

    public static /* synthetic */ void $anonfun$computeNewChecksum$10(RecordChecksum $this, boolean ignoreAddFiles$1, LongRef tableSizeBytes$1, LongRef numFiles$1, ObjectRef numDeletedRecordsOpt$1, ObjectRef numDeletionVectorsOpt$1, Option deletedRecordCountsHistogramOpt$1, boolean ignoreRemoveFiles$1, Object nonLocalReturnKey2$1, ObjectRef protocol$1, ObjectRef metadata$1, ObjectRef inCommitTimestamp$1, Action x0$1) {
        boolean bl = false;
        RemoveFile removeFile = null;
        Action action = x0$1;
        if (action instanceof AddFile) {
            AddFile addFile = (AddFile)action;
            if (!ignoreAddFiles$1) {
                tableSizeBytes$1.elem += addFile.size();
                ++numFiles$1.elem;
                Tuple2 tuple2 = (Tuple2)Option$.MODULE$.apply((Object)addFile.deletionVector()).map((Function1 & Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToLong((long)x$10.cardinality()))).getOrElse((Function0 & Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToLong((long)0L)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long dvCount = tuple2._1$mcJ$sp();
                long dvCardinality = tuple2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(dvCount, dvCardinality);
                long dvCount2 = sp2._1$mcJ$sp();
                long dvCardinality2 = sp2._2$mcJ$sp();
                numDeletedRecordsOpt$1.elem = ((Option)numDeletedRecordsOpt$1.elem).map((Function1)(JFunction1.mcJJ.sp & Serializable)x$12 -> x$12 + dvCardinality2);
                numDeletionVectorsOpt$1.elem = ((Option)numDeletionVectorsOpt$1.elem).map((Function1)(JFunction1.mcJJ.sp & Serializable)x$13 -> x$13 + dvCount2);
                deletedRecordCountsHistogramOpt$1.foreach((Function1 & Serializable)x$14 -> {
                    x$14.insert(dvCardinality2);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        if (action instanceof RemoveFile) {
            bl = true;
            removeFile = (RemoveFile)action;
            if (ignoreRemoveFiles$1) {
                return;
            }
        }
        if (bl) {
            Option<Object> option = removeFile.extendedFileMetadata();
            Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            if (!(option != null ? !option.equals((Object)some) : some != null)) {
                long size = BoxesRunTime.unboxToLong((Object)removeFile.size().get());
                tableSizeBytes$1.elem -= size;
                --numFiles$1.elem;
                Tuple2 tuple2 = (Tuple2)Option$.MODULE$.apply((Object)removeFile.deletionVector()).map((Function1 & Serializable)x$15 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToLong((long)x$15.cardinality()))).getOrElse((Function0 & Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToLong((long)0L)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long dvCount = tuple2._1$mcJ$sp();
                long dvCardinality = tuple2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(dvCount, dvCardinality);
                long dvCount3 = sp3._1$mcJ$sp();
                long dvCardinality3 = sp3._2$mcJ$sp();
                numDeletedRecordsOpt$1.elem = ((Option)numDeletedRecordsOpt$1.elem).map((Function1)(JFunction1.mcJJ.sp & Serializable)x$17 -> x$17 - dvCardinality3);
                numDeletionVectorsOpt$1.elem = ((Option)numDeletionVectorsOpt$1.elem).map((Function1)(JFunction1.mcJJ.sp & Serializable)x$18 -> x$18 - dvCount3);
                deletedRecordCountsHistogramOpt$1.foreach((Function1 & Serializable)x$19 -> {
                    x$19.remove(dvCardinality3);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        if (bl) {
            String msg = new StringBuilder(126).append("A remove action with a missing file size was detected in file ").append(removeFile.path()).append(" ").append("causing incremental commit to fallback to state reconstruction.").toString();
            DeltaLog x$1 = $this.deltaLog();
            String x$2 = "delta.checksum.compute";
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)msg)}));
            scala.collection.immutable.Map<TagDefinition, String> x$4 = $this.recordDeltaEvent$default$3();
            Option<Path> x$5 = $this.recordDeltaEvent$default$5();
            $this.recordDeltaEvent(x$1, "delta.checksum.compute", x$4, x$3, x$5);
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new Left((Object)"ENCOUNTERED_REMOVE_FILE_MISSING_SIZE"));
        }
        if (action instanceof Protocol) {
            Protocol protocol = (Protocol)action;
            protocol$1.elem = protocol;
            return;
        }
        if (action instanceof Metadata) {
            Metadata metadata = (Metadata)action;
            metadata$1.elem = metadata;
            return;
        }
        if (action instanceof CommitInfo) {
            CommitInfo commitInfo = (CommitInfo)action;
            inCommitTimestamp$1.elem = commitInfo.inCommitTimestamp();
            return;
        }
    }

    public static /* synthetic */ boolean $anonfun$computeNewChecksum$21(RecordChecksum $this, LongRef numFiles$1, LongRef tableSizeBytes$1, VersionChecksum oldVersionChecksum$2, Option oldSnapshot$1, Seq actions$2, long attemptVersion$1, String operationName$1, Seq files) {
        int computedNumFiles = files.size();
        long computedTableSizeBytes = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)files.map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if ((long)computedNumFiles != numFiles$1.elem || computedTableSizeBytes != tableSizeBytes$1.elem) {
            Seq filePathsFromPreviousVersion = (Seq)((IterableOps)oldVersionChecksum$2.allFiles().orElse((Function0 & Serializable)() -> (Option)$this.recordFrameProfile("Delta", "VersionChecksum.computeNewChecksum.allFiles", (Function0 & Serializable)() -> oldSnapshot$1.map((Function1 & Serializable)x$21 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])x$21.allFiles().collect()))))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$22 -> x$22.path());
            Seq addFilePathsInThisCommit = (Seq)actions$2.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof AddFile) {
                        AddFile addFile = (AddFile)A1;
                        return (B1)addFile.path();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    return action instanceof AddFile;
                }
            });
            Seq removeFilePathsInThisCommit = (Seq)actions$2.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        return (B1)removeFile.path();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Action x2) {
                    Action action = x2;
                    return action instanceof RemoveFile;
                }
            });
            $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Incrementally computed files does not match the incremental checksum "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for commit attempt: ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToLong((long)attemptVersion$1))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"addFilePathsInThisCommit: [", "], "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.PATHS(), (Object)addFilePathsInThisCommit.mkString(","))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"removeFilePathsInThisCommit: [", "], "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.PATHS2(), (Object)removeFilePathsInThisCommit.mkString(","))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"filePathsFromPreviousVersion: [", "], "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.PATHS3(), (Object)filePathsFromPreviousVersion.mkString(","))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"computedFiles: [", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.PATHS4(), (Object)((IterableOnceOps)files.map((Function1 & Serializable)x$23 -> x$23.path())).mkString(","))})))));
            scala.collection.immutable.Map eventData = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attemptVersion"), (Object)BoxesRunTime.boxToLong((long)attemptVersion$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNumFiles"), (Object)BoxesRunTime.boxToLong((long)numFiles$1.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedTableSizeBytes"), (Object)BoxesRunTime.boxToLong((long)tableSizeBytes$1.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"computedNumFiles"), (Object)BoxesRunTime.boxToInteger((int)computedNumFiles)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"computedTableSizeBytes"), (Object)BoxesRunTime.boxToLong((long)computedTableSizeBytes)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddFilePathsInThisCommit"), (Object)BoxesRunTime.boxToInteger((int)addFilePathsInThisCommit.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemoveFilePathsInThisCommit"), (Object)BoxesRunTime.boxToInteger((int)removeFilePathsInThisCommit.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFilesInPreviousVersion"), (Object)BoxesRunTime.boxToInteger((int)filePathsFromPreviousVersion.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationName"), (Object)operationName$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"addFilePathsInThisCommit"), (Object)JsonUtils$.MODULE$.toJson(addFilePathsInThisCommit.take(10), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"removeFilePathsInThisCommit"), (Object)JsonUtils$.MODULE$.toJson(removeFilePathsInThisCommit.take(10), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filePathsFromPreviousVersion"), (Object)JsonUtils$.MODULE$.toJson(filePathsFromPreviousVersion.take(10), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"computedFiles"), (Object)JsonUtils$.MODULE$.toJson(files.take(10), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(AddFile.class), (Seq)Nil$.MODULE$)))}));
            DeltaLog x$6 = $this.deltaLog();
            String x$7 = "delta.allFilesInCrc.checksumMismatch.aggregated";
            scala.collection.immutable.Map x$8 = eventData;
            scala.collection.immutable.Map<TagDefinition, String> x$9 = $this.recordDeltaEvent$default$3();
            Option<Path> x$10 = $this.recordDeltaEvent$default$5();
            $this.recordDeltaEvent(x$6, "delta.allFilesInCrc.checksumMismatch.aggregated", x$9, x$8, x$10);
            if (Utils$.MODULE$.isTesting()) {
                throw new IllegalStateException(new StringBuilder(65).append("Incrementally Computed State failed checksum check").append(" for commit ").append(attemptVersion$1).append(" [").append(eventData).append("]").toString());
            }
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeSetTransactions$2(Metadata x$25) {
        return DeltaLog$.MODULE$.minSetTransactionRetentionInterval(x$25).nonEmpty();
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeSetTransactions$4(Action x$26) {
        return x$26 instanceof SetTransaction;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeSetTransactions$5(long threshold$1, Seq x$27) {
        return (long)x$27.size() <= threshold$1;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeDomainMetadatas$2(Action x$28) {
        return x$28 instanceof DomainMetadata;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeDomainMetadatas$3(long threshold$2, Seq x$29) {
        return (long)x$29.size() <= threshold$2;
    }

    private static Action normalizePath$1(Action action, DeltaLog.CanonicalPathFunction canonicalPath$1) {
        Action action2 = action;
        if (action2 instanceof AddFile) {
            AddFile addFile = (AddFile)action2;
            return addFile.copy(canonicalPath$1.apply(addFile.path()), addFile.copy$default$2(), addFile.copy$default$3(), addFile.copy$default$4(), addFile.copy$default$5(), addFile.copy$default$6(), addFile.copy$default$7(), addFile.copy$default$8(), addFile.copy$default$9(), addFile.copy$default$10(), addFile.copy$default$11());
        }
        if (action2 instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)action2;
            return removeFile.copy(canonicalPath$1.apply(removeFile.path()), removeFile.copy$default$2(), removeFile.copy$default$3(), removeFile.copy$default$4(), removeFile.copy$default$5(), removeFile.copy$default$6(), removeFile.copy$default$7(), removeFile.copy$default$8(), removeFile.copy$default$9(), removeFile.copy$default$10(), removeFile.copy$default$11());
        }
        return action2;
    }

    public static void $init$(RecordChecksum $this) {
    }

    public static /* synthetic */ Object $anonfun$computeNewChecksum$10$adapted(RecordChecksum $this, boolean ignoreAddFiles$1, LongRef tableSizeBytes$1, LongRef numFiles$1, ObjectRef numDeletedRecordsOpt$1, ObjectRef numDeletionVectorsOpt$1, Option deletedRecordCountsHistogramOpt$1, boolean ignoreRemoveFiles$1, Object nonLocalReturnKey2$1, ObjectRef protocol$1, ObjectRef metadata$1, ObjectRef inCommitTimestamp$1, Action x0$1) {
        RecordChecksum.$anonfun$computeNewChecksum$10($this, ignoreAddFiles$1, tableSizeBytes$1, numFiles$1, numDeletedRecordsOpt$1, numDeletionVectorsOpt$1, deletedRecordCountsHistogramOpt$1, ignoreRemoveFiles$1, nonLocalReturnKey2$1, protocol$1, metadata$1, inCommitTimestamp$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

