/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.MaterializedRowId$;
import org.apache.spark.sql.delta.RowId;
import org.apache.spark.sql.delta.RowId$BaseRowIdMetadataStructField$;
import org.apache.spark.sql.delta.RowId$RowIdMetadataAttribute$;
import org.apache.spark.sql.delta.RowId$RowIdMetadataStructField$;
import org.apache.spark.sql.delta.RowId$RowTrackingMetadataDomain$;
import org.apache.spark.sql.delta.RowTracking$;
import org.apache.spark.sql.delta.RowTrackingFeature$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.types.StructField;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

public final class RowId$ {
    public static final RowId$ MODULE$ = new RowId$();
    private static final long MISSING_HIGH_WATER_MARK = -1L;
    private static final String BASE_ROW_ID = "base_row_id";
    private static final String ROW_ID = "row_id";
    private static final String QUALIFIED_COLUMN_NAME = new java.lang.StringBuilder(1).append(FileFormat$.MODULE$.METADATA_NAME()).append(".").append(MODULE$.ROW_ID()).toString();

    public long MISSING_HIGH_WATER_MARK() {
        return MISSING_HIGH_WATER_MARK;
    }

    public boolean isSupported(Protocol protocol) {
        return RowTracking$.MODULE$.isSupported(protocol);
    }

    public boolean isEnabled(Protocol protocol, Metadata metadata) {
        boolean isEnabled = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().fromMetaData(metadata));
        if (isEnabled && !this.isSupported(protocol)) {
            throw new IllegalStateException(new java.lang.StringBuilder(94).append("Table property '").append(DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().key()).append("' is ").append("set on the table but this table version doesn't support table feature ").append("'").append(TableFeatureProtocolUtils$.MODULE$.propertyKey(RowTrackingFeature$.MODULE$)).append("'.").toString());
        }
        return isEnabled;
    }

    public Iterator<Action> assignFreshRowIds(Protocol protocol, Snapshot snapshot, Iterator<Action> actions) {
        if (!this.isSupported(protocol)) {
            return actions;
        }
        long oldHighWatermark = BoxesRunTime.unboxToLong((Object)this.extractHighWatermark(snapshot).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.MISSING_HIGH_WATER_MARK()));
        LongRef newHighWatermark = LongRef.create((long)oldHighWatermark);
        Iterator actionsWithFreshRowIds = actions.map((Function1 & Serializable)x0$1 -> {
            DomainMetadata domainMetadata;
            AddFile addFile;
            Action action = x0$1;
            if (action instanceof AddFile && (addFile = (AddFile)action).baseRowId().isEmpty()) {
                long baseRowId = newHighWatermark$1.elem + 1L;
                newHighWatermark$1.elem += BoxesRunTime.unboxToLong((Object)addFile.numPhysicalRecords().getOrElse((Function0 & Serializable)() -> {
                    throw DeltaErrors$.MODULE$.rowIdAssignmentWithoutStats();
                }));
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)baseRowId));
                String x$2 = addFile.copy$default$1();
                Map<String, String> x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                boolean x$6 = addFile.copy$default$5();
                String x$7 = addFile.copy$default$6();
                Map<String, String> x$8 = addFile.copy$default$7();
                DeletionVectorDescriptor x$9 = addFile.copy$default$8();
                Option<Object> x$10 = addFile.copy$default$10();
                Option<String> x$11 = addFile.copy$default$11();
                return addFile.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Option<Object>)x$1, x$10, x$11);
            }
            if (action instanceof DomainMetadata && RowId$RowTrackingMetadataDomain$.MODULE$.isSameDomain(domainMetadata = (DomainMetadata)action)) {
                throw new IllegalStateException("Manually setting the Row ID high water mark is not allowed");
            }
            return action;
        });
        Iterator<Action> newHighWatermarkAction = new Iterator<Action>(newHighWatermark, oldHighWatermark){
            private final LongRef newHighWatermark$1;
            private final long oldHighWatermark$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Action> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Action> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Action> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> partition(Function1<Action, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B$> Iterator<B$> scanLeft(B$ z, Function2<B$, Action, B$> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B$> Iterator<B$> scanRight(B$ z, Function2<Action, B$, B$> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Action, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Action> filter(Function1<Action, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Action> filterNot(Function1<Action, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Action> filterImpl(Function1<Action, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Action> withFilter(Function1<Action, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B$> Iterator<B$> collect(PartialFunction<Action, B$> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Action> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B$> Iterator<Action> distinctBy(Function1<Action, B$> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B$> Iterator<B$> map(Function1<Action, B$> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B$> Iterator<B$> flatMap(Function1<Action, IterableOnce<B$>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B$> Iterator<B$> flatten(Function1<Action, IterableOnce<B$>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Action> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Action> takeWhile(Function1<Action, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Action> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Action> dropWhile(Function1<Action, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> span(Function1<Action, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Action> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Action> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B$> Iterator<Tuple2<Action, B$>> zip(IterableOnce<B$> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Action, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<Action> tapEach(Function1<Action, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Action> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Action, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Action, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Action, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Action, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Action> find(Function1<Action, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B$> B$ foldLeft(B$ z, Function2<B$, Action, B$> op) {
                return (B$)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B$> B$ foldRight(B$ z, Function2<Action, B$, B$> op) {
                return (B$)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B$> B$ $div$colon(B$ z, Function2<B$, Action, B$> op) {
                return (B$)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B$> B$ $colon$bslash(B$ z, Function2<Action, B$, B$> op) {
                return (B$)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Action, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Action, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Action, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Action, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Action> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Action> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B$> Option<Action> maxByOption(Function1<Action, B$> f, Ordering<B$> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B$> Option<Action> minByOption(Function1<Action, B$> f, Ordering<B$> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B$> Option<B$> collectFirst(PartialFunction<Action, B$> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B$> B$ aggregate(Function0<B$> z, Function2<B$, Action, B$> seqop, Function2<B$, B$, B$> combop) {
                return (B$)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B$> boolean corresponds(IterableOnce<B$> that, Function2<Action, B$, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Action, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Action> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Action> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Action> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<Action, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Action> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Action> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Action> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Action> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Action, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public boolean hasNext() {
                return this.newHighWatermark$1.elem != this.oldHighWatermark$1;
            }

            public Action next() {
                return new RowId.RowTrackingMetadataDomain(this.newHighWatermark$1.elem).toDomainMetadata(ManifestFactory$.MODULE$.Nothing());
            }
            {
                this.newHighWatermark$1 = newHighWatermark$1;
                this.oldHighWatermark$1 = oldHighWatermark$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }
        };
        return actionsWithFreshRowIds.$plus$plus(() -> RowId$.$anonfun$assignFreshRowIds$4((Iterator)newHighWatermarkAction));
    }

    public Option<Object> extractHighWatermark(Snapshot snapshot) {
        if (this.isSupported(snapshot.protocol())) {
            return RowId$RowTrackingMetadataDomain$.MODULE$.fromSnapshot(snapshot).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.rowIdHighWaterMark()));
        }
        return None$.MODULE$;
    }

    public String BASE_ROW_ID() {
        return BASE_ROW_ID;
    }

    public Option<StructField> createBaseRowIdField(Protocol protocol, Metadata metadata, boolean nullable) {
        return Option$.MODULE$.when(this.isEnabled(protocol, metadata), (Function0 & Serializable)() -> RowId$BaseRowIdMetadataStructField$.MODULE$.apply(nullable));
    }

    public String ROW_ID() {
        return ROW_ID;
    }

    public String QUALIFIED_COLUMN_NAME() {
        return QUALIFIED_COLUMN_NAME;
    }

    public org.apache.spark.sql.types.Metadata columnMetadata(String materializedColumnName) {
        return RowId$RowIdMetadataStructField$.MODULE$.metadata(materializedColumnName);
    }

    public Option<StructField> createRowIdField(Protocol protocol, Metadata metadata, boolean nullable) {
        return MaterializedRowId$.MODULE$.getMaterializedColumnName(protocol, metadata).map((Function1 & Serializable)x$2 -> RowId$RowIdMetadataStructField$.MODULE$.apply((String)x$2, nullable));
    }

    public void throwIfMaterializedRowIdColumnNameIsInvalid(Dataset<Row> data, Metadata metadata, Protocol protocol, String tableId) {
        if (!RowTracking$.MODULE$.isEnabled(protocol, metadata)) {
            return;
        }
        Option materializedColumnName = metadata.configuration().get((Object)MaterializedRowId$.MODULE$.MATERIALIZED_COLUMN_NAME_PROP());
        if (materializedColumnName.isEmpty()) {
            if (RowTracking$.MODULE$.isEnabled(protocol, metadata)) {
                throw DeltaErrors$.MODULE$.materializedRowIdMetadataMissing(tableId);
            }
            return;
        }
        DataTypeUtils$.MODULE$.toAttributes(data.schema()).foreach((Function1 & Serializable)x0$1 -> {
            RowId$.$anonfun$throwIfMaterializedRowIdColumnNameIsInvalid$1(materializedColumnName, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Dataset<Row> preserveRowIds(Dataset<Row> dataFrame, SnapshotDescriptor snapshot) {
        if (!this.isEnabled(snapshot.protocol(), snapshot.metadata())) {
            return dataFrame;
        }
        String materializedColumnName = MaterializedRowId$.MODULE$.getMaterializedColumnNameOrThrow(snapshot.protocol(), snapshot.metadata(), snapshot.deltaLog().tableId());
        Column rowIdColumn = DeltaTableUtils$.MODULE$.getFileMetadataColumn(dataFrame).getField(this.ROW_ID());
        return this.preserveRowIdsUnsafe(dataFrame, materializedColumnName, rowIdColumn);
    }

    public Dataset<Row> preserveRowIdsUnsafe(Dataset<Row> dataFrame, String materializedColumnName, Column rowIdColumn) {
        return dataFrame.withColumn(materializedColumnName, rowIdColumn).withMetadata(materializedColumnName, this.columnMetadata(materializedColumnName));
    }

    public static final /* synthetic */ Iterator $anonfun$assignFreshRowIds$4(Iterator newHighWatermarkAction$1) {
        return newHighWatermarkAction$1.take(1);
    }

    public static final /* synthetic */ void $anonfun$throwIfMaterializedRowIdColumnNameIsInvalid$1(Option materializedColumnName$1, AttributeReference x0$1) {
        Option<Attribute> option;
        AttributeReference attributeReference = x0$1;
        if (attributeReference != null && !(option = RowId$RowIdMetadataAttribute$.MODULE$.unapply((Attribute)attributeReference)).isEmpty()) {
            Attribute attribute = (Attribute)option.get();
            String string = attribute.name();
            Object object = materializedColumnName$1.get();
            if (string == null ? object != null : !string.equals(object)) {
                throw new UnsupportedOperationException(new java.lang.StringBuilder(55).append("Materialized Row IDs column name ").append(attribute.name()).append(" is invalid. Must be ").append(materializedColumnName$1.get()).append(".").toString());
            }
            return;
        }
    }

    private RowId$() {
    }
}

