/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.AllowColumnDefaultsTableFeature$;
import org.apache.spark.sql.delta.AppendOnlyTableFeature$;
import org.apache.spark.sql.delta.CatalogOwnedTableFeature$;
import org.apache.spark.sql.delta.ChangeDataFeedTableFeature$;
import org.apache.spark.sql.delta.CheckConstraintsTableFeature$;
import org.apache.spark.sql.delta.CheckpointProtectionTableFeature$;
import org.apache.spark.sql.delta.ClusteringTableFeature$;
import org.apache.spark.sql.delta.ColumnMappingTableFeature$;
import org.apache.spark.sql.delta.CoordinatedCommitsTableFeature$;
import org.apache.spark.sql.delta.DeletionVectorsTableFeature$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DomainMetadataTableFeature$;
import org.apache.spark.sql.delta.GeneratedColumnsTableFeature$;
import org.apache.spark.sql.delta.IcebergCompatV1TableFeature$;
import org.apache.spark.sql.delta.IcebergCompatV2TableFeature$;
import org.apache.spark.sql.delta.IdentityColumnsTableFeature$;
import org.apache.spark.sql.delta.InCommitTimestampTableFeature$;
import org.apache.spark.sql.delta.InvariantsTableFeature$;
import org.apache.spark.sql.delta.RedirectReaderWriterFeature$;
import org.apache.spark.sql.delta.RedirectWriterOnlyFeature$;
import org.apache.spark.sql.delta.RemovableFeature;
import org.apache.spark.sql.delta.RowTrackingFeature$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.TableFeature;
import org.apache.spark.sql.delta.TestFeatureWithDependency$;
import org.apache.spark.sql.delta.TestFeatureWithTransitiveDependency$;
import org.apache.spark.sql.delta.TestLegacyReaderWriterFeature$;
import org.apache.spark.sql.delta.TestLegacyWriterFeature$;
import org.apache.spark.sql.delta.TestReaderWriterFeature$;
import org.apache.spark.sql.delta.TestReaderWriterMetadataAutoUpdateFeature$;
import org.apache.spark.sql.delta.TestReaderWriterMetadataNoAutoUpdateFeature$;
import org.apache.spark.sql.delta.TestRemovableLegacyReaderWriterFeature$;
import org.apache.spark.sql.delta.TestRemovableLegacyWriterFeature$;
import org.apache.spark.sql.delta.TestRemovableReaderWriterFeature$;
import org.apache.spark.sql.delta.TestRemovableWriterFeature$;
import org.apache.spark.sql.delta.TestRemovableWriterFeatureWithDependency$;
import org.apache.spark.sql.delta.TestRemovableWriterWithHistoryTruncationFeature$;
import org.apache.spark.sql.delta.TestUnsupportedNoHistoryProtectionReaderWriterFeature$;
import org.apache.spark.sql.delta.TestUnsupportedReaderWriterFeature$;
import org.apache.spark.sql.delta.TestUnsupportedWriterFeature$;
import org.apache.spark.sql.delta.TestWriterFeature$;
import org.apache.spark.sql.delta.TestWriterFeatureWithTransitiveDependency$;
import org.apache.spark.sql.delta.TestWriterMetadataNoAutoUpdateFeature$;
import org.apache.spark.sql.delta.TimestampNTZTableFeature$;
import org.apache.spark.sql.delta.TypeWideningPreviewTableFeature$;
import org.apache.spark.sql.delta.TypeWideningTableFeature$;
import org.apache.spark.sql.delta.V2CheckpointTableFeature$;
import org.apache.spark.sql.delta.VacuumProtocolCheckTableFeature$;
import org.apache.spark.sql.delta.VariantShreddingPreviewTableFeature$;
import org.apache.spark.sql.delta.VariantTypePreviewTableFeature$;
import org.apache.spark.sql.delta.VariantTypeTableFeature$;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class TableFeature$
implements Serializable {
    public static final TableFeature$ MODULE$ = new TableFeature$();
    private static final boolean isTesting = Utils$.MODULE$.isTesting();
    private static final Map<TableFeature, Set<TableFeature>> allDependentFeaturesMap;

    static {
        Seq dependentFeatureTuples = (Seq)MODULE$.allSupportedFeaturesMap().values().toSeq().flatMap((Function1 & Serializable)f -> (Set)f.requiredFeatures().map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), f)));
        allDependentFeaturesMap = dependentFeatureTuples.groupBy((Function1 & Serializable)x$4 -> (TableFeature)x$4._1()).mapValues((Function1 & Serializable)x$5 -> ((IterableOnceOps)x$5.map((Function1 & Serializable)x$6 -> (TableFeature)x$6._2())).toSet()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean isTesting() {
        return isTesting;
    }

    public Map<String, TableFeature> allSupportedFeaturesMap() {
        boolean bl;
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)SparkSession$.MODULE$.getActiveSession().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TableFeature$.$anonfun$allSupportedFeaturesMap$1(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        }
        catch (Throwable throwable) {
            bl = true;
        }
        boolean testingFeaturesEnabled = bl;
        Set features = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableFeature[]{AllowColumnDefaultsTableFeature$.MODULE$, AppendOnlyTableFeature$.MODULE$, ChangeDataFeedTableFeature$.MODULE$, CheckConstraintsTableFeature$.MODULE$, ClusteringTableFeature$.MODULE$, DomainMetadataTableFeature$.MODULE$, GeneratedColumnsTableFeature$.MODULE$, IdentityColumnsTableFeature$.MODULE$, InvariantsTableFeature$.MODULE$, ColumnMappingTableFeature$.MODULE$, TimestampNTZTableFeature$.MODULE$, TypeWideningPreviewTableFeature$.MODULE$, TypeWideningTableFeature$.MODULE$, IcebergCompatV1TableFeature$.MODULE$, IcebergCompatV2TableFeature$.MODULE$, DeletionVectorsTableFeature$.MODULE$, VacuumProtocolCheckTableFeature$.MODULE$, V2CheckpointTableFeature$.MODULE$, RowTrackingFeature$.MODULE$, InCommitTimestampTableFeature$.MODULE$, VariantTypePreviewTableFeature$.MODULE$, VariantTypeTableFeature$.MODULE$, VariantShreddingPreviewTableFeature$.MODULE$, CatalogOwnedTableFeature$.MODULE$, CoordinatedCommitsTableFeature$.MODULE$, CheckpointProtectionTableFeature$.MODULE$}));
        if (this.isTesting() && testingFeaturesEnabled) {
            features = (Set)features.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableFeature[]{RedirectReaderWriterFeature$.MODULE$, RedirectWriterOnlyFeature$.MODULE$, TestLegacyWriterFeature$.MODULE$, TestLegacyReaderWriterFeature$.MODULE$, TestWriterFeature$.MODULE$, TestUnsupportedWriterFeature$.MODULE$, TestWriterMetadataNoAutoUpdateFeature$.MODULE$, TestReaderWriterFeature$.MODULE$, TestUnsupportedReaderWriterFeature$.MODULE$, TestUnsupportedNoHistoryProtectionReaderWriterFeature$.MODULE$, TestReaderWriterMetadataAutoUpdateFeature$.MODULE$, TestReaderWriterMetadataNoAutoUpdateFeature$.MODULE$, TestRemovableWriterFeature$.MODULE$, TestRemovableWriterFeatureWithDependency$.MODULE$, TestRemovableWriterWithHistoryTruncationFeature$.MODULE$, TestRemovableLegacyWriterFeature$.MODULE$, TestRemovableReaderWriterFeature$.MODULE$, TestRemovableLegacyReaderWriterFeature$.MODULE$, TestFeatureWithDependency$.MODULE$, TestFeatureWithTransitiveDependency$.MODULE$, TestWriterFeatureWithTransitiveDependency$.MODULE$})));
        }
        Map featureMap = ((IterableOnceOps)features.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name().toLowerCase(Locale.ROOT)), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Predef$.MODULE$.require(features.size() == featureMap.size(), (Function0 & Serializable)() -> "Lowercase feature names must not duplicate.");
        return featureMap;
    }

    public Set<TableFeature> testUnsupportedFeatures() {
        if (!this.isTesting()) {
            return Predef$.MODULE$.Set().empty();
        }
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableFeature[]{TestUnsupportedReaderWriterFeature$.MODULE$, TestUnsupportedNoHistoryProtectionReaderWriterFeature$.MODULE$, TestUnsupportedWriterFeature$.MODULE$}));
    }

    private Map<TableFeature, Set<TableFeature>> allDependentFeaturesMap() {
        return allDependentFeaturesMap;
    }

    public Option<TableFeature> featureNameToFeature(String featureName) {
        return this.allSupportedFeaturesMap().get((Object)featureName.toLowerCase(Locale.ROOT));
    }

    public Set<TableFeature> getDependentFeatures(TableFeature feature) {
        return (Set)this.allDependentFeaturesMap().getOrElse((Object)feature, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public Set<TableFeature> getDroppedFeatures(Protocol newProtocol, Protocol oldProtocol) {
        Set<TableFeature> newFeatureNames = newProtocol.implicitlyAndExplicitlySupportedFeatures();
        Set<TableFeature> oldFeatureNames = oldProtocol.implicitlyAndExplicitlySupportedFeatures();
        return (Set)oldFeatureNames.$minus$minus(newFeatureNames);
    }

    public boolean isProtocolRemovingFeatures(Protocol newProtocol, Protocol oldProtocol) {
        return this.getDroppedFeatures(newProtocol, oldProtocol).nonEmpty();
    }

    public boolean isProtocolRemovingFeatureWithHistoryProtection(Protocol newProtocol, Protocol oldProtocol) {
        return this.getDroppedFeatures(newProtocol, oldProtocol).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TableFeature$.$anonfun$isProtocolRemovingFeatureWithHistoryProtection$1(x0$1)));
    }

    public boolean validateFeatureRemovalAtSnapshot(Protocol newProtocol, Protocol oldProtocol, Snapshot snapshot) {
        Set<TableFeature> droppedFeatures = this.getDroppedFeatures(newProtocol, oldProtocol);
        Set<TableFeature> set = droppedFeatures;
        if (set.size() != 1) {
            return set.size() <= 1;
        }
        TableFeature droppedFeature = (TableFeature)set.head();
        TableFeature tableFeature = droppedFeature;
        if (tableFeature instanceof RemovableFeature) {
            TableFeature tableFeature2 = tableFeature;
            return ((RemovableFeature)((Object)tableFeature2)).validateRemoval(snapshot);
        }
        throw DeltaErrors$.MODULE$.dropTableFeatureFeatureNotSupportedByClient(droppedFeature.name());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TableFeature$.class);
    }

    public static final /* synthetic */ boolean $anonfun$allSupportedFeaturesMap$1(SparkSession x$2) {
        return BoxesRunTime.unboxToBoolean((Object)x$2.conf().get(DeltaSQLConf$.MODULE$.TABLE_FEATURES_TEST_FEATURES_ENABLED()));
    }

    public static final /* synthetic */ boolean $anonfun$isProtocolRemovingFeatureWithHistoryProtection$1(TableFeature x0$1) {
        TableFeature tableFeature;
        TableFeature tableFeature2 = x0$1;
        return tableFeature2 instanceof RemovableFeature && ((RemovableFeature)((Object)(tableFeature = tableFeature2))).requiresHistoryProtection();
    }

    private TableFeature$() {
    }
}

