/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.IcebergCompat$;
import org.apache.spark.sql.delta.IcebergCompatV1$;
import org.apache.spark.sql.delta.IcebergCompatV2$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function6;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class UniversalFormat$
implements DeltaLogging {
    public static final UniversalFormat$ MODULE$ = new UniversalFormat$();
    private static final String ICEBERG_FORMAT;
    private static final String HUDI_FORMAT;
    private static final Set<String> SUPPORTED_FORMATS;
    private static final String ICEBERG_TABLE_TYPE_KEY;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        ICEBERG_FORMAT = "iceberg";
        HUDI_FORMAT = "hudi";
        SUPPORTED_FORMATS = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.HUDI_FORMAT(), MODULE$.ICEBERG_FORMAT()}));
        ICEBERG_TABLE_TYPE_KEY = "table_type";
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public scala.collection.immutable.Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String ICEBERG_FORMAT() {
        return ICEBERG_FORMAT;
    }

    public String HUDI_FORMAT() {
        return HUDI_FORMAT;
    }

    public Set<String> SUPPORTED_FORMATS() {
        return SUPPORTED_FORMATS;
    }

    public boolean isCreatingOrReorgTable(Option<DeltaOperations.Operation> op) {
        Some some;
        Some some2;
        Some some3;
        Option<DeltaOperations.Operation> option = op;
        if (option instanceof Some && (some3 = (Some)option).value() instanceof DeltaOperations.CreateTable ? true : (option instanceof Some && (some2 = (Some)option).value() instanceof DeltaOperations.UpgradeUniformProperties ? true : option instanceof Some && (some = (Some)option).value() instanceof DeltaOperations.ReplaceTable)) {
            return true;
        }
        return None$.MODULE$.equals(option);
    }

    public boolean isReorgUpgradeUniform(Option<DeltaOperations.Operation> op) {
        Some some;
        Option<DeltaOperations.Operation> option = op;
        return option instanceof Some && (some = (Some)option).value() instanceof DeltaOperations.UpgradeUniformProperties;
    }

    public boolean icebergEnabled(Metadata metadata) {
        return ((SeqOps)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().fromMetaData(metadata)).contains((Object)this.ICEBERG_FORMAT());
    }

    public boolean hudiEnabled(Metadata metadata) {
        return ((SeqOps)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().fromMetaData(metadata)).contains((Object)this.HUDI_FORMAT());
    }

    public boolean hudiEnabled(scala.collection.immutable.Map<String, String> properties) {
        return properties.get((Object)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().key()).exists((Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)value.contains(UniversalFormat$.MODULE$.HUDI_FORMAT())));
    }

    public boolean icebergEnabled(scala.collection.immutable.Map<String, String> properties) {
        return properties.get((Object)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().key()).exists((Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)value.contains(UniversalFormat$.MODULE$.ICEBERG_FORMAT())));
    }

    public Tuple2<Option<Protocol>, Option<Metadata>> enforceInvariantsAndDependencies(SparkSession spark, Snapshot snapshot, Protocol newestProtocol, Metadata newestMetadata, Option<DeltaOperations.Operation> operation, Seq<Action> actions) {
        this.enforceHudiDependencies(newestMetadata, snapshot);
        return this.enforceIcebergInvariantsAndDependencies(spark, snapshot, newestProtocol, newestMetadata, operation, actions);
    }

    public Object enforceHudiDependencies(Metadata newestMetadata, Snapshot snapshot) {
        if (this.hudiEnabled(newestMetadata)) {
            if (BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_DELETION_VECTORS_CREATION().fromMetaData(newestMetadata))) {
                throw DeltaErrors$.MODULE$.uniFormHudiDeleteVectorCompat();
            }
            Option<DataType> option = SchemaUtils$.MODULE$.findAnyTypeRecursively((DataType)newestMetadata.schema(), (Function1<DataType, Object>)(Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)UniversalFormat$.$anonfun$enforceHudiDependencies$1(f)));
            if (option instanceof Some) {
                Some some = (Some)option;
                DataType unsupportedType = (DataType)some.value();
                throw DeltaErrors$.MODULE$.uniFormHudiSchemaCompat(unsupportedType);
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Option<Protocol>, Option<Metadata>> enforceIcebergInvariantsAndDependencies(SparkSession spark2, Snapshot snapshot, Protocol newestProtocol2, Metadata newestMetadata2, Option<DeltaOperations.Operation> operation2, Seq<Action> actions2) {
        Tuple2 tuple2;
        boolean bl;
        Metadata prevMetadata = snapshot.metadata();
        boolean uniformIcebergWasEnabled = this.icebergEnabled(prevMetadata);
        boolean uniformIcebergIsEnabled = this.icebergEnabled(newestMetadata2);
        String tableId = newestMetadata2.id();
        BooleanRef changed = BooleanRef.create((boolean)false);
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(uniformIcebergWasEnabled, uniformIcebergIsEnabled);
        if (sp2 != null && !(bl = sp2._2$mcZ$sp())) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        } else {
            boolean bl2;
            if (sp2 == null || !(bl2 = sp2._2$mcZ$sp())) throw new MatchError((Object)sp2);
            boolean icebergCompatWasEnabled = IcebergCompat$.MODULE$.isAnyEnabled(prevMetadata);
            boolean icebergCompatIsEnabled = IcebergCompat$.MODULE$.isAnyEnabled(newestMetadata2);
            if (icebergCompatIsEnabled) {
                tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            } else {
                if (!icebergCompatWasEnabled) throw DeltaErrors$.MODULE$.uniFormIcebergRequiresIcebergCompat();
                Seq remainingSupportedFormats = (Seq)((IterableOps)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().fromMetaData(newestMetadata2)).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UniversalFormat$.$anonfun$enforceIcebergInvariantsAndDependencies$1(x$1)));
                scala.collection.immutable.Map newConfiguration = remainingSupportedFormats.isEmpty() ? (scala.collection.immutable.Map)newestMetadata2.configuration().$minus((Object)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().key()) : (scala.collection.immutable.Map)newestMetadata2.configuration().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().key()), (Object)remainingSupportedFormats.mkString(","))})));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.TABLE_ID(), (Object)tableId)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"IcebergCompat is being disabled. Auto-disabling Universal Format (Iceberg), too."}))).log((Seq)Nil$.MODULE$))));
                scala.collection.immutable.Map x$12 = newConfiguration;
                String x$2 = newestMetadata2.copy$default$1();
                String x$3 = newestMetadata2.copy$default$2();
                String x$4 = newestMetadata2.copy$default$3();
                Format x$5 = newestMetadata2.copy$default$4();
                String x$6 = newestMetadata2.copy$default$5();
                Seq<String> x$7 = newestMetadata2.copy$default$6();
                Option<Object> x$8 = newestMetadata2.copy$default$8();
                Tuple2 tuple22 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)newestMetadata2.copy(x$2, x$3, x$4, x$5, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$12, x$8)));
                tuple2 = tuple22;
            }
        }
        Tuple2 tuple23 = tuple2;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        None$ uniformProtocol = (None$)tuple23._1();
        Option uniformMetadata = (Option)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)uniformProtocol, (Object)uniformMetadata);
        None$ uniformProtocol2 = (None$)tuple24._1();
        Option uniformMetadata2 = (Option)tuple24._2();
        ObjectRef protocolToCheck = ObjectRef.create((Object)((Protocol)uniformProtocol2.getOrElse((Function0 & Serializable)() -> newestProtocol2)));
        ObjectRef metadataToCheck = ObjectRef.create((Object)((Metadata)uniformMetadata2.getOrElse((Function0 & Serializable)() -> newestMetadata2)));
        changed.elem = uniformProtocol2.nonEmpty() || uniformMetadata2.nonEmpty();
        ObjectRef protocolUpdate = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef metadataUpdate = ObjectRef.create((Object)None$.MODULE$);
        .colon.colon compatChecks = new .colon.colon((Function6 & Serializable)(spark, prevSnapshot, newestProtocol, newestMetadata, operation, actions) -> IcebergCompatV1$.MODULE$.enforceInvariantsAndDependencies((SparkSession)spark, (Snapshot)prevSnapshot, (Protocol)newestProtocol, (Metadata)newestMetadata, (Option<DeltaOperations.Operation>)operation, (Seq<Action>)actions), (List)new .colon.colon((Function6 & Serializable)(spark, prevSnapshot, newestProtocol, newestMetadata, operation, actions) -> IcebergCompatV2$.MODULE$.enforceInvariantsAndDependencies((SparkSession)spark, (Snapshot)prevSnapshot, (Protocol)newestProtocol, (Metadata)newestMetadata, (Option<DeltaOperations.Operation>)operation, (Seq<Action>)actions), (List)Nil$.MODULE$));
        compatChecks.foreach((Function1 & Serializable)compatCheck -> {
            UniversalFormat$.$anonfun$enforceIcebergInvariantsAndDependencies$7(spark2, snapshot, protocolToCheck, metadataToCheck, operation2, actions2, protocolUpdate, metadataUpdate, changed, compatCheck);
            return BoxedUnit.UNIT;
        });
        if (!changed.elem) return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        return new Tuple2((Object)((Option)protocolUpdate.elem).orElse((Function0 & Serializable)() -> new Some((Object)((Protocol)protocolToCheck$1.elem))), (Object)((Option)metadataUpdate.elem).orElse((Function0 & Serializable)() -> new Some((Object)((Metadata)metadataToCheck$1.elem))));
    }

    public scala.collection.immutable.Map<String, String> enforceDependenciesInConfiguration(SparkSession spark, scala.collection.immutable.Map<String, String> configuration, Snapshot snapshot) {
        Option universalMetadata;
        Metadata qual$1 = snapshot.metadata();
        scala.collection.immutable.Map<String, String> x$1 = configuration;
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        String x$4 = qual$1.copy$default$3();
        Format x$5 = qual$1.copy$default$4();
        String x$6 = qual$1.copy$default$5();
        Seq<String> x$7 = qual$1.copy$default$6();
        Option<Object> x$8 = qual$1.copy$default$8();
        Metadata metadata = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
        Tuple2<Option<Protocol>, Option<Metadata>> tuple2 = this.enforceInvariantsAndDependencies(spark, snapshot, snapshot.protocol(), metadata, (Option<DeltaOperations.Operation>)None$.MODULE$, (Seq<Action>)((Seq)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option universalMetadata2 = (Option)tuple2._2();
        Option option = universalMetadata = universalMetadata2;
        if (option instanceof Some) {
            Some some = (Some)option;
            Metadata valid = (Metadata)some.value();
            return valid.configuration();
        }
        return configuration;
    }

    public String ICEBERG_TABLE_TYPE_KEY() {
        return ICEBERG_TABLE_TYPE_KEY;
    }

    public Option<CatalogTable> enforceSupportInCatalog(CatalogTable table, Metadata metadata) {
        boolean bl;
        Option option = table.properties().get((Object)this.ICEBERG_TABLE_TYPE_KEY());
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            bl = value.equalsIgnoreCase(this.ICEBERG_FORMAT());
        } else {
            bl = false;
        }
        boolean icebergInCatalog = bl;
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.icebergEnabled(metadata), icebergInCatalog);
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && !bl3) {
                scala.collection.immutable.Map x$1 = (scala.collection.immutable.Map)table.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ICEBERG_TABLE_TYPE_KEY()), (Object)this.ICEBERG_FORMAT()));
                TableIdentifier x$2 = table.copy$default$1();
                CatalogTableType x$3 = table.copy$default$2();
                CatalogStorageFormat x$4 = table.copy$default$3();
                StructType x$5 = table.copy$default$4();
                Option x$6 = table.copy$default$5();
                Seq x$7 = table.copy$default$6();
                Option x$8 = table.copy$default$7();
                String x$9 = table.copy$default$8();
                long x$10 = table.copy$default$9();
                long x$11 = table.copy$default$10();
                String x$12 = table.copy$default$11();
                Option x$13 = table.copy$default$13();
                Option x$14 = table.copy$default$14();
                Option x$15 = table.copy$default$15();
                Option x$16 = table.copy$default$16();
                Seq x$17 = table.copy$default$17();
                boolean x$18 = table.copy$default$18();
                boolean x$19 = table.copy$default$19();
                scala.collection.immutable.Map x$20 = table.copy$default$20();
                Option x$21 = table.copy$default$21();
                return new Some((Object)table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21));
            }
        }
        if (sp2 != null) {
            boolean bl4 = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (!bl4 && bl5) {
                scala.collection.immutable.Map x$22 = (scala.collection.immutable.Map)table.properties().$minus((Object)this.ICEBERG_TABLE_TYPE_KEY());
                TableIdentifier x$23 = table.copy$default$1();
                CatalogTableType x$24 = table.copy$default$2();
                CatalogStorageFormat x$25 = table.copy$default$3();
                StructType x$26 = table.copy$default$4();
                Option x$27 = table.copy$default$5();
                Seq x$28 = table.copy$default$6();
                Option x$29 = table.copy$default$7();
                String x$30 = table.copy$default$8();
                long x$31 = table.copy$default$9();
                long x$32 = table.copy$default$10();
                String x$33 = table.copy$default$11();
                Option x$34 = table.copy$default$13();
                Option x$35 = table.copy$default$14();
                Option x$36 = table.copy$default$15();
                Option x$37 = table.copy$default$16();
                Seq x$38 = table.copy$default$17();
                boolean x$39 = table.copy$default$18();
                boolean x$40 = table.copy$default$19();
                scala.collection.immutable.Map x$41 = table.copy$default$20();
                Option x$42 = table.copy$default$21();
                return new Some((Object)table.copy(x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$22, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42));
            }
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$enforceHudiDependencies$1(DataType f) {
        return f instanceof NullType | f instanceof ByteType | f instanceof ShortType | f instanceof TimestampNTZType;
    }

    public static final /* synthetic */ boolean $anonfun$enforceIcebergInvariantsAndDependencies$1(String x$1) {
        String string = x$1;
        String string2 = MODULE$.ICEBERG_FORMAT();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$enforceIcebergInvariantsAndDependencies$7(SparkSession spark$1, Snapshot snapshot$1, ObjectRef protocolToCheck$1, ObjectRef metadataToCheck$1, Option operation$1, Seq actions$1, ObjectRef protocolUpdate$1, ObjectRef metadataUpdate$1, BooleanRef changed$1, Function6 compatCheck) {
        Tuple2 updates = (Tuple2)compatCheck.apply((Object)spark$1, (Object)snapshot$1, (Object)((Protocol)protocolToCheck$1.elem), (Object)((Metadata)metadataToCheck$1.elem), (Object)operation$1, (Object)actions$1);
        protocolUpdate$1.elem = (Option)updates._1();
        metadataUpdate$1.elem = (Option)updates._2();
        protocolToCheck$1.elem = (Protocol)((Option)protocolUpdate$1.elem).getOrElse((Function0 & Serializable)() -> (Protocol)protocolToCheck$1.elem);
        metadataToCheck$1.elem = (Metadata)((Option)metadataUpdate$1.elem).getOrElse((Function0 & Serializable)() -> (Metadata)metadataToCheck$1.elem);
        changed$1.elem = changed$1.elem || ((Option)protocolUpdate$1.elem).nonEmpty() || ((Option)metadataUpdate$1.elem).nonEmpty();
    }

    private UniversalFormat$() {
    }
}

