/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Base64;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.paths.SparkPath$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor$;
import org.apache.spark.sql.delta.util.Codec$Base85Codec$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rMh\u0001\u00020`\u00012D!\"!\u0002\u0001\u0005+\u0007I\u0011AA\u0004\u0011)\tI\u0002\u0001B\tB\u0003%\u0011\u0011\u0002\u0005\u000b\u00037\u0001!Q3A\u0005\u0002\u0005\u001d\u0001BCA\u000f\u0001\tE\t\u0015!\u0003\u0002\n!Q\u0011q\u0004\u0001\u0003\u0016\u0004%\t!!\t\t\u0015\u0005=\u0002A!E!\u0002\u0013\t\u0019\u0003\u0003\u0006\u00022\u0001\u0011)\u001a!C\u0001\u0003gA!\"!\u000e\u0001\u0005#\u0005\u000b\u0011BA\u0015\u0011)\t9\u0004\u0001BK\u0002\u0013\u0005\u0011\u0011\b\u0005\u000b\u0003\u0003\u0002!\u0011#Q\u0001\n\u0005m\u0002BCA\"\u0001\tU\r\u0011\"\u0001\u0002F!Q\u0011\u0011\n\u0001\u0003\u0012\u0003\u0006I!a\u0012\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!Q\u0011\u0011\u0014\u0001\t\u0006\u0004%\t!a\u0002\t\u0015\u0005=\u0006\u0001#b\u0001\n\u0003\t9\u0001\u0003\u0005\u00026\u0002!\t\"YA\\\u0011!\t\t\r\u0001C\tC\u0006]\u0006\u0002CAc\u0001\u0011E\u0011-a.\t\u0011\u0005%\u0007\u0001\"\u0005b\u0003oC\u0001\"!4\u0001\t#\t\u0017q\u0017\u0005\b\u0003#\u0004A\u0011AAj\u0011\u001d\tI\u000f\u0001C\u0001\u0003WDq!!=\u0001\t\u0003\t\u0019\u0010C\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\tE\u0001\u0001\"\u0001\u0003\u0014!9!Q\u0004\u0001\u0005\u0002\t}\u0001b\u0003B\u0018\u0001!\u0015\r\u0011\"\u0005b\u0003gAqAa\r\u0001\t\u0003\u0011)\u0004C\u0005\u00038\u0001\t\t\u0011\"\u0001\u0003:!I!q\t\u0001\u0012\u0002\u0013\u0005!\u0011\n\u0005\n\u0005;\u0002\u0011\u0013!C\u0001\u0005\u0013B\u0011Ba\u0018\u0001#\u0003%\tA!\u0019\t\u0013\t\u0015\u0004!%A\u0005\u0002\t\u001d\u0004\"\u0003B6\u0001E\u0005I\u0011\u0001B7\u0011%\u0011\t\bAI\u0001\n\u0003\u0011\u0019\bC\u0005\u0003x\u0001\t\t\u0011\"\u0011\u0003z!I!q\u0010\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0005\u0003\u0003\u0011\u0011!C\u0001\u0005\u0007C\u0011Ba$\u0001\u0003\u0003%\tE!%\t\u0013\t}\u0005!!A\u0005\u0002\t\u0005\u0006\"\u0003BS\u0001\u0005\u0005I\u0011\tBT\u0011%\u0011Y\u000bAA\u0001\n\u0003\u0012i\u000bC\u0005\u00030\u0002\t\t\u0011\"\u0011\u00032\"I!1\u0017\u0001\u0002\u0002\u0013\u0005#QW\u0004\b\u0005s{\u0006\u0012\u0001B^\r\u0019qv\f#\u0001\u0003>\"9\u00111\n\u0018\u0005\u0002\t%\u0007\"\u0003Bf]\t\u0007I\u0011AA\u0004\u0011!\u0011iM\fQ\u0001\n\u0005%\u0001\"\u0003Bh]\t\u0007I\u0011\u0001B=\u0011!\u0011\tN\fQ\u0001\n\tm\u0004\"\u0003Bj]\t\u0007IQAA\u0004\u0011!\u0011)N\fQ\u0001\u000e\u0005%\u0001\"\u0003Bl]\t\u0007IQAA\u0004\u0011!\u0011IN\fQ\u0001\u000e\u0005%\u0001\"\u0003Bn]\t\u0007IQAA\u0004\u0011!\u0011iN\fQ\u0001\u000e\u0005%\u0001\"\u0003Bp]\t\u0007IQ\u0002Bq\u0011!\u0011\tP\fQ\u0001\u000e\t\r\b\"\u0003Bz]\t\u0007IQ\u0002B{\u0011!\u0019\u0019A\fQ\u0001\u000e\t]\bBCB\u0003]!\u0015\r\u0011\"\u0002\u0004\b!Q1Q\u0003\u0018\t\u0006\u0004%Iaa\u0006\t\u000f\r\rb\u0006b\u0001\u0004&!91q\u0006\u0018\u0005\u0002\rE\u0002\"CB ]E\u0005I\u0011\u0001B%\u0011%\u0019\tELI\u0001\n\u0003\u0011\t\u0007C\u0005\u0004D9\n\n\u0011\"\u0001\u0003t!91Q\t\u0018\u0005\u0002\r\u001d\u0003\"CB+]E\u0005I\u0011\u0001B1\u0011%\u00199FLI\u0001\n\u0003\u0011\u0019\bC\u0004\u0004Z9\"\taa\u0017\t\u0011\r\rd\u0006\"\u0001b\u0007KB\u0001ba\u0019/\t\u0003\t7\u0011\u000e\u0005\t\u0007GrC\u0011A1\u0004n!9\u0011\u0011\u0019\u0018\u0005\u0002\re\u0004bBAu]\u0011\u00051q\u0010\u0005\b\u0007\u000fsC\u0011ABE\u0011\u001d\u0019iI\fC\u0001\u0007\u001fC\u0011ba'/#\u0003%\tA!\u0013\t\u000f\rue\u0006\"\u0001\u0004 \"I11\u0015\u0018C\u0002\u0013\u00051Q\u0015\u0005\t\u0007Os\u0003\u0015!\u0003\u0002P!A1\u0011\u0016\u0018\u0005\u0002\u0005\u001cY\u000bC\u0004\u00042:\"\taa-\t\u000f\ref\u0006\"\u0001\u0004<\"I1\u0011\u0019\u0018\u0002\u0002\u0013\u000551\u0019\u0005\n\u0007#t\u0013\u0013!C\u0001\u0005CB\u0011ba5/#\u0003%\tAa\u001d\t\u0013\rUg&!A\u0005\u0002\u000e]\u0007\"CBs]E\u0005I\u0011\u0001B1\u0011%\u00199OLI\u0001\n\u0003\u0011\u0019\bC\u0005\u0004j:\n\t\u0011\"\u0003\u0004l\nAB)\u001a7fi&|gNV3di>\u0014H)Z:de&\u0004Ho\u001c:\u000b\u0005\u0001\f\u0017aB1di&|gn\u001d\u0006\u0003E\u000e\fQ\u0001Z3mi\u0006T!\u0001Z3\u0002\u0007M\fHN\u0003\u0002gO\u0006)1\u000f]1sW*\u0011\u0001.[\u0001\u0007CB\f7\r[3\u000b\u0003)\f1a\u001c:h\u0007\u0001\u0019B\u0001A7tmB\u0011a.]\u0007\u0002_*\t\u0001/A\u0003tG\u0006d\u0017-\u0003\u0002s_\n1\u0011I\\=SK\u001a\u0004\"A\u001c;\n\u0005U|'a\u0002)s_\u0012,8\r\u001e\t\u0003o~t!\u0001_?\u000f\u0005edX\"\u0001>\u000b\u0005m\\\u0017A\u0002\u001fs_>$h(C\u0001q\u0013\tqx.A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00111\u0001\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003}>\f1b\u001d;pe\u0006<W\rV=qKV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t\u0019B\u0004\u0003\u0002\u000e\u0005=\u0001CA=p\u0013\r\t\tb\\\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0011q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Eq.\u0001\u0007ti>\u0014\u0018mZ3UsB,\u0007%\u0001\bqCRDwJ]%oY&tW\r\u0012<\u0002\u001fA\fG\u000f[(s\u0013:d\u0017N\\3Em\u0002\naa\u001c4gg\u0016$XCAA\u0012!\u0015q\u0017QEA\u0015\u0013\r\t9c\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00079\fY#C\u0002\u0002.=\u00141!\u00138u\u0003\u001dygMZ:fi\u0002\n1b]5{K&s')\u001f;fgV\u0011\u0011\u0011F\u0001\rg&TX-\u00138CsR,7\u000fI\u0001\fG\u0006\u0014H-\u001b8bY&$\u00180\u0006\u0002\u0002<A\u0019a.!\u0010\n\u0007\u0005}rN\u0001\u0003M_:<\u0017\u0001D2be\u0012Lg.\u00197jif\u0004\u0013aC7bqJ{w/\u00138eKb,\"!a\u0012\u0011\u000b9\f)#a\u000f\u0002\u00195\f\u0007PU8x\u0013:$W\r\u001f\u0011\u0002\rqJg.\u001b;?)9\ty%a\u0015\u0002V\u0005]\u00131RAG\u0003\u001f\u00032!!\u0015\u0001\u001b\u0005y\u0006bBA\u0003\u001b\u0001\u0007\u0011\u0011\u0002\u0005\b\u00037i\u0001\u0019AA\u0005\u0011%\ty\"\u0004I\u0001\u0002\u0004\t\u0019\u0003\u000b\u0005\u0002X\u0005m\u0013qOA=!\u0011\ti&a\u001d\u000e\u0005\u0005}#\u0002BA1\u0003G\n!\"\u00198o_R\fG/[8o\u0015\u0011\t)'a\u001a\u0002\u0011\u0011\fG/\u00192j]\u0012TA!!\u001b\u0002l\u00059!.Y2lg>t'\u0002BA7\u0003_\n\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0005\u0005E\u0014aA2p[&!\u0011QOA0\u0005=Q5o\u001c8EKN,'/[1mSj,\u0017!C2p]R,g\u000e^!tG\t\tY\b\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\u000bAA[1wC&!\u0011\u0011RA@\u0005\u001dIe\u000e^3hKJDq!!\r\u000e\u0001\u0004\tI\u0003C\u0004\u000285\u0001\r!a\u000f\t\u0013\u0005\rS\u0002%AA\u0002\u0005\u001d\u0003\u0006CAH\u00037\n9(a%$\u0005\u0005U\u0005\u0003BA?\u0003/KA!a\u0010\u0002\u0000\u0005AQO\\5rk\u0016LE\rK\u0002\u000f\u0003;\u0003B!a(\u0002$6\u0011\u0011\u0011\u0015\u0006\u0005\u0003C\n9'\u0003\u0003\u0002&\u0006\u0005&A\u0003&t_:LuM\\8sK\"\u001aa\"!+\u0011\u00079\fY+C\u0002\u0002.>\u0014\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0019Ut\u0017.];f\r&dW-\u00133)\u0007=\ti\nK\u0002\u0010\u0003S\u000b\u0001\"[:P]\u0012K7o[\u000b\u0003\u0003s\u00032A\\A^\u0013\r\til\u001c\u0002\b\u0005>|G.Z1oQ\r\u0001\u0012QT\u0001\tSNLe\u000e\\5oK\"\u001a\u0011#!(\u0002\u0015%\u001c(+\u001a7bi&4X\rK\u0002\u0013\u0003;\u000b!\"[:BEN|G.\u001e;fQ\r\u0019\u0012QT\u0001\bSN,U\u000e\u001d;zQ\r!\u0012QT\u0001\rC\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u000b\u0005\u0003+\f)\u000f\u0005\u0003\u0002X\u0006\u0005XBAAm\u0015\u0011\tY.!8\u0002\u0005\u0019\u001c(bAApO\u00061\u0001.\u00193p_BLA!a9\u0002Z\n!\u0001+\u0019;i\u0011\u001d\t9/\u0006a\u0001\u0003+\fQ\u0002^1cY\u0016dunY1uS>t\u0017AD;sY\u0016s7m\u001c3fIB\u000bG\u000f\u001b\u000b\u0005\u0003\u0013\ti\u000fC\u0004\u0002pZ\u0001\r!!6\u0002\u0013Q\f'\r\\3QCRD\u0017AF4fiJ\u000bg\u000eZ8n!J,g-\u001b=B]\u0012,V/\u001b3\u0016\u0005\u0005U\b#\u00028\u0002&\u0005]\bc\u00028\u0002z\u0006%\u0011Q`\u0005\u0004\u0003w|'A\u0002+va2,'\u0007\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\u0011\u0011\u0019!a!\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u000f\u0011\tA\u0001\u0003V+&#\u0005fA\f\u0002\u001e\u0006!2m\u001c9z/&$\b.\u00112t_2,H/\u001a)bi\"$B!a\u0014\u0003\u0010!9\u0011q\u001d\rA\u0002\u0005U\u0017aF2paf<\u0016\u000e\u001e5OK^\u0014V\r\\1uSZ,\u0007+\u0019;i)\u0019\tyE!\u0006\u0003\u001a!9!qC\rA\u0002\u0005u\u0018AA5e\u0011\u001d\u0011Y\"\u0007a\u0001\u0003\u0013\tAB]1oI>l\u0007K]3gSb\f!\"\u001b8mS:,G)\u0019;b+\t\u0011\t\u0003E\u0003o\u0005G\u00119#C\u0002\u0003&=\u0014Q!\u0011:sCf\u00042A\u001cB\u0015\u0013\r\u0011Yc\u001c\u0002\u0005\u0005f$X\rK\u0002\u001b\u0003;\u000bq#Z:uS6\fG/\u001a3TKJL\u0017\r\\5{K\u0012\u001c\u0016N_3)\u0007m\ti*A\ttKJL\u0017\r\\5{KR{')Y:fmQ\"\"!!\u0003\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003\u001f\u0012YD!\u0010\u0003@\t\u0005#1\tB#\u0011%\t)!\bI\u0001\u0002\u0004\tI\u0001C\u0005\u0002\u001cu\u0001\n\u00111\u0001\u0002\n!I\u0011qD\u000f\u0011\u0002\u0003\u0007\u00111\u0005\u0005\n\u0003ci\u0002\u0013!a\u0001\u0003SA\u0011\"a\u000e\u001e!\u0003\u0005\r!a\u000f\t\u0013\u0005\rS\u0004%AA\u0002\u0005\u001d\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0017RC!!\u0003\u0003N-\u0012!q\n\t\u0005\u0005#\u0012I&\u0004\u0002\u0003T)!!Q\u000bB,\u0003%)hn\u00195fG.,GMC\u0002\u0002b=LAAa\u0017\u0003T\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B2U\u0011\t\u0019C!\u0014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u000e\u0016\u0005\u0003S\u0011i%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t=$\u0006BA\u001e\u0005\u001b\nabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0003v)\"\u0011q\tB'\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u0010\t\u0005\u0003{\u0012i(\u0003\u0003\u0002\u0016\u0005}\u0014\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u000b\u0013Y\tE\u0002o\u0005\u000fK1A!#p\u0005\r\te.\u001f\u0005\n\u0005\u001b3\u0013\u0011!a\u0001\u0003S\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BJ!\u0019\u0011)Ja'\u0003\u00066\u0011!q\u0013\u0006\u0004\u00053{\u0017AC2pY2,7\r^5p]&!!Q\u0014BL\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e&1\u0015\u0005\n\u0005\u001bC\u0013\u0011!a\u0001\u0005\u000b\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!1\u0010BU\u0011%\u0011i)KA\u0001\u0002\u0004\tI#\u0001\u0005iCND7i\u001c3f)\t\tI#\u0001\u0005u_N#(/\u001b8h)\t\u0011Y(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003s\u00139\fC\u0005\u0003\u000e2\n\t\u00111\u0001\u0003\u0006\u0006AB)\u001a7fi&|gNV3di>\u0014H)Z:de&\u0004Ho\u001c:\u0011\u0007\u0005Ecf\u0005\u0003/[\n}\u0006\u0003\u0002Ba\u0005\u000fl!Aa1\u000b\t\t\u0015\u00171Q\u0001\u0003S>LA!!\u0001\u0003DR\u0011!1X\u0001!\t\u0016cU\tV%P\u001d~3Vi\u0011+P%~3\u0015\nT#`\u001d\u0006kUi\u0018)S\u000b\u001aK\u0005,A\u0011E\u000b2+E+S(O?Z+5\tV(S?\u001aKE*R0O\u00036+u\f\u0015*F\r&C\u0006%\u0001\u0010E\u000b2+E+S(O?Z+5\tV(S?\u001aKE*R0O\u00036+ulQ(S\u000b\u0006yB)\u0012'F)&{ej\u0018,F\u0007R{%k\u0018$J\u0019\u0016{f*Q'F?\u000e{%+\u0012\u0011\u0002\u001dA\u000bE\u000bS0E-~k\u0015IU&F%\u0006y\u0001+\u0011+I?\u00123v,T!S\u0017\u0016\u0013\u0006%\u0001\tJ\u001d2Ke*R0E-~k\u0015IU&F%\u0006\t\u0012J\u0014'J\u001d\u0016{FIV0N\u0003J[UI\u0015\u0011\u0002\u001dU+\u0016\nR0E-~k\u0015IU&F%\u0006yQ+V%E?\u00123v,T!S\u0017\u0016\u0013\u0006%A\u000eeK2,G/[8o-\u0016\u001cGo\u001c:GS2,g*Y7f%\u0016<W\r_\u000b\u0003\u0005G\u0004BA!:\u0003n6\u0011!q\u001d\u0006\u0005\u0005S\u0014Y/\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\u0011\u0019a\\\u0005\u0005\u0005_\u00149OA\u0003SK\u001e,\u00070\u0001\u000feK2,G/[8o-\u0016\u001cGo\u001c:GS2,g*Y7f%\u0016<W\r\u001f\u0011\u0002;\u0011,G.\u001a;j_:4Vm\u0019;pe\u001aKG.\u001a(b[\u0016\u0004\u0016\r\u001e;fe:,\"Aa>\u0011\t\te(q`\u0007\u0003\u0005wTAA!@\u0003\u0002\u0005)!/Z4fq&!1\u0011\u0001B~\u0005\u001d\u0001\u0016\r\u001e;fe:\fa\u0004Z3mKRLwN\u001c,fGR|'OR5mK:\u000bW.\u001a)biR,'O\u001c\u0011\u0002\u0017M#&+V\"U?RK\u0006+R\u000b\u0003\u0007\u0013\u0001Baa\u0003\u0004\u00125\u00111Q\u0002\u0006\u0004\u0007\u001f\u0019\u0017!\u0002;za\u0016\u001c\u0018\u0002BB\n\u0007\u001b\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003!yVM\\2pI\u0016\u0014XCAB\r!\u0019\u0019Yba\b\u0002P5\u00111Q\u0004\u0006\u0004\u0005\u0007\t\u0017\u0002BB\u0011\u0007;\u0011A\u0002R3mi\u0006,enY8eKJ\fq!\u001a8d_\u0012,'/\u0006\u0002\u0004(A11\u0011FB\u0016\u0003\u001fj\u0011aY\u0005\u0004\u0007[\u0019'aB#oG>$WM]\u0001\u0017_:$\u0015n]6XSRD'+\u001a7bi&4X\rU1uQRq\u0011qJB\u001a\u0007k\u00199d!\u000f\u0004<\ru\u0002b\u0002B\f\u0003\u0002\u0007\u0011Q \u0005\n\u00057\t\u0005\u0013!a\u0001\u0003\u0013Aq!!\rB\u0001\u0004\tI\u0003C\u0004\u00028\u0005\u0003\r!a\u000f\t\u0013\u0005}\u0011\t%AA\u0002\u0005\r\u0002\"CA\"\u0003B\u0005\t\u0019AA$\u0003\u0001zg\u000eR5tW^KG\u000f\u001b*fY\u0006$\u0018N^3QCRDG\u0005Z3gCVdG\u000f\n\u001a\u0002A=tG)[:l/&$\bNU3mCRLg/\u001a)bi\"$C-\u001a4bk2$H%N\u0001!_:$\u0015n]6XSRD'+\u001a7bi&4X\rU1uQ\u0012\"WMZ1vYR$c'\u0001\fp]\u0012K7o[,ji\"\f%m]8mkR,\u0007+\u0019;i)1\tye!\u0013\u0004N\r=3\u0011KB*\u0011\u001d\u0019Y%\u0012a\u0001\u0003\u0013\tA\u0001]1uQ\"9\u0011\u0011G#A\u0002\u0005%\u0002bBA\u001c\u000b\u0002\u0007\u00111\b\u0005\n\u0003?)\u0005\u0013!a\u0001\u0003GA\u0011\"a\u0011F!\u0003\u0005\r!a\u0012\u0002A=tG)[:l/&$\b.\u00112t_2,H/\u001a)bi\"$C-\u001a4bk2$H\u0005N\u0001!_:$\u0015n]6XSRD\u0017IY:pYV$X\rU1uQ\u0012\"WMZ1vYR$S'A\u0006j]2Lg.Z%o\u0019><GCBA(\u0007;\u001a\t\u0007C\u0004\u0004`!\u0003\rA!\t\u0002\t\u0011\fG/\u0019\u0005\b\u0003oA\u0005\u0019AA\u001e\u0003QI7\u000fR3mKRLwN\u001c,fGR|'\u000fU1uQR!\u0011\u0011XB4\u0011\u001d\u0019Y%\u0013a\u0001\u0003+$B!!/\u0004l!911\n&A\u0002\u0005%A\u0003BB8\u0007k\u0002Ba!\u000b\u0004r%\u001911O2\u0003\r\r{G.^7o\u0011\u001d\u00199h\u0013a\u0001\u0007_\nq\u0001]1uQ\u000e{G\u000e\u0006\u0003\u0004p\rm\u0004bBB?\u0019\u0002\u00071qN\u0001\u0003IZ$baa\u001c\u0004\u0002\u000e\u0015\u0005bBBB\u001b\u0002\u00071qN\u0001\u0012I\u0016dW\r^5p]Z+7\r^8s\u0007>d\u0007bBAx\u001b\u0002\u0007\u0011Q[\u0001\u0013k:L\u0017/^3JI\u0016C\bO]3tg&|g\u000e\u0006\u0003\u0004p\r-\u0005bBBB\u001d\u0002\u00071qN\u0001\u001bCN\u001cX-\u001c2mK\u0012+G.\u001a;j_:4Vm\u0019;peB\u000bG\u000f\u001b\u000b\t\u0003+\u001c\tj!&\u0004\u0018\"911S(A\u0002\u0005U\u0017\u0001\u0005;be\u001e,G\u000fU1sK:$\b+\u0019;i\u0011\u001d\u00119b\u0014a\u0001\u0003{D\u0011b!'P!\u0003\u0005\r!!\u0003\u0002\rA\u0014XMZ5y\u0003\u0011\n7o]3nE2,G)\u001a7fi&|gNV3di>\u0014\b+\u0019;iI\u0011,g-Y;mi\u0012\u001a\u0014AH1tg\u0016l'\r\\3EK2,G/[8o-\u0016\u001cGo\u001c:GS2,g*Y7f)\u0011\tIa!)\t\u000f\t]\u0011\u000b1\u0001\u0002~\u0006)Q)\u0014)U3V\u0011\u0011qJ\u0001\u0007\u000b6\u0003F+\u0017\u0011\u0002\u0015\u0015t7m\u001c3f+VKE\t\u0006\u0004\u0002\n\r56q\u0016\u0005\b\u0005/!\u0006\u0019AA\u007f\u0011\u001d\u0011Y\u0002\u0016a\u0001\u0003\u0013\t!\"\u001a8d_\u0012,G)\u0019;b)\u0011\tIa!.\t\u000f\r]V\u000b1\u0001\u0003\"\u0005)!-\u001f;fg\u0006)B-Z:fe&\fG.\u001b>f\rJ|WNQ1tKZ\"D\u0003BA(\u0007{Cqaa0W\u0001\u0004\tI!A\u0004f]\u000e|G-\u001a3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001d\u0005=3QYBd\u0007\u0013\u001cYm!4\u0004P\"9\u0011QA,A\u0002\u0005%\u0001bBA\u000e/\u0002\u0007\u0011\u0011\u0002\u0005\n\u0003?9\u0006\u0013!a\u0001\u0003GAq!!\rX\u0001\u0004\tI\u0003C\u0004\u00028]\u0003\r!a\u000f\t\u0013\u0005\rs\u000b%AA\u0002\u0005\u001d\u0013aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIY\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004Z\u000e\u0005\b#\u00028\u0002&\rm\u0007c\u00048\u0004^\u0006%\u0011\u0011BA\u0012\u0003S\tY$a\u0012\n\u0007\r}wN\u0001\u0004UkBdWM\u000e\u0005\n\u0007GT\u0016\u0011!a\u0001\u0003\u001f\n1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!<\u0011\t\u0005u4q^\u0005\u0005\u0007c\fyH\u0001\u0004PE*,7\r\u001e")
public class DeletionVectorDescriptor
implements Product,
Serializable {
    @JsonIgnore
    private transient String uniqueId;
    @JsonIgnore
    private transient String uniqueFileId;
    @JsonIgnore
    private int estimatedSerializedSize;
    private final String storageType;
    private final String pathOrInlineDv;
    private final Option<Object> offset;
    private final int sizeInBytes;
    private final long cardinality;
    private final Option<Object> maxRowIndex;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Object> $lessinit$greater$default$6() {
        return DeletionVectorDescriptor$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Object> $lessinit$greater$default$3() {
        return DeletionVectorDescriptor$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple6<String, String, Option<Object>, Object, Object, Option<Object>>> unapply(DeletionVectorDescriptor x$0) {
        return DeletionVectorDescriptor$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$6() {
        return DeletionVectorDescriptor$.MODULE$.apply$default$6();
    }

    public static Option<Object> apply$default$3() {
        return DeletionVectorDescriptor$.MODULE$.apply$default$3();
    }

    public static DeletionVectorDescriptor apply(String storageType, String pathOrInlineDv, Option<Object> offset, int sizeInBytes, long cardinality, Option<Object> maxRowIndex) {
        return DeletionVectorDescriptor$.MODULE$.apply(storageType, pathOrInlineDv, offset, sizeInBytes, cardinality, maxRowIndex);
    }

    public static DeletionVectorDescriptor deserializeFromBase64(String encoded) {
        return DeletionVectorDescriptor$.MODULE$.deserializeFromBase64(encoded);
    }

    public static String encodeData(byte[] bytes) {
        return DeletionVectorDescriptor$.MODULE$.encodeData(bytes);
    }

    public static DeletionVectorDescriptor EMPTY() {
        return DeletionVectorDescriptor$.MODULE$.EMPTY();
    }

    public static String assembleDeletionVectorFileName(UUID id) {
        return DeletionVectorDescriptor$.MODULE$.assembleDeletionVectorFileName(id);
    }

    public static String assembleDeletionVectorPath$default$3() {
        return DeletionVectorDescriptor$.MODULE$.assembleDeletionVectorPath$default$3();
    }

    public static Path assembleDeletionVectorPath(Path targetParentPath, UUID id, String prefix) {
        return DeletionVectorDescriptor$.MODULE$.assembleDeletionVectorPath(targetParentPath, id, prefix);
    }

    public static Column uniqueIdExpression(Column deletionVectorCol) {
        return DeletionVectorDescriptor$.MODULE$.uniqueIdExpression(deletionVectorCol);
    }

    public static DeletionVectorDescriptor inlineInLog(byte[] data, long cardinality) {
        return DeletionVectorDescriptor$.MODULE$.inlineInLog(data, cardinality);
    }

    public static Option<Object> onDiskWithAbsolutePath$default$5() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithAbsolutePath$default$5();
    }

    public static Option<Object> onDiskWithAbsolutePath$default$4() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithAbsolutePath$default$4();
    }

    public static DeletionVectorDescriptor onDiskWithAbsolutePath(String path, int sizeInBytes, long cardinality, Option<Object> offset, Option<Object> maxRowIndex) {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithAbsolutePath(path, sizeInBytes, cardinality, offset, maxRowIndex);
    }

    public static Option<Object> onDiskWithRelativePath$default$6() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath$default$6();
    }

    public static Option<Object> onDiskWithRelativePath$default$5() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath$default$5();
    }

    public static String onDiskWithRelativePath$default$2() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath$default$2();
    }

    public static DeletionVectorDescriptor onDiskWithRelativePath(UUID id, String randomPrefix, int sizeInBytes, long cardinality, Option<Object> offset, Option<Object> maxRowIndex) {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath(id, randomPrefix, sizeInBytes, cardinality, offset, maxRowIndex);
    }

    public static Encoder<DeletionVectorDescriptor> encoder() {
        return DeletionVectorDescriptor$.MODULE$.encoder();
    }

    public static StructType STRUCT_TYPE() {
        return DeletionVectorDescriptor$.MODULE$.STRUCT_TYPE();
    }

    public static String UUID_DV_MARKER() {
        return DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
    }

    public static String INLINE_DV_MARKER() {
        return DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
    }

    public static String PATH_DV_MARKER() {
        return DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
    }

    public static String DELETION_VECTOR_FILE_NAME_CORE() {
        return DeletionVectorDescriptor$.MODULE$.DELETION_VECTOR_FILE_NAME_CORE();
    }

    public static String DELETION_VECTOR_FILE_NAME_PREFIX() {
        return DeletionVectorDescriptor$.MODULE$.DELETION_VECTOR_FILE_NAME_PREFIX();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String storageType() {
        return this.storageType;
    }

    public String pathOrInlineDv() {
        return this.pathOrInlineDv;
    }

    public Option<Object> offset() {
        return this.offset;
    }

    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    public long cardinality() {
        return this.cardinality;
    }

    public Option<Object> maxRowIndex() {
        return this.maxRowIndex;
    }

    private String uniqueId$lzycompute() {
        DeletionVectorDescriptor deletionVectorDescriptor = this;
        synchronized (deletionVectorDescriptor) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                String string;
                Option<Object> option = this.offset();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int offset = BoxesRunTime.unboxToInt((Object)some.value());
                    string = new StringBuilder(1).append(this.uniqueFileId()).append("@").append(offset).toString();
                } else if (None$.MODULE$.equals(option)) {
                    string = this.uniqueFileId();
                } else {
                    throw new MatchError(option);
                }
                this.uniqueId = string;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.uniqueId;
    }

    public String uniqueId() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.uniqueId$lzycompute();
        }
        return this.uniqueId;
    }

    private String uniqueFileId$lzycompute() {
        DeletionVectorDescriptor deletionVectorDescriptor = this;
        synchronized (deletionVectorDescriptor) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.uniqueFileId = new StringBuilder(0).append(this.storageType()).append(this.pathOrInlineDv()).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.uniqueFileId;
    }

    public String uniqueFileId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.uniqueFileId$lzycompute();
        }
        return this.uniqueFileId;
    }

    @JsonIgnore
    public boolean isOnDisk() {
        return !this.isInline();
    }

    @JsonIgnore
    public boolean isInline() {
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @JsonIgnore
    public boolean isRelative() {
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @JsonIgnore
    public boolean isAbsolute() {
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public Path absolutePath(Path tableLocation) {
        Predef$.MODULE$.require(this.isOnDisk(), (Function0 & Serializable)() -> "Can't get a path for an inline deletion vector");
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Tuple2 tuple2 = (Tuple2)this.getRandomPrefixAndUuid().get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String randomPrefix = (String)tuple2._1();
            UUID uuid = (UUID)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)randomPrefix, (Object)uuid);
            String randomPrefix2 = (String)tuple22._1();
            UUID uuid2 = (UUID)tuple22._2();
            return DeletionVectorDescriptor$.MODULE$.assembleDeletionVectorPath(tableLocation, uuid2, randomPrefix2);
        }
        String string4 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            URI parsedUri = new URI(this.pathOrInlineDv());
            Predef$.MODULE$.assert(parsedUri.isAbsolute(), (Function0 & Serializable)() -> "Relative URIs are not supported for DVs");
            return new Path(parsedUri);
        }
        throw DeltaErrors$.MODULE$.cannotReconstructPathFromURI(this.pathOrInlineDv());
    }

    public String urlEncodedPath(Path tablePath) {
        return SparkPath$.MODULE$.fromPath(this.absolutePath(tablePath)).urlEncoded();
    }

    @JsonIgnore
    public Option<Tuple2<String, UUID>> getRandomPrefixAndUuid() {
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            int randomPrefixLength = this.pathOrInlineDv().length() - Codec$Base85Codec$.MODULE$.ENCODED_UUID_LENGTH();
            Tuple2 tuple2 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(this.pathOrInlineDv()), randomPrefixLength);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String randomPrefix = (String)tuple2._1();
            String encodedUuid = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)randomPrefix, (Object)encodedUuid);
            String randomPrefix2 = (String)tuple22._1();
            String encodedUuid2 = (String)tuple22._2();
            return new Some((Object)new Tuple2((Object)randomPrefix2, (Object)Codec$Base85Codec$.MODULE$.decodeUUID(encodedUuid2)));
        }
        return None$.MODULE$;
    }

    public DeletionVectorDescriptor copyWithAbsolutePath(Path tableLocation) {
        boolean bl;
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.copy(DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER(), this.urlEncodedPath(tableLocation), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }
        String string4 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            bl = true;
        } else {
            String string6 = DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
            String string7 = string;
            bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
        }
        if (bl) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }
        throw new MatchError((Object)string);
    }

    public DeletionVectorDescriptor copyWithNewRelativePath(UUID id, String randomPrefix) {
        boolean bl;
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.copy(DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER(), DeletionVectorDescriptor$.MODULE$.encodeUUID(id, randomPrefix), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }
        String string4 = DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            bl = true;
        } else {
            String string6 = DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
            String string7 = string;
            bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
        }
        if (bl) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }
        throw new MatchError((Object)string);
    }

    @JsonIgnore
    public byte[] inlineData() {
        Predef$.MODULE$.require(this.isInline(), (Function0 & Serializable)() -> "Can't get data for an on-disk DV from the log.");
        return Codec$Base85Codec$.MODULE$.decodeBytes(this.pathOrInlineDv(), this.sizeInBytes());
    }

    private int estimatedSerializedSize$lzycompute() {
        DeletionVectorDescriptor deletionVectorDescriptor = this;
        synchronized (deletionVectorDescriptor) {
            if (!this.bitmap$0) {
                this.estimatedSerializedSize = 12 + this.storageType().length() + this.pathOrInlineDv().length() + (this.offset().isDefined() ? 4 : 0);
                this.bitmap$0 = true;
            }
        }
        return this.estimatedSerializedSize;
    }

    public int estimatedSerializedSize() {
        if (!this.bitmap$0) {
            return this.estimatedSerializedSize$lzycompute();
        }
        return this.estimatedSerializedSize;
    }

    public String serializeToBase64() {
        String string;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try (DataOutputStream ds = new DataOutputStream(bs);){
            ds.writeLong(this.cardinality());
            ds.writeInt(this.sizeInBytes());
            byte[] storageTypeBytes = this.storageType().getBytes();
            Predef$.MODULE$.assert(storageTypeBytes.length == 1, (Function0 & Serializable)() -> new StringBuilder(34).append("Storage type must be 1byte value: ").append(this.storageType()).toString());
            ds.writeByte(BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(storageTypeBytes))));
            String string2 = this.storageType();
            String string3 = DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                Predef$.MODULE$.assert(this.offset().isDefined());
                ds.writeInt(BoxesRunTime.unboxToInt((Object)this.offset().get()));
            } else {
                Predef$.MODULE$.assert(this.offset().isEmpty());
            }
            ds.writeUTF(this.pathOrInlineDv());
            string = Base64.getEncoder().encodeToString(bs.toByteArray());
        }
        return string;
    }

    public DeletionVectorDescriptor copy(String storageType, String pathOrInlineDv, Option<Object> offset, int sizeInBytes, long cardinality, Option<Object> maxRowIndex) {
        return new DeletionVectorDescriptor(storageType, pathOrInlineDv, offset, sizeInBytes, cardinality, maxRowIndex);
    }

    public String copy$default$1() {
        return this.storageType();
    }

    public String copy$default$2() {
        return this.pathOrInlineDv();
    }

    public Option<Object> copy$default$3() {
        return this.offset();
    }

    public int copy$default$4() {
        return this.sizeInBytes();
    }

    public long copy$default$5() {
        return this.cardinality();
    }

    public Option<Object> copy$default$6() {
        return this.maxRowIndex();
    }

    public String productPrefix() {
        return "DeletionVectorDescriptor";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.storageType();
            }
            case 1: {
                return this.pathOrInlineDv();
            }
            case 2: {
                return this.offset();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.sizeInBytes());
            }
            case 4: {
                return BoxesRunTime.boxToLong((long)this.cardinality());
            }
            case 5: {
                return this.maxRowIndex();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeletionVectorDescriptor;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "storageType";
            }
            case 1: {
                return "pathOrInlineDv";
            }
            case 2: {
                return "offset";
            }
            case 3: {
                return "sizeInBytes";
            }
            case 4: {
                return "cardinality";
            }
            case 5: {
                return "maxRowIndex";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.storageType()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pathOrInlineDv()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.offset()));
        n = Statics.mix((int)n, (int)this.sizeInBytes());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.cardinality()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.maxRowIndex()));
        return Statics.finalizeHash((int)n, (int)6);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeletionVectorDescriptor)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeletionVectorDescriptor deletionVectorDescriptor = (DeletionVectorDescriptor)x$1;
        if (this.sizeInBytes() != deletionVectorDescriptor.sizeInBytes()) return false;
        if (this.cardinality() != deletionVectorDescriptor.cardinality()) return false;
        String string = this.storageType();
        String string2 = deletionVectorDescriptor.storageType();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.pathOrInlineDv();
        String string4 = deletionVectorDescriptor.pathOrInlineDv();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<Object> option = this.offset();
        Option<Object> option2 = deletionVectorDescriptor.offset();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.maxRowIndex();
        Option<Object> option4 = deletionVectorDescriptor.maxRowIndex();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!deletionVectorDescriptor.canEqual(this)) return false;
        return true;
    }

    public DeletionVectorDescriptor(String storageType, String pathOrInlineDv, @JsonDeserialize(contentAs=Integer.class) Option<Object> offset, int sizeInBytes, long cardinality, @JsonDeserialize(contentAs=Long.class) Option<Object> maxRowIndex) {
        this.storageType = storageType;
        this.pathOrInlineDv = pathOrInlineDv;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
        this.cardinality = cardinality;
        this.maxRowIndex = maxRowIndex;
        Product.$init$((Product)this);
    }
}

